/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.smtp;

import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import org.apache.commons.net.io.DotTerminatedMessageWriter;
import org.apache.commons.net.smtp.RelayPath;
import org.apache.commons.net.smtp.SMTP;
import org.apache.commons.net.smtp.SMTPReply;

public class SMTPClient
extends SMTP {
    public boolean completePendingCommand() throws IOException {
        return SMTPReply.isPositiveCompletion(this.getReply());
    }

    public boolean login(String string) throws IOException {
        return SMTPReply.isPositiveCompletion(this.helo(string));
    }

    public boolean login() throws IOException {
        InetAddress inetAddress = this.getLocalAddress();
        String string = inetAddress.getHostName();
        if (string == null) {
            return false;
        }
        return SMTPReply.isPositiveCompletion(this.helo(string));
    }

    public boolean setSender(RelayPath relayPath) throws IOException {
        return SMTPReply.isPositiveCompletion(this.mail(relayPath.toString()));
    }

    public boolean setSender(String string) throws IOException {
        return SMTPReply.isPositiveCompletion(this.mail("<" + string + ">"));
    }

    public boolean addRecipient(RelayPath relayPath) throws IOException {
        return SMTPReply.isPositiveCompletion(this.rcpt(relayPath.toString()));
    }

    public boolean addRecipient(String string) throws IOException {
        return SMTPReply.isPositiveCompletion(this.rcpt("<" + string + ">"));
    }

    public Writer sendMessageData() throws IOException {
        if (!SMTPReply.isPositiveIntermediate(this.data())) {
            return null;
        }
        return new DotTerminatedMessageWriter(this._writer);
    }

    public boolean sendShortMessageData(String string) throws IOException {
        Writer writer = this.sendMessageData();
        if (writer == null) {
            return false;
        }
        writer.write(string);
        writer.close();
        return this.completePendingCommand();
    }

    public boolean sendSimpleMessage(String string, String string2, String string3) throws IOException {
        if (!this.setSender(string)) {
            return false;
        }
        if (!this.addRecipient(string2)) {
            return false;
        }
        return this.sendShortMessageData(string3);
    }

    public boolean sendSimpleMessage(String string, String[] stringArray, String string2) throws IOException {
        boolean bl = false;
        if (!this.setSender(string)) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.addRecipient(stringArray[i])) continue;
            bl = true;
        }
        if (!bl) {
            return false;
        }
        return this.sendShortMessageData(string2);
    }

    public boolean logout() throws IOException {
        return SMTPReply.isPositiveCompletion(this.quit());
    }

    public boolean reset() throws IOException {
        return SMTPReply.isPositiveCompletion(this.rset());
    }

    public boolean verify(String string) throws IOException {
        int n = this.vrfy(string);
        return n == 250 || n == 251;
    }

    public String listHelp() throws IOException {
        if (SMTPReply.isPositiveCompletion(this.help())) {
            return this.getReplyString();
        }
        return null;
    }

    public String listHelp(String string) throws IOException {
        if (SMTPReply.isPositiveCompletion(this.help(string))) {
            return this.getReplyString();
        }
        return null;
    }

    public boolean sendNoOp() throws IOException {
        return SMTPReply.isPositiveCompletion(this.noop());
    }
}

