/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output;

import org.apache.log.LogEvent;
import org.apache.log.format.Formatter;
import org.apache.log.output.AbstractTarget;

public abstract class AbstractOutputTarget
extends AbstractTarget {
    private Formatter m_formatter;

    public AbstractOutputTarget() {
    }

    public AbstractOutputTarget(Formatter formatter) {
        this.m_formatter = formatter;
    }

    protected Formatter getFormatter() {
        return this.m_formatter;
    }

    protected void write(String string) {
    }

    protected void doProcessEvent(LogEvent logEvent) {
        String string = this.format(logEvent);
        this.write(string);
    }

    protected synchronized void open() {
        if (!this.isOpen()) {
            super.open();
            this.writeHead();
        }
    }

    public synchronized void close() {
        if (this.isOpen()) {
            this.writeTail();
            super.close();
        }
    }

    private String format(LogEvent logEvent) {
        if (null != this.m_formatter) {
            return this.m_formatter.format(logEvent);
        }
        return logEvent.toString();
    }

    private void writeHead() {
        if (!this.isOpen()) {
            return;
        }
        String string = this.getHead();
        if (null != string) {
            this.write(string);
        }
    }

    private void writeTail() {
        if (!this.isOpen()) {
            return;
        }
        String string = this.getTail();
        if (null != string) {
            this.write(string);
        }
    }

    private String getHead() {
        return null;
    }

    private String getTail() {
        return null;
    }
}

