/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.db;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.apache.log.ContextMap;
import org.apache.log.LogEvent;
import org.apache.log.output.db.AbstractJDBCTarget;
import org.apache.log.output.db.ColumnInfo;

public class DefaultJDBCTarget
extends AbstractJDBCTarget {
    private final String m_table;
    private final ColumnInfo[] m_columns;
    private PreparedStatement m_statement;

    public DefaultJDBCTarget(DataSource dataSource, String string, ColumnInfo[] columnInfoArray) {
        super(dataSource);
        this.m_table = string;
        this.m_columns = columnInfoArray;
        if (null == string) {
            throw new NullPointerException("table property must not be null");
        }
        if (null == columnInfoArray) {
            throw new NullPointerException("columns property must not be null");
        }
        if (0 == columnInfoArray.length) {
            throw new NullPointerException("columns must have at least 1 element");
        }
        this.open();
    }

    protected synchronized void output(LogEvent logEvent) {
        try {
            for (int i = 0; i < this.m_columns.length; ++i) {
                this.specifyColumn(this.m_statement, i, logEvent);
            }
            this.m_statement.executeUpdate();
        }
        catch (SQLException sQLException) {
            this.getErrorHandler().error("Error executing statement", sQLException, logEvent);
        }
    }

    protected synchronized void openConnection() {
        super.openConnection();
        this.m_statement = null;
        try {
            Connection connection = this.getConnection();
            if (null != connection) {
                this.m_statement = connection.prepareStatement(this.getStatementSQL());
            }
        }
        catch (SQLException sQLException) {
            this.getErrorHandler().error("Error preparing statement", sQLException, null);
        }
    }

    protected String getStatementSQL() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
        stringBuffer.append(this.m_table);
        stringBuffer.append(" (");
        stringBuffer.append(this.m_columns[0].getName());
        for (n = 1; n < this.m_columns.length; ++n) {
            stringBuffer.append(", ");
            stringBuffer.append(this.m_columns[n].getName());
        }
        stringBuffer.append(") VALUES (?");
        for (n = 1; n < this.m_columns.length; ++n) {
            stringBuffer.append(", ?");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected boolean isStale() {
        return super.isStale();
    }

    protected synchronized void closeConnection() {
        super.closeConnection();
        if (null != this.m_statement) {
            try {
                this.m_statement.close();
            }
            catch (SQLException sQLException) {
                this.getErrorHandler().error("Error closing statement", sQLException, null);
            }
            this.m_statement = null;
        }
    }

    protected void specifyColumn(PreparedStatement preparedStatement, int n, LogEvent logEvent) throws SQLException, IllegalStateException {
        ColumnInfo columnInfo = this.m_columns[n];
        switch (columnInfo.getType()) {
            case 6: {
                preparedStatement.setLong(n + 1, logEvent.getRelativeTime());
                break;
            }
            case 5: {
                preparedStatement.setTimestamp(n + 1, new Timestamp(logEvent.getTime()));
                break;
            }
            case 4: {
                preparedStatement.setString(n + 1, logEvent.getMessage());
                break;
            }
            case 2: {
                preparedStatement.setString(n + 1, logEvent.getCategory());
                break;
            }
            case 8: {
                preparedStatement.setString(n + 1, logEvent.getPriority().getName());
                break;
            }
            case 3: {
                preparedStatement.setString(n + 1, this.getContextMap(logEvent.getContextMap(), columnInfo.getAux()));
                break;
            }
            case 1: {
                preparedStatement.setString(n + 1, columnInfo.getAux());
                break;
            }
            case 7: {
                preparedStatement.setString(n + 1, this.getStackTrace(logEvent.getThrowable()));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown ColumnType: " + columnInfo.getType());
            }
        }
    }

    protected final String getTable() {
        return this.m_table;
    }

    protected final ColumnInfo getColumn(int n) {
        return this.m_columns[n];
    }

    private String getStackTrace(Throwable throwable) {
        if (null == throwable) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private String getContextMap(ContextMap contextMap, String string) {
        if (null == contextMap) {
            return "";
        }
        return contextMap.get(string, "").toString();
    }
}

