/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.log.LogEvent;
import org.apache.log.format.Formatter;
import org.apache.log.output.io.FileTarget;

public class SafeFileTarget
extends FileTarget {
    public SafeFileTarget(File file, boolean bl, Formatter formatter) throws IOException {
        super(file, bl, formatter);
        this.shutdownStream();
    }

    public synchronized void processEvent(LogEvent logEvent) {
        if (!this.isOpen()) {
            this.getErrorHandler().error("Writing event to closed stream.", null, logEvent);
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.getFile().getPath(), true);
            this.setOutputStream(fileOutputStream);
        }
        catch (Throwable throwable) {
            this.getErrorHandler().error("Unable to open file to write log event.", throwable, logEvent);
            return;
        }
        super.processEvent(logEvent);
        this.shutdownStream();
    }
}

