/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.io.rotate;

import java.io.File;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import org.apache.log.output.io.rotate.BaseFileNameFilter;
import org.apache.log.output.io.rotate.FileStrategy;

public class RevolvingFileStrategy
implements FileStrategy {
    private static final String PATTERN = "'.'000000";
    private DecimalFormat m_decimalFormat = new DecimalFormat("'.'000000");
    private int m_rotation;
    private int m_maxRotations;
    private File m_baseFile;

    public RevolvingFileStrategy(File file, int n) {
        this(file, -1, n);
    }

    public RevolvingFileStrategy(File file, int n, int n2) {
        this.m_baseFile = file;
        this.m_rotation = n;
        this.m_maxRotations = n2;
        if (-1 == this.m_maxRotations) {
            this.m_maxRotations = Integer.MAX_VALUE;
        }
        if (-1 == n) {
            this.m_rotation = this.calculateInitialRotation();
        }
        if (this.m_rotation > this.m_maxRotations) {
            this.m_rotation = this.m_maxRotations;
        }
        if (this.m_rotation < 0) {
            this.m_rotation = 0;
        }
    }

    public File nextFile() {
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(0);
        stringBuffer.append(this.m_baseFile);
        StringBuffer stringBuffer2 = this.m_decimalFormat.format((long)this.m_rotation, stringBuffer, fieldPosition);
        ++this.m_rotation;
        if (this.m_rotation >= this.m_maxRotations) {
            this.m_rotation = 0;
        }
        return new File(stringBuffer2.toString());
    }

    public int getCurrentRotation() {
        return this.m_rotation;
    }

    private int calculateInitialRotation() {
        File[] fileArray = this.getMatchingFiles();
        if (null == fileArray || 0 == fileArray.length) {
            return 0;
        }
        int[] nArray = this.calculateRotations(fileArray);
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (n2 <= n) continue;
            n = n2;
        }
        if (this.m_maxRotations != n) {
            return n + 1;
        }
        long l = fileArray[0].lastModified();
        int n3 = nArray[0];
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            long l2 = file.lastModified();
            if (l2 >= l) continue;
            l = l2;
            n3 = nArray[i];
        }
        return n3;
    }

    private int[] calculateRotations(File[] fileArray) {
        int[] nArray = new int[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            try {
                nArray[i] = this.calculateRotationForFile(file);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                nArray[i] = -1;
            }
        }
        return nArray;
    }

    private int calculateRotationForFile(File file) {
        String string = file.toString();
        int n = string.length();
        int n2 = this.m_decimalFormat.getMinimumIntegerDigits();
        String string2 = string.substring(n - n2);
        return Integer.parseInt(string2);
    }

    private File[] getMatchingFiles() {
        String string;
        File file;
        String string2 = this.m_baseFile.getPath();
        int n = string2.lastIndexOf(File.separator);
        if (n < 0) {
            file = new File(".");
            string = string2;
        } else {
            String string3 = string2.substring(0, n);
            string = string2.substring(n + 1);
            file = new File(string3);
        }
        return file.listFiles(new BaseFileNameFilter(string));
    }
}

