/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.jms;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.log.ContextMap;
import org.apache.log.LogEvent;
import org.apache.log.format.Formatter;
import org.apache.log.output.jms.MessageBuilder;
import org.apache.log.output.jms.PropertyInfo;

public class TextMessageBuilder
implements MessageBuilder {
    private final PropertyInfo[] m_properties;
    private final Formatter m_formatter;

    public TextMessageBuilder(Formatter formatter) {
        this.m_properties = new PropertyInfo[0];
        this.m_formatter = formatter;
    }

    public TextMessageBuilder(PropertyInfo[] propertyInfoArray, Formatter formatter) {
        this.m_properties = propertyInfoArray;
        this.m_formatter = formatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message buildMessage(Session session, LogEvent logEvent) throws JMSException {
        Session session2 = session;
        synchronized (session2) {
            TextMessage textMessage = session.createTextMessage();
            textMessage.setText(this.getText(logEvent));
            for (int i = 0; i < this.m_properties.length; ++i) {
                this.setProperty(textMessage, i, logEvent);
            }
            return textMessage;
        }
    }

    private void setProperty(TextMessage textMessage, int n, LogEvent logEvent) throws JMSException {
        PropertyInfo propertyInfo = this.m_properties[n];
        String string = propertyInfo.getName();
        switch (propertyInfo.getType()) {
            case 4: {
                textMessage.setStringProperty(string, logEvent.getMessage());
                break;
            }
            case 6: {
                textMessage.setLongProperty(string, logEvent.getRelativeTime());
                break;
            }
            case 5: {
                textMessage.setLongProperty(string, logEvent.getTime());
                break;
            }
            case 2: {
                textMessage.setStringProperty(string, logEvent.getCategory());
                break;
            }
            case 8: {
                textMessage.setStringProperty(string, logEvent.getPriority().getName());
                break;
            }
            case 3: {
                textMessage.setStringProperty(string, this.getContextMap(logEvent.getContextMap(), propertyInfo.getAux()));
                break;
            }
            case 1: {
                textMessage.setStringProperty(string, propertyInfo.getAux());
                break;
            }
            case 7: {
                textMessage.setStringProperty(string, this.getStackTrace(logEvent.getThrowable()));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown PropertyType: " + propertyInfo.getType());
            }
        }
    }

    private String getText(LogEvent logEvent) {
        if (null == this.m_formatter) {
            return logEvent.getMessage();
        }
        return this.m_formatter.format(logEvent);
    }

    private String getStackTrace(Throwable throwable) {
        if (null == throwable) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.getBuffer().toString();
    }

    private String getContextMap(ContextMap contextMap, String string) {
        if (null == contextMap) {
            return "";
        }
        return contextMap.get(string, "").toString();
    }
}

