/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IFGT;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.xalan.xsltc.compiler.CastExpr;
import org.apache.xalan.xsltc.compiler.Expression;
import org.apache.xalan.xsltc.compiler.Instruction;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.Sort;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.Variable;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.NodeSetType;
import org.apache.xalan.xsltc.compiler.util.NodeType;
import org.apache.xalan.xsltc.compiler.util.ReferenceType;
import org.apache.xalan.xsltc.compiler.util.ResultTreeType;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;

final class ForEach
extends Instruction {
    private Expression _select;
    private Type _type;

    ForEach() {
    }

    public void display(int n) {
        this.indent(n);
        Util.println("ForEach");
        this.indent(n + 4);
        Util.println("select " + this._select.toString());
        this.displayContents(n + 4);
    }

    public void parseContents(Parser parser2) {
        this._select = parser2.parseExpression(this, "select", null);
        this.parseChildren(parser2);
        if (this._select.isDummy()) {
            this.reportError(this, parser2, "REQUIRED_ATTR_ERR", "select");
        }
    }

    public Type typeCheck(SymbolTable symbolTable) throws TypeCheckError {
        this._type = this._select.typeCheck(symbolTable);
        if (this._type instanceof ReferenceType || this._type instanceof NodeType) {
            this._select = new CastExpr(this._select, Type.NodeSet);
            this.typeCheckContents(symbolTable);
            return Type.Void;
        }
        if (this._type instanceof NodeSetType || this._type instanceof ResultTreeType) {
            this.typeCheckContents(symbolTable);
            return Type.Void;
        }
        throw new TypeCheckError(this);
    }

    public void translate(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        Object object;
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        instructionList.append(methodGenerator.loadCurrentNode());
        instructionList.append(methodGenerator.loadIterator());
        Vector vector = new Vector();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof Sort)) continue;
            vector.addElement(object);
        }
        if (this._type != null && this._type instanceof ResultTreeType) {
            instructionList.append(methodGenerator.loadDOM());
            if (vector.size() > 0) {
                object = new ErrorMsg("RESULT_TREE_SORT_ERR", this);
                this.getParser().reportError(4, (ErrorMsg)object);
            }
            this._select.translate(classGenerator, methodGenerator);
            this._type.translateTo(classGenerator, methodGenerator, Type.NodeSet);
            instructionList.append(SWAP);
            instructionList.append(methodGenerator.storeDOM());
        } else {
            if (vector.size() > 0) {
                Sort.translateSortIterator(classGenerator, methodGenerator, this._select, vector);
            } else {
                this._select.translate(classGenerator, methodGenerator);
            }
            if (!(this._type instanceof ReferenceType)) {
                instructionList.append(methodGenerator.loadContextNode());
                instructionList.append(methodGenerator.setStartNode());
            }
        }
        instructionList.append(methodGenerator.storeIterator());
        this.initializeVariables(classGenerator, methodGenerator);
        object = instructionList.append(new GOTO(null));
        InstructionHandle instructionHandle = instructionList.append(NOP);
        this.translateContents(classGenerator, methodGenerator);
        ((BranchHandle)object).setTarget(instructionList.append(methodGenerator.loadIterator()));
        instructionList.append(methodGenerator.nextNode());
        instructionList.append(DUP);
        instructionList.append(methodGenerator.storeCurrentNode());
        instructionList.append(new IFGT(instructionHandle));
        if (this._type != null && this._type instanceof ResultTreeType) {
            instructionList.append(methodGenerator.storeDOM());
        }
        instructionList.append(methodGenerator.storeIterator());
        instructionList.append(methodGenerator.storeCurrentNode());
    }

    public void initializeVariables(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        int n = this.elementCount();
        for (int i = 0; i < n; ++i) {
            Object e = this.getContents().elementAt(i);
            if (!(e instanceof Variable)) continue;
            Variable variable = (Variable)e;
            variable.initialize(classGenerator, methodGenerator);
        }
    }
}

