/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.Vector;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.Fallback;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;

final class UnsupportedElement
extends SyntaxTreeNode {
    private Vector _fallbacks = null;
    private ErrorMsg _message = null;
    private boolean _isExtension = false;

    public UnsupportedElement(String string, String string2, String string3, boolean bl) {
        super(string, string2, string3);
        this._isExtension = bl;
    }

    public void setErrorMessage(ErrorMsg errorMsg) {
        this._message = errorMsg;
    }

    public void display(int n) {
        this.indent(n);
        Util.println("Unsupported element = " + this._qname.getNamespace() + ":" + this._qname.getLocalPart());
        this.displayContents(n + 4);
    }

    private void processFallbacks(Parser parser2) {
        Vector vector = this.getContents();
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                SyntaxTreeNode syntaxTreeNode = (SyntaxTreeNode)vector.elementAt(i);
                if (!(syntaxTreeNode instanceof Fallback)) continue;
                Fallback fallback = (Fallback)syntaxTreeNode;
                fallback.activate();
                fallback.parseContents(parser2);
                if (this._fallbacks == null) {
                    this._fallbacks = new Vector();
                }
                this._fallbacks.addElement(syntaxTreeNode);
            }
        }
    }

    public void parseContents(Parser parser2) {
        this.processFallbacks(parser2);
    }

    public Type typeCheck(SymbolTable symbolTable) throws TypeCheckError {
        if (this._fallbacks != null) {
            int n = this._fallbacks.size();
            for (int i = 0; i < n; ++i) {
                Fallback fallback = (Fallback)this._fallbacks.elementAt(i);
                fallback.typeCheck(symbolTable);
            }
        }
        return Type.Void;
    }

    public void translate(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        if (this._fallbacks != null) {
            int n = this._fallbacks.size();
            for (int i = 0; i < n; ++i) {
                Fallback fallback = (Fallback)this._fallbacks.elementAt(i);
                fallback.translate(classGenerator, methodGenerator);
            }
        } else {
            ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
            InstructionList instructionList = methodGenerator.getInstructionList();
            int n = constantPoolGen.addMethodref("org.apache.xalan.xsltc.runtime.BasisLibrary", "unsupported_ElementF", "(Ljava/lang/String;Z)V");
            instructionList.append(new PUSH(constantPoolGen, this.getQName().toString()));
            instructionList.append(new PUSH(constantPoolGen, this._isExtension));
            instructionList.append(new INVOKESTATIC(n));
        }
    }
}

