/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import org.apache.xalan.xsltc.compiler.Closure;
import org.apache.xalan.xsltc.compiler.Expression;
import org.apache.xalan.xsltc.compiler.Param;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.TopLevelElement;
import org.apache.xalan.xsltc.compiler.Variable;
import org.apache.xalan.xsltc.compiler.VariableBase;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;

class VariableRefBase
extends Expression {
    protected final VariableBase _variable;
    protected Closure _closure = null;

    public VariableRefBase(VariableBase variableBase) {
        this._variable = variableBase;
        variableBase.addReference(this);
    }

    public VariableRefBase() {
        this._variable = null;
    }

    public VariableBase getVariable() {
        return this._variable;
    }

    public VariableBase findParentVariable() {
        SyntaxTreeNode syntaxTreeNode;
        for (syntaxTreeNode = this; syntaxTreeNode != null && !(syntaxTreeNode instanceof VariableBase); syntaxTreeNode = syntaxTreeNode.getParent()) {
        }
        return (VariableBase)syntaxTreeNode;
    }

    public boolean equals(Object object) {
        try {
            return this._variable == ((VariableRefBase)object)._variable;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String toString() {
        return "variable-ref(" + this._variable.getName() + '/' + this._variable.getType() + ')';
    }

    public Type typeCheck(SymbolTable symbolTable) throws TypeCheckError {
        SyntaxTreeNode syntaxTreeNode;
        if (this._type != null) {
            return this._type;
        }
        if (this._variable.isLocal()) {
            syntaxTreeNode = this.getParent();
            do {
                if (!(syntaxTreeNode instanceof Closure)) continue;
                this._closure = (Closure)((Object)syntaxTreeNode);
                break;
            } while (!(syntaxTreeNode instanceof TopLevelElement) && (syntaxTreeNode = syntaxTreeNode.getParent()) != null);
            if (this._closure != null) {
                this._closure.addVariable(this);
            }
        }
        if ((syntaxTreeNode = this.findParentVariable()) != null) {
            VariableBase variableBase = this._variable;
            if (this._variable._ignore) {
                if (this._variable instanceof Variable) {
                    variableBase = syntaxTreeNode.getSymbolTable().lookupVariable(this._variable._name);
                } else if (this._variable instanceof Param) {
                    variableBase = syntaxTreeNode.getSymbolTable().lookupParam(this._variable._name);
                }
            }
            ((VariableBase)syntaxTreeNode).addDependency(variableBase);
        }
        this._type = this._variable.getType();
        if (this._type == null) {
            this._variable.typeCheck(symbolTable);
            this._type = this._variable.getType();
        }
        return this._type;
    }
}

