/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import java.text.Collator;
import java.util.Locale;
import org.apache.xalan.xsltc.CollatorFactory;
import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.dom.ObjectFactory;
import org.apache.xalan.xsltc.dom.SortSettings;
import org.apache.xalan.xsltc.runtime.AbstractTranslet;
import org.apache.xml.utils.StringComparable;

public abstract class NodeSortRecord {
    public static final int COMPARE_STRING = 0;
    public static final int COMPARE_NUMERIC = 1;
    public static final int COMPARE_ASCENDING = 0;
    public static final int COMPARE_DESCENDING = 1;
    private static final Collator DEFAULT_COLLATOR = Collator.getInstance();
    protected Collator _collator = DEFAULT_COLLATOR;
    protected Collator[] _collators;
    protected Locale _locale;
    protected CollatorFactory _collatorFactory;
    protected SortSettings _settings;
    private DOM _dom = null;
    private int _node;
    private int _last = 0;
    private int _scanned = 0;
    private Object[] _values;

    public NodeSortRecord(int n) {
        this._node = n;
    }

    public NodeSortRecord() {
        this(0);
    }

    public final void initialize(int n, int n2, DOM dOM, SortSettings sortSettings) throws TransletException {
        this._dom = dOM;
        this._node = n;
        this._last = n2;
        this._settings = sortSettings;
        int n3 = sortSettings.getSortOrders().length;
        this._values = new Object[n3];
        String string = System.getProperty("org.apache.xalan.xsltc.COLLATOR_FACTORY");
        if (string != null) {
            Locale[] localeArray;
            try {
                localeArray = ObjectFactory.findProviderClass(string, ObjectFactory.findClassLoader(), true);
                this._collatorFactory = (CollatorFactory)localeArray;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new TransletException(classNotFoundException);
            }
            localeArray = sortSettings.getLocales();
            this._collators = new Collator[n3];
            for (int i = 0; i < n3; ++i) {
                this._collators[i] = this._collatorFactory.getCollator(localeArray[i]);
            }
            this._collator = this._collators[0];
        } else {
            this._collators = sortSettings.getCollators();
            this._collator = this._collators[0];
        }
    }

    public final int getNode() {
        return this._node;
    }

    public final int compareDocOrder(NodeSortRecord nodeSortRecord) {
        return this._node - nodeSortRecord._node;
    }

    private final Comparable stringValue(int n) {
        if (this._scanned <= n) {
            AbstractTranslet abstractTranslet = this._settings.getTranslet();
            Locale[] localeArray = this._settings.getLocales();
            String[] stringArray = this._settings.getCaseOrders();
            String string = this.extractValueFromDOM(this._dom, this._node, n, abstractTranslet, this._last);
            Comparable comparable = StringComparable.getComparator(string, localeArray[n], this._collators[n], stringArray[n]);
            this._values[this._scanned++] = comparable;
            return comparable;
        }
        return (Comparable)this._values[n];
    }

    private final Double numericValue(int n) {
        if (this._scanned <= n) {
            Double d;
            AbstractTranslet abstractTranslet = this._settings.getTranslet();
            String string = this.extractValueFromDOM(this._dom, this._node, n, abstractTranslet, this._last);
            try {
                d = new Double(string);
            }
            catch (NumberFormatException numberFormatException) {
                d = new Double(Double.NEGATIVE_INFINITY);
            }
            this._values[this._scanned++] = d;
            return d;
        }
        return (Double)this._values[n];
    }

    public int compareTo(NodeSortRecord nodeSortRecord) {
        int[] nArray = this._settings.getSortOrders();
        int n = this._settings.getSortOrders().length;
        int[] nArray2 = this._settings.getTypes();
        for (int i = 0; i < n; ++i) {
            int n2;
            Comparable<Double> comparable;
            Comparable<Double> comparable2;
            if (nArray2[i] == 1) {
                comparable2 = this.numericValue(i);
                comparable = nodeSortRecord.numericValue(i);
                n2 = ((Double)comparable2).compareTo((Double)comparable);
            } else {
                comparable2 = this.stringValue(i);
                comparable = nodeSortRecord.stringValue(i);
                n2 = comparable2.compareTo((Double)comparable);
            }
            if (n2 == 0) continue;
            return nArray[i] == 1 ? 0 - n2 : n2;
        }
        return this._node - nodeSortRecord._node;
    }

    public Collator[] getCollator() {
        return this._collators;
    }

    public abstract String extractValueFromDOM(DOM var1, int var2, int var3, AbstractTranslet var4, int var5);
}

