/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.jaxp;

import java.util.ArrayList;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.ExtensionsProvider;
import org.apache.xpath.functions.FuncExtFunction;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;

public class JAXPExtensionsProvider
implements ExtensionsProvider {
    private final XPathFunctionResolver resolver;
    private boolean extensionInvocationDisabled = false;

    public JAXPExtensionsProvider(XPathFunctionResolver xPathFunctionResolver) {
        this.resolver = xPathFunctionResolver;
        this.extensionInvocationDisabled = false;
    }

    public JAXPExtensionsProvider(XPathFunctionResolver xPathFunctionResolver, boolean bl) {
        this.resolver = xPathFunctionResolver;
        this.extensionInvocationDisabled = bl;
    }

    public boolean functionAvailable(String string, String string2) throws TransformerException {
        try {
            if (string2 == null) {
                String string3 = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"Function Name"});
                throw new NullPointerException(string3);
            }
            QName qName = new QName(string, string2);
            XPathFunction xPathFunction = this.resolver.resolveFunction(qName, 0);
            return xPathFunction != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean elementAvailable(String string, String string2) throws TransformerException {
        return false;
    }

    public Object extFunction(String string, String string2, Vector vector, Object object) throws TransformerException {
        try {
            if (string2 == null) {
                String string3 = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"Function Name"});
                throw new NullPointerException(string3);
            }
            QName qName = new QName(string, string2);
            if (this.extensionInvocationDisabled) {
                String string4 = XSLMessages.createXPATHMessage("ER_EXTENSION_FUNCTION_CANNOT_BE_INVOKED", new Object[]{qName.toString()});
                throw new XPathFunctionException(string4);
            }
            int n = vector.size();
            XPathFunction xPathFunction = this.resolver.resolveFunction(qName, n);
            ArrayList<Object> arrayList = new ArrayList<Object>(n);
            for (int i = 0; i < n; ++i) {
                Object e = vector.elementAt(i);
                if (e instanceof XNodeSet) {
                    arrayList.add(i, ((XNodeSet)e).nodelist());
                    continue;
                }
                if (e instanceof XObject) {
                    Object object2 = ((XObject)e).object();
                    arrayList.add(i, object2);
                    continue;
                }
                arrayList.add(i, e);
            }
            return xPathFunction.evaluate(arrayList);
        }
        catch (XPathFunctionException xPathFunctionException) {
            throw new WrappedRuntimeException(xPathFunctionException);
        }
        catch (Exception exception) {
            throw new TransformerException(exception);
        }
    }

    public Object extFunction(FuncExtFunction funcExtFunction, Vector vector) throws TransformerException {
        try {
            String string = funcExtFunction.getNamespace();
            String string2 = funcExtFunction.getFunctionName();
            int n = funcExtFunction.getArgCount();
            QName qName = new QName(string, string2);
            if (this.extensionInvocationDisabled) {
                String string3 = XSLMessages.createXPATHMessage("ER_EXTENSION_FUNCTION_CANNOT_BE_INVOKED", new Object[]{qName.toString()});
                throw new XPathFunctionException(string3);
            }
            XPathFunction xPathFunction = this.resolver.resolveFunction(qName, n);
            ArrayList<Object> arrayList = new ArrayList<Object>(n);
            for (int i = 0; i < n; ++i) {
                Object e = vector.elementAt(i);
                if (e instanceof XNodeSet) {
                    arrayList.add(i, ((XNodeSet)e).nodelist());
                    continue;
                }
                if (e instanceof XObject) {
                    Object object = ((XObject)e).object();
                    arrayList.add(i, object);
                    continue;
                }
                arrayList.add(i, e);
            }
            return xPathFunction.evaluate(arrayList);
        }
        catch (XPathFunctionException xPathFunctionException) {
            throw new WrappedRuntimeException(xPathFunctionException);
        }
        catch (Exception exception) {
            throw new TransformerException(exception);
        }
    }
}

