/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.PreorderNodeIterator;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.VariableTable;

public class NodeTransformer {
    protected ObjArray loops;
    protected ObjArray loopEnds;
    protected boolean inFunction;
    protected IRFactory irFactory;

    public NodeTransformer newInstance() {
        return new NodeTransformer();
    }

    public IRFactory createIRFactory(TokenStream tokenStream, Scriptable scriptable) {
        return new IRFactory(tokenStream, scriptable);
    }

    public Node transform(Node node, Node node2, TokenStream tokenStream, Scriptable scriptable) {
        Node node3;
        this.loops = new ObjArray();
        this.loopEnds = new ObjArray();
        boolean bl = this.inFunction = node.getType() == 110;
        if (!this.inFunction) {
            this.addVariables(node, this.getVariableTable(node));
        }
        this.irFactory = this.createIRFactory(tokenStream, scriptable);
        boolean bl2 = false;
        PreorderNodeIterator preorderNodeIterator = node.getPreorderIterator();
        block22: while ((node3 = preorderNodeIterator.nextNode()) != null) {
            int n = node3.getType();
            block0 : switch (n) {
                case 110: {
                    if (node3 == node) {
                        VariableTable variableTable = this.getVariableTable(node);
                        this.addVariables(node, variableTable);
                        Node node4 = node3.getLastChild();
                        Node node5 = node4.getLastChild();
                        if (node5 != null && node5.getType() == 5) continue block22;
                        node4.addChildToBack(new Node(5));
                        break;
                    }
                    FunctionNode functionNode = (FunctionNode)node3.getProp(5);
                    if (this.inFunction) {
                        ((FunctionNode)node).setRequiresActivation(true);
                        functionNode.setCheckThis(true);
                    }
                    this.addParameters(functionNode);
                    NodeTransformer nodeTransformer = this.newInstance();
                    functionNode = (FunctionNode)nodeTransformer.transform(functionNode, node, tokenStream, scriptable);
                    node3.putProp(5, functionNode);
                    ObjArray objArray = (ObjArray)node.getProp(5);
                    if (objArray == null) {
                        objArray = new ObjArray();
                        node.putProp(5, objArray);
                    }
                    objArray.add(functionNode);
                    break;
                }
                case 136: {
                    Object object3;
                    Object object2;
                    Node node6;
                    Node node7 = node3.getFirstChild();
                    node3.removeChild(node7);
                    String string = node7.getString();
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        node6 = (Node)this.loops.get(i);
                        if (node6.getType() != 136 || !string.equals(object2 = (String)node6.getProp(20))) continue;
                        object3 = Context.getMessage1("msg.dup.label", string);
                        this.reportMessage(Context.getContext(), (String)object3, node3, node, true, scriptable);
                        break block0;
                    }
                    node3.putProp(20, string);
                    Node node8 = new Node(137);
                    node6 = preorderNodeIterator.getCurrentParent();
                    for (object2 = node3.getNext(); object2 != null && (((Node)object2).getType() == 136 || ((Node)object2).getType() == 137); object2 = ((Node)object2).getNext()) {
                    }
                    if (object2 == null) break;
                    node6.addChildAfter(node8, (Node)object2);
                    node3.putProp(2, node8);
                    if (((Node)object2).getType() == 138) {
                        node3.putProp(3, ((Node)object2).getProp(3));
                    }
                    this.loops.push(node3);
                    this.loopEnds.push(node8);
                    break;
                }
                case 115: {
                    Node node9 = new Node(137);
                    Node node10 = preorderNodeIterator.getCurrentParent();
                    node10.addChildAfter(node9, node3);
                    Node node11 = node3;
                    Node node12 = node3.getFirstChild().next;
                    while (node12 != null) {
                        Node node13 = node12.next;
                        node3.removeChild(node12);
                        node10.addChildAfter(node12, node11);
                        node11 = node12;
                        node12 = node13;
                    }
                    node3.putProp(2, node9);
                    this.loops.push(node3);
                    this.loopEnds.push(node9);
                    node3.putProp(13, new ObjArray());
                    break;
                }
                case 116: 
                case 117: {
                    Node node14 = (Node)this.loops.peek();
                    if (n == 116) {
                        ObjArray objArray = (ObjArray)node14.getProp(13);
                        objArray.add(node3);
                        break;
                    }
                    node14.putProp(14, node3);
                    break;
                }
                case 144: {
                    int n2 = node.getIntProp(22, 0);
                    node.putIntProp(22, n2 + 1);
                    break;
                }
                case 138: {
                    this.loops.push(node3);
                    this.loopEnds.push(node3.getProp(2));
                    break;
                }
                case 124: {
                    if (this.inFunction) {
                        ((FunctionNode)node).setRequiresActivation(true);
                    }
                    this.loops.push(node3);
                    Node node15 = node3.getNext();
                    if (node15.getType() != 4) {
                        throw new RuntimeException("Unexpected tree");
                    }
                    this.loopEnds.push(node15);
                    break;
                }
                case 75: {
                    Node node16 = (Node)node3.getProp(21);
                    if (node16 != null) {
                        bl2 = true;
                        this.loops.push(node3);
                        this.loopEnds.push(node16);
                    }
                    int n3 = node.getIntProp(22, 0);
                    node.putIntProp(22, n3 + 1);
                    break;
                }
                case 4: 
                case 137: {
                    if (this.loopEnds.isEmpty() || this.loopEnds.peek() != node3) break;
                    this.loopEnds.pop();
                    this.loops.pop();
                    break;
                }
                case 5: {
                    if (!bl2) break;
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        Node node17;
                        Node node18 = (Node)this.loops.get(i);
                        int n4 = node18.getType();
                        if (n4 == 75) {
                            node17 = new Node(143);
                            Object object = node18.getProp(21);
                            node17.putProp(1, object);
                            preorderNodeIterator.addBeforeCurrent(node17);
                            continue;
                        }
                        if (n4 != 124) continue;
                        node17 = new Node(4);
                        preorderNodeIterator.addBeforeCurrent(node17);
                    }
                    continue block22;
                }
                case 121: 
                case 122: {
                    Object[] objectArray;
                    Object object;
                    Object object3;
                    Node node19 = null;
                    boolean bl3 = node3.hasChildren();
                    String string = null;
                    if (bl3) {
                        Node node20 = node3.getFirstChild();
                        string = node20.getString();
                        node3.removeChild(node20);
                    }
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        Node node21 = (Node)this.loops.get(i);
                        int n5 = node21.getType();
                        if (n5 == 124) {
                            object = new Node(4);
                            preorderNodeIterator.addBeforeCurrent((Node)object);
                            continue;
                        }
                        if (n5 == 75) {
                            object = new Node(143);
                            objectArray = node21.getProp(21);
                            ((Node)object).putProp(1, objectArray);
                            preorderNodeIterator.addBeforeCurrent((Node)object);
                            continue;
                        }
                        if (!bl3 && (n5 == 138 || n5 == 115 && n == 121)) {
                            node19 = node21;
                            break;
                        }
                        if (!bl3 || n5 != 136 || !string.equals((String)node21.getProp(20))) continue;
                        node19 = node21;
                        break;
                    }
                    int n6 = n == 121 ? 2 : 3;
                    Object object4 = object3 = node19 == null ? null : (Node)node19.getProp(n6);
                    if (node19 == null || object3 == null) {
                        if (!bl3) {
                            object = n == 122 ? Context.getMessage("msg.continue.outside", null) : Context.getMessage("msg.bad.break", null);
                        } else if (node19 != null) {
                            object = Context.getMessage0("msg.continue.nonloop");
                        } else {
                            objectArray = new Object[]{string};
                            object = Context.getMessage("msg.undef.label", objectArray);
                        }
                        this.reportMessage(Context.getContext(), (String)object, node3, node, true, scriptable);
                        node3.setType(128);
                        break;
                    }
                    node3.setType(6);
                    node3.putProp(1, object3);
                    break;
                }
                case 43: {
                    if (this.isSpecialCallName(node, node3)) {
                        node3.putProp(30, Boolean.TRUE);
                    }
                    this.visitCall(node3, node);
                    break;
                }
                case 30: {
                    if (this.isSpecialCallName(node, node3)) {
                        node3.putProp(30, Boolean.TRUE);
                    }
                    this.visitNew(node3, node);
                    break;
                }
                case 108: {
                    Node node22 = node3.getLastChild();
                    node22.setType(46);
                    break;
                }
                case 140: {
                    node3.setType(this.inFunction ? 57 : 2);
                    break;
                }
                case 56: {
                    ObjArray objArray = (ObjArray)node.getProp(12);
                    if (objArray == null) {
                        objArray = new ObjArray();
                        node.putProp(12, objArray);
                    }
                    objArray.add(node3);
                    Node node23 = new Node(56);
                    preorderNodeIterator.replaceCurrent(node23);
                    node23.putProp(12, node3);
                    break;
                }
                case 123: {
                    Object object3;
                    Node node24 = new Node(133);
                    for (Node node25 = node3.getFirstChild(); node25 != null; node25 = node25.getNext()) {
                        Node node26 = node25;
                        if (!node26.hasChildren()) continue;
                        Node node27 = node26.getFirstChild();
                        node26.removeChild(node27);
                        Node node28 = (Node)this.irFactory.createAssignment(128, node26, node27, null, false);
                        object3 = new Node(57, node28, node3.getLineno());
                        node24.addChildToBack((Node)object3);
                    }
                    preorderNodeIterator.replaceCurrent(node24);
                    break;
                }
                case 10: 
                case 31: {
                    VariableTable variableTable;
                    Node node29;
                    if (!this.inFunction || this.inWithStatement() || (node29 = node3.getFirstChild()) == null || node29.getType() != 61) break;
                    String string = node29.getString();
                    Context context = Context.getCurrentContext();
                    if (context != null && context.isActivationNeeded(string)) {
                        ((FunctionNode)node).setRequiresActivation(true);
                    }
                    if (!(variableTable = this.getVariableTable(node)).hasVariable(string)) break;
                    if (n == 10) {
                        node3.setType(73);
                        node29.setType(46);
                        break;
                    }
                    Node node30 = new Node(109, 51);
                    preorderNodeIterator.replaceCurrent(node30);
                    break;
                }
                case 39: {
                    if (!this.inFunction) break;
                    Node node31 = node3.getFirstChild().getNext();
                    String string = node31 == null ? "" : node31.getString();
                    Context context = Context.getCurrentContext();
                    if ((context == null || !context.isActivationNeeded(string)) && (!string.equals("length") || Context.getContext().getLanguageVersion() != 120)) continue block22;
                    ((FunctionNode)node).setRequiresActivation(true);
                    break;
                }
                case 44: {
                    VariableTable variableTable;
                    if (!this.inFunction || this.inWithStatement()) break;
                    String string = node3.getString();
                    Context context = Context.getCurrentContext();
                    if (context != null && context.isActivationNeeded(string)) {
                        ((FunctionNode)node).setRequiresActivation(true);
                    }
                    if (!(variableTable = this.getVariableTable(node)).hasVariable(string)) break;
                    node3.setType(72);
                    break;
                }
            }
        }
        return node;
    }

    protected void addVariables(Node node, VariableTable variableTable) {
        Object object;
        Object object2;
        Node node2;
        boolean bl = node.getType() == 110;
        PreorderNodeIterator preorderNodeIterator = node.getPreorderIterator();
        ObjToIntMap objToIntMap = null;
        while ((node2 = preorderNodeIterator.nextNode()) != null) {
            int n = node2.getType();
            if (bl && n == 110 && node2 != node && ((FunctionNode)node2.getProp(5)).getFunctionType() == 3) {
                object2 = node2.getString();
                if (object2 == null) continue;
                variableTable.removeLocal((String)object2);
                if (objToIntMap == null) {
                    objToIntMap = new ObjToIntMap();
                }
                objToIntMap.put(object2, 0);
            }
            if (n != 123) continue;
            for (object2 = node2.getFirstChild(); object2 != null; object2 = ((Node)object2).getNext()) {
                object = ((Node)object2).getString();
                if (objToIntMap != null && objToIntMap.has(object)) continue;
                variableTable.addLocal((String)object, this.createVariableObject((String)object, false));
            }
        }
        if (bl) {
            FunctionNode functionNode = (FunctionNode)node;
            object2 = functionNode.getFunctionName();
            if (functionNode.getFunctionType() == 2 && object2 != null && ((String)object2).length() > 0 && !variableTable.hasVariable((String)object2)) {
                variableTable.addLocal((String)object2, this.createVariableObject((String)object2, false));
                object = node.getLastChild();
                Node node3 = new Node(57, new Node(73, Node.newString((String)object2), new Node(109, 87)));
                ((Node)object).addChildrenToFront(node3);
            }
        }
    }

    protected void addParameters(FunctionNode functionNode) {
        VariableTable variableTable = functionNode.getVariableTable();
        Node node = functionNode.getFirstChild();
        if (node.getType() == 94 && variableTable.getParameterCount() == 0) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                String string = node2.getString();
                variableTable.addParameter(string, this.createVariableObject(string, true));
            }
        }
    }

    protected Object createVariableObject(String string, boolean bl) {
        return string;
    }

    protected void visitNew(Node node, Node node2) {
    }

    protected void visitCall(Node node, Node node2) {
        Node node3;
        Object object;
        Object object2;
        Node node4 = node.getFirstChild();
        int n = 0;
        Node node5 = node4.getNext();
        while (node5 != null) {
            node5 = node5.getNext();
            ++n;
        }
        boolean bl = false;
        if (node4.getType() == 44) {
            object2 = this.getVariableTable(node2);
            object = node4.getString();
            if (this.inFunction && ((VariableTable)object2).hasVariable((String)object) && !this.inWithStatement()) {
                node4.setType(72);
            } else {
                node.removeChild(node4);
                node4.setType(71);
                node3 = node4.cloneNode();
                node3.setType(46);
                Node node6 = new Node(39, node4, node3);
                node.addChildToFront(node6);
                node4 = node6;
                boolean bl2 = bl = this.inWithStatement() || !this.inFunction;
            }
        }
        if (node4.getType() != 39 && node4.getType() != 41) {
            node.removeChild(node4);
            object2 = this.irFactory.createNewTemp(node4);
            object = this.irFactory.createUseTemp((Node)object2);
            ((Node)object).putProp(6, object2);
            node3 = new Node(141, (Node)object);
            node.addChildToFront(node3);
            node.addChildToFront((Node)object2);
            return;
        }
        object2 = node4.getFirstChild();
        node4.removeChild((Node)object2);
        object = this.irFactory.createNewTemp((Node)object2);
        node4.addChildToFront((Node)object);
        node3 = this.irFactory.createUseTemp((Node)object);
        node3.putProp(6, object);
        if (bl) {
            node3 = new Node(68, node3);
        }
        node.addChildAfter(node3, node4);
    }

    protected boolean inWithStatement() {
        for (int i = this.loops.size() - 1; i >= 0; --i) {
            Node node = (Node)this.loops.get(i);
            if (node.getType() != 124) continue;
            return true;
        }
        return false;
    }

    private boolean isSpecialCallName(Node node, Node node2) {
        Node node3 = node2.getFirstChild();
        boolean bl = false;
        if (node3.getType() == 44) {
            String string = node3.getString();
            bl = string.equals("eval") || string.equals("With");
        } else if (node3.getType() == 39) {
            String string = node3.getLastChild().getString();
            bl = string.equals("exec");
        }
        if (bl) {
            if (this.inFunction) {
                ((FunctionNode)node).setRequiresActivation(true);
            }
            return true;
        }
        return false;
    }

    protected VariableTable createVariableTable() {
        return new VariableTable();
    }

    protected VariableTable getVariableTable(Node node) {
        if (this.inFunction) {
            return ((FunctionNode)node).getVariableTable();
        }
        VariableTable variableTable = (VariableTable)node.getProp(10);
        if (variableTable == null) {
            variableTable = this.createVariableTable();
            node.putProp(10, variableTable);
        }
        return variableTable;
    }

    protected void reportMessage(Context context, String string, Node node, Node node2, boolean bl, Scriptable scriptable) {
        Object object;
        int n = node.getLineno();
        Object object2 = object = node2 == null ? null : node2.getProp(16);
        if (bl) {
            if (scriptable != null) {
                throw NativeGlobal.constructError(context, "SyntaxError", string, scriptable, (String)object, n, 0, null);
            }
            Context.reportError(string, (String)object, n, null, 0);
        } else {
            Context.reportWarning(string, (String)object, n, null, 0);
        }
    }
}

