/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Cursor;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideMetaData;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.util.swing.SlideDataLoader;
import org.tigr.microarray.util.swing.TAVFileFilter;
import org.tigr.util.swing.FileTransferDialog;
import org.tigr.util.swing.TXTFileFilter;

public abstract class ArrayViewer
extends JPanel {
    protected JFrame mainframe;
    protected boolean firstLoad = true;
    protected String currentDataPath;

    public ArrayViewer(JFrame jFrame) {
        this.mainframe = jFrame;
    }

    public JFrame getFrame() {
        return this.mainframe;
    }

    public void setCursor(int n) {
        this.setCursor(Cursor.getPredefinedCursor(n));
    }

    private File selectFile() {
        return this.selectFile("Select a datafile to open", true);
    }

    private File selectFile(String string, boolean bl) {
        JFileChooser jFileChooser = this.firstLoad ? new JFileChooser(System.getProperty("user.dir")) : new JFileChooser(this.currentDataPath);
        jFileChooser.setDialogTitle(string);
        jFileChooser.addChoosableFileFilter(new TXTFileFilter());
        jFileChooser.addChoosableFileFilter(new TAVFileFilter());
        if (!bl) {
            jFileChooser.setFileFilter(jFileChooser.getAcceptAllFileFilter());
        }
        jFileChooser.setMultiSelectionEnabled(bl);
        if (this.firstLoad) {
            jFileChooser.setCurrentDirectory(new File("Data"));
        }
        if (jFileChooser.showOpenDialog(this.getParent()) == 0) {
            File file = jFileChooser.getSelectedFile();
            this.firstLoad = false;
            this.currentDataPath = file.getParent();
            if (this.currentDataPath == null) {
                this.currentDataPath = file.getPath();
            }
            return file;
        }
        return null;
    }

    public ISlideData loadSlideData(ISlideMetaData iSlideMetaData) throws Exception {
        File file = this.selectFile();
        if (file == null) {
            return null;
        }
        SlideDataLoader slideDataLoader = this instanceof MultipleArrayViewer ? new SlideDataLoader(this.getFrame(), iSlideMetaData, file, false) : new SlideDataLoader(this.getFrame(), iSlideMetaData, file, true);
        if (slideDataLoader.showModal() != 0) {
            return null;
        }
        return slideDataLoader.getData(0);
    }

    public ISlideData[] loadDirectory(ISlideMetaData iSlideMetaData) throws Exception {
        String string;
        if (this.firstLoad) {
            String string2 = System.getProperty("user.dir");
            String string3 = "Data";
            string = new File(string2, string3).getPath();
        } else {
            string = this.currentDataPath;
        }
        return this.loadSlideDataDirectory(string, new FileFilter[]{new TAVFileFilter()}, iSlideMetaData);
    }

    private ISlideData[] loadSlideDataDirectory(String string, FileFilter[] fileFilterArray, ISlideMetaData iSlideMetaData) throws Exception {
        SlideDataLoader slideDataLoader;
        FileTransferDialog fileTransferDialog = new FileTransferDialog(this.getFrame(), string, fileFilterArray);
        if (fileTransferDialog.showModal() != 0) {
            return null;
        }
        File[] fileArray = fileTransferDialog.getFiles();
        if (fileArray.length < 1) {
            return null;
        }
        if (this.firstLoad) {
            this.firstLoad = false;
        }
        this.currentDataPath = fileArray[0].getParent();
        if (this.currentDataPath == null) {
            this.currentDataPath = fileArray[0].getPath();
        }
        if ((slideDataLoader = this instanceof MultipleArrayViewer ? new SlideDataLoader(this.getFrame(), iSlideMetaData, fileArray, false) : new SlideDataLoader(this.getFrame(), iSlideMetaData, fileArray, true)).showModal() != 0) {
            return null;
        }
        return slideDataLoader.getData();
    }

    public ISlideData[] loadStanfordFile(String string) throws Exception {
        File file = this.selectFile(string, false);
        if (file == null) {
            return null;
        }
        SlideDataLoader slideDataLoader = new SlideDataLoader(this.getFrame(), null, file, false);
        if (slideDataLoader.showModal(true) != 0) {
            return null;
        }
        return slideDataLoader.getData();
    }

    public abstract void systemDisable(int var1);

    public abstract void systemEnable(int var1);
}

