/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.action.ActionManager;
import org.tigr.microarray.mev.action.DefaultAction;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;

public class MultipleArrayMenubar
extends JMenuBar {
    private DisplayMenu displayMenu = new DisplayMenu();
    private DistanceMenu distanceMenu = new DistanceMenu();
    private JMenu normalizationMenu;
    private JMenu labelMenu;
    private JMenu adjustMenu;
    private ButtonGroup labelGroup;
    private JMenu sortMenu;
    private ButtonGroup sortGroup;
    private ActionListener listener;
    private ActionManager actionManager;

    public MultipleArrayMenubar(ActionManager actionManager) {
        this.listener = actionManager.getListener();
        this.actionManager = actionManager;
        JMenu jMenu = new JMenu("File");
        jMenu.add(this.createJMenuItem(actionManager.getAction("action-load")));
        jMenu.addSeparator();
        jMenu.add(this.createJMenuItem(actionManager.getAction("action-save-matrix")));
        jMenu.addSeparator();
        jMenu.add(this.createJMenuItem(actionManager.getAction("action-save-image")));
        jMenu.addSeparator();
        jMenu.add(this.createJMenuItem(actionManager.getAction("action-print-image")));
        jMenu.addSeparator();
        jMenu.add(this.createJMenuItem(actionManager.getAction("action-close")));
        this.add(jMenu);
        this.adjustMenu = new JMenu("Adjust Data");
        this.adjustMenu.add(this.createJMenuItem("Log2 Transform", "log2-transform-cmd", this.listener));
        this.adjustMenu.addSeparator();
        this.adjustMenu.add(this.createJMenuItem("Normalize Spots", "normalize-spots-cmd", this.listener));
        this.adjustMenu.add(this.createJMenuItem("Divide Spots by RMS", "divide-spots-rms-cmd", this.listener));
        this.adjustMenu.add(this.createJMenuItem("Divide Spots by SD", "divide-spots-sd-cmd", this.listener));
        this.adjustMenu.add(this.createJMenuItem("Mean Center Spots", "mean-center-spots-cmd", this.listener));
        this.adjustMenu.add(this.createJMenuItem("Median Center Spots", "median-center-spots-cmd", this.listener));
        this.adjustMenu.add(this.createJMenuItem("Digital Spots", "digital-spots-cmd", this.listener));
        this.adjustMenu.addSeparator();
        this.adjustMenu.add(this.createJMenuItem("Normalize Experiments", "normalize-experiments-cmd", this.listener));
        this.adjustMenu.add(this.createJMenuItem("Divide Experiments by RMS", "divide-experiments-rms-cmd", this.listener));
        this.adjustMenu.add(this.createJMenuItem("Divide Experiments by SD", "divide-experiments-sd-cmd", this.listener));
        this.adjustMenu.add(this.createJMenuItem("Mean Center Experiments", "mean-center-experiments-cmd", this.listener));
        this.adjustMenu.add(this.createJMenuItem("Median Center Experiments", "median-center-experiments-cmd", this.listener));
        this.adjustMenu.add(this.createJMenuItem("Digital Experiments", "digital-experiments-cmd", this.listener));
        this.adjustMenu.addSeparator();
        this.adjustMenu.add(this.createJMenuItem("Log10 to Log2", "log10-to-log2-cmd", this.listener));
        this.adjustMenu.addSeparator();
        this.adjustMenu.add(this.createJMenuItem("Set Lower Cutoffs", "set-lower-cutoffs-cmd", this.listener));
        this.adjustMenu.add(this.createJCheckBoxMenuItem("Use Lower Cutoffs", "use-lower-cutoffs-cmd", this.listener));
        this.adjustMenu.addSeparator();
        this.adjustMenu.add(this.createJMenuItem("Set Percentage Cutoffs", "set-percentage-cutoffs-cmd", this.listener));
        this.adjustMenu.add(this.createJCheckBoxMenuItem("Use Percentage Cutoffs", "use-percentage-cutoffs-cmd", this.listener));
        this.adjustMenu.addSeparator();
        this.adjustMenu.add(this.createJCheckBoxMenuItem("Adjust Intensities of '0'", "adjust-intensities-0-cmd", this.listener, true));
        if (TMEV.getDataType() == 2) {
            this.adjustMenu.addSeparator();
            this.adjustMenu.add(this.createJMenuItem("Set Detection Filter", "set-detection-filter-cmd", this.listener));
            this.adjustMenu.add(this.createJCheckBoxMenuItem("Use Detection Filter", "use-detection-filter-cmd", this.listener));
            this.adjustMenu.add(this.createJMenuItem("Set Fold Filter", "set-fold-filter-cmd", this.listener));
            this.adjustMenu.add(this.createJCheckBoxMenuItem("Use Fold Filter", "use-fold-filter-cmd", this.listener));
        }
        this.add(this.adjustMenu);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.normalizationMenu = new JMenu("Normalization");
        this.normalizationMenu.add(this.createJRadioButtonMenuItem("Total Intensity", "total-intensity-cmd", this.listener, buttonGroup));
        this.normalizationMenu.add(this.createJRadioButtonMenuItem("Linear Regression", "linear-regression-cmd", this.listener, buttonGroup));
        this.normalizationMenu.add(this.createJRadioButtonMenuItem("Ratio Statistics", "ratio-statistics-cmd", this.listener, buttonGroup));
        this.normalizationMenu.add(this.createJRadioButtonMenuItem("Iterative Log", "iterative-log-cmd", this.listener, buttonGroup));
        this.normalizationMenu.addSeparator();
        this.normalizationMenu.add(this.createJRadioButtonMenuItem("No Normalization", "no-normalization-cmd", this.listener, buttonGroup, true));
        this.add(this.normalizationMenu);
        buttonGroup = new ButtonGroup();
        JMenu jMenu2 = new JMenu("Distance");
        jMenu2.add(this.createJRadioButtonMenuItem("Default Distance", "default-distance-cmd", this.listener, buttonGroup, true));
        jMenu2.addSeparator();
        jMenu2.add(this.createJRadioButtonMenuItem("Pearson Correlation", "pearson-correlation-cmd", this.listener, buttonGroup));
        jMenu2.add(this.createJRadioButtonMenuItem("Pearson Uncentered", "pearson-uncentered-cmd", this.listener, buttonGroup));
        jMenu2.add(this.createJRadioButtonMenuItem("Pearson Squared", "pearson-squared-cmd", this.listener, buttonGroup));
        jMenu2.add(this.createJRadioButtonMenuItem("Cosine Correlation", "cosine-correlation-cmd", this.listener, buttonGroup));
        jMenu2.add(this.createJRadioButtonMenuItem("Covariance Value", "covariance-value-cmd", this.listener, buttonGroup));
        jMenu2.add(this.createJRadioButtonMenuItem("Euclidean Distance", "euclidean-distance-cmd", this.listener, buttonGroup));
        jMenu2.add(this.createJRadioButtonMenuItem("Average Dot Product", "average-dot-product-cmd", this.listener, buttonGroup));
        jMenu2.add(this.createJRadioButtonMenuItem("Manhattan Distance", "manhattan-distance-cmd", this.listener, buttonGroup));
        jMenu2.addSeparator();
        jMenu2.add(this.createJRadioButtonMenuItem("Mutual Information", "mutual-information-cmd", this.listener, buttonGroup));
        jMenu2.add(this.createJRadioButtonMenuItem("Spearman Rank Correlation", "spearman-rank-correlation-cmd", this.listener, buttonGroup));
        jMenu2.add(this.createJRadioButtonMenuItem("Kendall's Tau", "kendalls-tau-cmd", this.listener, buttonGroup));
        jMenu2.addSeparator();
        jMenu2.add(this.createJCheckBoxMenuItem("Absolute distance", "absolute-distance-cmd", this.listener, false));
        this.add(jMenu2);
        JMenu jMenu3 = new JMenu("Analysis");
        this.addAnalysisMenu(jMenu3, actionManager);
        jMenu3.addSeparator();
        jMenu3.add(actionManager.getAction("delete-all-action"));
        jMenu3.addSeparator();
        jMenu3.add(actionManager.getAction("delete-all-experiments-action"));
        jMenu3.addSeparator();
        jMenu3.add(actionManager.getAction("show-thumbnail-action"));
        this.add(jMenu3);
        JMenu jMenu4 = new JMenu("Display");
        buttonGroup = new ButtonGroup();
        JMenu jMenu5 = new JMenu("Color Scheme");
        jMenu5.add(this.createJRadioButtonMenuItem("Green/Red Scheme", "display-green-red-scheme-cmd", this.listener, buttonGroup, true));
        jMenu5.add(this.createJRadioButtonMenuItem("Blue/Yellow Scheme", "display-blue-yellow-scheme-cmd", this.listener, buttonGroup));
        jMenu5.add(this.createJRadioButtonMenuItem("Custom Color Scheme", "display-custom-color-scheme-cmd", this.listener, buttonGroup));
        jMenu5.add(this.createJCheckBoxMenuItem("Use Color Gradient on Graphs", "display-color-gradient-cmd", this.listener));
        jMenu4.add(jMenu5);
        jMenu4.addSeparator();
        buttonGroup = new ButtonGroup();
        jMenu4.add(this.createJRadioButtonMenuItem("Expression Bar View", "display-green-red-cmd", this.listener, buttonGroup));
        jMenu4.add(this.createJRadioButtonMenuItem("Ratio Split View", "display-gr-ratio-split-cmd", this.listener, buttonGroup, true));
        jMenu4.add(this.createJRadioButtonMenuItem("Color Overlay View", "display-gr-overlay-cmd", this.listener, buttonGroup));
        jMenu4.addSeparator();
        jMenu4.add(this.createJMenuItem("Abbr. Experiment Names", "toggle-abbr-expt-names-cmd", this.listener));
        jMenu4.addSeparator();
        this.labelMenu = new JMenu("Label");
        this.labelGroup = new ButtonGroup();
        jMenu4.add(this.labelMenu);
        jMenu4.addSeparator();
        jMenu4.add(this.createJCheckBoxMenuItem("G/R Scale", "display-gr-dcale-cmd", this.listener, true));
        jMenu4.add(this.createJCheckBoxMenuItem("Draw Borders", "display-draw-borders-cmd", this.listener, false));
        jMenu4.add(this.createJCheckBoxMenuItem("Tracing", "display-tracing-cmd", this.listener));
        jMenu4.add(this.createJCheckBoxMenuItem("Use Anti-Aliasing", "display-use-antialiasing-cmd", this.listener, true));
        jMenu4.addSeparator();
        jMenu4.add(this.createJMenuItem("Set Upper Limits", "display-set-upper-limits-cmd", this.listener));
        jMenu4.add(this.createJMenuItem("Set Ratio Scale", "display-set-ratio-scale-cmd", this.listener));
        JMenu jMenu6 = new JMenu("Element Size");
        buttonGroup = new ButtonGroup();
        jMenu6.add(this.createJRadioButtonMenuItem("5 x 2", "display-5x2-cmd", this.listener, buttonGroup));
        jMenu6.add(this.createJRadioButtonMenuItem("10 x 10", "display-10x10-cmd", this.listener, buttonGroup));
        jMenu6.add(this.createJRadioButtonMenuItem("20 x 5", "display-20x5-cmd", this.listener, buttonGroup, true));
        jMenu6.add(this.createJRadioButtonMenuItem("50 x 10", "display-50x10-cmd", this.listener, buttonGroup));
        jMenu6.add(this.createJRadioButtonMenuItem("Other", "display-other-cmd", this.listener, buttonGroup));
        jMenu4.add(jMenu6);
        this.add(jMenu4);
        this.sortGroup = new ButtonGroup();
        this.sortMenu = new JMenu("Sort");
        this.sortMenu.add(this.createJRadioButtonMenuItem("Sort by Location", "sort-by-location-cmd", this.listener, this.sortGroup, true));
        this.sortMenu.add(this.createJRadioButtonMenuItem("Sort by Ratio", "sort-by-ratio-cmd", this.listener, this.sortGroup));
        ((JRadioButtonMenuItem)this.sortMenu.getMenuComponent(0)).setSelected(true);
        this.add(this.sortMenu);
        JMenu jMenu7 = new JMenu("Help");
        jMenu7.add(this.createJMenuItem("Default Distances", "default-distances-cmd", this.listener));
        jMenu7.add(this.createJMenuItem("Support Tree Legend", "show-supporttree-legend-command", this.listener));
        this.add(jMenu7);
    }

    public void systemEnable(int n) {
        switch (n) {
            case 1000: {
                this.setEnableMenu("File", true);
                this.setEnableMenuItem("File", "command-load-stanford", true);
                break;
            }
            case 1003: {
                this.setEnableMenu("File", true);
                this.setEnableMenuItem("File", "command-save-matrix", true);
                this.setEnableMenuItem("File", "command-save-image", true);
                this.setEnableMenuItem("File", "command-print-image", true);
                this.setEnableMenu("Adjust Data", true);
                this.setEnableMenu("Normalization", true);
                this.setEnableMenu("Distance", true);
                this.setEnableMenu("Analysis", true);
                this.setEnableMenu("Display", true);
                this.setEnableMenu("Sort", true);
                break;
            }
            case 1001: {
                break;
            }
            case 1002: {
                this.setEnableMenuItem("File", "command-load-db", true);
            }
        }
    }

    public void systemDisable(int n) {
        switch (n) {
            case 1000: {
                this.setEnableMenu("File", true);
                this.setEnableMenuItem("File", "command-load-db", false);
                this.setEnableMenuItem("File", "command-load-file", false);
                this.setEnableMenuItem("File", "command-load-directory", false);
                this.setEnableMenuItem("File", "command-load-stanford", false);
                break;
            }
            case 1003: {
                this.setEnableMenu("File", true);
                this.setEnableMenuItem("File", "command-save-matrix", false);
                this.setEnableMenuItem("File", "command-save-image", false);
                this.setEnableMenuItem("File", "command-print-image", false);
                this.setEnableMenu("Adjust Data", false);
                this.setEnableMenu("Normalization", false);
                this.setEnableMenu("Distance", false);
                break;
            }
            case 1001: {
                this.setEnableMenu("File", true);
                this.setEnableMenuItem("File", "command-load-db", false);
                break;
            }
            case 1002: {
                this.setEnableMenu("File", true);
                this.setEnableMenuItem("File", "command-load-db", false);
            }
        }
        this.setEnableMenu("Analysis", false);
        this.setEnableMenu("Display", false);
        this.setEnableMenu("Sort", false);
    }

    private void addLabelMenuItems(JMenu jMenu, ActionManager actionManager, ButtonGroup buttonGroup) {
        Action action;
        int n = -1;
        while ((action = actionManager.getAction("display--label-action" + String.valueOf(n))) != null) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(action);
            buttonGroup.add(jRadioButtonMenuItem);
            if (n < 1) {
                jRadioButtonMenuItem.setSelected(true);
                String string = (String)action.getValue("command-parameter");
                this.displayMenu.labelIndex = Integer.parseInt(string);
            }
            jMenu.add(jRadioButtonMenuItem);
            ++n;
        }
    }

    public void addLabelMenuItems(String[] stringArray) {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < stringArray.length; ++i) {
            DefaultAction defaultAction = new DefaultAction(this.actionManager, "Label by " + stringArray[i], "display-label-cmd");
            defaultAction.putValue("command-parameter", String.valueOf(i));
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(defaultAction);
            this.labelGroup.add(jRadioButtonMenuItem);
            if (i == 0) {
                jRadioButtonMenuItem.setSelected(true);
            }
            this.labelMenu.add(jRadioButtonMenuItem);
        }
    }

    public void addAffyFilterMenuItems() {
        this.adjustMenu.addSeparator();
        this.adjustMenu.add(this.createJMenuItem("Set Detection Filter", "set-detection-filter-cmd", this.listener));
        this.adjustMenu.add(this.createJCheckBoxMenuItem("Use Detection Filter", "use-detection-filter-cmd", this.listener));
        this.adjustMenu.add(this.createJMenuItem("Set Fold Filter", "set-fold-filter-cmd", this.listener));
        this.adjustMenu.add(this.createJCheckBoxMenuItem("Use Fold Filter", "use-fold-filter-cmd", this.listener));
    }

    private void addSortMenuItems(JMenu jMenu, ActionManager actionManager, ButtonGroup buttonGroup) {
        Action action;
        int n = 0;
        while ((action = actionManager.getAction("sort-label-action" + String.valueOf(n))) != null) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(action);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            ++n;
        }
    }

    public void addSortMenuItems(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            DefaultAction defaultAction = new DefaultAction(this.actionManager, "Sort by " + stringArray[i], "sort-label-cmd");
            defaultAction.putValue("command-parameter", String.valueOf(i));
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(defaultAction);
            this.sortGroup.add(jRadioButtonMenuItem);
            this.sortMenu.add(jRadioButtonMenuItem);
        }
    }

    public void addAnalysisMenu(JMenu jMenu, ActionManager actionManager) {
        Action action;
        int n = 0;
        while ((action = actionManager.getAction("analysis-action" + String.valueOf(n))) != null) {
            jMenu.add(this.createJMenuItem(action));
            ++n;
        }
    }

    public IDisplayMenu getDisplayMenu() {
        return this.displayMenu;
    }

    public IDistanceMenu getDistanceMenu() {
        return this.distanceMenu;
    }

    private JMenuItem createJMenuItem(Action action) {
        JMenuItem jMenuItem = new JMenuItem(action);
        jMenuItem.setActionCommand((String)action.getValue("ActionCommandKey"));
        return jMenuItem;
    }

    private JMenuItem createJMenuItem(String string, String string2, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    private JCheckBoxMenuItem createJCheckBoxMenuItem(String string, String string2, ActionListener actionListener, boolean bl) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
        jCheckBoxMenuItem.setActionCommand(string2);
        jCheckBoxMenuItem.addActionListener(actionListener);
        jCheckBoxMenuItem.setSelected(bl);
        return jCheckBoxMenuItem;
    }

    private JCheckBoxMenuItem createJCheckBoxMenuItem(String string, String string2, ActionListener actionListener) {
        return this.createJCheckBoxMenuItem(string, string2, actionListener, false);
    }

    private JRadioButtonMenuItem createJRadioButtonMenuItem(String string, String string2, ActionListener actionListener, ButtonGroup buttonGroup, boolean bl) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
        jRadioButtonMenuItem.setActionCommand(string2);
        jRadioButtonMenuItem.addActionListener(actionListener);
        jRadioButtonMenuItem.setSelected(bl);
        if (buttonGroup != null) {
            buttonGroup.add(jRadioButtonMenuItem);
        }
        return jRadioButtonMenuItem;
    }

    private JRadioButtonMenuItem createJRadioButtonMenuItem(String string, String string2, ActionListener actionListener, ButtonGroup buttonGroup) {
        return this.createJRadioButtonMenuItem(string, string2, actionListener, buttonGroup, false);
    }

    public JMenu getJMenu(String string) {
        for (int i = 0; i < this.getMenuCount(); ++i) {
            JMenu jMenu = this.getMenu(i);
            if (jMenu == null || !jMenu.getText().equals(string)) continue;
            return jMenu;
        }
        return null;
    }

    public JMenuItem getJMenuItem(String string, String string2) {
        JMenu jMenu = this.getJMenu(string);
        if (jMenu == null) {
            return null;
        }
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null || !jMenuItem.getActionCommand().equals(string2)) continue;
            return jMenuItem;
        }
        return null;
    }

    private void setEnableMenu(String string, boolean bl) {
        JMenu jMenu = this.getJMenu(string);
        if (jMenu == null) {
            return;
        }
        jMenu.setEnabled(bl);
    }

    private void setEnableMenuItem(String string, String string2, boolean bl) {
        JMenuItem jMenuItem = this.getJMenuItem(string, string2);
        if (jMenuItem == null) {
            return;
        }
        jMenuItem.setEnabled(bl);
    }

    void setLabelIndex(int n) {
        this.displayMenu.labelIndex = n;
    }

    void setElementSize(int n, int n2) {
        this.displayMenu.elementSize.setSize(n, n2);
    }

    void setPaletteStyle(int n) {
        this.displayMenu.paletteStyle = n;
    }

    void setTracing(boolean bl) {
        this.displayMenu.tracing = bl;
    }

    void setDrawBorders(boolean bl) {
        this.displayMenu.drawBorders = bl;
    }

    void setAntiAliasing(boolean bl) {
        this.displayMenu.antialiasing = bl;
    }

    void setGRScale(boolean bl) {
        this.displayMenu.grscale = bl;
    }

    void setDistanceAbsolute(boolean bl) {
        this.distanceMenu.absolute = bl;
    }

    void setDistanceFunction(int n) {
        this.distanceMenu.function = n;
    }

    void setMinRatioScale(float f) {
        this.displayMenu.minRatioScale = f;
    }

    void setMaxRatioScale(float f) {
        this.displayMenu.maxRatioScale = f;
    }

    void setMaxCY3Scale(float f) {
        this.displayMenu.maxCY3Scale = f;
    }

    void setMaxCY5Scale(float f) {
        this.displayMenu.maxCY5Scale = f;
    }

    void setPositiveCustomGradient(BufferedImage bufferedImage) {
        this.displayMenu.posCustomColorImage = bufferedImage;
    }

    void setNegativeCustomGradient(BufferedImage bufferedImage) {
        this.displayMenu.negCustomColorImage = bufferedImage;
    }

    void setColorSchemeIndex(int n) {
        this.displayMenu.colorScheme = n;
    }

    int getColorScheme() {
        return this.displayMenu.colorScheme;
    }

    public BufferedImage getPositiveGradientImage() {
        return this.displayMenu.getPositiveGradientImage();
    }

    public BufferedImage getNegativeGradientImage() {
        return this.displayMenu.getNegativeGradientImage();
    }

    public boolean getColorGradientState() {
        return this.displayMenu.getColorGradientState();
    }

    public void setColorGradientState(boolean bl) {
        this.displayMenu.setColorGradientState(bl);
    }

    public void setNormalizedButtonState(int n) {
        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)this.normalizationMenu.getMenuComponent(n);
        jRadioButtonMenuItem.setSelected(true);
    }

    static {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
    }

    private class DistanceMenu
    implements IDistanceMenu {
        private boolean absolute = false;
        private int function = 0;

        private DistanceMenu() {
        }

        public boolean isAbsoluteDistance() {
            return this.absolute;
        }

        public int getDistanceFunction() {
            return this.function;
        }

        public String getFunctionName(int n) {
            String string;
            switch (n) {
                case 0: {
                    string = "Euclidean distance";
                    break;
                }
                case 1: {
                    string = "Pearson correlation";
                    break;
                }
                case 2: {
                    string = "Cosine correlation";
                    break;
                }
                case 3: {
                    string = "Covariance";
                    break;
                }
                case 4: {
                    string = "Euclidean distance";
                    break;
                }
                case 5: {
                    string = "Average dot product";
                    break;
                }
                case 6: {
                    string = "Pearson uncentered";
                    break;
                }
                case 7: {
                    string = "Pearson squared";
                    break;
                }
                case 8: {
                    string = "Manhattan distance";
                    break;
                }
                case 9: {
                    string = "Spearman rank correlation";
                    break;
                }
                case 10: {
                    string = "Kendall's Tau";
                    break;
                }
                case 11: {
                    string = "Mutual information";
                    break;
                }
                default: {
                    string = "Euclidean distance";
                }
            }
            return string;
        }
    }

    private class DisplayMenu
    implements IDisplayMenu {
        private final Dimension elementSize = new Dimension(20, 5);
        private int labelIndex;
        private int paletteStyle = 4;
        private boolean tracing = false;
        private boolean drawBorders = false;
        private boolean antialiasing = true;
        private boolean grscale = true;
        private boolean useColorGradient = false;
        private float minRatioScale = -3.0f;
        private float maxRatioScale = 3.0f;
        private float maxCY3Scale = 0.0f;
        private float maxCY5Scale = 0.0f;
        private int colorScheme = 5;
        private BufferedImage negGreenColorImage = this.createGradientImage(Color.green, Color.black);
        private BufferedImage posRedColorImage = this.createGradientImage(Color.black, Color.red);
        private BufferedImage negBlueColorImage = this.createGradientImage(Color.blue, Color.black);
        private BufferedImage posYellowColorImage = this.createGradientImage(Color.black, Color.yellow);
        private BufferedImage negCustomColorImage;
        private BufferedImage posCustomColorImage;

        private DisplayMenu() {
        }

        public int getPaletteStyle() {
            return this.paletteStyle;
        }

        public boolean isGRScale() {
            return this.grscale;
        }

        public Dimension getElementSize() {
            return this.elementSize;
        }

        public boolean isDrawingBorder() {
            return this.drawBorders;
        }

        public boolean isTracing() {
            return this.tracing;
        }

        public boolean isAntiAliasing() {
            return this.antialiasing;
        }

        public int getLabelIndex() {
            return this.labelIndex;
        }

        public float getMaxRatioScale() {
            return this.maxRatioScale;
        }

        public float getMinRatioScale() {
            return this.minRatioScale;
        }

        public float getMaxCY3Scale() {
            return this.maxCY3Scale;
        }

        public float getMaxCY5Scale() {
            return this.maxCY5Scale;
        }

        public BufferedImage getPositiveGradientImage() {
            BufferedImage bufferedImage = this.posRedColorImage;
            switch (this.colorScheme) {
                case 5: {
                    break;
                }
                case 6: {
                    bufferedImage = this.posYellowColorImage;
                    break;
                }
                case 7: {
                    if (this.posCustomColorImage == null) break;
                    bufferedImage = this.posCustomColorImage;
                }
            }
            return bufferedImage;
        }

        public BufferedImage getNegativeGradientImage() {
            BufferedImage bufferedImage = this.negGreenColorImage;
            switch (this.colorScheme) {
                case 5: {
                    break;
                }
                case 6: {
                    bufferedImage = this.negBlueColorImage;
                    break;
                }
                case 7: {
                    if (this.negCustomColorImage == null) break;
                    bufferedImage = this.negCustomColorImage;
                }
            }
            return bufferedImage;
        }

        public BufferedImage createGradientImage(Color color, Color color2) {
            BufferedImage bufferedImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(256, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 255.0f, 0.0f, color2);
            graphics2D.setPaint(gradientPaint);
            graphics2D.drawRect(0, 0, 255, 1);
            return bufferedImage;
        }

        public boolean getColorGradientState() {
            return this.useColorGradient;
        }

        public void setColorGradientState(boolean bl) {
            this.useColorGradient = bl;
        }
    }
}

