/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.util.HashSet;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.microarray.mev.cluster.algorithm.impl.KMC;
import org.tigr.util.FloatMatrix;

public class KMCSupport
extends AbstractAlgorithm {
    private boolean stop = false;
    private int function;
    private float factor;
    private boolean absolute;
    private Vector clusterVector = new Vector();
    boolean[] assigned;
    private Vector[] clusters;
    private boolean kmcGenes;
    private int numGenes;
    private int numSamples;
    private int numReps;
    private int k;
    private float thresholdPercent;
    private float[][] geneMatrix;
    private int userK;
    private FloatMatrix expMatrix;
    private int iterations;
    private boolean converged;
    private boolean unassignedExists;
    private boolean calculateMeans;
    HashSet unassignedGeneSet = new HashSet();
    int validN;

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        int n;
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.function = algorithmParameters.getInt("distance-function", 4);
        this.factor = algorithmParameters.getFloat("distance-factor", 1.0f);
        this.absolute = algorithmParameters.getBoolean("distance-absolute", false);
        this.iterations = algorithmParameters.getInt("number_of_iterations", 50);
        this.kmcGenes = algorithmParameters.getBoolean("kmc-cluster-genes", true);
        boolean bl = algorithmParameters.getBoolean("hierarchical-tree", false);
        int n2 = algorithmParameters.getInt("method-linkage", 0);
        boolean bl2 = algorithmParameters.getBoolean("calculate-genes", false);
        boolean bl3 = algorithmParameters.getBoolean("calculate-experiments", false);
        this.expMatrix = algorithmData.getMatrix("experiment");
        this.numGenes = this.expMatrix.getRowDimension();
        this.numSamples = this.expMatrix.getColumnDimension();
        this.numReps = algorithmParameters.getInt("number_of_repetitions", 0);
        this.thresholdPercent = algorithmParameters.getFloat("threshold-percent", 80.0f);
        this.userK = algorithmParameters.getInt("number-of-desired-clusters", 5);
        this.calculateMeans = algorithmParameters.getBoolean("calculate-means", true);
        this.geneMatrix = new float[this.numGenes][];
        this.assigned = new boolean[this.numGenes];
        this.unassignedExists = false;
        for (n = 0; n < this.numGenes; ++n) {
            this.assigned[n] = false;
        }
        for (n = 1; n < this.numGenes; ++n) {
            this.geneMatrix[n] = new float[n];
            for (int i = 0; i < this.geneMatrix[n].length; ++i) {
                this.geneMatrix[n][i] = 0.0f;
            }
        }
        this.populateGeneMatrix();
        this.createClusters();
        this.k = this.clusterVector.size();
        this.clusters = new Vector[this.k];
        for (n = 0; n < this.k; ++n) {
            this.clusters[n] = (Vector)this.clusterVector.get(n);
        }
        FloatMatrix floatMatrix = this.getMeans(this.clusters);
        FloatMatrix floatMatrix2 = this.getVariances(this.clusters, floatMatrix);
        AlgorithmEvent algorithmEvent = null;
        if (bl) {
            algorithmEvent = new AlgorithmEvent(this, 1, this.clusters.length, "Calculate Hierarchical Trees");
            this.fireValueChanged(algorithmEvent);
            algorithmEvent.setIntValue(0);
            algorithmEvent.setId(2);
            this.fireValueChanged(algorithmEvent);
        }
        Cluster cluster = new Cluster();
        NodeList nodeList = cluster.getNodeList();
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] nArray = this.convert2int(this.clusters[i]);
            Node node = new Node(nArray);
            nodeList.addNode(node);
            if (!bl) continue;
            node.setValues(this.calculateHierarchicalTree(nArray, n2, bl2, bl3));
            algorithmEvent.setIntValue(i + 1);
            this.fireValueChanged(algorithmEvent);
        }
        AlgorithmData algorithmData2 = new AlgorithmData();
        algorithmData2.addCluster("cluster", cluster);
        algorithmData2.addParam("number-of-clusters", String.valueOf(this.clusters.length));
        algorithmData2.addParam("unassigned-genes-exist", String.valueOf(this.unassignedExists));
        algorithmData2.addMatrix("clusters_means", floatMatrix);
        algorithmData2.addMatrix("clusters_variances", floatMatrix2);
        return algorithmData2;
    }

    private NodeValueList calculateHierarchicalTree(int[] nArray, int n, boolean bl, boolean bl2) throws AlgorithmException {
        AlgorithmData algorithmData;
        NodeValueList nodeValueList = new NodeValueList();
        AlgorithmData algorithmData2 = new AlgorithmData();
        FloatMatrix floatMatrix = this.kmcGenes ? this.getSubExperiment(this.expMatrix, nArray) : this.getSubExperimentReducedCols(this.expMatrix, nArray);
        algorithmData2.addMatrix("experiment", floatMatrix);
        algorithmData2.addParam("distance-function", String.valueOf(this.function));
        algorithmData2.addParam("distance-absolute", String.valueOf(this.absolute));
        algorithmData2.addParam("method-linkage", String.valueOf(n));
        HCL hCL = new HCL();
        if (bl) {
            algorithmData2.addParam("calculate-genes", String.valueOf(true));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        if (bl2) {
            algorithmData2.addParam("calculate-genes", String.valueOf(false));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        return nodeValueList;
    }

    private void addNodeValues(NodeValueList nodeValueList, AlgorithmData algorithmData) {
        nodeValueList.addNodeValue(new NodeValue("child-1-array", algorithmData.getIntArray("child-1-array")));
        nodeValueList.addNodeValue(new NodeValue("child-2-array", algorithmData.getIntArray("child-2-array")));
        nodeValueList.addNodeValue(new NodeValue("node-order", algorithmData.getIntArray("node-order")));
        nodeValueList.addNodeValue(new NodeValue("height", algorithmData.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(nArray.length, floatMatrix.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix2.A[i] = floatMatrix.A[nArray[i]];
        }
        return floatMatrix2;
    }

    private FloatMatrix getSubExperimentReducedCols(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = floatMatrix.copy();
        FloatMatrix floatMatrix3 = new FloatMatrix(nArray.length, floatMatrix2.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix3.A[i] = floatMatrix2.A[nArray[i]];
        }
        floatMatrix3 = floatMatrix3.transpose();
        return floatMatrix3;
    }

    private void validate(AlgorithmData algorithmData) throws AlgorithmException {
        if (algorithmData.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (algorithmData.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (algorithmData.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (algorithmData.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(Vector vector) {
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    private FloatMatrix getMeans(Vector[] vectorArray) {
        FloatMatrix floatMatrix = new FloatMatrix(vectorArray.length, this.numSamples);
        for (int i = 0; i < vectorArray.length; ++i) {
            FloatMatrix floatMatrix2 = this.getMean(vectorArray[i]);
            floatMatrix.A[i] = floatMatrix2.A[0];
        }
        return floatMatrix;
    }

    private FloatMatrix getMean(Vector vector) {
        FloatMatrix floatMatrix = new FloatMatrix(1, this.numSamples);
        int n = vector.size();
        for (int i = 0; i < this.numSamples; ++i) {
            float f = 0.0f;
            int n2 = 0;
            for (int j = 0; j < n; ++j) {
                float f2 = this.expMatrix.get((Integer)vector.get(j), i);
                if (Float.isNaN(f2)) continue;
                f += f2;
                ++n2;
            }
            floatMatrix.set(0, i, f / (float)n2);
        }
        return floatMatrix;
    }

    private FloatMatrix getVariances(Vector[] vectorArray, FloatMatrix floatMatrix) {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                floatMatrix2.set(i, j, this.getSampleVariance(vectorArray[i], j, floatMatrix.get(i, j)));
            }
        }
        return floatMatrix2;
    }

    private float getSampleNormalizedSum(Vector vector, int n, float f) {
        int n2 = vector.size();
        float f2 = 0.0f;
        this.validN = 0;
        for (int i = 0; i < n2; ++i) {
            float f3 = this.expMatrix.get((Integer)vector.get(i), n);
            if (Float.isNaN(f3)) continue;
            f2 = (float)((double)f2 + Math.pow(f3 - f, 2.0));
            ++this.validN;
        }
        return f2;
    }

    private float getSampleVariance(Vector vector, int n, float f) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(vector, n, f) / (float)(this.validN - 1));
    }

    void populateGeneMatrix() throws AlgorithmException {
        int n;
        KMC kMC = new KMC();
        AlgorithmData algorithmData = new AlgorithmData();
        algorithmData.addMatrix("experiment", this.expMatrix);
        algorithmData.addParam("distance-factor", String.valueOf(this.factor));
        algorithmData.addParam("distance-absolute", String.valueOf(this.absolute));
        algorithmData.addParam("distance-function", String.valueOf(this.function));
        algorithmData.addParam("number_of_iterations", String.valueOf(this.iterations));
        algorithmData.addParam("number_of_clusters", String.valueOf(this.userK));
        algorithmData.addParam("calculate-means", String.valueOf(this.calculateMeans));
        AlgorithmEvent algorithmEvent = new AlgorithmEvent(this, 1, this.numReps);
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        for (n = 0; n < this.numReps; ++n) {
            if (this.stop) {
                throw new AbortException();
            }
            algorithmEvent.setIntValue(n);
            algorithmEvent.setDescription("Current repetition = " + (n + 1));
            this.fireValueChanged(algorithmEvent);
            AlgorithmData algorithmData2 = kMC.execute(algorithmData);
            Cluster cluster = algorithmData2.getCluster("cluster");
            Vector vector = this.getClusterVector(cluster);
            for (int i = 1; i < this.numGenes; ++i) {
                for (int j = 0; j < i; ++j) {
                    if (!this.occurInSameCluster(i, j, vector)) continue;
                    this.geneMatrix[i][j] = this.geneMatrix[i][j] + 1.0f;
                }
            }
        }
        for (n = 1; n < this.numGenes; ++n) {
            for (int i = 0; i < n; ++i) {
                this.geneMatrix[n][i] = this.geneMatrix[n][i] / (float)this.numReps * 100.0f;
            }
        }
    }

    private Vector getClusterVector(Cluster cluster) {
        NodeList nodeList = cluster.getNodeList();
        int n = nodeList.getSize();
        Vector vector = new Vector();
        for (int i = 0; i < n; ++i) {
            int[] nArray = nodeList.getNode(i).getFeaturesIndexes();
            Vector<Integer> vector2 = new Vector<Integer>();
            for (int j = 0; j < nArray.length; ++j) {
                vector2.add(new Integer(nArray[j]));
            }
            vector.add(vector2);
        }
        return vector;
    }

    boolean occurInSameCluster(int n, int n2, Vector vector) {
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = (Vector)vector.get(i);
            if (!this.isFound(n, vector2) || !this.isFound(n2, vector2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    void createClusters() throws AlgorithmException {
        Vector vector;
        Vector vector2;
        int n;
        block0: for (int i = 1; i < this.numGenes; ++i) {
            for (int j = 0; j < i; ++j) {
                if (!(this.geneMatrix[i][j] >= this.thresholdPercent)) continue;
                if (this.assigned[j]) {
                    this.addToCluster(i, j);
                    this.assigned[i] = true;
                    continue block0;
                }
                Vector<Integer> vector3 = new Vector<Integer>();
                vector3.add(new Integer(i));
                vector3.add(new Integer(j));
                this.clusterVector.add(vector3);
                this.assigned[i] = true;
                this.assigned[j] = true;
                continue block0;
            }
        }
        for (int i = 0; i < this.assigned.length; ++i) {
            if (this.assigned[i]) continue;
            this.unassignedGeneSet.add(new Integer(i));
        }
        System.out.println();
        Vector<Vector> vector4 = new Vector<Vector>();
        for (n = 0; n < this.clusterVector.size(); ++n) {
            vector2 = (Vector)this.clusterVector.get(n);
            vector = this.weedOutLowerThanThreshGenes(vector2);
            if (vector.size() <= 0) continue;
            vector4.add(vector);
        }
        this.clusterVector = vector4;
        if (this.unassignedGeneSet.size() > 0) {
            for (n = 0; n < this.clusterVector.size(); ++n) {
                vector2 = (Vector)this.clusterVector.get(n);
                vector = this.recheckWithUnassigned(vector2);
                this.clusterVector.set(n, vector);
            }
        }
        if (this.unassignedGeneSet.size() > 0) {
            this.unassignedExists = true;
            Vector vector5 = new Vector(this.unassignedGeneSet);
            this.clusterVector.add(vector5);
        }
        for (int i = 0; i < this.numGenes; ++i) {
            int n2 = 0;
            for (int j = 0; j < this.clusterVector.size(); ++j) {
                if (!this.isFound(i, (Vector)this.clusterVector.get(j))) continue;
                ++n2;
            }
            if (n2 > 1) {
                System.out.println("Warning: UniqueID[" + i + "] is found in " + n2 + "clusters");
            }
            this.errorCheck1(i);
            this.errorCheck2(i);
        }
    }

    private Vector weedOutLowerThanThreshGenes(Vector vector) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < vector.size() - 1; ++i) {
            int n = (Integer)vector.get(i);
            for (int j = i + 1; j < vector.size(); ++j) {
                int n2 = (Integer)vector.get(j);
                if (n > n2) {
                    if (!(this.geneMatrix[n][n2] < this.thresholdPercent)) continue;
                    this.unassignedGeneSet.add(new Integer(n));
                    this.unassignedGeneSet.add(new Integer(n2));
                    hashSet.add(new Integer(n));
                    hashSet.add(new Integer(n2));
                    continue;
                }
                if (n >= n2 || !(this.geneMatrix[n2][n] < this.thresholdPercent)) continue;
                this.unassignedGeneSet.add(new Integer(n));
                this.unassignedGeneSet.add(new Integer(n2));
                hashSet.add(new Integer(n));
                hashSet.add(new Integer(n2));
            }
        }
        vector.removeAll(hashSet);
        return vector;
    }

    private Vector recheckWithUnassigned(Vector vector) {
        Vector vector2 = new Vector(this.unassignedGeneSet);
        for (int i = 0; i < vector2.size(); ++i) {
            int n = (Integer)vector2.get(i);
            if (!this.belongsInCluster(n, vector)) continue;
            vector.add(new Integer(n));
            this.unassignedGeneSet.remove(new Integer(n));
        }
        return vector;
    }

    private boolean belongsInCluster(int n, Vector vector) {
        boolean bl = true;
        for (int i = 0; i < vector.size(); ++i) {
            int n2 = (Integer)vector.get(i);
            if (n == n2) {
                bl = true;
                break;
            }
            if (n > n2) {
                if (!(this.geneMatrix[n][n2] < this.thresholdPercent)) continue;
                bl = false;
                break;
            }
            if (n >= n2 || !(this.geneMatrix[n2][n] < this.thresholdPercent)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    void addToCluster(int n, int n2) {
        for (int i = 0; i < this.clusterVector.size(); ++i) {
            Vector vector = (Vector)this.clusterVector.get(i);
            if (!this.isFound(n2, vector)) continue;
            vector.add(new Integer(n));
            this.clusterVector.set(i, vector);
            break;
        }
    }

    boolean isFound(int n, Vector vector) {
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            if (n != (Integer)vector.get(i)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean unassignedGenesExist() {
        return this.unassignedExists;
    }

    void errorCheck1(int n) {
        boolean bl = false;
        if (n == 0) {
            if (!this.assigned[n]) {
                for (int i = 1; i < this.numGenes; ++i) {
                    if (!(this.geneMatrix[i][0] >= this.thresholdPercent)) continue;
                    bl = true;
                    break;
                }
            }
        } else if (!this.assigned[n]) {
            for (int i = 0; i < n; ++i) {
                if (!(this.geneMatrix[n][i] >= this.thresholdPercent)) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            System.out.println("Warning: UniqueID[" + n + "] not assigned even though it equals or exceeds the threshold % for at least one entry");
        }
    }

    void errorCheck2(int n) {
        int n2;
        boolean bl = false;
        Vector<Integer> vector = new Vector<Integer>();
        for (n2 = 0; n2 < this.clusterVector.size(); ++n2) {
            if (!this.isFound(n, (Vector)this.clusterVector.get(n2))) continue;
            vector.add(new Integer(n2));
        }
        block1: for (n2 = 0; n2 < vector.size(); ++n2) {
            int n3 = (Integer)vector.get(n2);
            Vector vector2 = (Vector)this.clusterVector.get(n3);
            for (int i = 0; i < vector2.size(); ++i) {
                int n4 = (Integer)vector2.get(i);
                if (n4 == n) continue;
                if (n4 > n) {
                    if (!(this.geneMatrix[n4][n] < this.thresholdPercent)) continue;
                    bl = true;
                    if (this.unassignedExists && n3 == this.clusterVector.size() - 1) break block1;
                    System.out.println("Warning: UniqueID[" + n + "] got assigned to cluster" + n3 + " where its 'affinity' to at least one gene is less than the threshold %");
                    System.out.println("geneMatrix[" + n4 + "][" + n + "] = " + this.geneMatrix[n4][n]);
                    break block1;
                }
                if (!(this.geneMatrix[n][n4] < this.thresholdPercent)) continue;
                bl = true;
                if (this.unassignedExists && n3 == this.clusterVector.size() - 1) break block1;
                System.out.println("Warning: UniqueID[" + n + "] got assigned to cluster" + n3 + " where its 'affinity' to at least one gene is less than the threshold %");
                System.out.println("geneMatrix[" + n + "][" + n4 + "] = " + this.geneMatrix[n][n4]);
                break block1;
            }
        }
    }

    public Vector itf(Vector vector) {
        Vector<Float> vector2 = new Vector<Float>();
        for (int i = 0; i < vector.size(); ++i) {
            vector2.addElement(new Float(((Integer)vector.elementAt(i)).intValue()));
        }
        return vector2;
    }

    public void abort() {
        this.stop = true;
    }
}

