/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class Monitor
extends JDialog {
    private JPanel drawingArea;
    private int position = 0;
    private int stepXFactor = 1;
    private double factor;
    private int[] values = new int[245];

    public Monitor(Frame frame, String string, int n, int n2, double d) {
        super(frame, string);
        this.factor = d;
        this.enableEvents(64L);
        this.drawingArea = new JPanel(){

            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Monitor.this.onPaint(graphics);
            }
        };
        this.drawingArea.setPreferredSize(new Dimension(275, 275));
        this.drawingArea.setOpaque(false);
        for (int i = 1; i < 200; ++i) {
            this.values[i] = 0;
        }
        this.getContentPane().add(this.drawingArea);
        ((JPanel)this.getContentPane()).setOpaque(false);
        ImageIcon imageIcon = GUIFactory.getIcon("monitor.jpg");
        JLabel jLabel = new JLabel(imageIcon);
        this.drawingArea.add(jLabel);
        this.getLayeredPane().add((Component)jLabel, new Integer(Integer.MIN_VALUE));
        jLabel.setBounds(0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight());
        this.setLocation(n, n2);
        this.pack();
    }

    public void update(double d) {
        int n = (int)Math.round(d * this.factor);
        if (n > 210) {
            n = 210;
        }
        this.values[this.position] = 210 - n;
        ++this.position;
        if (this.position * this.stepXFactor >= 245) {
            this.position = 0;
        }
        this.drawingArea.repaint();
    }

    public void setStepXFactor(int n) {
        this.stepXFactor = n;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.dispose();
        }
        super.processWindowEvent(windowEvent);
    }

    private void onPaint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.clipRect(15, 28, 245, 210);
        graphics2D.setColor(new Color(118, 243, 254));
        for (int i = 1; i < this.position; ++i) {
            graphics2D.drawLine(15 + (i - 1) * this.stepXFactor, 28 + this.values[i - 1], 15 + i * this.stepXFactor, 28 + this.values[i]);
        }
    }
}

