/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.fom;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.fom.CastFOMViewerA;
import org.tigr.microarray.mev.cluster.gui.impl.fom.CastFOMViewerB;
import org.tigr.microarray.mev.cluster.gui.impl.fom.FOMInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.fom.KFOMViewer;
import org.tigr.util.FloatMatrix;

public class FOMGUI
implements IClusterGUI {
    private Algorithm algorithm;
    private Progress progress;
    private boolean clusterGenes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        FOMInitDialog fOMInitDialog = new FOMInitDialog((JFrame)iFramework.getFrame(), true);
        fOMInitDialog.setVisible(true);
        if (!fOMInitDialog.isOkPressed()) {
            return null;
        }
        int n = fOMInitDialog.getMethod();
        float f = fOMInitDialog.getInterval();
        int n2 = fOMInitDialog.getIterations();
        int n3 = fOMInitDialog.getKMCIterations();
        boolean bl = fOMInitDialog.isAverage();
        boolean bl2 = fOMInitDialog.useMeans();
        this.clusterGenes = fOMInitDialog.isClusterGenes();
        Experiment experiment = iFramework.getData().getExperiment();
        Listener listener = new Listener();
        try {
            this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("FOM");
            this.algorithm.addAlgorithmListener(listener);
            int n4 = experiment.getNumberOfGenes();
            this.progress = new Progress(iFramework.getFrame(), "Calculating FOM values", listener);
            this.progress.show();
            AlgorithmData algorithmData = new AlgorithmData();
            FloatMatrix floatMatrix = experiment.getMatrix();
            if (!this.clusterGenes) {
                floatMatrix = floatMatrix.transpose();
            }
            algorithmData.addMatrix("experiment", floatMatrix);
            algorithmData.addParam("distance-factor", String.valueOf(1.0f));
            IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
            algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
            int n5 = iDistanceMenu.getDistanceFunction();
            if (n5 == 0) {
                n5 = 4;
            }
            algorithmData.addParam("distance-function", String.valueOf(n5));
            algorithmData.addParam("method", String.valueOf(n));
            algorithmData.addParam("cluster-genes", String.valueOf(this.clusterGenes));
            algorithmData.addParam("number_of_clusters", String.valueOf(n2));
            algorithmData.addParam("interval", String.valueOf(f));
            algorithmData.addParam("iterations", String.valueOf(n3));
            algorithmData.addParam("average", String.valueOf(bl));
            algorithmData.addParam("calculate-means", String.valueOf(bl2));
            long l = System.currentTimeMillis();
            AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
            long l2 = System.currentTimeMillis() - l;
            float[] fArray = algorithmData2.getMatrix((String)"fom-values").A[0];
            int[] nArray = algorithmData2.getIntArray("numOfCastClusters");
            GeneralInfo generalInfo = new GeneralInfo();
            generalInfo.average = bl;
            generalInfo.function = iDistanceMenu.getFunctionName(n5);
            generalInfo.interval = f;
            generalInfo.iterations = n3;
            generalInfo.method = n;
            if (n == 2) {
                generalInfo.kMeansOrKMedians = bl2 ? "Calculated Means" : "Calculated Medians";
            }
            generalInfo.time = l2;
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(fArray, generalInfo, f, nArray);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener(listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private DefaultMutableTreeNode createResultTree(float[] fArray, GeneralInfo generalInfo, float f, int[] nArray) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.clusterGenes ? new DefaultMutableTreeNode("FOM - genes") : new DefaultMutableTreeNode("FOM - experiments");
        this.addResultNodes(defaultMutableTreeNode, fArray, generalInfo, f, nArray);
        return defaultMutableTreeNode;
    }

    private void addResultNodes(DefaultMutableTreeNode defaultMutableTreeNode, float[] fArray, GeneralInfo generalInfo, float f, int[] nArray) {
        this.addGraphViewer(defaultMutableTreeNode, fArray, generalInfo, f, nArray);
        this.addGeneralInfo(defaultMutableTreeNode, generalInfo);
    }

    private void addGraphViewer(DefaultMutableTreeNode defaultMutableTreeNode, float[] fArray, GeneralInfo generalInfo, float f, int[] nArray) {
        ViewerAdapter viewerAdapter = null;
        if (generalInfo.method == 2) {
            viewerAdapter = new KFOMViewer(fArray);
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Graph - FOM value vs. # of Clusters", viewerAdapter)));
        } else {
            viewerAdapter = new CastFOMViewerA(fArray, f, nArray);
            CastFOMViewerB castFOMViewerB = new CastFOMViewerB(fArray, f, nArray);
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Graph - FOM value vs. Threshold", viewerAdapter)));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Graph - FOM value vs. # of Clusters", castFOMViewerB)));
        }
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        if (generalInfo.method == 1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Method: " + generalInfo.getMethod()));
        }
        if (generalInfo.method == 2) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Method: " + generalInfo.getMethod() + " : " + generalInfo.kMeansOrKMedians));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Iterations: " + String.valueOf(generalInfo.iterations)));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Interval: " + String.valueOf(generalInfo.interval)));
        }
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Average: " + String.valueOf(generalInfo.average)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(generalInfo.function));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private class GeneralInfo {
        public int method;
        public String kMeansOrKMedians;
        public float interval;
        public int iterations;
        public boolean average;
        public long time;
        public String function;

        private GeneralInfo() {
        }

        public String getMethod() {
            return this.method == 1 ? "CAST" : "KMC";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            switch (algorithmEvent.getId()) {
                case 1: {
                    FOMGUI.this.progress.setUnits(algorithmEvent.getIntValue());
                    FOMGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 2: {
                    FOMGUI.this.progress.setValue(algorithmEvent.getIntValue());
                    FOMGUI.this.progress.setDescription(algorithmEvent.getDescription());
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                FOMGUI.this.algorithm.abort();
                FOMGUI.this.progress.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            FOMGUI.this.algorithm.abort();
            FOMGUI.this.progress.dispose();
        }
    }
}

