/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gsh;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.gsh.GSHCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gsh.GSHCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gsh.GSHExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gsh.GSHExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gsh.GSHExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gsh.GSHExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gsh.GSHInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gsh.GSHInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.util.FloatMatrix;

public class GSHGUI
implements IClusterGUI {
    private Algorithm algorithm;
    private Experiment experiment;
    private int[][] clusters;
    private FloatMatrix means;
    private FloatMatrix variances;
    private boolean clusterGenes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        Object object;
        int n = 10;
        int n2 = 20;
        int n3 = 5;
        GSHInitDialog gSHInitDialog = new GSHInitDialog(iFramework.getFrame(), n, n2, n3);
        if (gSHInitDialog.showModal() != 0) {
            return null;
        }
        n = gSHInitDialog.getClusters();
        n2 = gSHInitDialog.getFM();
        n3 = gSHInitDialog.getST();
        this.clusterGenes = gSHInitDialog.isClusterGenesSelected();
        if (n < 1) {
            JOptionPane.showMessageDialog(iFramework.getFrame(), "Number of clusters must be greater than 0!", "Error", 0);
            return null;
        }
        if (n2 < 1) {
            JOptionPane.showMessageDialog(iFramework.getFrame(), "Number of faked matrix must be greater than 0!", "Error", 0);
            return null;
        }
        if (n3 < 1) {
            JOptionPane.showMessageDialog(iFramework.getFrame(), "Number of swap must be greater than 0!", "Error", 0);
            return null;
        }
        boolean bl = gSHInitDialog.isHierarchicalTree();
        int n4 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (bl) {
            object = new HCLInitDialog(iFramework.getFrame());
            if (((HCLInitDialog)object).showModal() != 0) {
                return null;
            }
            n4 = ((HCLInitDialog)object).getMethod();
            bl2 = ((HCLInitDialog)object).isClusterExperience();
            bl3 = ((HCLInitDialog)object).isClusterGenes();
        }
        this.experiment = iFramework.getData().getExperiment();
        object = new Listener();
        try {
            this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("GSH");
            this.algorithm.addAlgorithmListener((AlgorithmListener)object);
            int n5 = this.experiment.getNumberOfGenes();
            AlgorithmData algorithmData = new AlgorithmData();
            FloatMatrix floatMatrix = this.experiment.getMatrix();
            if (!this.clusterGenes) {
                floatMatrix = floatMatrix.transpose();
            }
            algorithmData.addMatrix("experiment", floatMatrix);
            algorithmData.addParam("distance-factor", String.valueOf(1.0f));
            IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
            algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
            algorithmData.addParam("gsh-cluster-genes", String.valueOf(this.clusterGenes));
            int n6 = iDistanceMenu.getDistanceFunction();
            if (n6 == 0) {
                n6 = 4;
            }
            algorithmData.addParam("distance-function", String.valueOf(n6));
            algorithmData.addParam("number_of_clusters", String.valueOf(n));
            algorithmData.addParam("number_of_fakedMatrix", String.valueOf(n2));
            algorithmData.addParam("number_of_swap", String.valueOf(n3));
            if (bl) {
                algorithmData.addParam("hierarchical-tree", String.valueOf(true));
                algorithmData.addParam("method-linkage", String.valueOf(n4));
                algorithmData.addParam("calculate-genes", String.valueOf(bl3));
                algorithmData.addParam("calculate-experiments", String.valueOf(bl2));
            }
            long l = System.currentTimeMillis();
            AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
            long l2 = System.currentTimeMillis() - l;
            Cluster cluster = algorithmData2.getCluster("cluster");
            NodeList nodeList = cluster.getNodeList();
            AlgorithmParameters algorithmParameters = algorithmData2.getParams();
            n = algorithmParameters.getInt("number-of-clusters");
            this.clusters = new int[n][];
            for (int i = 0; i < n; ++i) {
                this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            this.means = algorithmData2.getMatrix("clusters_means");
            this.variances = algorithmData2.getMatrix("clusters_variances");
            GeneralInfo generalInfo = new GeneralInfo();
            generalInfo.clusters = n;
            generalInfo.time = l2;
            generalInfo.FM = n2;
            generalInfo.ST = n3;
            generalInfo.function = iDistanceMenu.getFunctionName(n6);
            generalInfo.hcl = bl;
            generalInfo.hcl_genes = bl3;
            generalInfo.hcl_samples = bl2;
            generalInfo.hcl_method = n4;
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(cluster, generalInfo);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
            }
        }
    }

    private DefaultMutableTreeNode createResultTree(Cluster cluster, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.clusterGenes ? new DefaultMutableTreeNode("GSH - genes") : new DefaultMutableTreeNode("GSH - experiments");
        this.addResultNodes(defaultMutableTreeNode, cluster, generalInfo);
        return defaultMutableTreeNode;
    }

    private void addResultNodes(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        this.addExpressionImages(defaultMutableTreeNode);
        this.addHierarchicalTrees(defaultMutableTreeNode, cluster, generalInfo);
        this.addCentroidViews(defaultMutableTreeNode);
        this.addClusterInfo(defaultMutableTreeNode);
        this.addGeneralInfo(defaultMutableTreeNode, generalInfo);
    }

    private void addExpressionImages(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        JPanel jPanel = this.clusterGenes ? new GSHExperimentViewer(this.experiment, this.clusters) : new GSHExperimentClusterViewer(this.experiment, this.clusters);
        for (n = 0; n < this.clusters.length - 1; ++n) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1), (IViewer)((Object)jPanel), new Integer(n))));
        }
        if (this.clusterGenes) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Genes", (IViewer)((Object)jPanel), new Integer(n))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Experiments", (IViewer)((Object)jPanel), new Integer(n))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        int n;
        if (!generalInfo.hcl) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = cluster.getNodeList();
        Object object = null;
        int n2 = this.clusters.length;
        if (!this.clusterGenes) {
            object = new int[n2][];
            for (n = 0; n < n2; ++n) {
                object[n] = nodeList.getNode(n).getFeaturesIndexes();
            }
            if (generalInfo.hcl_samples) {
                object = this.getOrderedIndices(nodeList, (int[][])object, generalInfo.hcl_genes);
            }
        }
        for (n = 0; n < nodeList.getSize() - 1; ++n) {
            if (this.clusterGenes) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1), this.createHCLViewer(nodeList.getNode(n), generalInfo, null))));
                continue;
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1), this.createHCLViewer(nodeList.getNode(n), generalInfo, (int[][])object), new Integer(n))));
        }
        if (this.clusterGenes) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Genes", this.createHCLViewer(nodeList.getNode(nodeList.getSize() - 1), generalInfo, null))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Experiments", this.createHCLViewer(nodeList.getNode(nodeList.getSize() - 1), generalInfo, (int[][])object), new Integer(nodeList.getSize() - 1))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private IViewer createHCLViewer(Node node, GeneralInfo generalInfo, int[][] nArray) {
        HCLTreeData hCLTreeData;
        HCLTreeData hCLTreeData2;
        HCLTreeData hCLTreeData3 = hCLTreeData2 = generalInfo.hcl_genes ? this.getResult(node, 0) : null;
        HCLTreeData hCLTreeData4 = generalInfo.hcl_samples ? this.getResult(node, generalInfo.hcl_genes ? 4 : 0) : (hCLTreeData = null);
        if (this.clusterGenes) {
            return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData);
        }
        return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData, nArray, true);
    }

    private HCLTreeData getResult(Node node, int n) {
        HCLTreeData hCLTreeData = new HCLTreeData();
        NodeValueList nodeValueList = node.getValues();
        hCLTreeData.child_1_array = (int[])nodeValueList.getNodeValue((int)n).value;
        hCLTreeData.child_2_array = (int[])nodeValueList.getNodeValue((int)(n + 1)).value;
        hCLTreeData.node_order = (int[])nodeValueList.getNodeValue((int)(n + 2)).value;
        hCLTreeData.height = (float[])nodeValueList.getNodeValue((int)(n + 3)).value;
        return hCLTreeData;
    }

    private void addClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Cluster Information");
        if (this.clusterGenes) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Genes in Clusters (#,%)", new GSHInfoViewer(this.clusters, this.experiment.getNumberOfGenes()))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Experiments in Clusters (#,%)", new GSHInfoViewer(this.clusters, this.experiment.getNumberOfSamples(), false))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        if (this.clusterGenes) {
            GSHCentroidViewer gSHCentroidViewer = new GSHCentroidViewer(this.experiment, this.clusters);
            gSHCentroidViewer.setMeans(this.means.A);
            gSHCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length - 1; ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)gSHCentroidViewer, new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)gSHCentroidViewer, new CentroidUserObject(i, 1))));
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Genes ", (IViewer)gSHCentroidViewer, new CentroidUserObject(this.clusters.length - 1, 0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Genes ", (IViewer)gSHCentroidViewer, new CentroidUserObject(this.clusters.length - 1, 1))));
            GSHCentroidsViewer gSHCentroidsViewer = new GSHCentroidsViewer(this.experiment, this.clusters);
            gSHCentroidsViewer.setMeans(this.means.A);
            gSHCentroidsViewer.setVariances(this.variances.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)gSHCentroidsViewer, new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)gSHCentroidsViewer, new Integer(1))));
        } else {
            GSHExperimentCentroidViewer gSHExperimentCentroidViewer = new GSHExperimentCentroidViewer(this.experiment, this.clusters);
            gSHExperimentCentroidViewer.setMeans(this.means.A);
            gSHExperimentCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length - 1; ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)gSHExperimentCentroidViewer, new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)gSHExperimentCentroidViewer, new CentroidUserObject(i, 1))));
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Experiments", (IViewer)gSHExperimentCentroidViewer, new CentroidUserObject(this.clusters.length - 1, 0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Experiments", (IViewer)gSHExperimentCentroidViewer, new CentroidUserObject(this.clusters.length - 1, 1))));
            GSHExperimentCentroidsViewer gSHExperimentCentroidsViewer = new GSHExperimentCentroidsViewer(this.experiment, this.clusters);
            gSHExperimentCentroidsViewer.setMeans(this.means.A);
            gSHExperimentCentroidsViewer.setVariances(this.variances.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)gSHExperimentCentroidsViewer, new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)gSHExperimentCentroidsViewer, new Integer(1))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Clusters: " + String.valueOf(generalInfo.clusters)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Faked_Matrix: " + String.valueOf(generalInfo.FM)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Swap_Time: " + String.valueOf(generalInfo.ST)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("HCL: " + generalInfo.getMethodName()));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(generalInfo.function));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private int[][] getOrderedIndices(NodeList nodeList, int[][] nArray, boolean bl) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i].length <= 0) continue;
            HCLTreeData hCLTreeData = this.getResult(nodeList.getNode(i), bl ? 4 : 0);
            nArray[i] = this.getSampleOrder(hCLTreeData, nArray[i]);
        }
        return nArray;
    }

    private int[] getSampleOrder(HCLTreeData hCLTreeData, int[] nArray) {
        return this.getLeafOrder(hCLTreeData.node_order, hCLTreeData.child_1_array, hCLTreeData.child_2_array, nArray);
    }

    private int[] getLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = new int[nArray.length];
        Arrays.fill(nArray5, -1);
        this.fillLeafOrder(nArray5, nArray2, nArray3, 0, nArray2.length - 2, nArray4);
        return nArray5;
    }

    private int fillLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int[] nArray4) {
        if (nArray2[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray2[n2], nArray4);
        }
        if (nArray3[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray3[n2], nArray4);
        } else {
            nArray[n] = nArray4 == null ? n2 : nArray4[n2];
            ++n;
        }
        return n;
    }

    private class GeneralInfo {
        public int clusters;
        public long time;
        public String function;
        public int FM;
        public int ST;
        private boolean hcl;
        private int hcl_method;
        private boolean hcl_genes;
        private boolean hcl_samples;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            switch (algorithmEvent.getId()) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                GSHGUI.this.algorithm.abort();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            GSHGUI.this.algorithm.abort();
        }
    }
}

