/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gsh;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.SampleSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class GSHInitDialog
extends AlgorithmDialog {
    private int result;
    private JTextField textField1;
    private JTextField textField2;
    private JTextField textField3;
    private SampleSelectionPanel sampleSelectionPanel;
    private HCLSelectionPanel hclOpsPanel;

    public GSHInitDialog(Frame frame, int n, int n2, int n3) {
        super(new JFrame(), "GSH: Gene Shaving", true);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        this.sampleSelectionPanel = new SampleSelectionPanel(Color.white, UIManager.getColor("Label.foreground"), true, "Sample Selection");
        ParameterPanel parameterPanel = new ParameterPanel();
        parameterPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        parameterPanel.add((Component)new JLabel("Number of clusters"), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        parameterPanel.add((Component)new JLabel("Number of permuted matrices"), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        parameterPanel.add((Component)new JLabel("Number of permutations/matrix"), gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        this.textField1 = new JTextField(String.valueOf(n), 5);
        this.textField2 = new JTextField(String.valueOf(n2), 5);
        this.textField3 = new JTextField(String.valueOf(n3), 5);
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        parameterPanel.add((Component)this.textField1, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        parameterPanel.add((Component)this.textField2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        parameterPanel.add((Component)this.textField3, gridBagConstraints);
        this.hclOpsPanel = new HCLSelectionPanel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBackground(Color.white);
        jPanel.add((Component)this.sampleSelectionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)parameterPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.hclOpsPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(jPanel);
        this.setActionListeners(listener);
        this.pack();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public int getClusters() {
        return Integer.parseInt(this.textField1.getText());
    }

    public boolean isClusterGenesSelected() {
        return this.sampleSelectionPanel.isClusterGenesSelected();
    }

    public int getFM() {
        return Integer.parseInt(this.textField2.getText());
    }

    public int getST() {
        return Integer.parseInt(this.textField2.getText());
    }

    public boolean isHierarchicalTree() {
        return this.hclOpsPanel.isHCLSelected();
    }

    private void resetControls() {
        this.sampleSelectionPanel.setClusterGenesSelected(true);
        this.hclOpsPanel.setHCLSelected(false);
        this.textField1.setText("10");
        this.textField2.setText("20");
        this.textField3.setText("5");
    }

    private boolean validInput(int n, int n2, int n3) {
        boolean bl = true;
        if (n < 1) {
            JOptionPane.showMessageDialog(this, "Number of clusters must be > 0", "Input Error!", 0);
            this.textField1.requestFocus();
            this.textField1.selectAll();
            bl = false;
        } else if (n2 <= 0) {
            JOptionPane.showMessageDialog(this, "Number of permuted matricies must be > 0", "Input Error!", 0);
            this.textField2.requestFocus();
            this.textField2.selectAll();
            bl = false;
        } else if (n3 < 0) {
            JOptionPane.showMessageDialog(this, "Number permutations must be >= 0", "Input Error!", 0);
            this.textField3.requestFocus();
            this.textField3.selectAll();
            bl = false;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        GSHInitDialog gSHInitDialog = new GSHInitDialog(new Frame(), 0, 0, 0);
        gSHInitDialog.showModal();
        System.exit(0);
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                int n;
                int n2;
                int n3;
                int n4 = 0;
                try {
                    n3 = Integer.parseInt(GSHInitDialog.this.textField1.getText());
                    ++n4;
                    n2 = Integer.parseInt(GSHInitDialog.this.textField2.getText());
                    ++n4;
                    n = Integer.parseInt(GSHInitDialog.this.textField3.getText());
                    ++n4;
                    GSHInitDialog.this.result = 0;
                }
                catch (NumberFormatException numberFormatException) {
                    if (n4 == 0) {
                        GSHInitDialog.this.textField1.requestFocus();
                        GSHInitDialog.this.textField1.selectAll();
                    } else if (n4 == 1) {
                        GSHInitDialog.this.textField2.requestFocus();
                        GSHInitDialog.this.textField2.selectAll();
                    } else if (n4 == 2) {
                        GSHInitDialog.this.textField3.requestFocus();
                        GSHInitDialog.this.textField3.selectAll();
                    }
                    JOptionPane.showMessageDialog(GSHInitDialog.this, "Number format error.", "Number Format Error", 0);
                    GSHInitDialog.this.result = 2;
                    return;
                }
                if (GSHInitDialog.this.validInput(n3, n2, n)) {
                    GSHInitDialog.this.dispose();
                } else {
                    GSHInitDialog.this.result = 2;
                }
            } else if (string.equals("cancel-command")) {
                GSHInitDialog.this.result = 2;
                GSHInitDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                GSHInitDialog.this.resetControls();
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(GSHInitDialog.this, "GSH Initialization Dialog");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 500);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            GSHInitDialog.this.result = -1;
            GSHInitDialog.this.dispose();
        }
    }
}

