/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.kmcs;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmcs.KMCSuppCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmcs.KMCSuppCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmcs.KMCSuppExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmcs.KMCSuppExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmcs.KMCSuppExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmcs.KMCSuppExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmcs.KMCSuppInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmcs.KMCSupportDialog;
import org.tigr.util.FloatMatrix;

public class KMCSuppGUI
implements IClusterGUI {
    private Algorithm algorithm;
    private Progress progress;
    private Experiment experiment;
    private int[][] clusters;
    private int k;
    private FloatMatrix means;
    private FloatMatrix variances;
    private boolean unassignedExists;
    private boolean clusterGenes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        Object object;
        int n = 10;
        int n2 = 50;
        KMCSupportDialog kMCSupportDialog = new KMCSupportDialog((JFrame)iFramework.getFrame(), true);
        kMCSupportDialog.setVisible(true);
        if (!kMCSupportDialog.isOkPressed()) {
            return null;
        }
        int n3 = 0;
        double d = 0.0;
        try {
            n = kMCSupportDialog.getNumClusters();
            n2 = kMCSupportDialog.getIterations();
            n3 = kMCSupportDialog.getNumReps();
            d = kMCSupportDialog.getThresholdPercent();
            this.clusterGenes = kMCSupportDialog.isClusterGenes();
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(iFramework.getFrame(), "Invalid input parameters!", "Error", 0);
            return null;
        }
        boolean bl = kMCSupportDialog.isDrawTrees();
        boolean bl2 = kMCSupportDialog.meansChosen();
        int n4 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        if (bl) {
            object = new HCLInitDialog(iFramework.getFrame());
            if (((HCLInitDialog)object).showModal() != 0) {
                return null;
            }
            n4 = ((HCLInitDialog)object).getMethod();
            bl3 = ((HCLInitDialog)object).isClusterExperience();
            bl4 = ((HCLInitDialog)object).isClusterGenes();
        }
        this.experiment = iFramework.getData().getExperiment();
        object = new Listener();
        try {
            this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("KMCS");
            this.algorithm.addAlgorithmListener((AlgorithmListener)object);
            int n5 = this.experiment.getNumberOfGenes();
            this.progress = new Progress(iFramework.getFrame(), "Calculating clusters", (DialogListener)object);
            this.progress.show();
            AlgorithmData algorithmData = new AlgorithmData();
            FloatMatrix floatMatrix = this.experiment.getMatrix();
            if (!this.clusterGenes) {
                floatMatrix = floatMatrix.transpose();
            }
            algorithmData.addMatrix("experiment", floatMatrix);
            algorithmData.addParam("kmc-cluster-genes", String.valueOf(this.clusterGenes));
            algorithmData.addParam("distance-factor", String.valueOf(1.0f));
            IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
            algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
            int n6 = iDistanceMenu.getDistanceFunction();
            if (n6 == 0) {
                n6 = 4;
            }
            algorithmData.addParam("distance-function", String.valueOf(n6));
            algorithmData.addParam("number-of-desired-clusters", String.valueOf(n));
            algorithmData.addParam("number_of_iterations", String.valueOf(n2));
            algorithmData.addParam("number_of_repetitions", String.valueOf(n3));
            algorithmData.addParam("threshold-percent", String.valueOf(d));
            algorithmData.addParam("calculate-means", String.valueOf(bl2));
            if (bl) {
                algorithmData.addParam("hierarchical-tree", String.valueOf(true));
                algorithmData.addParam("method-linkage", String.valueOf(n4));
                algorithmData.addParam("calculate-genes", String.valueOf(bl4));
                algorithmData.addParam("calculate-experiments", String.valueOf(bl3));
            }
            long l = System.currentTimeMillis();
            AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
            long l2 = System.currentTimeMillis() - l;
            Cluster cluster = algorithmData2.getCluster("cluster");
            NodeList nodeList = cluster.getNodeList();
            AlgorithmParameters algorithmParameters = algorithmData2.getParams();
            this.k = algorithmParameters.getInt("number-of-clusters");
            this.unassignedExists = algorithmParameters.getBoolean("unassigned-genes-exist");
            this.clusters = new int[this.k][];
            for (int i = 0; i < this.k; ++i) {
                this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            this.means = algorithmData2.getMatrix("clusters_means");
            this.variances = algorithmData2.getMatrix("clusters_variances");
            GeneralInfo generalInfo = new GeneralInfo();
            generalInfo.clusters = this.unassignedExists ? this.k - 1 : this.k;
            generalInfo.userNumClusters = n;
            generalInfo.meansOrMedians = bl2 ? "K-Means" : "K-Medians";
            generalInfo.iterations = n2;
            generalInfo.time = l2;
            generalInfo.numReps = n3;
            generalInfo.thresholdPercent = d;
            generalInfo.function = iDistanceMenu.getFunctionName(n6);
            generalInfo.hcl = bl;
            generalInfo.hcl_genes = bl4;
            generalInfo.hcl_samples = bl3;
            generalInfo.hcl_method = n4;
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(cluster, generalInfo);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private DefaultMutableTreeNode createResultTree(Cluster cluster, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.clusterGenes ? new DefaultMutableTreeNode("KMS - genes") : new DefaultMutableTreeNode("KMS - experiments");
        this.addResultNodes(defaultMutableTreeNode, cluster, generalInfo);
        return defaultMutableTreeNode;
    }

    private void addResultNodes(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        this.addExpressionImages(defaultMutableTreeNode);
        this.addHierarchicalTrees(defaultMutableTreeNode, cluster, generalInfo);
        this.addCentroidViews(defaultMutableTreeNode);
        this.addClusterInfo(defaultMutableTreeNode);
        this.addGeneralInfo(defaultMutableTreeNode, generalInfo);
    }

    private void addExpressionImages(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        JPanel jPanel = this.clusterGenes ? new KMCSuppExperimentViewer(this.experiment, this.clusters) : new KMCSuppExperimentClusterViewer(this.experiment, this.clusters);
        if (!this.unassignedExists) {
            for (int i = 0; i < this.clusters.length; ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)((Object)jPanel), new Integer(i))));
            }
        } else {
            for (int i = 0; i < this.clusters.length - 1; ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)((Object)jPanel), new Integer(i))));
            }
            if (this.clusterGenes) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned genes ", (IViewer)((Object)jPanel), new Integer(this.clusters.length - 1))));
            } else {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned experiments ", (IViewer)((Object)jPanel), new Integer(this.clusters.length - 1))));
            }
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        if (!generalInfo.hcl) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = cluster.getNodeList();
        Object object = null;
        if (this.clusterGenes) {
            if (!this.unassignedExists) {
                for (int i = 0; i < nodeList.getSize(); ++i) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), this.createHCLViewer(nodeList.getNode(i), generalInfo, (int[][])object))));
                }
            } else {
                for (int i = 0; i < nodeList.getSize() - 1; ++i) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), this.createHCLViewer(nodeList.getNode(i), generalInfo, (int[][])object))));
                }
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned genes ", this.createHCLViewer(nodeList.getNode(nodeList.getSize() - 1), generalInfo, (int[][])object))));
            }
        } else {
            int n;
            object = new int[this.k][];
            for (n = 0; n < this.k; ++n) {
                object[n] = nodeList.getNode(n).getFeaturesIndexes();
            }
            if (generalInfo.hcl_samples) {
                object = this.getOrderedIndices(nodeList, (int[][])object, generalInfo.hcl_genes);
            }
            if (!this.unassignedExists) {
                for (n = 0; n < nodeList.getSize(); ++n) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1), this.createHCLViewer(nodeList.getNode(n), generalInfo, (int[][])object), new Integer(n))));
                }
            } else {
                for (n = 0; n < nodeList.getSize() - 1; ++n) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1), this.createHCLViewer(nodeList.getNode(n), generalInfo, (int[][])object), new Integer(n))));
                }
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned experiments ", this.createHCLViewer(nodeList.getNode(nodeList.getSize() - 1), generalInfo, (int[][])object), new Integer(n))));
            }
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private IViewer createHCLViewer(Node node, GeneralInfo generalInfo, int[][] nArray) {
        HCLTreeData hCLTreeData;
        HCLTreeData hCLTreeData2;
        HCLTreeData hCLTreeData3 = hCLTreeData2 = generalInfo.hcl_genes ? this.getResult(node, 0) : null;
        HCLTreeData hCLTreeData4 = generalInfo.hcl_samples ? this.getResult(node, generalInfo.hcl_genes ? 4 : 0) : (hCLTreeData = null);
        if (this.clusterGenes) {
            return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData);
        }
        return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData, nArray, true);
    }

    private HCLTreeData getResult(Node node, int n) {
        HCLTreeData hCLTreeData = new HCLTreeData();
        NodeValueList nodeValueList = node.getValues();
        hCLTreeData.child_1_array = (int[])nodeValueList.getNodeValue((int)n).value;
        hCLTreeData.child_2_array = (int[])nodeValueList.getNodeValue((int)(n + 1)).value;
        hCLTreeData.node_order = (int[])nodeValueList.getNodeValue((int)(n + 2)).value;
        hCLTreeData.height = (float[])nodeValueList.getNodeValue((int)(n + 3)).value;
        return hCLTreeData;
    }

    private void addClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Cluster Information");
        if (this.clusterGenes) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Genes in Clusters (#,%)", new KMCSuppInfoViewer(this.clusters, this.experiment.getNumberOfGenes(), this.unassignedExists, this.clusterGenes))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Experiments in Clusters (#,%)", new KMCSuppInfoViewer(this.clusters, this.experiment.getNumberOfSamples(), this.unassignedExists, this.clusterGenes))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        if (this.clusterGenes) {
            KMCSuppCentroidViewer kMCSuppCentroidViewer = new KMCSuppCentroidViewer(this.experiment, this.clusters);
            kMCSuppCentroidViewer.setMeans(this.means.A);
            kMCSuppCentroidViewer.setVariances(this.variances.A);
            if (!this.unassignedExists) {
                for (int i = 0; i < this.clusters.length; ++i) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)kMCSuppCentroidViewer, new CentroidUserObject(i, 0))));
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)kMCSuppCentroidViewer, new CentroidUserObject(i, 1))));
                }
            } else {
                for (int i = 0; i < this.clusters.length - 1; ++i) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)kMCSuppCentroidViewer, new CentroidUserObject(i, 0))));
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)kMCSuppCentroidViewer, new CentroidUserObject(i, 1))));
                }
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned genes ", (IViewer)kMCSuppCentroidViewer, new CentroidUserObject(this.clusters.length - 1, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned genes ", (IViewer)kMCSuppCentroidViewer, new CentroidUserObject(this.clusters.length - 1, 1))));
            }
            KMCSuppCentroidsViewer kMCSuppCentroidsViewer = new KMCSuppCentroidsViewer(this.experiment, this.clusters);
            kMCSuppCentroidsViewer.setMeans(this.means.A);
            kMCSuppCentroidsViewer.setVariances(this.variances.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)kMCSuppCentroidsViewer, new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)kMCSuppCentroidsViewer, new Integer(1))));
        } else {
            KMCSuppExperimentCentroidViewer kMCSuppExperimentCentroidViewer = new KMCSuppExperimentCentroidViewer(this.experiment, this.clusters);
            kMCSuppExperimentCentroidViewer.setMeans(this.means.A);
            kMCSuppExperimentCentroidViewer.setVariances(this.variances.A);
            if (!this.unassignedExists) {
                for (int i = 0; i < this.clusters.length; ++i) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)kMCSuppExperimentCentroidViewer, new CentroidUserObject(i, 0))));
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)kMCSuppExperimentCentroidViewer, new CentroidUserObject(i, 1))));
                }
            } else {
                int n;
                for (n = 0; n < this.clusters.length - 1; ++n) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1), (IViewer)kMCSuppExperimentCentroidViewer, new CentroidUserObject(n, 0))));
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(n + 1), (IViewer)kMCSuppExperimentCentroidViewer, new CentroidUserObject(n, 1))));
                }
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Experiments ", (IViewer)kMCSuppExperimentCentroidViewer, new CentroidUserObject(n, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Experiments ", (IViewer)kMCSuppExperimentCentroidViewer, new CentroidUserObject(n, 1))));
            }
            KMCSuppExperimentCentroidsViewer kMCSuppExperimentCentroidsViewer = new KMCSuppExperimentCentroidsViewer(this.experiment, this.clusters);
            kMCSuppExperimentCentroidsViewer.setMeans(this.means.A);
            kMCSuppExperimentCentroidsViewer.setVariances(this.variances.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)kMCSuppExperimentCentroidsViewer, new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)kMCSuppExperimentCentroidsViewer, new Integer(1))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("K-Means or K-Medians: " + generalInfo.meansOrMedians));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Number of consensus clusters: " + String.valueOf(generalInfo.clusters)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Clusters per K-means / K-medians run: " + String.valueOf(generalInfo.userNumClusters)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Iterations per K-means / K-Medians run: " + String.valueOf(generalInfo.iterations)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Number of K-Means / K-Medians runs: " + String.valueOf(generalInfo.numReps)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Threshold co-occurrence %: " + String.valueOf(generalInfo.thresholdPercent)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("HCL: " + generalInfo.getMethodName()));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(generalInfo.function));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private int[][] getOrderedIndices(NodeList nodeList, int[][] nArray, boolean bl) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i].length <= 0) continue;
            HCLTreeData hCLTreeData = this.getResult(nodeList.getNode(i), bl ? 4 : 0);
            nArray[i] = this.getSampleOrder(hCLTreeData, nArray[i]);
        }
        return nArray;
    }

    private int[] getSampleOrder(HCLTreeData hCLTreeData, int[] nArray) {
        return this.getLeafOrder(hCLTreeData.node_order, hCLTreeData.child_1_array, hCLTreeData.child_2_array, nArray);
    }

    private int[] getLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = new int[nArray.length];
        Arrays.fill(nArray5, -1);
        this.fillLeafOrder(nArray5, nArray2, nArray3, 0, nArray2.length - 2, nArray4);
        return nArray5;
    }

    private int fillLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int[] nArray4) {
        if (nArray2[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray2[n2], nArray4);
        }
        if (nArray3[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray3[n2], nArray4);
        } else {
            nArray[n] = nArray4 == null ? n2 : nArray4[n2];
            ++n;
        }
        return n;
    }

    private class GeneralInfo {
        public int clusters;
        public String meansOrMedians;
        public int iterations;
        public int userNumClusters;
        public long time;
        public String function;
        public int numReps;
        public double thresholdPercent;
        private boolean hcl;
        private int hcl_method;
        private boolean hcl_genes;
        private boolean hcl_samples;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            switch (algorithmEvent.getId()) {
                case 1: {
                    KMCSuppGUI.this.progress.setUnits(algorithmEvent.getIntValue());
                    KMCSuppGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 2: {
                    KMCSuppGUI.this.progress.setValue(algorithmEvent.getIntValue());
                    KMCSuppGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 3: {
                    int n = algorithmEvent.getIntValue();
                    if (n != -1) break;
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                KMCSuppGUI.this.algorithm.abort();
                KMCSuppGUI.this.progress.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            KMCSuppGUI.this.algorithm.abort();
            KMCSuppGUI.this.progress.dispose();
        }
    }
}

