/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.owa;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileFilter;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileView;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class OWACentroidsViewer
extends CentroidsViewer {
    private static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    private static final String SET_Y_TO_EXPERIMENT_MAX_CMD = "set-y-to-exp-max-cmd";
    private static final String SET_Y_TO_CLUSTER_MAX_CMD = "set-y-to-cluster-max-cmd";
    private JPopupMenu popup;
    private JMenuItem setOverallMaxMenuItem;
    private JMenuItem setClusterMaxMenuItem;
    private Vector fValues;
    private Vector pValues;
    private Vector dfNumValues;
    private Vector dfDenomValues;
    private Vector ssGroups;
    private Vector ssError;
    private float[][] geneGroupMeans;
    private float[][] geneGroupSDs;

    public OWACentroidsViewer(Experiment experiment, int[][] nArray, float[][] fArray, float[][] fArray2, Vector vector, Vector vector2, Vector vector3, Vector vector4, Vector vector5, Vector vector6) {
        super(experiment, nArray);
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.pValues = vector;
        this.fValues = vector2;
        this.geneGroupMeans = fArray;
        this.geneGroupSDs = fArray2;
        this.ssGroups = vector3;
        this.ssError = vector4;
        this.dfNumValues = vector5;
        this.dfDenomValues = vector6;
        this.getContentComponent().addMouseListener(listener);
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu, listener);
        return jPopupMenu;
    }

    private void addMenuItems(JPopupMenu jPopupMenu, Listener listener) {
        JMenuItem jMenuItem = new JMenuItem("Save all clusters", GUIFactory.getIcon("save16.gif"));
        jMenuItem.setActionCommand(SAVE_ALL_CLUSTERS_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        this.setOverallMaxMenuItem = new JMenuItem("Set Y to overall max...", GUIFactory.getIcon("Y_range_expand.gif"));
        this.setOverallMaxMenuItem.setActionCommand(SET_Y_TO_EXPERIMENT_MAX_CMD);
        this.setOverallMaxMenuItem.addActionListener(listener);
        this.setOverallMaxMenuItem.setEnabled(false);
        jPopupMenu.add(this.setOverallMaxMenuItem);
        this.setClusterMaxMenuItem = new JMenuItem("Set Y to cluster max...", GUIFactory.getIcon("Y_range_expand.gif"));
        this.setClusterMaxMenuItem.setActionCommand(SET_Y_TO_CLUSTER_MAX_CMD);
        this.setClusterMaxMenuItem.addActionListener(listener);
        jPopupMenu.add(this.setClusterMaxMenuItem);
    }

    private void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveExperiment(frame, this.getExperiment(), this.getData(), this.getClusters());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    public void saveExperiment(Frame frame, Experiment experiment, IData iData, int[][] nArray) throws Exception {
        File file = OWACentroidsViewer.getFile(frame);
        if (file != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == null || nArray[i].length == 0) continue;
                File file2 = new File(file.getPath() + "-" + String.valueOf(i + 1) + ".txt");
                this.saveCluster(file2, experiment, iData, nArray[i]);
            }
        }
    }

    private void saveCluster(File file, Experiment experiment, IData iData, int[] nArray) throws Exception {
        int n;
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        String[] stringArray = iData.getFieldNames();
        printWriter.print("Original row");
        printWriter.print("\t");
        for (n = 0; n < stringArray.length; ++n) {
            printWriter.print(stringArray[n]);
            printWriter.print("\t");
        }
        for (n = 0; n < this.geneGroupMeans[0].length; ++n) {
            printWriter.print("Group" + (n + 1) + " mean\t");
            printWriter.print("Group" + (n + 1) + " std.dev.\t");
        }
        printWriter.print("F ratio");
        printWriter.print("\t");
        printWriter.print("SS(Groups)\t");
        printWriter.print("SS(Error)\t");
        printWriter.print("df (Groups)\t");
        printWriter.print("df (Error)\t");
        printWriter.print("p value");
        for (n = 0; n < experiment.getNumberOfSamples(); ++n) {
            printWriter.print("\t");
            printWriter.print(iData.getFullSampleName(experiment.getSampleIndex(n)));
        }
        printWriter.print("\n");
        for (n = 0; n < nArray.length; ++n) {
            int n2;
            printWriter.print(Integer.toString(experiment.getGeneIndexMappedToData(nArray[n]) + 1));
            printWriter.print("\t");
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                printWriter.print(iData.getElementAttribute(experiment.getGeneIndexMappedToData(nArray[n]), n2));
                printWriter.print("\t");
            }
            for (n2 = 0; n2 < this.geneGroupMeans[nArray[n]].length; ++n2) {
                printWriter.print(this.geneGroupMeans[nArray[n]][n2] + "\t");
                printWriter.print(this.geneGroupSDs[nArray[n]][n2] + "\t");
            }
            printWriter.print("" + ((Float)this.fValues.get(nArray[n])).floatValue());
            printWriter.print("\t");
            printWriter.print("" + ((Float)this.ssGroups.get(nArray[n])).floatValue());
            printWriter.print("\t");
            printWriter.print("" + ((Float)this.ssError.get(nArray[n])).floatValue());
            printWriter.print("\t");
            printWriter.print("" + ((Float)this.dfNumValues.get(nArray[n])).floatValue());
            printWriter.print("\t");
            printWriter.print("" + ((Float)this.dfDenomValues.get(nArray[n])).floatValue());
            printWriter.print("\t");
            printWriter.print("" + ((Float)this.pValues.get(nArray[n])).floatValue());
            for (n2 = 0; n2 < experiment.getNumberOfSamples(); ++n2) {
                printWriter.print("\t");
                printWriter.print(Float.toString(experiment.get(nArray[n], n2)));
            }
            printWriter.print("\n");
        }
        printWriter.flush();
        printWriter.close();
    }

    private static File getFile(Frame frame) {
        File file = null;
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.addChoosableFileFilter(new ExpressionFileFilter());
        jFileChooser.setFileView(new ExpressionFileView());
        int n = jFileChooser.showSaveDialog(frame);
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
        }
        return file;
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(OWACentroidsViewer.SAVE_ALL_CLUSTERS_CMD)) {
                OWACentroidsViewer.this.onSaveClusters();
            } else if (string.equals(OWACentroidsViewer.SET_Y_TO_EXPERIMENT_MAX_CMD)) {
                this.setAllYRanges(CentroidViewer.USE_EXPERIMENT_MAX);
                OWACentroidsViewer.this.setClusterMaxMenuItem.setEnabled(true);
                OWACentroidsViewer.this.setOverallMaxMenuItem.setEnabled(false);
                OWACentroidsViewer.this.repaint();
            } else if (string.equals(OWACentroidsViewer.SET_Y_TO_CLUSTER_MAX_CMD)) {
                this.setAllYRanges(CentroidViewer.USE_CLUSTER_MAX);
                OWACentroidsViewer.this.setClusterMaxMenuItem.setEnabled(false);
                OWACentroidsViewer.this.setOverallMaxMenuItem.setEnabled(true);
                OWACentroidsViewer.this.repaint();
            }
        }

        private void setAllYRanges(int n) {
            int n2 = OWACentroidsViewer.this.getClusters().length;
            for (int i = 0; i < n2; ++i) {
                OWACentroidsViewer.this.centroidViewer.setClusterIndex(i);
                OWACentroidsViewer.this.centroidViewer.setYRangeOption(n);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            OWACentroidsViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

