/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.owa;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.owa.FStatsTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.owa.OWACentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.owa.OWACentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.owa.OWAExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.owa.OWAInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.owa.OneWayANOVAInitBox;
import org.tigr.util.FloatMatrix;

public class OWAGUI
implements IClusterGUI {
    private Algorithm algorithm;
    private Progress progress;
    private Experiment experiment;
    private int[][] clusters;
    private FloatMatrix means;
    private FloatMatrix variances;
    private Vector fValues;
    private Vector pValues;
    private Vector dfNumValues;
    private Vector dfDenomValues;
    private Vector ssGroups;
    private Vector ssError;
    private float[][] geneGroupMeans;
    private float[][] geneGroupSDs;
    Vector exptNamesVector;
    int[] groupAssignments;
    private IData data;
    private int numGroups;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        Object object;
        this.experiment = iFramework.getData().getExperiment();
        this.data = iFramework.getData();
        this.exptNamesVector = new Vector();
        int n = this.experiment.getNumberOfSamples();
        int n2 = this.experiment.getNumberOfGenes();
        for (int i = 0; i < n; ++i) {
            this.exptNamesVector.add(iFramework.getData().getFullSampleName(i));
        }
        OneWayANOVAInitBox oneWayANOVAInitBox = new OneWayANOVAInitBox((JFrame)iFramework.getFrame(), true, this.exptNamesVector);
        oneWayANOVAInitBox.setVisible(true);
        if (!oneWayANOVAInitBox.isOkPressed()) {
            return null;
        }
        double d = oneWayANOVAInitBox.getPValue();
        this.numGroups = oneWayANOVAInitBox.getNumGroups();
        this.groupAssignments = oneWayANOVAInitBox.getGroupAssignments();
        int n3 = oneWayANOVAInitBox.getCorrectionMethod();
        boolean bl = oneWayANOVAInitBox.drawTrees();
        int n4 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (bl) {
            object = new HCLInitDialog(iFramework.getFrame());
            if (((HCLInitDialog)object).showModal() != 0) {
                return null;
            }
            n4 = ((HCLInitDialog)object).getMethod();
            bl2 = ((HCLInitDialog)object).isClusterExperience();
            bl3 = ((HCLInitDialog)object).isClusterGenes();
        }
        object = new Listener();
        try {
            int n5;
            this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("OWA");
            this.algorithm.addAlgorithmListener((AlgorithmListener)object);
            this.progress = new Progress(iFramework.getFrame(), "Finding significant genes", (DialogListener)object);
            this.progress.show();
            AlgorithmData algorithmData = new AlgorithmData();
            algorithmData.addMatrix("experiment", this.experiment.getMatrix());
            algorithmData.addParam("distance-factor", String.valueOf(1.0f));
            IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
            algorithmData.addParam("distance-absolute", String.valueOf(iDistanceMenu.isAbsoluteDistance()));
            int n6 = iDistanceMenu.getDistanceFunction();
            if (n6 == 0) {
                n6 = 4;
            }
            algorithmData.addParam("distance-function", String.valueOf(n6));
            algorithmData.addIntArray("group-assignments", this.groupAssignments);
            algorithmData.addParam("alpha", String.valueOf(d));
            algorithmData.addParam("correction-method", String.valueOf(n3));
            algorithmData.addParam("numGroups", String.valueOf(this.numGroups));
            if (bl) {
                algorithmData.addParam("hierarchical-tree", String.valueOf(true));
                algorithmData.addParam("method-linkage", String.valueOf(n4));
                algorithmData.addParam("calculate-genes", String.valueOf(bl3));
                algorithmData.addParam("calculate-experiments", String.valueOf(bl2));
            }
            long l = System.currentTimeMillis();
            AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
            long l2 = System.currentTimeMillis() - l;
            Cluster cluster = algorithmData2.getCluster("cluster");
            NodeList nodeList = cluster.getNodeList();
            AlgorithmParameters algorithmParameters = algorithmData2.getParams();
            int n7 = 2;
            this.clusters = new int[n7][];
            for (int i = 0; i < n7; ++i) {
                this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            this.means = algorithmData2.getMatrix("clusters_means");
            this.variances = algorithmData2.getMatrix("clusters_variances");
            FloatMatrix floatMatrix = algorithmData2.getMatrix("pValues");
            FloatMatrix floatMatrix2 = algorithmData2.getMatrix("fValues");
            FloatMatrix floatMatrix3 = algorithmData2.getMatrix("dfNumMatrix");
            FloatMatrix floatMatrix4 = algorithmData2.getMatrix("dfDenomMatrix");
            FloatMatrix floatMatrix5 = algorithmData2.getMatrix("ssGroupsMatrix");
            FloatMatrix floatMatrix6 = algorithmData2.getMatrix("ssErrorMatrix");
            FloatMatrix floatMatrix7 = algorithmData2.getMatrix("geneGroupMeansMatrix");
            FloatMatrix floatMatrix8 = algorithmData2.getMatrix("geneGroupSDsMatrix");
            this.pValues = new Vector();
            this.fValues = new Vector();
            this.ssGroups = new Vector();
            this.ssError = new Vector();
            this.geneGroupMeans = new float[floatMatrix7.getRowDimension()][floatMatrix7.getColumnDimension()];
            this.geneGroupSDs = new float[floatMatrix8.getRowDimension()][floatMatrix8.getColumnDimension()];
            for (n5 = 0; n5 < this.geneGroupMeans.length; ++n5) {
                for (int i = 0; i < this.geneGroupMeans[n5].length; ++i) {
                    this.geneGroupMeans[n5][i] = floatMatrix7.A[n5][i];
                    this.geneGroupSDs[n5][i] = floatMatrix8.A[n5][i];
                }
            }
            for (n5 = 0; n5 < floatMatrix.getRowDimension(); ++n5) {
                this.pValues.add(new Float(floatMatrix.A[n5][0]));
            }
            for (n5 = 0; n5 < floatMatrix2.getRowDimension(); ++n5) {
                this.fValues.add(new Float(floatMatrix2.A[n5][0]));
            }
            this.dfNumValues = new Vector();
            this.dfDenomValues = new Vector();
            for (n5 = 0; n5 < floatMatrix3.getRowDimension(); ++n5) {
                this.dfNumValues.add(new Float(floatMatrix3.A[n5][0]));
                this.dfDenomValues.add(new Float(floatMatrix4.A[n5][0]));
                this.ssGroups.add(new Float(floatMatrix5.A[n5][0]));
                this.ssError.add(new Float(floatMatrix6.A[n5][0]));
            }
            GeneralInfo generalInfo = new GeneralInfo();
            generalInfo.time = l2;
            generalInfo.alpha = d;
            generalInfo.correctionMethod = this.getSigMethod(n3);
            generalInfo.function = iDistanceMenu.getFunctionName(n6);
            generalInfo.hcl = bl;
            generalInfo.hcl_genes = bl3;
            generalInfo.hcl_samples = bl2;
            generalInfo.hcl_method = n4;
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(cluster, generalInfo);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private String getSigMethod(int n) {
        String string = "";
        if (n == 1) {
            string = "Just alpha (uncorrected)";
        } else if (n == 2) {
            string = "Standard Bonferroni correction";
        } else if (n == 3) {
            string = "Adjusted Bonferroni correction";
        }
        return string;
    }

    private DefaultMutableTreeNode createResultTree(Cluster cluster, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("One-way ANOVA");
        this.addResultNodes(defaultMutableTreeNode, cluster, generalInfo);
        return defaultMutableTreeNode;
    }

    private void addResultNodes(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        this.addExpressionImages(defaultMutableTreeNode);
        this.addHierarchicalTrees(defaultMutableTreeNode, cluster, generalInfo);
        this.addCentroidViews(defaultMutableTreeNode);
        this.addClusterInfo(defaultMutableTreeNode);
        this.addFRatioInfoViews(defaultMutableTreeNode);
        this.addGeneralInfo(defaultMutableTreeNode, generalInfo);
    }

    private void addExpressionImages(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        OWAExperimentViewer oWAExperimentViewer = new OWAExperimentViewer(this.experiment, this.clusters, this.geneGroupMeans, this.geneGroupSDs, this.pValues, this.fValues, this.ssGroups, this.ssError, this.dfNumValues, this.dfDenomValues);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (i < this.clusters.length - 1) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)oWAExperimentViewer, new Integer(i))));
                continue;
            }
            if (i != this.clusters.length - 1) continue;
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)oWAExperimentViewer, new Integer(i))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        if (!generalInfo.hcl) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = cluster.getNodeList();
        for (int i = 0; i < nodeList.getSize(); ++i) {
            if (i < nodeList.getSize() - 1) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", this.createHCLViewer(nodeList.getNode(i), generalInfo))));
                continue;
            }
            if (i != nodeList.getSize() - 1) continue;
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", this.createHCLViewer(nodeList.getNode(i), generalInfo))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private IViewer createHCLViewer(Node node, GeneralInfo generalInfo) {
        HCLTreeData hCLTreeData;
        HCLTreeData hCLTreeData2 = hCLTreeData = generalInfo.hcl_genes ? this.getResult(node, 0) : null;
        HCLTreeData hCLTreeData3 = generalInfo.hcl_samples ? this.getResult(node, generalInfo.hcl_genes ? 4 : 0) : null;
        return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData, hCLTreeData3);
    }

    private HCLTreeData getResult(Node node, int n) {
        HCLTreeData hCLTreeData = new HCLTreeData();
        NodeValueList nodeValueList = node.getValues();
        hCLTreeData.child_1_array = (int[])nodeValueList.getNodeValue((int)n).value;
        hCLTreeData.child_2_array = (int[])nodeValueList.getNodeValue((int)(n + 1)).value;
        hCLTreeData.node_order = (int[])nodeValueList.getNodeValue((int)(n + 2)).value;
        hCLTreeData.height = (float[])nodeValueList.getNodeValue((int)(n + 3)).value;
        return hCLTreeData;
    }

    private void addClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Cluster Information");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Results (#,%)", new OWAInfoViewer(this.clusters, this.experiment.getNumberOfGenes()))));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        OWACentroidViewer oWACentroidViewer = new OWACentroidViewer(this.experiment, this.clusters, this.geneGroupMeans, this.geneGroupSDs, this.pValues, this.fValues, this.ssGroups, this.ssError, this.dfNumValues, this.dfDenomValues);
        oWACentroidViewer.setMeans(this.means.A);
        oWACentroidViewer.setVariances(this.variances.A);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (i == 0) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)oWACentroidViewer, new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)oWACentroidViewer, new CentroidUserObject(i, 1))));
                continue;
            }
            if (i != 1) continue;
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)oWACentroidViewer, new CentroidUserObject(i, 0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)oWACentroidViewer, new CentroidUserObject(i, 1))));
        }
        OWACentroidsViewer oWACentroidsViewer = new OWACentroidsViewer(this.experiment, this.clusters, this.geneGroupMeans, this.geneGroupSDs, this.pValues, this.fValues, this.ssGroups, this.ssError, this.dfNumValues, this.dfDenomValues);
        oWACentroidsViewer.setMeans(this.means.A);
        oWACentroidsViewer.setVariances(this.variances.A);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)oWACentroidsViewer, new Integer(0))));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)oWACentroidsViewer, new Integer(1))));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private void addFRatioInfoViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("F-Ratio information");
        FStatsTableViewer fStatsTableViewer = new FStatsTableViewer(this.experiment, this.clusters, this.data, this.geneGroupMeans, this.geneGroupSDs, this.pValues, this.fValues, this.ssGroups, this.ssError, this.dfNumValues, this.dfDenomValues, true);
        FStatsTableViewer fStatsTableViewer2 = new FStatsTableViewer(this.experiment, this.clusters, this.data, this.geneGroupMeans, this.geneGroupSDs, this.pValues, this.fValues, this.ssGroups, this.ssError, this.dfNumValues, this.dfDenomValues, false);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes", fStatsTableViewer)));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes", fStatsTableViewer2)));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        defaultMutableTreeNode2.add(this.getGroupAssignmentInfo());
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Alpha (overall threshold p-value): " + generalInfo.alpha));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Significance determined by: " + generalInfo.correctionMethod));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("HCL: " + generalInfo.getMethodName()));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(generalInfo.function));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private DefaultMutableTreeNode getGroupAssignmentInfo() {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Group assigments ");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Not in groups");
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[this.numGroups];
        for (n = 0; n < this.numGroups; ++n) {
            defaultMutableTreeNodeArray[n] = new DefaultMutableTreeNode("Group " + (n + 1));
        }
        for (n = 0; n < this.groupAssignments.length; ++n) {
            int n2 = this.groupAssignments[n];
            if (n2 == 0) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(n)));
                continue;
            }
            defaultMutableTreeNodeArray[n2 - 1].add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(n)));
        }
        for (n = 0; n < defaultMutableTreeNodeArray.length; ++n) {
            defaultMutableTreeNode.add(defaultMutableTreeNodeArray[n]);
        }
        if (defaultMutableTreeNode2.getChildCount() > 0) {
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    private class GeneralInfo {
        public int clusters;
        public String correctionMethod;
        public double alpha;
        public long time;
        public String function;
        private boolean hcl;
        private int hcl_method;
        private boolean hcl_genes;
        private boolean hcl_samples;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            switch (algorithmEvent.getId()) {
                case 1: {
                    OWAGUI.this.progress.setUnits(algorithmEvent.getIntValue());
                    OWAGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 2: {
                    OWAGUI.this.progress.setValue(algorithmEvent.getIntValue());
                    OWAGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 3: {
                    int n = algorithmEvent.getIntValue();
                    if (n != -1) break;
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                OWAGUI.this.algorithm.abort();
                OWAGUI.this.progress.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            OWAGUI.this.algorithm.abort();
            OWAGUI.this.progress.dispose();
        }
    }
}

