/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.pca;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class PCASelectionAreaDialog
extends AlgorithmDialog {
    private int result;
    private JTextField textField1;
    private JTextField textField2;
    private JTextField textField3;
    private JTextField textField4;
    private JTextField textField5;
    private JTextField textField6;
    private float positionX;
    private float positionY;
    private float positionZ;
    private float sizeX;
    private float sizeY;
    private float sizeZ;

    public PCASelectionAreaDialog(Frame frame, float f, float f2, float f3, float f4, float f5, float f6) {
        super(new JFrame(), "PCA selection area configuration", true);
        this.positionX = f;
        this.positionY = f2;
        this.positionZ = f3;
        this.sizeX = f4;
        this.sizeY = f5;
        this.sizeZ = f6;
        Listener listener = new Listener();
        this.addWindowListener(listener);
        JPanel jPanel = new JPanel(new GridLayout(0, 2, 10, 0));
        jPanel.setBorder(new EmptyBorder(20, 20, 20, 10));
        jPanel.setBackground(Color.white);
        jPanel.add(new JLabel("Position X  "));
        this.textField1 = new JTextField(Float.toString(f), 5);
        jPanel.add((Component)this.textField1, "East");
        jPanel.add(new JLabel("Position Y  "));
        this.textField2 = new JTextField(Float.toString(f2), 5);
        jPanel.add((Component)this.textField2, "East");
        jPanel.add(new JLabel("Position Z  "));
        this.textField3 = new JTextField(Float.toString(f3), 5);
        jPanel.add((Component)this.textField3, "East");
        jPanel.add(new JLabel("Size X  "));
        this.textField4 = new JTextField(Float.toString(f4), 5);
        jPanel.add((Component)this.textField4, "East");
        jPanel.add(new JLabel("Size Y "));
        this.textField5 = new JTextField(Float.toString(f5), 5);
        jPanel.add((Component)this.textField5, "East");
        jPanel.add(new JLabel("Size Z "));
        this.textField6 = new JTextField(Float.toString(f6), 5);
        jPanel.add((Component)this.textField6, "East");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setForeground(Color.white);
        jPanel2.setBorder(BorderFactory.createLineBorder(Color.gray));
        jPanel2.setBackground(Color.white);
        jPanel2.add((Component)jPanel, "West");
        jPanel2.add((Component)new JLabel(GUIFactory.getIcon("tigr_logo.gif")), "East");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "Center");
        this.addContent(jPanel3);
        this.setActionListeners(listener);
        this.pack();
        this.setResizable(false);
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public float getPositionX() {
        return Float.parseFloat(this.textField1.getText());
    }

    public float getPositionY() {
        return Float.parseFloat(this.textField2.getText());
    }

    public float getPositionZ() {
        return Float.parseFloat(this.textField3.getText());
    }

    public float getSizeX() {
        return Float.parseFloat(this.textField4.getText());
    }

    public float getSizeY() {
        return Float.parseFloat(this.textField5.getText());
    }

    public float getSizeZ() {
        return Float.parseFloat(this.textField6.getText());
    }

    public static void main(String[] stringArray) {
        PCASelectionAreaDialog pCASelectionAreaDialog = new PCASelectionAreaDialog(new Frame(), 0.0f, 0.0f, 0.0f, 5.0f, 5.0f, 5.0f);
        pCASelectionAreaDialog.showModal();
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                try {
                    Float.parseFloat(PCASelectionAreaDialog.this.textField1.getText());
                    Float.parseFloat(PCASelectionAreaDialog.this.textField2.getText());
                    Float.parseFloat(PCASelectionAreaDialog.this.textField3.getText());
                    Float.parseFloat(PCASelectionAreaDialog.this.textField4.getText());
                    Float.parseFloat(PCASelectionAreaDialog.this.textField5.getText());
                    Float.parseFloat(PCASelectionAreaDialog.this.textField6.getText());
                    PCASelectionAreaDialog.this.result = 0;
                }
                catch (Exception exception) {
                    PCASelectionAreaDialog.this.result = 2;
                }
                PCASelectionAreaDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                PCASelectionAreaDialog.this.result = 2;
                PCASelectionAreaDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                PCASelectionAreaDialog.this.textField1.setText(String.valueOf(PCASelectionAreaDialog.this.positionX));
                PCASelectionAreaDialog.this.textField2.setText(String.valueOf(PCASelectionAreaDialog.this.positionY));
                PCASelectionAreaDialog.this.textField3.setText(String.valueOf(PCASelectionAreaDialog.this.positionZ));
                PCASelectionAreaDialog.this.textField4.setText(String.valueOf(PCASelectionAreaDialog.this.sizeX));
                PCASelectionAreaDialog.this.textField5.setText(String.valueOf(PCASelectionAreaDialog.this.sizeY));
                PCASelectionAreaDialog.this.textField6.setText(String.valueOf(PCASelectionAreaDialog.this.sizeZ));
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(PCASelectionAreaDialog.this, "PCA Selection Area Configuration");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 600);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.dispose();
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            PCASelectionAreaDialog.this.result = -1;
            PCASelectionAreaDialog.this.dispose();
        }
    }
}

