/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ptm;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMInitDialog;
import org.tigr.util.FloatMatrix;

public class PTMGUI
implements IClusterGUI {
    private Algorithm algorithm;
    private Experiment experiment;
    private int[][] clusters;
    private FloatMatrix means;
    private FloatMatrix variances;
    Vector templateVector;
    private boolean clusterGenes = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        Object object;
        boolean bl;
        FloatMatrix floatMatrix;
        int n;
        int n2;
        Color[] colorArray;
        int n3;
        int n4 = 2;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        float f = 0.8f;
        this.experiment = iFramework.getData().getExperiment();
        Vector<String> vector = new Vector<String>();
        int n5 = this.experiment.getNumberOfSamples();
        int n6 = this.experiment.getNumberOfGenes();
        for (int i = 0; i < n5; ++i) {
            vector.add(iFramework.getData().getFullSampleName(i));
        }
        Vector<String> vector2 = new Vector<String>();
        int n7 = iFramework.getDisplayMenu().getLabelIndex();
        for (int i = 0; i < n6; ++i) {
            vector2.add(iFramework.getData().getElementAttribute(this.experiment.getGeneIndexMappedToData(i), n7));
        }
        Vector<Color[]> vector3 = new Vector<Color[]>();
        Color[] colorArray2 = iFramework.getData().getColors();
        boolean[] blArray = new boolean[n6];
        for (n3 = 0; n3 < n6; ++n3) {
            blArray[n3] = false;
        }
        for (n3 = 0; n3 < colorArray2.length; ++n3) {
            colorArray = new Vector();
            for (int i = 0; i < n6; ++i) {
                if (blArray[i] || !colorArray2[n3].equals(iFramework.getData().getProbeColor(this.experiment.getGeneIndexMappedToData(i)))) continue;
                colorArray.add(new Integer(i));
                blArray[i] = true;
            }
            vector3.add(colorArray);
        }
        Vector vector4 = new Vector();
        colorArray = iFramework.getData().getExperimentColors();
        boolean[] blArray2 = new boolean[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            blArray2[n2] = false;
        }
        for (n2 = 0; n2 < colorArray.length; ++n2) {
            Vector<Integer> vector5 = new Vector<Integer>();
            for (n = 0; n < n5; ++n) {
                if (blArray2[n] || !colorArray[n2].equals(iFramework.getData().getExperimentColor(n))) continue;
                vector5.add(new Integer(n));
                blArray2[n] = true;
            }
            vector4.add(vector5);
        }
        PTMInitDialog pTMInitDialog = new PTMInitDialog(new JFrame(), bl2, this.experiment.getMatrix(), vector2, vector, vector3, vector4, colorArray2, colorArray);
        n = 0;
        boolean bl5 = false;
        boolean bl6 = false;
        pTMInitDialog.setVisible(true);
        if (!pTMInitDialog.isOkPressed()) {
            return null;
        }
        this.clusterGenes = pTMInitDialog.isGeneTemplate();
        if (this.clusterGenes) {
            floatMatrix = pTMInitDialog.convertTemplateVectorToFloatMatrix();
            this.templateVector = pTMInitDialog.getTemplate();
            bl3 = pTMInitDialog.isUseAbsolute();
            bl4 = pTMInitDialog.isUseR();
            f = (float)pTMInitDialog.getThresholdR();
            bl = pTMInitDialog.isDrawTrees();
        } else {
            floatMatrix = pTMInitDialog.convertTemplateVectorToFloatMatrix();
            this.templateVector = pTMInitDialog.getTemplate();
            bl3 = pTMInitDialog.isUseAbsolute();
            bl4 = pTMInitDialog.isUseR();
            f = (float)pTMInitDialog.getThresholdR();
            bl = pTMInitDialog.isDrawTrees();
        }
        if (bl) {
            object = new HCLInitDialog(iFramework.getFrame());
            if (((HCLInitDialog)object).showModal() != 0) {
                return null;
            }
            n = ((HCLInitDialog)object).getMethod();
            bl5 = ((HCLInitDialog)object).isClusterExperience();
            bl6 = ((HCLInitDialog)object).isClusterGenes();
        }
        object = new Listener();
        try {
            int n8;
            this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("PTM");
            this.algorithm.addAlgorithmListener((AlgorithmListener)object);
            FloatMatrix floatMatrix2 = this.experiment.getMatrix();
            if (!this.clusterGenes) {
                floatMatrix2 = floatMatrix2.transpose();
                n8 = floatMatrix2.getRowDimension();
            }
            n8 = this.experiment.getNumberOfGenes();
            AlgorithmData algorithmData = new AlgorithmData();
            algorithmData.addMatrix("experiment", floatMatrix2);
            algorithmData.addParam("ptm-cluster-genes", String.valueOf(this.clusterGenes));
            algorithmData.addMatrix("templateVectorMatrix", floatMatrix);
            algorithmData.addParam("distance-factor", String.valueOf(1.0f));
            IDistanceMenu iDistanceMenu = iFramework.getDistanceMenu();
            algorithmData.addParam("use-absolute", String.valueOf(bl3));
            algorithmData.addParam("useR", String.valueOf(bl4));
            algorithmData.addParam("threshold", String.valueOf(f));
            int n9 = iDistanceMenu.getDistanceFunction();
            if (n9 == 0) {
                n9 = 4;
            }
            algorithmData.addParam("distance-function", String.valueOf(n9));
            if (bl) {
                algorithmData.addParam("hierarchical-tree", String.valueOf(true));
                algorithmData.addParam("method-linkage", String.valueOf(n));
                algorithmData.addParam("calculate-genes", String.valueOf(bl6));
                algorithmData.addParam("calculate-experiments", String.valueOf(bl5));
            }
            long l = System.currentTimeMillis();
            AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
            long l2 = System.currentTimeMillis() - l;
            Cluster cluster = algorithmData2.getCluster("cluster");
            NodeList nodeList = cluster.getNodeList();
            this.clusters = new int[n4][];
            for (int i = 0; i < n4; ++i) {
                this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            this.means = algorithmData2.getMatrix("clusters_means");
            this.variances = algorithmData2.getMatrix("clusters_variances");
            GeneralInfo generalInfo = new GeneralInfo();
            generalInfo.clusters = n4;
            generalInfo.time = l2;
            generalInfo.function = iDistanceMenu.getFunctionName(n9);
            generalInfo.isR = bl4;
            generalInfo.isAbsolute = bl3;
            generalInfo.threshold = f;
            generalInfo.hcl = bl;
            generalInfo.hcl_genes = bl6;
            generalInfo.hcl_samples = bl5;
            generalInfo.hcl_method = n;
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(cluster, generalInfo);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)object);
            }
        }
    }

    private HCLTreeData getResult(Node node, int n) {
        HCLTreeData hCLTreeData = new HCLTreeData();
        NodeValueList nodeValueList = node.getValues();
        hCLTreeData.child_1_array = (int[])nodeValueList.getNodeValue((int)n).value;
        hCLTreeData.child_2_array = (int[])nodeValueList.getNodeValue((int)(n + 1)).value;
        hCLTreeData.node_order = (int[])nodeValueList.getNodeValue((int)(n + 2)).value;
        hCLTreeData.height = (float[])nodeValueList.getNodeValue((int)(n + 3)).value;
        return hCLTreeData;
    }

    private DefaultMutableTreeNode createResultTree(Cluster cluster, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.clusterGenes ? new DefaultMutableTreeNode("PTM - genes") : new DefaultMutableTreeNode("PTM - experiments");
        this.addResultNodes(defaultMutableTreeNode, cluster, generalInfo);
        return defaultMutableTreeNode;
    }

    private void addResultNodes(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        this.addExpressionImages(defaultMutableTreeNode);
        this.addHierarchicalTrees(defaultMutableTreeNode, cluster, generalInfo);
        this.addCentroidViews(defaultMutableTreeNode);
        this.addClusterInfo(defaultMutableTreeNode);
        this.addGeneralInfo(defaultMutableTreeNode, generalInfo);
    }

    private void addExpressionImages(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        if (this.clusterGenes) {
            PTMExperimentViewer pTMExperimentViewer = new PTMExperimentViewer(this.experiment, this.clusters, this.templateVector);
            for (int i = 0; i < this.clusters.length; ++i) {
                if (i < this.clusters.length - 1) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Matched Genes ", (IViewer)pTMExperimentViewer, new Integer(i))));
                    continue;
                }
                if (i != this.clusters.length - 1) continue;
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Genes ", (IViewer)pTMExperimentViewer, new Integer(i))));
            }
        } else {
            PTMExperimentClusterViewer pTMExperimentClusterViewer = new PTMExperimentClusterViewer(this.experiment, this.clusters, "Template", this.templateVector);
            for (int i = 0; i < this.clusters.length; ++i) {
                if (i < this.clusters.length - 1) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Matched Experiments ", (IViewer)pTMExperimentClusterViewer, new Integer(i))));
                    continue;
                }
                if (i != this.clusters.length - 1) continue;
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Experiments ", (IViewer)pTMExperimentClusterViewer, new Integer(i))));
            }
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode defaultMutableTreeNode, Cluster cluster, GeneralInfo generalInfo) {
        int n;
        if (!generalInfo.hcl) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = cluster.getNodeList();
        int n2 = nodeList.getSize();
        Object object = null;
        if (!this.clusterGenes) {
            object = new int[n2][];
            for (n = 0; n < ((int[][])object).length; ++n) {
                object[n] = nodeList.getNode(n).getFeaturesIndexes();
            }
            if (generalInfo.hcl_samples) {
                object = this.getOrderedIndices(nodeList, (int[][])object, generalInfo.hcl_genes);
            }
        }
        for (n = 0; n < n2; ++n) {
            if (this.clusterGenes) {
                if (n == 0) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Matched Genes", this.createHCLViewer(nodeList.getNode(n), generalInfo, null))));
                    continue;
                }
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Genes", this.createHCLViewer(nodeList.getNode(n), generalInfo, null))));
                continue;
            }
            if (n == 0) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Matched Experiments", this.createHCLViewer(nodeList.getNode(n), generalInfo, (int[][])object), new Integer(n))));
                continue;
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("UnMatched Experiments", this.createHCLViewer(nodeList.getNode(n), generalInfo, (int[][])object), new Integer(n))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private IViewer createHCLViewer(Node node, GeneralInfo generalInfo, int[][] nArray) {
        HCLTreeData hCLTreeData;
        HCLTreeData hCLTreeData2;
        HCLTreeData hCLTreeData3 = hCLTreeData2 = generalInfo.hcl_genes ? this.getResult(node, 0) : null;
        HCLTreeData hCLTreeData4 = generalInfo.hcl_samples ? this.getResult(node, generalInfo.hcl_genes ? 4 : 0) : (hCLTreeData = null);
        if (this.clusterGenes) {
            return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData);
        }
        return new HCLViewer(this.experiment, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData, nArray, true);
    }

    private void addClusterInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Cluster Information");
        if (this.clusterGenes) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Matching Results (#,%)", new PTMInfoViewer(this.clusters, this.experiment.getNumberOfGenes()))));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Matching Results (#,%)", new PTMInfoViewer(this.clusters, this.experiment.getNumberOfSamples(), this.clusterGenes))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        if (this.clusterGenes) {
            PTMCentroidViewer pTMCentroidViewer = new PTMCentroidViewer(this.experiment, this.clusters, this.templateVector);
            pTMCentroidViewer.setMeans(this.means.A);
            pTMCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length; ++i) {
                if (i == 0) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Matched Genes ", (IViewer)pTMCentroidViewer, new CentroidUserObject(i, 0))));
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Matched Genes ", (IViewer)pTMCentroidViewer, new CentroidUserObject(i, 1))));
                    continue;
                }
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Genes ", (IViewer)pTMCentroidViewer, new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Genes ", (IViewer)pTMCentroidViewer, new CentroidUserObject(i, 1))));
            }
            PTMCentroidsViewer pTMCentroidsViewer = new PTMCentroidsViewer(this.experiment, this.clusters, this.templateVector);
            pTMCentroidsViewer.setMeans(this.means.A);
            pTMCentroidsViewer.setVariances(this.variances.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)pTMCentroidsViewer, new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)pTMCentroidsViewer, new Integer(1))));
        } else {
            PTMExperimentCentroidViewer pTMExperimentCentroidViewer = new PTMExperimentCentroidViewer(this.experiment, this.clusters, this.templateVector);
            float[][] fArray = this.getCodes(this.templateVector);
            pTMExperimentCentroidViewer.setMeans(this.means.A);
            pTMExperimentCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length; ++i) {
                if (i == 0) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Matched Experiments ", (IViewer)pTMExperimentCentroidViewer, new CentroidUserObject(i, 0))));
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Matched Experiments ", (IViewer)pTMExperimentCentroidViewer, new CentroidUserObject(i, 1))));
                    continue;
                }
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Experiments ", (IViewer)pTMExperimentCentroidViewer, new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Experiments ", (IViewer)pTMExperimentCentroidViewer, new CentroidUserObject(i, 1))));
            }
            PTMExperimentCentroidsViewer pTMExperimentCentroidsViewer = new PTMExperimentCentroidsViewer(this.experiment, this.clusters, this.templateVector);
            pTMExperimentCentroidsViewer.setMeans(this.means.A);
            pTMExperimentCentroidsViewer.setVariances(this.variances.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)pTMExperimentCentroidsViewer, new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)pTMExperimentCentroidsViewer, new Integer(1))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    public float[][] getCodes(Vector vector) {
        int n = vector.size();
        float[][] fArray = new float[2][n];
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[i].length; ++j) {
                fArray[i][j] = ((Float)vector.elementAt(i)).intValue();
            }
        }
        return fArray;
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Absolute: " + String.valueOf(generalInfo.isAbsolute)));
        if (generalInfo.isR) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Threshold Pearson R: " + String.valueOf(generalInfo.threshold)));
        } else {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Threshold prob. of R: " + String.valueOf(generalInfo.threshold)));
        }
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("HCL: " + generalInfo.getMethodName()));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(generalInfo.function));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private int[][] getOrderedIndices(NodeList nodeList, int[][] nArray, boolean bl) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i].length <= 0) continue;
            HCLTreeData hCLTreeData = this.getResult(nodeList.getNode(i), bl ? 4 : 0);
            nArray[i] = this.getSampleOrder(hCLTreeData, nArray[i]);
        }
        return nArray;
    }

    private int[] getSampleOrder(HCLTreeData hCLTreeData, int[] nArray) {
        return this.getLeafOrder(hCLTreeData.node_order, hCLTreeData.child_1_array, hCLTreeData.child_2_array, nArray);
    }

    private int[] getLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = new int[nArray.length];
        Arrays.fill(nArray5, -1);
        this.fillLeafOrder(nArray5, nArray2, nArray3, 0, nArray2.length - 2, nArray4);
        return nArray5;
    }

    private int fillLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int[] nArray4) {
        if (nArray2[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray2[n2], nArray4);
        }
        if (nArray3[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray3[n2], nArray4);
        } else {
            nArray[n] = nArray4 == null ? n2 : nArray4[n2];
            ++n;
        }
        return n;
    }

    private class GeneralInfo {
        public int clusters;
        public long time;
        public String function;
        public boolean isAbsolute;
        public boolean isR;
        public float threshold;
        private boolean hcl;
        private int hcl_method;
        private boolean hcl_genes;
        private boolean hcl_samples;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                PTMGUI.this.algorithm.abort();
                this.cleanUp();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            PTMGUI.this.algorithm.abort();
            this.cleanUp();
        }

        public void cleanUp() {
        }
    }
}

