/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.qtc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.SampleSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.util.awt.GBA;

public class QTCInitDialog
extends AlgorithmDialog {
    protected GBA gba;
    protected EventListener eventListener;
    protected JPanel inputPanel;
    public JLabel diameterLabel;
    public JTextField diameterTextField;
    public JLabel clusterLabel;
    public JTextField clusterTextField;
    protected JPanel useAbsolutePanel;
    public JCheckBox useAbsoluteCheckBox;
    public int result;
    private SampleSelectionPanel sampleSelectionPanel;
    private HCLSelectionPanel hclOpsPanel;
    protected JPanel mainPanel;
    private boolean okPressed = false;

    public QTCInitDialog(JFrame jFrame, boolean bl) {
        super(jFrame, "QTC: QT Cluster", bl);
        this.initialize();
    }

    protected void initialize() {
        this.gba = new GBA();
        this.eventListener = new EventListener();
        this.diameterLabel = new JLabel("Maximum Cluster Diameter");
        this.diameterLabel.setAlignmentX(0.0f);
        this.diameterTextField = new JTextField(5);
        this.diameterTextField.setText("0.5");
        this.clusterLabel = new JLabel("Minimum Cluster Population");
        this.clusterTextField = new JTextField(5);
        this.clusterTextField.setText("5");
        this.sampleSelectionPanel = new SampleSelectionPanel(Color.white, UIManager.getColor("Label.foreground"), true, "Sample Selection");
        this.inputPanel = new JPanel();
        this.inputPanel.setLayout(new GridBagLayout());
        this.inputPanel.setBackground(Color.white);
        this.gba.add(this.inputPanel, this.diameterLabel, 0, 0, 1, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.inputPanel, this.clusterLabel, 0, 1, 1, 0, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.inputPanel, this.diameterTextField, 1, 0, 1, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.inputPanel, this.clusterTextField, 1, 1, 1, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.useAbsoluteCheckBox = new JCheckBox("Use Absolute R");
        this.useAbsoluteCheckBox.setForeground(UIManager.getColor("Label.foreground"));
        this.useAbsoluteCheckBox.setBackground(Color.white);
        this.useAbsoluteCheckBox.setFocusPainted(false);
        this.useAbsolutePanel = new JPanel();
        this.useAbsolutePanel.setBackground(Color.white);
        this.useAbsolutePanel.setLayout(new GridBagLayout());
        this.gba.add(this.useAbsolutePanel, this.useAbsoluteCheckBox, 0, 0, 1, 1, 0, 0, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.hclOpsPanel = new HCLSelectionPanel();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBackground(Color.white);
        ParameterPanel parameterPanel = new ParameterPanel();
        parameterPanel.setLayout(new GridBagLayout());
        this.gba.add(parameterPanel, this.inputPanel, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(parameterPanel, this.useAbsolutePanel, 0, 1, 2, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.mainPanel, this.sampleSelectionPanel, 0, 0, 1, 1, 1, 1, 2, 10, new Insets(0, 0, 0, 0), 0, 0);
        this.gba.add(this.mainPanel, parameterPanel, 0, 1, 1, 1, 1, 1, 2, 10, new Insets(0, 0, 0, 0), 0, 0);
        this.gba.add(this.mainPanel, this.hclOpsPanel, 0, 2, 1, 1, 1, 1, 2, 10, new Insets(0, 0, 0, 0), 0, 0);
        this.setActionListeners(this.eventListener);
        this.addContent(this.mainPanel);
        this.pack();
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.setVisible(bl);
        if (bl) {
            this.okButton.requestFocus();
        }
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean isClusterGenesSelected() {
        return this.sampleSelectionPanel.isClusterGenesSelected();
    }

    public boolean isHCLSelected() {
        return this.hclOpsPanel.isHCLSelected();
    }

    private void resetControls() {
        this.sampleSelectionPanel.setClusterGenesSelected(true);
        this.hclOpsPanel.setHCLSelected(false);
        this.clusterTextField.setText("5");
        this.diameterTextField.setText("0.5");
        this.useAbsoluteCheckBox.setSelected(false);
    }

    private boolean validInput(int n, float f) {
        boolean bl = true;
        if (f <= 0.0f) {
            JOptionPane.showMessageDialog(this, "Diameter must be > 0", "Input Error!", 0);
            this.diameterTextField.requestFocus();
            this.diameterTextField.selectAll();
            bl = false;
        } else if (n < 1) {
            JOptionPane.showMessageDialog(this, "Population of a cluster must be > 0", "Input Error!", 0);
            this.clusterTextField.requestFocus();
            this.clusterTextField.selectAll();
            bl = false;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        QTCInitDialog qTCInitDialog = new QTCInitDialog(new JFrame(), true);
        qTCInitDialog.show();
        System.exit(0);
    }

    protected class EventListener
    implements ActionListener {
        protected EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                int n;
                float f;
                int n2 = 0;
                try {
                    f = Float.parseFloat(QTCInitDialog.this.diameterTextField.getText());
                    ++n2;
                    n = Integer.parseInt(QTCInitDialog.this.clusterTextField.getText());
                    ++n2;
                }
                catch (NumberFormatException numberFormatException) {
                    if (n2 == 0) {
                        QTCInitDialog.this.diameterTextField.requestFocus();
                        QTCInitDialog.this.diameterTextField.selectAll();
                    } else if (n2 == 1) {
                        QTCInitDialog.this.clusterTextField.requestFocus();
                        QTCInitDialog.this.clusterTextField.selectAll();
                    }
                    JOptionPane.showMessageDialog(QTCInitDialog.this, "Number format error.", "Number Format Error", 0);
                    QTCInitDialog.this.result = 2;
                    QTCInitDialog.this.okPressed = false;
                    return;
                }
                if (QTCInitDialog.this.validInput(n, f)) {
                    QTCInitDialog.this.result = 0;
                    QTCInitDialog.this.okPressed = true;
                    QTCInitDialog.this.dispose();
                } else {
                    QTCInitDialog.this.result = 2;
                    QTCInitDialog.this.okPressed = false;
                }
            } else if (string.equals("cancel-command")) {
                QTCInitDialog.this.result = 2;
                QTCInitDialog.this.okPressed = false;
                QTCInitDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                QTCInitDialog.this.resetControls();
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(QTCInitDialog.this, "QTC Initialization Dialog");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 500);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                }
            }
        }
    }
}

