/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sota;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentHeader;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLCluster;
import org.tigr.util.FloatMatrix;

public class SOTACentroidExpressionViewer
extends JPanel
implements IViewer {
    private int numberOfCentroids;
    private int[] clusterPopulation;
    private FloatMatrix clusterDiversity;
    private int TEXT_LEFT_MARGIN = 20;
    private int CLUSTER_POP_SPACER = 20;
    private int POP_DIV_SPACER = 20;
    private static final float INITIAL_MAX_VALUE = 3.0f;
    private static final float INITIAL_MIN_VALUE = -3.0f;
    private static final String NO_GENES_STR = "No Genes in Cluster!";
    private static final Font ERROR_FONT = new Font("monospaced", 1, 20);
    private ExperimentHeader header;
    private Experiment experiment;
    private IFramework framework;
    private IData data;
    private int clusterIndex;
    private int[][] clusters;
    private int[] samplesOrder;
    private Dimension elementSize = new Dimension(40, 20);
    private boolean isAntiAliasing = true;
    private boolean isDrawBorders = true;
    public static Color missingColor = new Color(128, 128, 128);
    public static Color maskColor = new Color(255, 255, 255, 128);
    private float maxValue = 3.0f;
    private float minValue = -3.0f;
    private int firstSelectedRow = -1;
    private int lastSelectedRow = -1;
    private ArrayList selectedClusterList;
    public BufferedImage posColorImage = this.createGradientImage(Color.black, Color.red);
    public BufferedImage negColorImage = this.createGradientImage(Color.green, Color.black);
    private int maxUniqueIDWidth;
    private int maxGeneNameWidth;
    private Listener listener;

    public SOTACentroidExpressionViewer(Experiment experiment, int[][] nArray, int[] nArray2, int[] nArray3, FloatMatrix floatMatrix, ArrayList arrayList) {
        if (experiment == null) {
            throw new IllegalArgumentException("experiment == null");
        }
        this.experiment = experiment;
        this.clusterPopulation = nArray3;
        this.clusterDiversity = floatMatrix;
        this.numberOfCentroids = this.clusterPopulation.length;
        this.selectedClusterList = arrayList;
        this.clusters = nArray == null ? SOTACentroidExpressionViewer.defGenesOrder(this.experiment.getNumberOfGenes()) : nArray;
        this.samplesOrder = nArray2 == null ? SOTACentroidExpressionViewer.defSamplesOrder(this.experiment.getNumberOfSamples()) : nArray2;
        this.header = new ExperimentHeader(this.experiment, this.clusters, this.samplesOrder);
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        this.setBackground(Color.white);
        this.listener = new Listener();
        this.addMouseMotionListener(this.listener);
        this.addMouseListener(this.listener);
    }

    private static int[] defSamplesOrder(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    private static int[][] defGenesOrder(int n) {
        int[][] nArray = new int[1][n];
        for (int i = 0; i < nArray[0].length; ++i) {
            nArray[0][i] = i;
        }
        return nArray;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public BufferedImage getImage() {
        return null;
    }

    public BufferedImage getPosColorImage() {
        return this.posColorImage;
    }

    public BufferedImage getNegColorImage() {
        return this.negColorImage;
    }

    public Color getMissingColor() {
        return missingColor;
    }

    public void selectRows(int n, int n2) {
        this.firstSelectedRow = n;
        this.lastSelectedRow = n2;
        this.repaint();
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        this.data = iFramework.getData();
        this.header.setData(this.data);
        Integer n = (Integer)iFramework.getUserObject();
        this.setClusterIndex(n == null ? 0 : n);
        IDisplayMenu iDisplayMenu = iFramework.getDisplayMenu();
        this.maxValue = Math.abs(iDisplayMenu.getMaxRatioScale());
        this.minValue = -Math.abs(iDisplayMenu.getMinRatioScale());
        this.setElementSize(iDisplayMenu.getElementSize());
        this.setAntialiasing(iDisplayMenu.isAntiAliasing());
        this.setDrawBorders(iDisplayMenu.isDrawingBorder());
        this.updateSize();
        this.posColorImage = iDisplayMenu.getPositiveGradientImage();
        this.negColorImage = iDisplayMenu.getNegativeGradientImage();
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        this.header.setValues(this.minValue, this.maxValue);
        this.header.setAntiAliasing(iDisplayMenu.isAntiAliasing());
        this.header.updateSizes(this.getSize().width, this.elementSize.width);
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.setDrawBorders(iDisplayMenu.isDrawingBorder());
        this.maxValue = Math.abs(iDisplayMenu.getMaxRatioScale());
        this.minValue = -Math.abs(iDisplayMenu.getMinRatioScale());
        this.header.setValues(this.minValue, this.maxValue);
        this.posColorImage = iDisplayMenu.getPositiveGradientImage();
        this.negColorImage = iDisplayMenu.getNegativeGradientImage();
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        if (this.elementSize.equals(iDisplayMenu.getElementSize()) && this.isAntiAliasing == iDisplayMenu.isAntiAliasing()) {
            return;
        }
        this.setElementSize(iDisplayMenu.getElementSize());
        this.setAntialiasing(iDisplayMenu.isAntiAliasing());
        this.updateSize();
        this.header.setAntiAliasing(iDisplayMenu.isAntiAliasing());
        this.header.updateSizes(this.getSize().width, this.elementSize.width);
    }

    public void onDataChanged(IData iData) {
        this.data = iData;
        this.header.setData(iData);
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    public void setClusterIndex(int n) {
        this.clusterIndex = n;
    }

    public int getClusterIndex() {
        return this.clusterIndex;
    }

    public int[] getCluster() {
        return this.clusters[this.clusterIndex];
    }

    public int[][] getClusters() {
        return this.clusters;
    }

    private int getRow(int n) {
        return this.clusters[this.clusterIndex][n];
    }

    private int getColumn(int n) {
        return this.samplesOrder[n];
    }

    protected Experiment getExperiment() {
        return this.experiment;
    }

    protected IData getData() {
        return this.data;
    }

    public void setClusterColor(Color color) {
        this.data.setProbesColor(this.getCluster(), color);
    }

    public void saveClusters(Frame frame) throws Exception {
        frame = frame == null ? JOptionPane.getFrameForComponent(this) : frame;
        ExperimentUtil.saveExperiment(frame, this.getExperiment(), this.getData(), this.getClusters());
    }

    public void saveCluster(Frame frame) throws Exception {
        frame = frame == null ? JOptionPane.getFrameForComponent(this) : frame;
        ExperimentUtil.saveExperiment(frame, this.getExperiment(), this.getData(), this.getCluster());
    }

    private void setElementSize(Dimension dimension) {
        this.elementSize = new Dimension(dimension);
    }

    private void setAntialiasing(boolean bl) {
        this.isAntiAliasing = bl;
    }

    private void setDrawBorders(boolean bl) {
        this.isDrawBorders = bl;
    }

    public BufferedImage createGradientImage(Color color, Color color2) {
        BufferedImage bufferedImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(256, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 255.0f, 0.0f, color2);
        graphics2D.setPaint(gradientPaint);
        graphics2D.drawRect(0, 0, 255, 1);
        return bufferedImage;
    }

    private void updateSize() {
        if (this.clusters == null || this.getCluster().length == 0) {
            this.setFont(ERROR_FONT);
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = fontMetrics.stringWidth(NO_GENES_STR) + 10;
            int n2 = fontMetrics.getHeight() + 30;
            this.setSize(n, n2);
            this.setPreferredSize(new Dimension(n, n2));
            return;
        }
        this.setFont(new Font("monospaced", 0, this.elementSize.height));
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        int n = this.elementSize.width * this.experiment.getNumberOfSamples() + 1;
        int n3 = this.elementSize.height * this.numberOfCentroids + 1;
        this.setSize(n += this.getClusterTextWidth(graphics2D) + this.TEXT_LEFT_MARGIN + this.CLUSTER_POP_SPACER + this.POP_DIV_SPACER, n3);
        this.setPreferredSize(new Dimension(n, n3));
    }

    private int getClusterTextWidth(Graphics2D graphics2D) {
        return this.getPopulationTextWidth(graphics2D) + this.getDiversityTextWidth(graphics2D) + this.getClusterNumberTextWidth(graphics2D);
    }

    private int getPopulationTextWidth(Graphics2D graphics2D) {
        int n = 0;
        int n2 = 0;
        if (this.clusterPopulation == null) {
            return 0;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        for (int i = 0; i < this.clusterPopulation.length; ++i) {
            n2 = fontMetrics.stringWidth(String.valueOf(this.clusterPopulation[i]));
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private int getDiversityTextWidth(Graphics2D graphics2D) {
        int n = 0;
        int n2 = 0;
        if (this.clusterDiversity == null) {
            return 0;
        }
        int n3 = this.clusterDiversity.getRowDimension();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        for (int i = 0; i < n3; ++i) {
            n2 = fontMetrics.stringWidth(String.valueOf(this.clusterDiversity.get(i, 0)));
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private int getClusterNumberTextWidth(Graphics2D graphics2D) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        return fontMetrics.stringWidth(String.valueOf(this.numberOfCentroids));
    }

    private Color getColor(float f) {
        if (Float.isNaN(f)) {
            return missingColor;
        }
        float f2 = f < 0.0f ? this.minValue : this.maxValue;
        int n = (int)(255.0f * f / f2);
        n = n > 255 ? 255 : n;
        int n2 = f < 0.0f ? this.negColorImage.getRGB(255 - n, 0) : this.posColorImage.getRGB(n, 0);
        return new Color(n2);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        super.paint(graphics);
        if (this.isAntiAliasing) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        int n3 = this.experiment.getNumberOfSamples();
        if (this.clusters == null || this.getCluster().length == 0) {
            graphics.setColor(new Color(0, 0, 128));
            graphics.setFont(ERROR_FONT);
            graphics.drawString(NO_GENES_STR, 10, 30);
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        int n4 = this.getTopIndex(rectangle.y);
        int n5 = this.getBottomIndex(rectangle.y + rectangle.height, this.getCluster().length);
        int n6 = this.getLeftIndex(rectangle.x);
        int n7 = this.getRightIndex(rectangle.x + rectangle.width, n3);
        for (n2 = n6; n2 < n7; ++n2) {
            for (n = n4; n < n5; ++n) {
                this.fillRectAt(graphics, n, n2);
            }
        }
        graphics.setColor(Color.black);
        n2 = this.elementSize.width * n3 + this.TEXT_LEFT_MARGIN;
        n = n2 + this.CLUSTER_POP_SPACER + this.getClusterNumberTextWidth((Graphics2D)graphics);
        int n8 = n + this.POP_DIV_SPACER + this.getPopulationTextWidth((Graphics2D)graphics);
        for (int i = n4; i < n5; ++i) {
            int n9 = (i + 1) * this.elementSize.height;
            graphics.drawString(Integer.toString(i + 1), n2, n9);
            graphics.drawString(Integer.toString(this.clusterPopulation[i]), n, n9);
            graphics.drawString(Float.toString(this.clusterDiversity.get(i, 0)), n8, n9);
        }
        if (!this.selectedClusterList.isEmpty()) {
            Color color = graphics.getColor();
            for (int i = 0; i < this.selectedClusterList.size(); ++i) {
                HCLCluster hCLCluster = (HCLCluster)this.selectedClusterList.get(i);
                graphics.setColor(hCLCluster.color);
                graphics.fillRect(this.elementSize.width * n3 + 2, this.elementSize.height * hCLCluster.root, 15, this.elementSize.height);
            }
        }
    }

    private void fillRectAt(Graphics graphics, int n, int n2) {
        int n3 = n2 * this.elementSize.width;
        int n4 = n * this.elementSize.height;
        boolean bl = this.firstSelectedRow >= 0 && this.lastSelectedRow >= 0 && (n < this.firstSelectedRow || n > this.lastSelectedRow);
        graphics.setColor(this.getColor(this.experiment.get(this.getRow(n), this.getColumn(n2))));
        graphics.fillRect(n3, n4, this.elementSize.width, this.elementSize.height);
        if (bl) {
            graphics.setColor(maskColor);
            graphics.fillRect(n3, n4, this.elementSize.width, this.elementSize.height);
        }
        if (this.isDrawBorders) {
            graphics.setColor(Color.black);
            graphics.drawRect(n3, n4, this.elementSize.width - 1, this.elementSize.height - 1);
        }
    }

    private void drawRectAt(Graphics graphics, int n, int n2, Color color) {
        graphics.setColor(color);
        graphics.drawRect(n2 * this.elementSize.width, n * this.elementSize.height, this.elementSize.width - 1, this.elementSize.height - 1);
    }

    private void drawCentroidRectangle(Graphics graphics, int n, Color color) {
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        graphics.drawRect(0, n * this.elementSize.height, this.samplesOrder.length * this.elementSize.width - 1, this.elementSize.height - 1);
        graphics.setColor(color2);
    }

    private void fillCentroid(Graphics graphics, int n) {
        for (int i = 0; i < this.samplesOrder.length; ++i) {
            this.fillRectAt(graphics, n, i);
        }
    }

    private int getTopIndex(int n) {
        if (n < 0) {
            return 0;
        }
        return n / this.elementSize.height;
    }

    private int getLeftIndex(int n) {
        if (n < 0) {
            return 0;
        }
        return n / this.elementSize.width;
    }

    private int getRightIndex(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        int n3 = n / this.elementSize.width + 1;
        return n3 > n2 ? n2 : n3;
    }

    private int getBottomIndex(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        int n3 = n / this.elementSize.height + 1;
        return n3 > n2 ? n2 : n3;
    }

    private int findColumn(int n) {
        int n2 = this.experiment.getNumberOfSamples() * this.elementSize.width;
        if (n >= n2 || n < 0) {
            return -1;
        }
        return n / this.elementSize.width;
    }

    private int findRow(int n) {
        int n2 = this.getCluster().length * this.elementSize.height;
        if (n >= n2 || n < 0) {
            return -1;
        }
        return n / this.elementSize.height;
    }

    private boolean isLegalPosition(int n, int n2) {
        return this.isLegalRow(n) && this.isLegalColumn(n2);
    }

    private boolean isLegalColumn(int n) {
        return n >= 0 && n <= this.experiment.getNumberOfSamples() - 1;
    }

    private boolean isLegalRow(int n) {
        return n >= 0 && n <= this.getCluster().length - 1;
    }

    public int getCurrentCentroidNumber() {
        return this.listener.getCurrCentroidNumber();
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    MouseMotionListener {
        int x = 0;
        int y = 0;
        int currCentroidNumber;
        int oldCentroidNumber;
        Point origin;
        int originX;
        int originY;
        Rectangle expBounds;
        float xDim;
        float yDim;
        Graphics g;
        Color rectangleColor = Color.white;

        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.x = mouseEvent.getX();
            this.y = mouseEvent.getY();
            this.currCentroidNumber = this.cursorOverCentroid(this.x, this.y);
            if (this.currCentroidNumber != this.oldCentroidNumber) {
                int n;
                this.g = SOTACentroidExpressionViewer.this.getGraphics();
                if (this.currCentroidNumber != -1) {
                    if (this.oldCentroidNumber != -1) {
                        for (n = 0; n < SOTACentroidExpressionViewer.this.samplesOrder.length; ++n) {
                            SOTACentroidExpressionViewer.this.fillRectAt(this.g, this.oldCentroidNumber, n);
                        }
                    }
                    SOTACentroidExpressionViewer.this.drawCentroidRectangle(this.g, this.currCentroidNumber, this.rectangleColor);
                    SOTACentroidExpressionViewer.this.framework.setStatusText("Cluster # " + (this.currCentroidNumber + 1) + ",  Population: " + SOTACentroidExpressionViewer.this.clusterPopulation[this.currCentroidNumber] + ",  Diversity: " + SOTACentroidExpressionViewer.this.clusterDiversity.get(this.currCentroidNumber, 0));
                }
                if (this.currCentroidNumber == -1 && this.oldCentroidNumber != -1) {
                    for (n = 0; n < SOTACentroidExpressionViewer.this.samplesOrder.length; ++n) {
                        SOTACentroidExpressionViewer.this.fillRectAt(this.g, this.oldCentroidNumber, n);
                    }
                    SOTACentroidExpressionViewer.this.framework.setStatusText(" ");
                }
                this.oldCentroidNumber = this.currCentroidNumber;
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            Graphics graphics = SOTACentroidExpressionViewer.this.getGraphics();
            if (this.currCentroidNumber != -1) {
                SOTACentroidExpressionViewer.this.fillCentroid(graphics, this.currCentroidNumber);
            }
            if (this.oldCentroidNumber != -1) {
                SOTACentroidExpressionViewer.this.fillCentroid(graphics, this.oldCentroidNumber);
            }
            this.currCentroidNumber = -1;
        }

        private int cursorOverCentroid(int n, int n2) {
            this.currCentroidNumber = -1;
            this.originX = 0;
            this.originY = 0;
            this.xDim = (float)SOTACentroidExpressionViewer.this.samplesOrder.length * (float)((SOTACentroidExpressionViewer)SOTACentroidExpressionViewer.this).elementSize.width;
            this.yDim = (float)SOTACentroidExpressionViewer.this.numberOfCentroids * (float)((SOTACentroidExpressionViewer)SOTACentroidExpressionViewer.this).elementSize.height;
            if (this.originX < n && (float)n < (float)this.originX + this.xDim && this.originY < n2 && (float)n2 < (float)this.originY + this.yDim) {
                this.currCentroidNumber = (int)((float)(SOTACentroidExpressionViewer.this.numberOfCentroids * (n2 - this.originY)) / this.yDim);
            }
            return this.currCentroidNumber;
        }

        public int getCurrCentroidNumber() {
            return this.currCentroidNumber;
        }
    }
}

