/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sota;

import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.SampleSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class SOTAInitDialog
extends AlgorithmDialog {
    public int result = 0;
    private float initDiv = 0.01f;
    private SampleSelectionPanel sampleSelectionPanel;
    private ButtonGroup divideCritButtonGroup;
    private JPanel parameters;
    private JPanel growthCritPanel;
    private JLabel maxCyclesLabel;
    private JLabel maxDivLabel;
    private JTextField maxTreeDiv;
    private JTextField stopEpochCriteria;
    private JLabel epochImpLabel;
    private JTextField maxCyclesText;
    private JCheckBox runMaxCycles;
    private JTextField maxEpPerCycleText;
    private JLabel jLabel52;
    private JCheckBox runIterative;
    private JPanel migCritPanel;
    private JLabel jLabel57;
    private JTextField migFactor_w;
    private JLabel jLabel58;
    private JLabel jLabel49;
    private JTextField migFactor_s;
    private JTextField migFactor_p;
    private Choice levelChoice;
    private JLabel jLabel1;
    private JPanel cellDivPanel;
    private JRadioButton useClusterDiversity;
    private JPanel jPanel1;
    private JRadioButton useClusterVariance;
    private JLabel pValueLabel;
    private JTextField pValue;
    private HCLSelectionPanel hclOpsPanel;

    public SOTAInitDialog(Frame frame, int n) {
        super(new JFrame(), "SOTA: Self Organizing Tree Algorithm", true);
        this.initComponents();
        if (n == -1) {
            this.maxTreeDiv.setText("0.90");
            this.initDiv = 0.9f;
        }
        this.runIterative.setVisible(false);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        this.setActionListeners(listener);
        this.useClusterVariance.addItemListener(listener);
        this.setSize(580, 510);
    }

    private void initComponents() {
        this.sampleSelectionPanel = new SampleSelectionPanel(Color.white, UIManager.getColor("Label.foreground"), true, "Sample Selection");
        this.maxCyclesLabel = new JLabel();
        this.maxDivLabel = new JLabel();
        this.maxTreeDiv = new JTextField();
        this.stopEpochCriteria = new JTextField();
        this.epochImpLabel = new JLabel();
        this.maxCyclesText = new JTextField();
        this.runMaxCycles = new JCheckBox();
        this.maxEpPerCycleText = new JTextField();
        this.jLabel52 = new JLabel();
        this.runIterative = new JCheckBox();
        this.migCritPanel = new JPanel();
        this.jLabel57 = new JLabel();
        this.migFactor_w = new JTextField();
        this.jLabel58 = new JLabel();
        this.jLabel49 = new JLabel();
        this.migFactor_s = new JTextField();
        this.migFactor_p = new JTextField();
        this.levelChoice = new Choice();
        for (int i = 5; i >= 0; --i) {
            this.levelChoice.addItem(String.valueOf(i));
        }
        this.levelChoice.select("5");
        this.jLabel1 = new JLabel();
        this.cellDivPanel = new JPanel();
        this.useClusterDiversity = new JRadioButton();
        this.jPanel1 = new JPanel();
        this.useClusterVariance = new JRadioButton();
        this.pValueLabel = new JLabel();
        this.pValue = new JTextField();
        this.hclOpsPanel = new HCLSelectionPanel();
        this.growthCritPanel = new JPanel();
        this.growthCritPanel.setLayout(new GridBagLayout());
        this.growthCritPanel.setBackground(Color.white);
        this.growthCritPanel.setBorder(new TitledBorder(new LineBorder(Color.gray), "Growth Termination Criteria", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.maxCyclesLabel.setText("Max. Cycles");
        this.maxCyclesLabel.setToolTipText("Maximum training cycles (final cluster number = MaxCycles +1)");
        this.maxDivLabel.setText("Max. Cell Diversity");
        this.maxDivLabel.setToolTipText("Training will stop when the most diverse cell crosses this limit. (for Euclidean diversity approaches 0, for Pearson diversity approaches 1.0)  ");
        this.maxTreeDiv.setColumns(6);
        this.maxTreeDiv.setText("0.01");
        this.stopEpochCriteria.setColumns(6);
        this.stopEpochCriteria.setText("0.0001");
        this.epochImpLabel.setText("Min. Epoch Error Improvement");
        this.epochImpLabel.setToolTipText("If improvement in relative tree error changes by less than this, current cycle ends");
        this.maxCyclesText.setColumns(6);
        this.maxCyclesText.setText("10");
        this.runMaxCycles.setText("Run Maximum  Number of Cycles (unrestricted growth)");
        this.runMaxCycles.setBackground(Color.white);
        this.runMaxCycles.setForeground(UIManager.getColor("Label.foreground"));
        this.runMaxCycles.setAlignmentX(0.5f);
        this.runMaxCycles.setFocusPainted(false);
        this.maxEpPerCycleText.setColumns(6);
        this.maxEpPerCycleText.setText("1000");
        this.jLabel52.setText("Max. epochs/cycle");
        this.jLabel52.setToolTipText("Maximum training epochs per cycle");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SOTAInitDialog.this.closeDialog(windowEvent);
            }
        });
        this.growthCritPanel.add((Component)this.maxCyclesLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 30, 5, 0), 0, 0));
        this.growthCritPanel.add((Component)this.maxCyclesText, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        this.growthCritPanel.add((Component)this.maxDivLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 40, 5, 0), 0, 0));
        this.growthCritPanel.add((Component)this.maxTreeDiv, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 20), 0, 0));
        this.growthCritPanel.add((Component)this.jLabel52, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 30, 0, 0), 0, 0));
        this.growthCritPanel.add((Component)this.maxEpPerCycleText, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.growthCritPanel.add((Component)this.epochImpLabel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 40, 0, 0), 0, 0));
        this.growthCritPanel.add((Component)this.stopEpochCriteria, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 20), 0, 0));
        this.growthCritPanel.add((Component)this.runMaxCycles, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 10, 1, new Insets(5, 90, 0, 10), 0, 0));
        this.migCritPanel.setLayout(new GridBagLayout());
        this.migCritPanel.setBorder(new TitledBorder(new EtchedBorder(), "Cetroid Migration and Neighborhood Parameters", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.migCritPanel.setBackground(Color.white);
        this.jLabel57.setText("Winning Cell Migration Weight");
        this.jLabel57.setToolTipText("Factor to apply to winning cell migration");
        this.migFactor_w.setColumns(5);
        this.migFactor_w.setText("0.01");
        this.jLabel58.setText("Parent Cell Migration Weight");
        this.jLabel58.setToolTipText("Factor to apply to parent cell migration");
        this.migFactor_p.setColumns(5);
        this.migFactor_p.setText("0.005");
        this.jLabel49.setText("Sister Cell Migration Weight");
        this.jLabel49.setToolTipText("Factor to apply to sister cell migration");
        this.migFactor_s.setColumns(5);
        this.migFactor_s.setText("0.001");
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.levelChoice, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 15, 0, 20), 0, 0));
        this.jLabel1.setText("Neighborhood Level");
        this.jLabel1.setToolTipText("Determines extent of redistribution neighborhood");
        this.levelChoice.setSize(50, 35);
        this.migCritPanel.add((Component)this.jLabel57, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        this.migCritPanel.add((Component)this.jLabel58, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.migCritPanel.add((Component)this.jLabel49, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.migCritPanel.add((Component)this.migFactor_w, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 25, 5, 20), 0, 0));
        this.migCritPanel.add((Component)this.migFactor_p, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 25, 5, 20), 0, 0));
        this.migCritPanel.add((Component)this.migFactor_s, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 25, 5, 20), 0, 0));
        this.migCritPanel.add((Component)jPanel, new GridBagConstraints(2, 0, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.cellDivPanel.setLayout(new GridBagLayout());
        this.cellDivPanel.setBackground(Color.white);
        this.cellDivPanel.setBorder(new TitledBorder(new EtchedBorder(), "Cell Division Criteria", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.useClusterDiversity.setToolTipText("Use cell resource to determin cell to divide");
        this.useClusterDiversity.setSelected(true);
        this.useClusterDiversity.setText("Use Cell Diversity  ( mean dist(gene,centroid) )");
        this.useClusterDiversity.setAlignmentX(0.5f);
        this.useClusterDiversity.setBackground(Color.white);
        this.useClusterDiversity.setFocusPainted(false);
        this.useClusterDiversity.setForeground(UIManager.getColor("Label.foreground"));
        this.divideCritButtonGroup = new ButtonGroup();
        this.divideCritButtonGroup.add(this.useClusterDiversity);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBackground(Color.white);
        this.useClusterVariance.setToolTipText("Use variance and p Value to stop cell division");
        this.useClusterVariance.setText("Use Cell Variability ( max( dist(g(i), g(j)) ) )");
        this.useClusterVariance.setBackground(Color.white);
        this.useClusterVariance.setFocusPainted(false);
        this.useClusterVariance.setForeground(UIManager.getColor("Label.foreground"));
        this.divideCritButtonGroup.add(this.useClusterVariance);
        this.pValueLabel.setText("p Value");
        this.pValueLabel.setBackground(Color.white);
        this.pValue.setText("0.05");
        this.pValue.setEnabled(false);
        this.jPanel1.add((Component)this.useClusterVariance, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 30), 0, 0));
        this.jPanel1.add((Component)this.pValueLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.pValue, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 30), 0, 0));
        this.cellDivPanel.add((Component)this.useClusterDiversity, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(0, 90, 0, 0), 0, 0));
        this.cellDivPanel.add((Component)this.jPanel1, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 1, new Insets(0, 10, 5, 10), 0, 0));
        this.parameters = new JPanel();
        this.parameters.setLayout(new GridBagLayout());
        this.parameters.setPreferredSize(new Dimension(520, 412));
        this.parameters.setMaximumSize(new Dimension(Short.MAX_VALUE, 690));
        this.parameters.add((Component)this.sampleSelectionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.parameters.add((Component)this.growthCritPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.parameters.add((Component)this.migCritPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.parameters.add((Component)this.cellDivPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.parameters.add((Component)this.hclOpsPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(this.parameters);
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public int getInt(String string) throws NumberFormatException {
        int n = 0;
        if (string.equals("maxCycles")) {
            String string2 = this.maxCyclesText.getText();
            n = Integer.parseInt(string2);
        } else if (string.equals("maxEpochsPerCycle")) {
            String string3 = this.maxEpPerCycleText.getText();
            n = Integer.parseInt(string3);
        } else if (string.equals("neighborhood-level")) {
            n = Integer.parseInt(this.levelChoice.getSelectedItem());
        }
        return n;
    }

    public float getFloat(String string) throws NumberFormatException {
        float f = 0.0f;
        if (string.equals("maxTreeDiv")) {
            String string2 = this.maxTreeDiv.getText();
            f = Float.parseFloat(string2);
        } else if (string.equals("epochStopCriteria")) {
            String string3 = this.stopEpochCriteria.getText();
            f = Float.parseFloat(string3);
        } else if (string.equals("migFactor_w")) {
            String string4 = this.migFactor_w.getText();
            f = Float.parseFloat(string4);
        } else if (string.equals("migFactor_p")) {
            String string5 = this.migFactor_p.getText();
            f = Float.parseFloat(string5);
        } else if (string.equals("migFactor_s")) {
            String string6 = this.migFactor_s.getText();
            f = Float.parseFloat(string6);
        } else if (string.equals("pValue")) {
            String string7 = this.pValue.getText();
            f = Float.parseFloat(string7);
        }
        return f;
    }

    public boolean getBoolean(String string) {
        boolean bl = false;
        if (string.equals("runToMaxCycles")) {
            bl = this.runMaxCycles.isSelected();
        } else if (string.equals("useVariance")) {
            bl = this.useClusterVariance.isSelected();
        } else if (string.equals("calcClusterHCL")) {
            bl = this.hclOpsPanel.isHCLSelected();
        } else if (string.equals("runIterative")) {
            bl = this.runIterative.isSelected();
        } else if (string.equals("clusterGenes")) {
            bl = this.sampleSelectionPanel.isClusterGenesSelected();
        }
        return bl;
    }

    private void resetControls() {
        this.sampleSelectionPanel.setClusterGenesSelected(true);
        this.maxCyclesText.setText("10");
        this.maxTreeDiv.setText(Float.toString(this.initDiv));
        this.maxEpPerCycleText.setText("1000");
        this.stopEpochCriteria.setText("0.0001");
        this.runMaxCycles.setSelected(false);
        this.migFactor_w.setText("0.01");
        this.migFactor_p.setText("0.005");
        this.migFactor_s.setText("0.001");
        this.levelChoice.select(0);
        this.hclOpsPanel.setHCLSelected(false);
        this.useClusterDiversity.setSelected(true);
        this.pValue.setText("0.05");
    }

    private boolean validateValues() {
        float f;
        int n;
        boolean bl = true;
        try {
            n = Integer.parseInt(this.maxCyclesText.getText());
            if (n <= 0) {
                JOptionPane.showMessageDialog(this, "Input Value Error. Max cycles must be > 0.  Please try again.", "Input error", 2);
                this.maxCyclesText.requestFocus();
                this.maxCyclesText.selectAll();
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Input Format Error. " + numberFormatException.getMessage() + " is not valid.  Please try again.", "Input error", 2);
            this.maxCyclesText.requestFocus();
            this.maxCyclesText.selectAll();
            return false;
        }
        try {
            n = Integer.parseInt(this.maxEpPerCycleText.getText());
            if (n <= 0) {
                JOptionPane.showMessageDialog(this, "Input Value Error. Max epochs/cycle must be > 0.  Please try again.", "Input error", 2);
                this.maxEpPerCycleText.requestFocus();
                this.maxEpPerCycleText.selectAll();
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Input Format Error. " + numberFormatException.getMessage() + " is not valid.  Please try again.", "Input error", 2);
            this.maxEpPerCycleText.requestFocus();
            this.maxEpPerCycleText.selectAll();
            return false;
        }
        if (this.useClusterDiversity.isSelected()) {
            try {
                f = Float.parseFloat(this.maxTreeDiv.getText());
                if (f <= 0.0f) {
                    JOptionPane.showMessageDialog(this, "Input Value Error. Max Tree Diversity must be > 0.  Please try again.", "Input error", 2);
                    this.maxTreeDiv.requestFocus();
                    this.maxTreeDiv.selectAll();
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "Input Format Error. " + numberFormatException.getMessage() + " is not valid.  Please try again.", "Input error", 2);
                this.maxTreeDiv.requestFocus();
                this.maxTreeDiv.selectAll();
                return false;
            }
        }
        try {
            f = Float.parseFloat(this.stopEpochCriteria.getText());
            if (f <= 0.0f) {
                JOptionPane.showMessageDialog(this, "Input Value Error. Epoch Improvment Limit  must be > 0.  Please try again.", "Input error", 2);
                this.stopEpochCriteria.requestFocus();
                this.stopEpochCriteria.selectAll();
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Input Format Error. " + numberFormatException.getMessage() + " is not valid.  Please try again.", "Input error", 2);
            this.stopEpochCriteria.requestFocus();
            this.stopEpochCriteria.selectAll();
            return false;
        }
        try {
            f = Float.parseFloat(this.migFactor_w.getText());
            if (f <= 0.0f) {
                JOptionPane.showMessageDialog(this, "Input Value Error. Winning Cell Migration Weight must be > 0.  Please try again.", "Input error", 2);
                this.migFactor_w.requestFocus();
                this.migFactor_w.selectAll();
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Input Format Error. " + numberFormatException.getMessage() + " is not valid.  Please try again.", "Input error", 2);
            this.migFactor_w.requestFocus();
            this.migFactor_w.selectAll();
            return false;
        }
        try {
            f = Float.parseFloat(this.migFactor_p.getText());
            if (f <= 0.0f) {
                JOptionPane.showMessageDialog(this, "Input Value Error. Parent Cell Migration Weight must be > 0.  Please try again.", "Input error", 2);
                this.migFactor_p.requestFocus();
                this.migFactor_p.selectAll();
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Input Format Error. " + numberFormatException.getMessage() + " is not valid.  Please try again.", "Input error", 2);
            this.migFactor_p.requestFocus();
            this.migFactor_p.selectAll();
            return false;
        }
        try {
            f = Float.parseFloat(this.migFactor_s.getText());
            if (f <= 0.0f) {
                JOptionPane.showMessageDialog(this, "Input Value Error. Sister Cell Migration Weight must be > 0.  Please try again.", "Input error", 2);
                this.migFactor_s.requestFocus();
                this.migFactor_s.selectAll();
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Input Format Error. " + numberFormatException.getMessage() + " is not valid.  Please try again.", "Input error", 2);
            this.migFactor_s.requestFocus();
            this.migFactor_s.selectAll();
            return false;
        }
        if (this.useClusterVariance.isSelected()) {
            try {
                f = Float.parseFloat(this.pValue.getText());
                if (f <= 0.0f || (double)f >= 1.0) {
                    JOptionPane.showMessageDialog(this, "Input Value Error. Alpha Value must be > 0 and < 1.0.  Please try again.", "Input error", 2);
                    this.pValue.requestFocus();
                    this.pValue.selectAll();
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "Input Format Error. " + numberFormatException.getMessage() + " is not valid.  Please try again.", "Input error", 2);
                this.pValue.requestFocus();
                this.pValue.selectAll();
                return false;
            }
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        new SOTAInitDialog(new Frame(), 1).show();
        System.exit(0);
    }

    protected void disposeDialog() {
    }

    private class Listener
    extends DialogListener
    implements ItemListener {
        private Listener() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                if (!SOTAInitDialog.this.validateValues()) return;
                SOTAInitDialog.this.result = 0;
            } else if (string.equals("cancel-command")) {
                SOTAInitDialog.this.result = 2;
            } else {
                if (string.equals("reset-command")) {
                    SOTAInitDialog.this.result = 2;
                    SOTAInitDialog.this.resetControls();
                    return;
                }
                if (string.equals("info-command")) {
                    SOTAInitDialog.this.result = 2;
                    HelpWindow helpWindow = new HelpWindow(SOTAInitDialog.this, "SOTA Initialization Dialog");
                    if (helpWindow.getWindowContent()) {
                        helpWindow.setSize(500, 650);
                        helpWindow.setLocation();
                        helpWindow.show();
                        return;
                    }
                    helpWindow.dispose();
                    return;
                }
            }
            SOTAInitDialog.this.dispose();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (SOTAInitDialog.this.useClusterVariance.isSelected()) {
                SOTAInitDialog.this.pValue.setEnabled(true);
                SOTAInitDialog.this.maxTreeDiv.setEnabled(false);
                SOTAInitDialog.this.repaint();
            } else {
                SOTAInitDialog.this.pValue.setEnabled(false);
                SOTAInitDialog.this.maxTreeDiv.setEnabled(true);
                SOTAInitDialog.this.repaint();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            SOTAInitDialog.this.result = -1;
            SOTAInitDialog.this.dispose();
        }
    }
}

