/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.st;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Vector;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTree;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;

public class HCLSupportTree
extends HCLTree {
    private Vector geneTreeSupportVector;
    private Vector exptTreeSupportVector;

    public HCLSupportTree(HCLTreeData hCLTreeData, int n, Vector vector, Vector vector2) {
        super(hCLTreeData, n);
        this.geneTreeSupportVector = vector;
        this.exptTreeSupportVector = vector2;
    }

    public void paint(Graphics graphics) {
        int n;
        super.paintSubTree(graphics);
        if (this.treeData.node_order.length < 2) {
            return;
        }
        for (n = 0; n < this.terminalNodes.length; ++n) {
            this.terminalNodes[n] = false;
        }
        n = 1;
        if (this.orientation == 1) {
            ((Graphics2D)graphics).rotate(-1.5707963267948966);
            n = -1;
        }
        int n2 = this.pHeights[this.treeData.node_order[this.treeData.node_order.length - 2]];
        for (int i = 0; i < this.treeData.node_order.length - 1; ++i) {
            int n3 = this.treeData.node_order[i];
            int n4 = this.treeData.child_1_array[n3];
            int n5 = this.treeData.child_2_array[n3];
            int n6 = (n2 - this.pHeights[n3]) * n;
            int n7 = (n2 - this.pHeights[n4]) * n;
            int n8 = (int)(this.positions[n4] * (float)this.stepSize) + this.stepSize / 2;
            int n9 = (n2 - this.pHeights[n3]) * n;
            int n10 = (n2 - this.pHeights[n5]) * n;
            int n11 = (int)(this.positions[n5] * (float)this.stepSize) + this.stepSize / 2;
            if (this.geneTreeSupportVector != null || this.exptTreeSupportVector != null) {
                int n12 = n3 - this.treeData.node_order.length;
                Float f = null;
                try {
                    if (this.orientation == 0) {
                        if (this.geneTreeSupportVector != null) {
                            f = (Float)this.geneTreeSupportVector.get(n12);
                        }
                    } else if (this.exptTreeSupportVector != null) {
                        f = (Float)this.exptTreeSupportVector.get(n12);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (f != null) {
                    graphics.setColor(HCLSupportTree.getColorFromPercentage(f.doubleValue()));
                }
            }
            if (this.treeData.height[n3] >= this.zero_threshold) {
                this.terminalNodes[n3] = false;
                if (this.pHeights[n4] == 0) {
                    this.terminalNodes[n4] = true;
                }
                if (this.pHeights[n5] == 0) {
                    this.terminalNodes[n5] = true;
                }
            } else {
                this.terminalNodes[n3] = false;
                if (this.treeData.height[this.parentNodes[n3]] >= this.zero_threshold) {
                    this.drawWedge(graphics, n3, n6 + 10, n9 + 10, n8, n11);
                    this.terminalNodes[n3] = true;
                    this.terminalNodes[n4] = false;
                    this.terminalNodes[n5] = false;
                }
            }
            this.selectedLineColor = Color.lightGray;
            if (this.selected[n3]) {
                graphics.setColor(this.selectedLineColor);
            }
            if (this.orientation == 0) {
                graphics.drawLine(n6 + 10, n8, n7 + 10, n8);
                graphics.drawLine(n9 + 10, n11, n10 + 10, n11);
                graphics.drawLine(n6 + 10, n8, n9 + 10, n11);
                continue;
            }
            graphics.drawLine(n6, n8 + this.horizontalOffset, n7, n8 + this.horizontalOffset);
            graphics.drawLine(n9, n11 + this.horizontalOffset, n10, n11 + this.horizontalOffset);
            graphics.drawLine(n6, n8 + this.horizontalOffset, n9, n11 + this.horizontalOffset);
        }
    }

    public static JPanel getColorLegendPanel() {
        JPanel jPanel = new JPanel(){

            public void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                super.paintComponent(graphics2D);
                int n = this.getSize().width;
                int n2 = this.getSize().height;
                int n3 = n;
                int n4 = n2 / 9;
                Font font = new Font("monospaced", 0, 12);
                graphics2D.setFont(font);
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                int n5 = fontMetrics.getHeight();
                int n6 = 0;
                String string = null;
                string = "100% Support";
                graphics2D.setColor(Color.black);
                graphics2D.fillRect(0, n4 * 0, n3, n4);
                graphics2D.setColor(Color.white);
                n6 = fontMetrics.stringWidth(string);
                graphics2D.drawString(string, 0 + n3 / 2 - n6 / 2, n4 * 0 + n4 / 2 + n5 / 2);
                string = "90-100% Support";
                graphics2D.setColor(Color.darkGray);
                graphics2D.fillRect(0, n4 * 1, n3, n4);
                graphics2D.setColor(Color.white);
                n6 = fontMetrics.stringWidth(string);
                graphics2D.drawString(string, 0 + n3 / 2 - n6 / 2, n4 * 1 + n4 / 2 + n5 / 2);
                string = "80-90% Support";
                graphics2D.setColor(Color.blue);
                graphics2D.fillRect(0, n4 * 2, n3, n4);
                graphics2D.setColor(Color.white);
                n6 = fontMetrics.stringWidth(string);
                graphics2D.drawString(string, 0 + n3 / 2 - n6 / 2, n4 * 2 + n4 / 2 + n5 / 2);
                string = "70-80% Support";
                graphics2D.setColor(Color.green);
                graphics2D.fillRect(0, n4 * 3, n3, n4);
                graphics2D.setColor(Color.white);
                n6 = fontMetrics.stringWidth(string);
                graphics2D.drawString(string, 0 + n3 / 2 - n6 / 2, n4 * 3 + n4 / 2 + n5 / 2);
                string = "60-70% Support";
                graphics2D.setColor(Color.yellow);
                graphics2D.fillRect(0, n4 * 4, n3, n4);
                graphics2D.setColor(Color.white);
                n6 = fontMetrics.stringWidth(string);
                graphics2D.drawString(string, 0 + n3 / 2 - n6 / 2, n4 * 4 + n4 / 2 + n5 / 2);
                string = "50-60% Support";
                graphics2D.setColor(Color.orange);
                graphics2D.fillRect(0, n4 * 5, n3, n4);
                graphics2D.setColor(Color.white);
                n6 = fontMetrics.stringWidth(string);
                graphics2D.drawString(string, 0 + n3 / 2 - n6 / 2, n4 * 5 + n4 / 2 + n5 / 2);
                string = "0-50% Support";
                graphics2D.setColor(Color.magenta);
                graphics2D.fillRect(0, n4 * 6, n3, n4);
                graphics2D.setColor(Color.white);
                n6 = fontMetrics.stringWidth(string);
                graphics2D.drawString(string, 0 + n3 / 2 - n6 / 2, n4 * 6 + n4 / 2 + n5 / 2);
                string = "0% Support";
                graphics2D.setColor(Color.red);
                graphics2D.fillRect(0, n4 * 7, n3, n4);
                graphics2D.setColor(Color.white);
                n6 = fontMetrics.stringWidth(string);
                graphics2D.drawString(string, 0 + n3 / 2 - n6 / 2, n4 * 7 + n4 / 2 + n5 / 2);
                string = "Unrecovered Node";
                graphics2D.setColor(Color.pink);
                graphics2D.fillRect(0, n4 * 8, n3, n4);
                graphics2D.setColor(Color.white);
                n6 = fontMetrics.stringWidth(string);
                graphics2D.drawString(string, 0 + n3 / 2 - n6 / 2, n4 * 8 + n4 / 2 + n5 / 2);
            }
        };
        return jPanel;
    }

    public static Color getColorFromPercentage(double d) {
        if (d > 100.0) {
            return Color.gray;
        }
        if (d == 100.0) {
            return Color.black;
        }
        if (d < 100.0 && d >= 90.0) {
            return Color.darkGray;
        }
        if (d < 90.0 && d >= 80.0) {
            return Color.blue;
        }
        if (d < 80.0 && d >= 70.0) {
            return Color.green;
        }
        if (d < 70.0 && d >= 60.0) {
            return Color.yellow;
        }
        if (d < 60.0 && d >= 50.0) {
            return Color.orange;
        }
        if (d < 50.0 && d > 0.0) {
            return Color.magenta;
        }
        if (d == 0.0) {
            return Color.red;
        }
        return Color.pink;
    }
}

