/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.st;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.util.awt.GBA;

public class ResampleTreeInitDialog
extends AlgorithmDialog {
    protected GBA gba;
    protected EventListener eventListener;
    protected JPanel geneTreePanel;
    public JCheckBox drawGeneTreeCheckBox;
    protected JPanel geneTreeResamplingOptionsPanel;
    protected JRadioButton geneBootstrapGenes;
    protected JRadioButton geneBootstrapExpts;
    protected JRadioButton geneJackknifeGenes;
    protected JRadioButton geneJackknifeExpts;
    protected JRadioButton geneStandard;
    protected JPanel geneTreeIterationsPanel;
    protected JLabel geneTreeIterationsLabel;
    public JTextField geneTreeIterationsTextField;
    protected JPanel exptTreePanel;
    public JCheckBox drawExptTreeCheckBox;
    protected JPanel exptTreeResamplingOptionsPanel;
    protected JRadioButton exptBootstrapGenes;
    protected JRadioButton exptBootstrapExpts;
    protected JRadioButton exptJackknifeGenes;
    protected JRadioButton exptJackknifeExpts;
    protected JRadioButton exptStandard;
    protected JPanel exptTreeIterationsPanel;
    protected JLabel exptTreeIterationsLabel;
    public JTextField exptTreeIterationsTextField;
    protected JPanel linkagePanel;
    protected JRadioButton averageLinkage;
    protected JRadioButton completeLinkage;
    protected JRadioButton singleLinkage;
    protected JPanel topPanel;
    protected JPanel bottomPanel;
    protected ButtonGroup buttonGroup;
    protected int linkageStyle = 0;
    protected int geneTreeAnalysisOption = 0;
    protected int exptTreeAnalysisOption = 0;
    protected boolean cancelled = true;
    protected Color labelColor;
    public static final int NONE = 0;
    public static final int BOOT_EXPTS = 1;
    public static final int BOOT_GENES = 2;
    public static final int JACK_EXPTS = 3;
    public static final int JACK_GENES = 4;

    public ResampleTreeInitDialog(JFrame jFrame, boolean bl) {
        super(jFrame, "ST: Support Trees", bl);
        this.initialize();
    }

    protected void initialize() {
        this.gba = new GBA();
        this.labelColor = UIManager.getColor("Label.foreground");
        this.eventListener = new EventListener();
        this.drawGeneTreeCheckBox = new JCheckBox("Draw Gene Tree", true);
        this.drawGeneTreeCheckBox.setFocusPainted(false);
        this.drawGeneTreeCheckBox.setBackground(Color.white);
        this.drawGeneTreeCheckBox.setForeground(this.labelColor);
        this.buttonGroup = new ButtonGroup();
        this.geneBootstrapGenes = new JRadioButton("Bootstrap Genes");
        this.geneBootstrapGenes.setFocusPainted(false);
        this.geneBootstrapGenes.setBackground(Color.white);
        this.geneBootstrapGenes.setForeground(this.labelColor);
        this.buttonGroup.add(this.geneBootstrapGenes);
        this.geneBootstrapExpts = new JRadioButton("Bootstrap Experiments");
        this.geneBootstrapExpts.setFocusPainted(false);
        this.geneBootstrapExpts.setBackground(Color.white);
        this.geneBootstrapExpts.setForeground(this.labelColor);
        this.buttonGroup.add(this.geneBootstrapExpts);
        this.geneJackknifeGenes = new JRadioButton("Jackknife Genes");
        this.geneJackknifeGenes.setFocusPainted(false);
        this.geneJackknifeGenes.setBackground(Color.white);
        this.geneJackknifeGenes.setForeground(this.labelColor);
        this.buttonGroup.add(this.geneJackknifeGenes);
        this.geneJackknifeExpts = new JRadioButton("Jackknife Experiments");
        this.geneJackknifeExpts.setFocusPainted(false);
        this.geneJackknifeExpts.setBackground(Color.white);
        this.geneJackknifeExpts.setForeground(this.labelColor);
        this.buttonGroup.add(this.geneJackknifeExpts);
        this.geneStandard = new JRadioButton("No resampling", true);
        this.geneStandard.setFocusPainted(false);
        this.geneStandard.setBackground(Color.white);
        this.geneStandard.setForeground(this.labelColor);
        this.buttonGroup.add(this.geneStandard);
        this.geneTreeIterationsLabel = new JLabel("Iterations");
        this.geneTreeIterationsTextField = new JTextField("100");
        this.geneTreeIterationsPanel = new JPanel();
        this.geneTreeIterationsPanel.setLayout(new GridBagLayout());
        this.geneTreeIterationsPanel.setBackground(Color.white);
        this.gba.add(this.geneTreeIterationsPanel, this.geneTreeIterationsLabel, 0, 0, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.geneTreeIterationsPanel, this.geneTreeIterationsTextField, 1, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.geneTreeResamplingOptionsPanel = new JPanel();
        this.geneTreeResamplingOptionsPanel.setLayout(new GridBagLayout());
        this.geneTreeResamplingOptionsPanel.setBackground(Color.white);
        this.geneTreeResamplingOptionsPanel.setBorder(new TitledBorder(new EtchedBorder(), "Resampling Options", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.gba.add(this.geneTreeResamplingOptionsPanel, this.geneBootstrapGenes, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.geneTreeResamplingOptionsPanel, this.geneBootstrapExpts, 0, 1, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.geneTreeResamplingOptionsPanel, this.geneJackknifeGenes, 0, 2, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.geneTreeResamplingOptionsPanel, this.geneJackknifeExpts, 0, 3, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.geneTreeResamplingOptionsPanel, this.geneStandard, 0, 4, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.geneTreePanel = new JPanel();
        this.geneTreePanel.setLayout(new GridBagLayout());
        this.geneTreePanel.setBackground(Color.white);
        this.geneTreePanel.setBorder(new TitledBorder(new EtchedBorder(), "Gene Tree", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.gba.add(this.geneTreePanel, this.drawGeneTreeCheckBox, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.geneTreePanel, this.geneTreeResamplingOptionsPanel, 0, 1, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.geneTreePanel, this.geneTreeIterationsPanel, 0, 2, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.drawExptTreeCheckBox = new JCheckBox("Draw Experiment Tree", true);
        this.drawExptTreeCheckBox.setFocusPainted(false);
        this.drawExptTreeCheckBox.setBackground(Color.white);
        this.drawExptTreeCheckBox.setForeground(this.labelColor);
        this.buttonGroup = new ButtonGroup();
        this.exptBootstrapGenes = new JRadioButton("Bootstrap Genes");
        this.exptBootstrapGenes.setFocusPainted(false);
        this.exptBootstrapGenes.setBackground(Color.white);
        this.exptBootstrapGenes.setForeground(this.labelColor);
        this.buttonGroup.add(this.exptBootstrapGenes);
        this.exptBootstrapExpts = new JRadioButton("Bootstrap Experiments");
        this.exptBootstrapExpts.setFocusPainted(false);
        this.exptBootstrapExpts.setBackground(Color.white);
        this.exptBootstrapExpts.setForeground(this.labelColor);
        this.buttonGroup.add(this.exptBootstrapExpts);
        this.exptJackknifeGenes = new JRadioButton("Jackknife Genes");
        this.exptJackknifeGenes.setFocusPainted(false);
        this.exptJackknifeGenes.setBackground(Color.white);
        this.exptJackknifeGenes.setForeground(this.labelColor);
        this.buttonGroup.add(this.exptJackknifeGenes);
        this.exptJackknifeExpts = new JRadioButton("Jackknife Experiments");
        this.exptJackknifeExpts.setFocusPainted(false);
        this.exptJackknifeExpts.setBackground(Color.white);
        this.exptJackknifeExpts.setForeground(this.labelColor);
        this.buttonGroup.add(this.exptJackknifeExpts);
        this.exptStandard = new JRadioButton("No resampling", true);
        this.exptStandard.setFocusPainted(false);
        this.exptStandard.setBackground(Color.white);
        this.exptStandard.setForeground(this.labelColor);
        this.buttonGroup.add(this.exptStandard);
        this.exptTreeIterationsLabel = new JLabel("Iterations");
        this.exptTreeIterationsTextField = new JTextField("100");
        this.exptTreeIterationsPanel = new JPanel();
        this.exptTreeIterationsPanel.setLayout(new GridBagLayout());
        this.exptTreeIterationsPanel.setBackground(Color.white);
        this.gba.add(this.exptTreeIterationsPanel, this.exptTreeIterationsLabel, 0, 0, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.exptTreeIterationsPanel, this.exptTreeIterationsTextField, 1, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.exptTreeResamplingOptionsPanel = new JPanel();
        this.exptTreeResamplingOptionsPanel.setLayout(new GridBagLayout());
        this.exptTreeResamplingOptionsPanel.setBackground(Color.white);
        this.exptTreeResamplingOptionsPanel.setBorder(new TitledBorder(new EtchedBorder(), "Resampling Options", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.gba.add(this.exptTreeResamplingOptionsPanel, this.exptBootstrapGenes, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.exptTreeResamplingOptionsPanel, this.exptBootstrapExpts, 0, 1, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.exptTreeResamplingOptionsPanel, this.exptJackknifeGenes, 0, 2, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.exptTreeResamplingOptionsPanel, this.exptJackknifeExpts, 0, 3, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.exptTreeResamplingOptionsPanel, this.exptStandard, 0, 4, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.exptTreePanel = new JPanel();
        this.exptTreePanel.setLayout(new GridBagLayout());
        this.exptTreePanel.setBackground(Color.white);
        this.exptTreePanel.setBorder(new TitledBorder(new EtchedBorder(), "Experiment Tree", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.gba.add(this.exptTreePanel, this.drawExptTreeCheckBox, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.exptTreePanel, this.exptTreeResamplingOptionsPanel, 0, 1, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.exptTreePanel, this.exptTreeIterationsPanel, 0, 2, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new GridBagLayout());
        this.topPanel.setBackground(Color.white);
        this.gba.add(this.topPanel, this.geneTreePanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.topPanel, this.exptTreePanel, 1, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.buttonGroup = new ButtonGroup();
        this.averageLinkage = new JRadioButton("Average Linkage", true);
        this.averageLinkage.setFocusPainted(false);
        this.averageLinkage.setBackground(Color.white);
        this.averageLinkage.setForeground(this.labelColor);
        this.buttonGroup.add(this.averageLinkage);
        this.completeLinkage = new JRadioButton("Complete Linkage", false);
        this.completeLinkage.setFocusPainted(false);
        this.completeLinkage.setBackground(Color.white);
        this.completeLinkage.setForeground(this.labelColor);
        this.buttonGroup.add(this.completeLinkage);
        this.singleLinkage = new JRadioButton("Single Linkage", false);
        this.singleLinkage.setFocusPainted(false);
        this.singleLinkage.setBackground(Color.white);
        this.singleLinkage.setForeground(this.labelColor);
        this.buttonGroup.add(this.singleLinkage);
        this.linkagePanel = new JPanel();
        this.linkagePanel.setLayout(new GridBagLayout());
        this.linkagePanel.setBackground(Color.white);
        this.linkagePanel.setBorder(new TitledBorder(new EtchedBorder(), "Linkage Method", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.gba.add(this.linkagePanel, this.averageLinkage, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.linkagePanel, this.completeLinkage, 1, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.linkagePanel, this.singleLinkage, 2, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new GridBagLayout());
        this.bottomPanel.setBackground(Color.white);
        this.gba.add(this.bottomPanel, this.linkagePanel, 0, 0, 2, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBackground(Color.white);
        this.gba.add(jPanel, this.topPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(jPanel, this.bottomPanel, 0, 1, 1, 1, 1, 1, 1, 10, new Insets(0, 5, 5, 5), 0, 0);
        this.addContent(jPanel);
        this.setActionListeners(this.eventListener);
        this.pack();
        this.setResizable(false);
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.setVisible(bl);
        if (bl) {
            // empty if block
        }
    }

    public int getMethod() {
        return this.linkageStyle;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public int getGeneTreeAnalysisOption() {
        return this.geneTreeAnalysisOption;
    }

    public int getExptTreeAnalysisOption() {
        return this.exptTreeAnalysisOption;
    }

    protected void fireOkButtonEvent() {
        boolean bl = this.drawGeneTreeCheckBox.isSelected();
        int n = Integer.parseInt(this.geneTreeIterationsTextField.getText());
        boolean bl2 = this.drawExptTreeCheckBox.isSelected();
        int n2 = Integer.parseInt(this.exptTreeIterationsTextField.getText());
        this.geneTreeAnalysisOption = this.geneBootstrapGenes.isSelected() ? 2 : (this.geneBootstrapExpts.isSelected() ? 1 : (this.geneJackknifeGenes.isSelected() ? 4 : (this.geneJackknifeExpts.isSelected() ? 3 : 0)));
        this.exptTreeAnalysisOption = this.exptBootstrapGenes.isSelected() ? 2 : (this.exptBootstrapExpts.isSelected() ? 1 : (this.exptJackknifeGenes.isSelected() ? 4 : (this.exptJackknifeExpts.isSelected() ? 3 : 0)));
        this.linkageStyle = this.completeLinkage.isSelected() ? 1 : (this.singleLinkage.isSelected() ? -1 : 0);
    }

    private void resetControls() {
        this.drawGeneTreeCheckBox.setSelected(true);
        this.drawExptTreeCheckBox.setSelected(true);
        this.geneStandard.setSelected(true);
        this.exptStandard.setSelected(true);
        this.averageLinkage.setSelected(true);
        this.geneTreeIterationsTextField.setText("100");
        this.exptTreeIterationsTextField.setText("100");
    }

    public static void main(String[] stringArray) {
        ResampleTreeInitDialog resampleTreeInitDialog = new ResampleTreeInitDialog(new JFrame(), true);
        resampleTreeInitDialog.show();
        System.exit(0);
    }

    protected class EventListener
    implements ActionListener {
        protected EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                if (ResampleTreeInitDialog.this.drawExptTreeCheckBox.isSelected()) {
                    try {
                        int n = Integer.parseInt(ResampleTreeInitDialog.this.exptTreeIterationsTextField.getText());
                        if (n < 1) {
                            ResampleTreeInitDialog.this.exptTreeIterationsTextField.requestFocus();
                            ResampleTreeInitDialog.this.exptTreeIterationsTextField.selectAll();
                            JOptionPane.showMessageDialog(ResampleTreeInitDialog.this, "Number of iterations must be > 0", "Error", 0);
                            return;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        ResampleTreeInitDialog.this.exptTreeIterationsTextField.requestFocus();
                        ResampleTreeInitDialog.this.exptTreeIterationsTextField.selectAll();
                        JOptionPane.showMessageDialog(ResampleTreeInitDialog.this, "Entry format error.", "Error", 0);
                        return;
                    }
                }
                if (ResampleTreeInitDialog.this.drawGeneTreeCheckBox.isSelected()) {
                    try {
                        int n = Integer.parseInt(ResampleTreeInitDialog.this.geneTreeIterationsTextField.getText());
                        if (n < 1) {
                            ResampleTreeInitDialog.this.geneTreeIterationsTextField.requestFocus();
                            ResampleTreeInitDialog.this.geneTreeIterationsTextField.selectAll();
                            JOptionPane.showMessageDialog(ResampleTreeInitDialog.this, "Number of iterations must be > 0", "Error", 0);
                            return;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        ResampleTreeInitDialog.this.geneTreeIterationsTextField.requestFocus();
                        ResampleTreeInitDialog.this.geneTreeIterationsTextField.selectAll();
                        JOptionPane.showMessageDialog(ResampleTreeInitDialog.this, "Entry format error.", "Error", 0);
                        return;
                    }
                }
                ResampleTreeInitDialog.this.fireOkButtonEvent();
                ResampleTreeInitDialog.this.cancelled = false;
            } else if (string.equals("cancel-command")) {
                ResampleTreeInitDialog.this.cancelled = true;
            } else {
                if (string.equals("reset-command")) {
                    ResampleTreeInitDialog.this.resetControls();
                    ResampleTreeInitDialog.this.cancelled = false;
                    return;
                }
                if (string.equals("info-command")) {
                    HelpWindow helpWindow = new HelpWindow(ResampleTreeInitDialog.this, "ST Initialization Dialog");
                    ResampleTreeInitDialog.this.cancelled = false;
                    if (helpWindow.getWindowContent()) {
                        helpWindow.setSize(450, 650);
                        helpWindow.setLocation();
                        helpWindow.show();
                        return;
                    }
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                    return;
                }
            }
            ResampleTreeInitDialog.this.dispose();
        }
    }
}

