/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.svm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMSearchDialog;

public class SVMClassificationEditor
extends JFrame {
    IFramework framework;
    IData data;
    Experiment experiment;
    String[] fieldNames;
    File currentFile;
    SVMSearchDialog searchDialog;
    SortListener sorter;
    SVMTableModel svmTableModel;
    boolean classifyGenes;
    boolean cancelForm = false;
    private JMenuBar jMenuBar2;
    private JMenu fileMenu;
    private JMenuItem saveMenuItem;
    private JMenuItem saveAsMenuItem;
    private JSeparator jSeparator2;
    private JMenuItem closeMenuItem;
    private JMenu editMenu;
    private JMenuItem svcApplyMenuItem;
    private JMenuItem storedClusterMenuItem;
    private JMenuItem tcListMenuItem;
    private JSeparator jSeparator3;
    private JMenuItem selectAllMenuItem;
    private JMenu toolsMenu;
    private JMenuItem searchMenuItem;
    private JMenu sortByMenu;
    private JMenuItem indexSortMenuItem;
    private JMenuItem classSortMenuItem;
    private JToolBar jToolBar1;
    private JButton inClassButton;
    private JButton outClassButton;
    private JButton neutralButton;
    private JButton searchButton;
    private JButton runButton;
    private JScrollPane jScrollPane1;
    private JTable table;

    public SVMClassificationEditor(IFramework iFramework, boolean bl) {
        this.classifyGenes = bl;
        this.initComponents();
        this.editMenu.remove(2);
        this.editMenu.remove(1);
        this.editMenu.validate();
        this.inClassButton.setIcon(GUIFactory.getIcon("in_class.gif"));
        this.outClassButton.setIcon(GUIFactory.getIcon("out_class.gif"));
        this.neutralButton.setIcon(GUIFactory.getIcon("neutral_class.gif"));
        this.searchButton.setIcon(GUIFactory.getIcon("search.gif"));
        this.runButton.setIcon(GUIFactory.getIcon("go.gif"));
        this.svcApplyMenuItem.setIcon(GUIFactory.getIcon("svcfileicon.gif"));
        this.saveAsMenuItem.setIcon(GUIFactory.getIcon("svcfileicon.gif"));
        this.tcListMenuItem.setIcon(null);
        this.currentFile = null;
        this.framework = iFramework;
        this.data = this.framework.getData();
        this.experiment = this.data.getExperiment();
        this.table.setAutoResizeMode(0);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        this.jScrollPane1.setBackground(Color.black);
        this.loadTable();
        this.searchDialog = new SVMSearchDialog((Frame)this, this.table, false);
        this.sorter = new SortListener(this.svmTableModel);
        this.indexSortMenuItem.addActionListener(this.sorter);
        this.classSortMenuItem.addActionListener(this.sorter);
        for (int i = 0; i < this.fieldNames.length; ++i) {
            JMenuItem jMenuItem = new JMenuItem(this.fieldNames[i]);
            jMenuItem.addActionListener(this.sorter);
            this.sortByMenu.add(jMenuItem);
        }
    }

    private void loadTable() {
        int n;
        if (this.data == null) {
            return;
        }
        int n2 = this.data.getFeaturesSize();
        int n3 = this.data.getFeaturesCount();
        if (this.classifyGenes) {
            this.fieldNames = this.data.getFieldNames();
        } else {
            this.fieldNames = new String[1];
            this.fieldNames[0] = "Sample/Experiment Name";
        }
        Object[] objectArray = new String[this.fieldNames.length + 4];
        objectArray[0] = "Index";
        objectArray[1] = "In Class";
        objectArray[2] = "Out of Class";
        objectArray[3] = "Neutral";
        for (int i = 4; i < this.fieldNames.length + 4; ++i) {
            objectArray[i] = this.fieldNames[i - 4];
        }
        DefaultTableModel defaultTableModel = this.classifyGenes ? new DefaultTableModel(new Object[n2][this.fieldNames.length + 4], objectArray) : new DefaultTableModel(new Object[n3][this.fieldNames.length + 4], objectArray);
        this.svmTableModel = new SVMTableModel((String[])objectArray, defaultTableModel);
        this.table.setModel(this.svmTableModel);
        if (this.classifyGenes) {
            for (n = 0; n < n2; ++n) {
                this.table.setValueAt(new Integer(n), n, 0);
                this.table.setValueAt(new Boolean(false), n, 1);
                this.table.setValueAt(new Boolean(true), n, 2);
                this.table.setValueAt(new Boolean(false), n, 3);
                for (int i = 4; i < objectArray.length; ++i) {
                    String string = this.data.getElementAttribute(n, i - 4);
                    this.table.setValueAt(string, n, i);
                }
            }
        } else {
            for (n = 0; n < n3; ++n) {
                this.table.setValueAt(new Integer(n), n, 0);
                this.table.setValueAt(new Boolean(false), n, 1);
                this.table.setValueAt(new Boolean(true), n, 2);
                this.table.setValueAt(new Boolean(false), n, 3);
                this.table.setValueAt(this.data.getFullSampleName(n), n, 4);
            }
        }
        n = 75;
        TableColumn tableColumn = this.table.getColumn("In Class");
        this.setWidth(tableColumn, n, true);
        tableColumn = this.table.getColumn("Out of Class");
        this.setWidth(tableColumn, n, true);
        tableColumn = this.table.getColumn("Neutral");
        this.setWidth(tableColumn, n, true);
        tableColumn = this.table.getColumn("Index");
        n = this.getIndexColumnWidth();
        this.setWidth(tableColumn, n, true);
        for (int i = 0; i < this.fieldNames.length; ++i) {
            tableColumn = this.table.getColumn(this.fieldNames[i]);
            n = this.getColumnTextWidth(i + 4);
            n = Math.min(n, 300);
            this.setWidth(tableColumn, n, false);
        }
        this.table.getModel().addTableModelListener(new ClassSelectionListener());
        this.table.setColumnModel(new SVMTableColumnModel(this.table.getColumnModel()));
    }

    private int getColumnTextWidth(int n) {
        Graphics graphics = this.table.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.stringWidth(this.table.getColumnName(n));
        int n3 = this.table.getRowCount();
        for (int i = 0; i < n3; ++i) {
            if (fontMetrics.stringWidth((String)this.table.getValueAt(i, n)) <= n2) continue;
            n2 = fontMetrics.stringWidth((String)this.table.getValueAt(i, n));
        }
        return n2 + 10;
    }

    private int getIndexColumnWidth() {
        Graphics graphics = this.table.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth("Index");
        int n2 = this.table.getRowCount();
        for (int i = 0; i < n2; ++i) {
            if (fontMetrics.stringWidth(((Integer)this.table.getValueAt(i, 0)).toString()) <= n) continue;
            n = fontMetrics.stringWidth((String)this.table.getValueAt(i, 0));
        }
        return n + 10;
    }

    private void setWidth(TableColumn tableColumn, int n, boolean bl) {
        tableColumn.setWidth(n);
        tableColumn.setPreferredWidth(n);
        if (bl) {
            tableColumn.setMaxWidth(n);
            tableColumn.setMinWidth(n);
        }
    }

    private void applySVCFile() {
        File file = null;
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.setCurrentDirectory(new File("Data/SVM"));
        jFileChooser.setFileFilter(new SVCFileFilter());
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
        }
        this.readAndApplyFile(file);
    }

    private void readAndApplyFile(File file) {
        if (file == null) {
            return;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = new String();
            boolean bl = false;
            Vector<String> vector = new Vector<String>();
            bufferedReader.readLine();
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
                if (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                }
                if (!stringTokenizer.hasMoreElements()) continue;
                vector.add(stringTokenizer.nextToken());
            }
            if (vector.size() != this.table.getRowCount()) {
                if (this.classifyGenes) {
                    JOptionPane.showMessageDialog(this.framework.getFrame(), "Number of classification indices provided does not match the number of genes in the data set!", "Classification Input Error", 0);
                } else {
                    JOptionPane.showMessageDialog(this.framework.getFrame(), "Number of classification indices provided does not match the number of experiments in the data set!", "Classification Input Error", 0);
                }
                return;
            }
            this.applyClassArrayToTable(vector);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "Classification file not found.", "Classification Input Error", 0);
            return;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "File Input Error, please check format.", "Classification Input Error", 0);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "File Input Error, please check number format format.", "Classification Input Error", 0);
            return;
        }
    }

    public void applyClassArrayToTable(Vector vector) throws NumberFormatException {
        if (vector == null) {
            return;
        }
        this.svmTableModel.sort(0);
        int n = vector.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (((Boolean)this.table.getValueAt(i, 1)).booleanValue()) continue;
            n2 = Integer.parseInt((String)vector.elementAt(i));
            if (n2 == 1) {
                this.table.setValueAt(new Boolean(true), i, 1);
                continue;
            }
            if (n2 == -1) {
                this.table.setValueAt(new Boolean(true), i, 2);
                continue;
            }
            this.table.setValueAt(new Boolean(true), i, 3);
        }
    }

    private void applyStoredCluster() {
    }

    private void sortBy(int n) {
    }

    private void setClassificationForRange(int n, int n2, int n3) {
        for (int i = n; i <= n2; ++i) {
            this.table.setValueAt(new Boolean(true), i, n3);
        }
        this.table.repaint();
    }

    private void setClassificationForSet(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            this.table.setValueAt(new Boolean(true), nArray[i], n);
        }
        this.table.repaint();
    }

    private void saveTableAsSVC() throws IOException {
        int n;
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.addChoosableFileFilter(new SVCFileFilter());
        jFileChooser.setFileView(new SVCFileView());
        jFileChooser.setCurrentDirectory(new File("Data/SVM"));
        if (this.currentFile != null) {
            jFileChooser.setSelectedFile(this.currentFile);
        }
        if ((n = jFileChooser.showSaveDialog(this)) == 1) {
            return;
        }
        this.currentFile = jFileChooser.getSelectedFile();
        this.writeToFile(this.currentFile);
        this.saveMenuItem.setEnabled(true);
    }

    private void writeToFile(File file) throws IOException {
        int n;
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        PrintWriter printWriter = new PrintWriter(bufferedWriter);
        String string = "\t";
        int n2 = this.table.getRowCount();
        printWriter.print("Index" + string + "Classification" + string);
        for (n = 0; n < this.fieldNames.length; ++n) {
            printWriter.print(this.fieldNames[n] + string);
        }
        printWriter.print("\n");
        for (n = 0; n < n2; ++n) {
            printWriter.print(this.table.getValueAt(n, 0) + string + this.getClassificationString(n) + string);
            String string2 = this.getRowAnnotationString(n);
            if (!string2.equals("")) {
                printWriter.print(string2);
            }
            printWriter.print("\n");
        }
        printWriter.close();
        bufferedWriter.close();
    }

    private void saveTableToCurrentSVC() throws IOException {
        if (this.currentFile != null) {
            this.writeToFile(this.currentFile);
        }
    }

    private String getClassificationString(int n) {
        if (((Boolean)this.table.getValueAt(n, 2)).booleanValue()) {
            return "-1";
        }
        if (((Boolean)this.table.getValueAt(n, 1)).booleanValue()) {
            return "1";
        }
        return "0";
    }

    private String getRowAnnotationString(int n) {
        String string = new String("");
        int n2 = this.table.getColumnCount();
        String string2 = "\t";
        for (int i = 4; i < n2; ++i) {
            string = string + (String)this.table.getValueAt(n, i);
            string = string + string2;
        }
        return string;
    }

    private void searchTable() {
        this.searchDialog.setVisible(true);
        this.searchDialog.toFront();
        this.searchDialog.setLocation(this.getLocation().x + 100, this.getLocation().y + 100);
    }

    public int[] getClassification() {
        if (this.classifyGenes) {
            return this.getGeneClassification();
        }
        return this.getSampleClassification();
    }

    private int[] getGeneClassification() {
        this.svmTableModel.sort(0);
        int n = this.experiment.getNumberOfGenes();
        int n2 = this.table.getRowCount();
        int n3 = 0;
        int[] nArray = new int[n];
        int n4 = this.experiment.getGeneIndexMappedToData(n3);
        for (int i = 0; i < n2; ++i) {
            if (n4 != i) continue;
            nArray[n3] = (Boolean)this.table.getValueAt(i, 1) != false ? 1 : ((Boolean)this.table.getValueAt(i, 2) != false ? -1 : 0);
            n4 = this.experiment.getGeneIndexMappedToData(++n3);
        }
        return nArray;
    }

    private int[] getSampleClassification() {
        this.svmTableModel.sort(0);
        int n = this.table.getRowCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (Boolean)this.table.getValueAt(i, 1) != false ? 1 : ((Boolean)this.table.getValueAt(i, 2) != false ? -1 : -1);
        }
        return nArray;
    }

    public boolean formCanceled() {
        return this.cancelForm;
    }

    private void initComponents() {
        this.jMenuBar2 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.closeMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.svcApplyMenuItem = new JMenuItem();
        this.storedClusterMenuItem = new JMenuItem();
        this.tcListMenuItem = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.selectAllMenuItem = new JMenuItem();
        this.toolsMenu = new JMenu();
        this.searchMenuItem = new JMenuItem();
        this.sortByMenu = new JMenu();
        this.indexSortMenuItem = new JMenuItem();
        this.classSortMenuItem = new JMenuItem();
        this.jToolBar1 = new JToolBar();
        this.inClassButton = new JButton();
        this.outClassButton = new JButton();
        this.neutralButton = new JButton();
        this.searchButton = new JButton();
        this.runButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.fileMenu.setMnemonic(70);
        this.fileMenu.setText("File");
        this.fileMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVMClassificationEditor.this.fileMenuActionPerformed(actionEvent);
            }
        });
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveMenuItem.setText("Save");
        this.saveMenuItem.setEnabled(false);
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVMClassificationEditor.this.saveMenuItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setText("Save as...");
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVMClassificationEditor.this.saveAsMenuItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.saveAsMenuItem);
        this.fileMenu.add(this.jSeparator2);
        this.closeMenuItem.setToolTipText("Applies current classification");
        this.closeMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.closeMenuItem.setText("Run");
        this.closeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVMClassificationEditor.this.closeMenuItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.closeMenuItem);
        this.jMenuBar2.add(this.fileMenu);
        this.editMenu.setMnemonic(69);
        this.editMenu.setText("Edit");
        this.svcApplyMenuItem.setText("Apply SVC File");
        this.svcApplyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVMClassificationEditor.this.svcApplyMenuItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.svcApplyMenuItem);
        this.storedClusterMenuItem.setText("Apply Stored Cluster");
        this.storedClusterMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVMClassificationEditor.this.storedClusterMenuItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.storedClusterMenuItem);
        this.tcListMenuItem.setText("Apply Gene Index List");
        this.tcListMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVMClassificationEditor.this.tcListMenuItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.tcListMenuItem);
        this.editMenu.add(this.jSeparator3);
        this.selectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.selectAllMenuItem.setText("Select All");
        this.selectAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVMClassificationEditor.this.selectAllMenuItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.selectAllMenuItem);
        this.jMenuBar2.add(this.editMenu);
        this.toolsMenu.setMnemonic(84);
        this.toolsMenu.setText("Tools");
        this.searchMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.searchMenuItem.setText("Search ");
        this.searchMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVMClassificationEditor.this.searchMenuItemActionPerformed(actionEvent);
            }
        });
        this.toolsMenu.add(this.searchMenuItem);
        this.sortByMenu.setText("Sort by...");
        this.indexSortMenuItem.setText("index");
        this.indexSortMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVMClassificationEditor.this.indexSortMenuItemActionPerformed(actionEvent);
            }
        });
        this.sortByMenu.add(this.indexSortMenuItem);
        this.classSortMenuItem.setToolTipText("in->out->neutral");
        this.classSortMenuItem.setText("classification");
        this.classSortMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVMClassificationEditor.this.classSortMenuItemActionPerformed(actionEvent);
            }
        });
        this.sortByMenu.add(this.classSortMenuItem);
        this.toolsMenu.add(this.sortByMenu);
        this.jMenuBar2.add(this.toolsMenu);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("SVM Classification Editor");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SVMClassificationEditor.this.exitForm(windowEvent);
            }
        });
        this.jToolBar1.setPreferredSize(new Dimension(18, 35));
        this.jToolBar1.setMinimumSize(new Dimension(18, 35));
        this.jToolBar1.setAlignmentX(0.0f);
        this.jToolBar1.setMaximumSize(new Dimension(18, 50));
        this.inClassButton.setToolTipText(" move into class");
        this.inClassButton.setPreferredSize(new Dimension(32, 32));
        this.inClassButton.setMaximumSize(new Dimension(32, 32));
        this.inClassButton.setMinimumSize(new Dimension(32, 32));
        this.inClassButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVMClassificationEditor.this.inClassButtonActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.inClassButton);
        this.outClassButton.setToolTipText("move out of class");
        this.outClassButton.setPreferredSize(new Dimension(32, 32));
        this.outClassButton.setMaximumSize(new Dimension(32, 32));
        this.outClassButton.setMinimumSize(new Dimension(32, 32));
        this.outClassButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVMClassificationEditor.this.outClassButtonActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.outClassButton);
        this.neutralButton.setToolTipText("move to neutal status");
        this.neutralButton.setPreferredSize(new Dimension(32, 32));
        this.neutralButton.setMaximumSize(new Dimension(32, 32));
        this.neutralButton.setMinimumSize(new Dimension(32, 32));
        this.neutralButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVMClassificationEditor.this.neutralButtonActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.neutralButton);
        this.searchButton.setToolTipText("search (Ctrl - s)");
        this.searchButton.setPreferredSize(new Dimension(32, 32));
        this.searchButton.setMaximumSize(new Dimension(32, 32));
        this.searchButton.setMinimumSize(new Dimension(32, 32));
        this.jToolBar1.addSeparator(new Dimension(20, 32));
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVMClassificationEditor.this.searchButtonActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.searchButton);
        this.runButton.setToolTipText("Run SVM on current classification...");
        this.runButton.setPreferredSize(new Dimension(32, 32));
        this.runButton.setMaximumSize(new Dimension(32, 32));
        this.runButton.setMinimumSize(new Dimension(32, 32));
        this.jToolBar1.addSeparator(new Dimension(20, 32));
        this.runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVMClassificationEditor.this.runButtonActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.runButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jToolBar1, gridBagConstraints);
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[]{"Index", "In Class", "Out of Class", "Neutral", "UID (Spot_ID)", "Gene Name"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, Object.class, Object.class, Object.class, Object.class, Object.class};
                this.canEdit = new boolean[]{false, true, true, true, false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.setJMenuBar(this.jMenuBar2);
        this.pack();
    }

    private void runButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private void classSortMenuItemActionPerformed(ActionEvent actionEvent) {
    }

    private void selectAllMenuItemActionPerformed(ActionEvent actionEvent) {
        this.table.selectAll();
    }

    private void indexSortMenuItemActionPerformed(ActionEvent actionEvent) {
    }

    private void svcApplyMenuItemActionPerformed(ActionEvent actionEvent) {
        this.applySVCFile();
    }

    private void tcListMenuItemActionPerformed(ActionEvent actionEvent) {
    }

    private void searchButtonActionPerformed(ActionEvent actionEvent) {
        this.searchTable();
    }

    private void hideOutClassCheckBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void searchMenuItemActionPerformed(ActionEvent actionEvent) {
        this.searchTable();
    }

    private void neutralButtonActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.table.getSelectedRows();
        this.setClassificationForSet(nArray, 3);
    }

    private void outClassButtonActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.table.getSelectedRows();
        this.setClassificationForSet(nArray, 2);
    }

    private void inClassButtonActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.table.getSelectedRows();
        this.setClassificationForSet(nArray, 1);
    }

    private void saveMenuItemActionPerformed(ActionEvent actionEvent) {
        try {
            this.saveTableToCurrentSVC();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void saveAsMenuItemActionPerformed(ActionEvent actionEvent) {
        try {
            this.saveTableAsSVC();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void fileMenuActionPerformed(ActionEvent actionEvent) {
    }

    private void storedClusterMenuItemActionPerformed(ActionEvent actionEvent) {
    }

    private void closeMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private void exitForm(WindowEvent windowEvent) {
        this.cancelForm = true;
        this.setVisible(false);
    }

    public class SVCFileView
    extends FileView {
        private Icon SVMIcon = GUIFactory.getIcon("svcfileicon.gif");

        public String getName(File file) {
            return null;
        }

        public String getDescription(File file) {
            return null;
        }

        public Boolean isTraversable(File file) {
            return null;
        }

        public String getTypeDescription(File file) {
            String string = this.getExtension(file);
            String string2 = null;
            if (string != null && string.equals("svc")) {
                string2 = "SVC File";
            }
            return string2;
        }

        public Icon getIcon(File file) {
            String string = this.getExtension(file);
            Icon icon = null;
            if (string != null && string.equals("svc")) {
                icon = this.SVMIcon;
            }
            return icon;
        }

        private String getExtension(File file) {
            String string = null;
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            return string;
        }
    }

    public class SVCFileFilter
    extends FileFilter {
        public boolean accept(File file) {
            return file.getName().toLowerCase().endsWith(".svc") || file.isDirectory();
        }

        public String getDescription() {
            return "SVC File";
        }
    }

    public class SVMTableColumnModel
    implements TableColumnModel {
        TableColumnModel tcm;

        public SVMTableColumnModel(TableColumnModel tableColumnModel) {
            this.tcm = tableColumnModel;
        }

        public int getColumnMargin() {
            return this.tcm.getColumnMargin();
        }

        public int[] getSelectedColumns() {
            return this.tcm.getSelectedColumns();
        }

        public int getColumnIndex(Object object) {
            return this.tcm.getColumnIndex(object);
        }

        public void setColumnSelectionAllowed(boolean bl) {
            this.tcm.setColumnSelectionAllowed(bl);
        }

        public ListSelectionModel getSelectionModel() {
            return this.tcm.getSelectionModel();
        }

        public void moveColumn(int n, int n2) {
            if (n < 4 || n2 < 4) {
                return;
            }
            this.tcm.moveColumn(n, n2);
        }

        public void setColumnMargin(int n) {
            this.tcm.setColumnMargin(n);
        }

        public boolean getColumnSelectionAllowed() {
            return this.tcm.getColumnSelectionAllowed();
        }

        public Enumeration getColumns() {
            return this.tcm.getColumns();
        }

        public void removeColumnModelListener(TableColumnModelListener tableColumnModelListener) {
            this.tcm.removeColumnModelListener(tableColumnModelListener);
        }

        public void removeColumn(TableColumn tableColumn) {
        }

        public int getColumnIndexAtX(int n) {
            return this.tcm.getColumnIndexAtX(n);
        }

        public int getSelectedColumnCount() {
            return this.tcm.getSelectedColumnCount();
        }

        public int getTotalColumnWidth() {
            return this.tcm.getTotalColumnWidth();
        }

        public void addColumnModelListener(TableColumnModelListener tableColumnModelListener) {
            this.tcm.addColumnModelListener(tableColumnModelListener);
        }

        public void addColumn(TableColumn tableColumn) {
            this.tcm.addColumn(tableColumn);
        }

        public void setSelectionModel(ListSelectionModel listSelectionModel) {
            this.tcm.setSelectionModel(listSelectionModel);
        }

        public TableColumn getColumn(int n) {
            return this.tcm.getColumn(n);
        }

        public int getColumnCount() {
            return this.tcm.getColumnCount();
        }
    }

    public class ClassSelectionListener
    implements TableModelListener {
        public void tableChanged(TableModelEvent tableModelEvent) {
            tableModelEvent.getSource();
            int n = tableModelEvent.getColumn();
            int n2 = tableModelEvent.getFirstRow();
            if (n < 1 || n > 3) {
                return;
            }
            if (this.verifySelected(n2, n)) {
                this.changeNeighbors(n2, n);
            }
        }

        private void changeNeighbors(int n, int n2) {
            if (n2 == 1) {
                SVMClassificationEditor.this.table.setValueAt(new Boolean(false), n, 2);
                SVMClassificationEditor.this.table.setValueAt(new Boolean(false), n, 3);
            } else if (n2 == 2) {
                SVMClassificationEditor.this.table.setValueAt(new Boolean(false), n, 1);
                SVMClassificationEditor.this.table.setValueAt(new Boolean(false), n, 3);
            } else if (n2 == 3) {
                SVMClassificationEditor.this.table.setValueAt(new Boolean(false), n, 1);
                SVMClassificationEditor.this.table.setValueAt(new Boolean(false), n, 2);
            }
        }

        private boolean verifySelected(int n, int n2) {
            boolean bl = (Boolean)SVMClassificationEditor.this.table.getValueAt(n, n2);
            if (bl) {
                return true;
            }
            if (n2 == 1) {
                boolean bl2 = (Boolean)SVMClassificationEditor.this.table.getValueAt(n, 2);
                boolean bl3 = (Boolean)SVMClassificationEditor.this.table.getValueAt(n, 3);
                if (!bl2 && !bl3) {
                    SVMClassificationEditor.this.table.setValueAt(new Boolean(true), n, n2);
                }
            } else if (n2 == 2) {
                boolean bl4 = (Boolean)SVMClassificationEditor.this.table.getValueAt(n, 1);
                boolean bl5 = (Boolean)SVMClassificationEditor.this.table.getValueAt(n, 3);
                if (!bl4 && !bl5) {
                    SVMClassificationEditor.this.table.setValueAt(new Boolean(true), n, n2);
                }
            } else if (n2 == 3) {
                boolean bl6 = (Boolean)SVMClassificationEditor.this.table.getValueAt(n, 1);
                boolean bl7 = (Boolean)SVMClassificationEditor.this.table.getValueAt(n, 2);
                if (!bl6 && !bl7) {
                    SVMClassificationEditor.this.table.setValueAt(new Boolean(true), n, n2);
                }
            }
            return false;
        }
    }

    public class ClassificationCellRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        private JRadioButton button = new JRadioButton();
        private Color selectionBackgroundColor;
        private Color selectionForegroundColor;

        public ClassificationCellRenderer(JTable jTable) {
            this.button.setBackground(Color.white);
            this.selectionBackgroundColor = jTable.getSelectionBackground();
            this.selectionForegroundColor = jTable.getForeground();
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.button.setSelected((Boolean)object);
            return this.button;
        }
    }

    public class SortListener
    implements ActionListener {
        private SVMTableModel model;

        public SortListener(TableModel tableModel) {
            this.model = (SVMTableModel)tableModel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = ((JMenuItem)object).getText();
                if (string.equals("index")) {
                    this.model.sort(0);
                } else if (string.equals("classification")) {
                    this.model.sort(1);
                } else {
                    this.model.sortBy(string);
                }
            }
        }
    }

    public class SVMTableModel
    extends AbstractTableModel {
        private Class[] types;
        private boolean[] canEdit;
        private TableModel tableModel;
        private Row[] rows;
        private int colToSort;
        private String[] headerNames;

        public SVMTableModel(String[] stringArray, TableModel tableModel) {
            int n;
            this.tableModel = tableModel;
            this.headerNames = stringArray;
            this.rows = new Row[this.tableModel.getRowCount()];
            for (n = 0; n < this.rows.length; ++n) {
                this.rows[n] = new Row();
                this.rows[n].index = n;
            }
            this.types = new Class[this.headerNames.length];
            this.canEdit = new boolean[this.types.length];
            for (n = 0; n < this.types.length; ++n) {
                if (n == 1 || n == 2 || n == 3) {
                    this.types[n] = Boolean.class;
                    this.canEdit[n] = true;
                    continue;
                }
                this.types[n] = Object.class;
                this.canEdit[n] = false;
            }
        }

        public void sort(int n) {
            this.colToSort = n;
            Arrays.sort(this.rows);
            SVMClassificationEditor.this.table.repaint();
        }

        public void sortBy(String string) {
            int n = this.getColumnIndex(string);
            if (n >= 0) {
                this.sort(n);
                this.colToSort = n;
            }
        }

        private int getColumnIndex(String string) {
            int n;
            for (n = 0; n < this.headerNames.length && !this.headerNames[n].equals(string); ++n) {
            }
            if (n < this.headerNames.length) {
                return n;
            }
            return -1;
        }

        public Class getColumnClass(int n) {
            return this.types[n];
        }

        public boolean isCellEditable(int n, int n2) {
            return this.canEdit[n2];
        }

        public Object getValueAt(int n, int n2) {
            return this.tableModel.getValueAt(this.rows[n].index, n2);
        }

        public void setValueAt(Object object, int n, int n2) {
            this.tableModel.setValueAt(object, this.rows[n].index, n2);
            this.fireTableChanged(new TableModelEvent(this, n, n, n2));
        }

        public int getRowCount() {
            return this.tableModel.getRowCount();
        }

        public int getColumnCount() {
            return this.tableModel.getColumnCount();
        }

        public String getColumnName(int n) {
            return this.tableModel.getColumnName(n);
        }

        public int convertToViewerRow(int n) {
            if (n > -1 && n < this.rows.length) {
                return this.rows[n].index;
            }
            return -1;
        }

        private class Row
        implements Comparable {
            public int index;

            private Row() {
            }

            public int compareTo(Object object) {
                Row row = (Row)object;
                Object object2 = SVMTableModel.this.tableModel.getValueAt(this.index, SVMTableModel.this.colToSort);
                Object object3 = SVMTableModel.this.tableModel.getValueAt(row.index, SVMTableModel.this.colToSort);
                if (object2 instanceof Comparable) {
                    return ((Comparable)object2).compareTo(object3);
                }
                if (object2 instanceof Boolean) {
                    boolean bl = (Boolean)object2;
                    boolean bl2 = (Boolean)object3;
                    if (bl2 && !bl) {
                        return 1;
                    }
                    if (!bl2 && bl) {
                        return -1;
                    }
                    return 0;
                }
                return this.index - row.index;
            }
        }
    }
}

