/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.svm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileFilter;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileView;
import org.tigr.microarray.mev.cluster.gui.impl.svm.GeneralInfo;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMData;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMResultViewer;
import org.tigr.util.FloatMatrix;

public class SVMClassifyViewer
extends SVMResultViewer {
    private IData experiment;
    private FloatMatrix discriminant;
    private SVMData data;
    private GeneralInfo info;
    private boolean classifyGenes;
    float[] classes;
    float[] discr;

    public SVMClassifyViewer(IFramework iFramework, IData iData, SVMData sVMData, FloatMatrix floatMatrix, GeneralInfo generalInfo, boolean bl) {
        super(iFramework);
        this.experiment = iData;
        this.discriminant = floatMatrix;
        this.data = sVMData;
        this.info = generalInfo;
        this.classifyGenes = bl;
        FloatMatrix floatMatrix2 = floatMatrix.transpose();
        this.classes = floatMatrix2.A[0];
        this.discr = floatMatrix2.A[1];
        this.resultPanel = new ClassifyResultPanel();
        this.displayData();
        this.add((Component)this.resultPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void displayData() {
        this.displayResult(this.classifyGenes);
    }

    private void displayResult(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        DecimalFormat decimalFormat = new DecimalFormat();
        DecimalFormat decimalFormat2 = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(4);
        decimalFormat.setMinimumFractionDigits(4);
        decimalFormat.setGroupingUsed(false);
        stringBuffer.append("Constant : " + Float.toString(this.data.constant) + "\n");
        stringBuffer.append("Coefficient : " + Float.toString(this.data.coefficient) + "\n");
        stringBuffer.append("Power : " + Float.toString(this.data.power) + "\n");
        stringBuffer.append("Diagonal factor : " + Float.toString(this.data.diagonalFactor) + "\n");
        stringBuffer.append("Convergence threshold : " + Float.toString(this.data.convergenceThreshold) + "\n");
        stringBuffer.append("Radial : " + this.data.radial + "\n");
        stringBuffer.append("Width factor : " + Float.toString(this.data.widthFactor) + "\n");
        stringBuffer.append("Use Constraint : " + this.data.constrainWeights + "\n");
        stringBuffer.append("Positive Constraint : " + Float.toString(this.data.positiveConstraint) + "\n");
        stringBuffer.append("Negative Constraint : " + Float.toString(this.data.negativeConstraint) + "\n");
        stringBuffer.append("Seed : " + Float.toString(this.data.seed) + "\n");
        stringBuffer.append("Calculation time : " + Float.toString(this.info.time) + " ms\n");
        stringBuffer.append("Objective : " + Float.toString(this.data.objective1) + "\n\n");
        if (bl) {
            if (this.labelIndex >= 0 && this.labelIndex < this.fieldNames.length) {
                stringBuffer.append(" Index    Class.   Discr.    " + this.fieldNames[this.labelIndex]);
            } else {
                stringBuffer.append(" Index    Class.   Discr.");
            }
        } else {
            stringBuffer.append(" Index    Class.   Discr.     Experiment");
        }
        this.Log.setText(stringBuffer.toString());
        this.Log.setCaretPosition(0);
    }

    protected void onSaveResult() {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.addChoosableFileFilter(new ExpressionFileFilter());
        jFileChooser.setFileView(new ExpressionFileView());
        jFileChooser.setCurrentDirectory(new File("Data"));
        int n = jFileChooser.showSaveDialog(JOptionPane.getFrameForComponent(this));
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            int n2 = this.discriminant.getRowDimension();
            String string = this.Log.getText();
            string = string.substring(0, string.lastIndexOf("Index"));
            bufferedWriter.write(string);
            if (this.classifyGenes) {
                if (this.labelIndex >= 0 && this.labelIndex < this.fieldNames.length) {
                    bufferedWriter.write("Index\tClass.\tDiscr.\t" + this.fieldNames[this.labelIndex] + "\t\n");
                } else {
                    bufferedWriter.write("Index\tClass.\tDiscr.\t\n");
                }
            } else {
                bufferedWriter.write("Index\tClass.\tDiscr.\tExperiment\t\n");
            }
            for (int i = 0; i < n2; ++i) {
                if (this.classifyGenes) {
                    bufferedWriter.write(String.valueOf(i + 1) + "\t" + String.valueOf(this.discriminant.get(i, 0)) + "\t" + String.valueOf(this.discriminant.get(i, 1)) + "\t" + this.experiment.getElementAttribute(this.getMultipleArrayDataRow(i), this.labelIndex) + "\t\n");
                    continue;
                }
                bufferedWriter.write(String.valueOf(i + 1) + "\t" + String.valueOf(this.discriminant.get(i, 0)) + "\t" + String.valueOf(this.discriminant.get(i, 1)) + "\t" + this.experiment.getSampleName(i) + "\t\n");
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            bufferedWriter = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error writing to file " + file.getPath() + "!", "Error", 0);
        }
    }

    protected Dimension updateSize() {
        return ((ClassifyResultPanel)this.resultPanel).updateSize();
    }

    public class ClassifyResultPanel
    extends JPanel {
        int lineHeight = 20;
        int indexLength = 1;
        DecimalFormat floatFormat = new DecimalFormat();
        DecimalFormat intFormat;
        DecimalFormat indexFormat;
        String[] spacerStrings;

        public ClassifyResultPanel() {
            this.floatFormat.setMaximumFractionDigits(4);
            this.floatFormat.setMinimumFractionDigits(4);
            this.floatFormat.setGroupingUsed(false);
            this.intFormat = new DecimalFormat();
            this.intFormat.setMinimumFractionDigits(0);
            this.intFormat.setMaximumFractionDigits(0);
            this.intFormat.setGroupingUsed(false);
            this.indexFormat = new DecimalFormat();
            this.indexFormat = new DecimalFormat();
            this.indexFormat.setMinimumFractionDigits(0);
            this.indexFormat.setMaximumFractionDigits(0);
            this.indexLength = String.valueOf(SVMClassifyViewer.this.classes.length).length();
            this.indexFormat.setMinimumIntegerDigits(this.indexLength);
            this.indexFormat.setGroupingUsed(false);
            this.setBackground(Color.white);
            Dimension dimension = this.updateSize();
            this.setSize(dimension.width, SVMClassifyViewer.this.classes.length * this.lineHeight + 10);
            this.setPreferredSize(new Dimension(dimension.width, SVMClassifyViewer.this.classes.length * this.lineHeight + 5));
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setFont(new Font("monospaced", 0, 14));
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle rectangle = graphics.getClipBounds();
            int n = this.getTopIndex(rectangle.y);
            int n2 = this.getBottomIndex(rectangle.y + rectangle.height, SVMClassifyViewer.this.classes.length + 1);
            for (int i = n; i < n2; ++i) {
                int n3 = i;
                if (!this.isLegalIndex(n3)) continue;
                String[] stringArray = this.getSpacerStrings(this.indexLength, this.intFormat.format(SVMClassifyViewer.this.classes[n3]), this.floatFormat.format(SVMClassifyViewer.this.discr[n3]));
                if (SVMClassifyViewer.this.classifyGenes) {
                    graphics.drawString(" " + this.indexFormat.format(i + 1) + stringArray[0] + this.intFormat.format(SVMClassifyViewer.this.classes[n3]) + stringArray[1] + this.floatFormat.format(SVMClassifyViewer.this.discr[n3]) + stringArray[2] + SVMClassifyViewer.this.experiment.getElementAttribute(SVMClassifyViewer.this.getMultipleArrayDataRow(n3), SVMClassifyViewer.this.labelIndex), 10, (i + 1) * this.lineHeight);
                    continue;
                }
                graphics.drawString(" " + this.indexFormat.format(i + 1) + stringArray[0] + this.intFormat.format(SVMClassifyViewer.this.classes[n3]) + stringArray[1] + this.floatFormat.format(SVMClassifyViewer.this.discr[n3]) + stringArray[2] + SVMClassifyViewer.this.experiment.getSampleName(n3), 10, (i + 1) * this.lineHeight);
            }
        }

        private boolean isLegalIndex(int n) {
            return n >= 0 && n < SVMClassifyViewer.this.classes.length;
        }

        private int getTopIndex(int n) {
            if (n < 0) {
                return 0;
            }
            return n / this.lineHeight;
        }

        private int getBottomIndex(int n, int n2) {
            if (n < 0) {
                return 0;
            }
            int n3 = n / this.lineHeight + 1;
            return n3 > n2 ? n2 : n3;
        }

        protected String[] getSpacerStrings(int n, String string, String string2) {
            int n2;
            String[] stringArray = new String[3];
            stringArray[2] = "";
            stringArray[1] = "";
            stringArray[0] = "";
            for (n2 = n; n2 < 10; ++n2) {
                stringArray[0] = stringArray[0] + " ";
            }
            if (string.length() == 1) {
                stringArray[0] = stringArray[0] + " ";
            }
            stringArray[1] = "     ";
            int n3 = 13 - string2.length();
            for (n2 = 0; n2 < n3; ++n2) {
                stringArray[2] = stringArray[2] + " ";
            }
            return stringArray;
        }

        protected Dimension updateSize() {
            FontMetrics fontMetrics = this.getFontMetrics(new Font("monospaced", 0, 14));
            int n = 0;
            this.indexLength = String.valueOf(SVMClassifyViewer.this.classes.length).length();
            this.floatFormat = new DecimalFormat();
            this.floatFormat.setMaximumFractionDigits(4);
            this.floatFormat.setMinimumFractionDigits(4);
            this.floatFormat.setGroupingUsed(false);
            this.intFormat = new DecimalFormat();
            this.intFormat.setMinimumFractionDigits(0);
            this.intFormat.setMaximumFractionDigits(0);
            this.intFormat.setGroupingUsed(false);
            this.indexFormat = new DecimalFormat();
            this.indexFormat = new DecimalFormat();
            this.indexFormat.setMinimumFractionDigits(0);
            this.indexFormat.setMaximumFractionDigits(0);
            this.indexFormat.setMinimumIntegerDigits(this.indexLength);
            this.indexFormat.setGroupingUsed(false);
            int n2 = SVMClassifyViewer.this.classifyGenes ? SVMClassifyViewer.this.experiment.getFeaturesSize() : SVMClassifyViewer.this.experiment.getFeaturesCount();
            for (int i = 0; i < n2; ++i) {
                this.spacerStrings = this.getSpacerStrings(this.indexLength, this.intFormat.format(SVMClassifyViewer.this.classes[i]), this.floatFormat.format(SVMClassifyViewer.this.discr[i]));
                String string = SVMClassifyViewer.this.classifyGenes ? " " + this.indexFormat.format(i + 1) + this.spacerStrings[0] + this.intFormat.format(SVMClassifyViewer.this.classes[i]) + this.spacerStrings[1] + this.floatFormat.format(SVMClassifyViewer.this.discr[i]) + this.spacerStrings[2] + SVMClassifyViewer.this.experiment.getElementAttribute(SVMClassifyViewer.this.getMultipleArrayDataRow(i), SVMClassifyViewer.this.labelIndex) : " " + this.indexFormat.format(i) + this.spacerStrings[0] + this.intFormat.format(SVMClassifyViewer.this.classes[i]) + this.spacerStrings[1] + this.floatFormat.format(SVMClassifyViewer.this.discr[i]) + this.spacerStrings[2] + SVMClassifyViewer.this.experiment.getSampleName(i);
                n = Math.max(n, fontMetrics.stringWidth(string));
            }
            this.setSize(n + 10, this.getHeight());
            this.setPreferredSize(new Dimension(n + 10, this.getHeight()));
            return new Dimension(n + 10, this.getHeight());
        }
    }
}

