/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.svm;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmFactory;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Logger;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Monitor;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.svm.GeneralInfo;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMClassificationEditor;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMClassifyViewer;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMData;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMDiscriminantExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMExperimentClusterCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMExperimentClusterCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMFileFilter;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMFileView;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMOneOutViewer;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMProcessInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMTrainViewer;
import org.tigr.util.FloatMatrix;

public class SVMGUI
implements IClusterGUI {
    protected Frame parentFrame;
    private IFramework framework;
    protected IDistanceMenu menu;
    protected Logger logger;
    protected Monitor monitor;
    protected Listener listener;
    protected IData experiment;
    protected Algorithm algorithm;
    protected SVMData data = new SVMData();
    protected GeneralInfo info = new GeneralInfo();
    protected Experiment experimentMap;
    private File SVMFile;
    private float[] Weights;
    private FloatMatrix trainingMatrix;
    private FloatMatrix kernelMatrix;
    private int[] classes;
    public static int TRAIN_AND_CLASSIFY = 0;
    public static int TRAIN_ONLY = 1;
    public static int CLASSIFY_ONLY = 2;
    public static int ONE_OUT_VALIDATION = 3;
    private int SVMMode = 0;
    private boolean classifyGenes;
    private FloatMatrix discriminantMatrix;
    private boolean stop = false;

    protected void createAlgorithm(AlgorithmFactory algorithmFactory) throws AlgorithmException {
        this.listener = new Listener();
        this.algorithm = algorithmFactory.getAlgorithm("SVM");
        this.algorithm.addAlgorithmListener(this.listener);
    }

    protected void bindParams(AlgorithmData algorithmData) {
        FloatMatrix floatMatrix = this.experiment.getExperiment().getMatrix();
        if (!this.data.classifyGenes) {
            floatMatrix = floatMatrix.transpose();
        }
        algorithmData.addMatrix("experiment", floatMatrix);
        algorithmData.addParam("distance-factor", String.valueOf(1.0f));
        algorithmData.addParam("distance-absolute", String.valueOf(this.menu.isAbsoluteDistance()));
        algorithmData.addParam("distance-function", String.valueOf(this.data.distanceFunction));
        algorithmData.addParam("constant", String.valueOf(this.data.constant));
        algorithmData.addParam("coefficient", String.valueOf(this.data.coefficient));
        algorithmData.addParam("power", String.valueOf(this.data.power));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        this.parentFrame = iFramework.getFrame();
        this.experiment = iFramework.getData();
        this.experimentMap = this.experiment.getExperiment();
        this.menu = iFramework.getDistanceMenu();
        this.framework = iFramework;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        try {
            this.createAlgorithm(iFramework.getAlgorithmFactory());
            AlgorithmData algorithmData = new AlgorithmData();
            if (!this.selectSVMProcedure()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = null;
                return defaultMutableTreeNode2;
            }
            if (this.SVMMode == TRAIN_AND_CLASSIFY) {
                if (!this.initTrainingParams()) {
                    DefaultMutableTreeNode defaultMutableTreeNode3 = null;
                    return defaultMutableTreeNode3;
                }
                this.bindTrainingParams(algorithmData);
                long l = System.currentTimeMillis();
                AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
                long l2 = System.currentTimeMillis() - l;
                this.getTrainingResults(algorithmData2);
                defaultMutableTreeNode = this.classifyGenes ? new DefaultMutableTreeNode("SVM - genes") : new DefaultMutableTreeNode("SVM - experiments");
                defaultMutableTreeNode.add(this.createTrainingGUIResult());
                this.createAlgorithm(iFramework.getAlgorithmFactory());
                this.bindClassificationParams(algorithmData);
                l = System.currentTimeMillis();
                AlgorithmData algorithmData3 = this.algorithm.execute(algorithmData);
                this.getClassificationResults(algorithmData3);
                this.info.time = l2 += System.currentTimeMillis() - l;
                this.info.function = this.menu.getFunctionName(this.menu.getDistanceFunction());
                defaultMutableTreeNode.add(this.createClassificationGUIResult());
                defaultMutableTreeNode.add(this.createSVMExpressionViews(algorithmData3, this.classes));
                if (this.data.calculateHCL) {
                    defaultMutableTreeNode.add(this.createHierarchicalTreeViews(algorithmData3.getCluster("cluster"), algorithmData3));
                }
                this.createSVMCentroidViews(algorithmData3, defaultMutableTreeNode);
                this.createInfoView(algorithmData3, defaultMutableTreeNode);
                this.addSVMParameterNode(defaultMutableTreeNode);
            } else if (this.SVMMode == TRAIN_ONLY) {
                if (!this.initTrainingParams()) {
                    DefaultMutableTreeNode defaultMutableTreeNode4 = null;
                    return defaultMutableTreeNode4;
                }
                this.bindTrainingParams(algorithmData);
                long l = System.currentTimeMillis();
                AlgorithmData algorithmData4 = this.algorithm.execute(algorithmData);
                long l3 = System.currentTimeMillis() - l;
                this.getTrainingResults(algorithmData4);
                defaultMutableTreeNode = this.classifyGenes ? new DefaultMutableTreeNode("SVM - genes") : new DefaultMutableTreeNode("SVM - experiments");
                defaultMutableTreeNode.add(this.createTrainingGUIResult());
                this.info.time = l3;
                int n = this.menu.getDistanceFunction();
                this.info.function = this.menu.getFunctionName(n);
                this.addSVMParameterNode(defaultMutableTreeNode);
            } else if (this.SVMMode == CLASSIFY_ONLY) {
                if (!this.initClassificationParams()) {
                    DefaultMutableTreeNode defaultMutableTreeNode5 = null;
                    return defaultMutableTreeNode5;
                }
                this.bindClassificationParams(algorithmData);
                long l = System.currentTimeMillis();
                AlgorithmData algorithmData5 = this.algorithm.execute(algorithmData);
                long l4 = System.currentTimeMillis() - l;
                this.getClassificationResults(algorithmData5);
                defaultMutableTreeNode = this.classifyGenes ? new DefaultMutableTreeNode("SVM - genes") : new DefaultMutableTreeNode("SVM - experiments");
                this.info.time = l4;
                int n = this.menu.getDistanceFunction();
                this.info.function = this.menu.getFunctionName(n);
                defaultMutableTreeNode.add(this.createClassificationGUIResult());
                defaultMutableTreeNode.add(this.createViewers(algorithmData5));
                if (this.data.calculateHCL) {
                    defaultMutableTreeNode.add(this.createHierarchicalTreeViews(algorithmData5.getCluster("cluster"), algorithmData5));
                }
                this.createSVMCentroidViews(algorithmData5, defaultMutableTreeNode);
                this.createInfoView(algorithmData5, defaultMutableTreeNode);
                this.addSVMParameterNode(defaultMutableTreeNode);
            } else if (this.SVMMode == ONE_OUT_VALIDATION) {
                if (!this.initTrainingParams()) {
                    DefaultMutableTreeNode defaultMutableTreeNode6 = null;
                    return defaultMutableTreeNode6;
                }
                int n = this.classifyGenes ? this.experimentMap.getNumberOfGenes() : this.experimentMap.getNumberOfSamples();
                FloatMatrix floatMatrix = new FloatMatrix(n, 2);
                int n2 = this.getNumberOfNonNeutrals();
                int[] nArray = new int[n];
                int[] nArray2 = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray2[i] = 0;
                }
                defaultMutableTreeNode = this.classifyGenes ? new DefaultMutableTreeNode("SVM Val. - genes") : new DefaultMutableTreeNode("SVM Val. - experiments");
                for (int i = 0; i < n; ++i) {
                    int n3 = this.classes[i];
                    this.classes[i] = 0;
                    this.bindTrainingParams(algorithmData);
                    long l = System.currentTimeMillis();
                    AlgorithmData algorithmData6 = this.algorithm.execute(algorithmData);
                    long l5 = System.currentTimeMillis() - l;
                    this.getTrainingResults(algorithmData6);
                    this.createAlgorithm(iFramework.getAlgorithmFactory());
                    this.bindClassificationParams(algorithmData);
                    l = System.currentTimeMillis();
                    AlgorithmData algorithmData7 = this.algorithm.execute(algorithmData);
                    l5 += System.currentTimeMillis() - l;
                    this.getClassificationResults(algorithmData7);
                    this.accumulateResult(floatMatrix, i);
                    this.classes[i] = n3;
                    this.getNumberOfCorrectPlacements(nArray, nArray2, i);
                }
                DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(new LeafInfo("SVM One-out Validation", new SVMOneOutViewer(iFramework, this.experiment, this.data, floatMatrix, this.info, this.data.classifyGenes, this.classes, nArray2, nArray, n2)));
                defaultMutableTreeNode.add(defaultMutableTreeNode7);
                AlgorithmData algorithmData8 = this.constructCumulativeResult(floatMatrix);
                defaultMutableTreeNode.add(this.createSVMExpressionViews(algorithmData8, this.classes));
                if (this.data.calculateHCL) {
                    try {
                        this.calculateHCL(algorithmData8, floatMatrix);
                        defaultMutableTreeNode.add(this.createHierarchicalTreeViews(algorithmData8.getCluster("cluster"), algorithmData8));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.createSVMCentroidViews(algorithmData8, defaultMutableTreeNode);
                this.createInfoView(algorithmData8, defaultMutableTreeNode);
                this.addSVMParameterNode(defaultMutableTreeNode);
            }
            DefaultMutableTreeNode defaultMutableTreeNode8 = defaultMutableTreeNode;
            return defaultMutableTreeNode8;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener(this.listener);
            }
            if (this.monitor != null) {
                this.monitor.dispose();
            }
            if (this.logger != null) {
                this.logger.dispose();
            }
        }
    }

    private AlgorithmData constructCumulativeResult(FloatMatrix floatMatrix) {
        AlgorithmData algorithmData = new AlgorithmData();
        algorithmData.addMatrix("experiment", this.experimentMap.getMatrix());
        algorithmData.addMatrix("discriminant", floatMatrix);
        algorithmData.addIntArray("positives", this.getPositives(floatMatrix));
        algorithmData.addIntArray("negatives", this.getNegatives(floatMatrix));
        FloatMatrix floatMatrix2 = this.getMeans(floatMatrix);
        algorithmData.addMatrix("means", floatMatrix2);
        algorithmData.addMatrix("variances", this.getVariance(floatMatrix, floatMatrix2));
        return algorithmData;
    }

    private void getNumberOfCorrectPlacements(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        for (int i = 0; i < this.discriminantMatrix.getRowDimension(); ++i) {
            int n3 = (int)this.discriminantMatrix.get(i, 0);
            if (n3 != this.classes[i]) continue;
            int n4 = i;
            nArray2[n4] = nArray2[n4] + 1;
            ++n2;
        }
        nArray[n] = n2;
    }

    private boolean selectSVMProcedure() {
        SVMProcessInitDialog sVMProcessInitDialog = new SVMProcessInitDialog(this.parentFrame, true);
        if (sVMProcessInitDialog.showModal() != 0) {
            return false;
        }
        this.data.classifyGenes = this.classifyGenes = sVMProcessInitDialog.isEvaluateGenesSelected();
        this.SVMMode = sVMProcessInitDialog.getSVMProcessSelection();
        this.data.calculateHCL = sVMProcessInitDialog.getHCLSelection();
        if (this.data.calculateHCL) {
            HCLInitDialog hCLInitDialog = new HCLInitDialog(this.framework.getFrame());
            if (hCLInitDialog.showModal() == 0) {
                this.data.hclMethod = hCLInitDialog.getMethod();
                this.data.calcSampleHCL = hCLInitDialog.isClusterExperience();
                this.data.calcGeneHCL = hCLInitDialog.isClusterGenes();
            } else {
                this.data.calculateHCL = false;
            }
        }
        return true;
    }

    protected boolean initTrainingParams() throws AlgorithmException {
        SVMInitDialog sVMInitDialog;
        this.trainingMatrix = this.experiment.getExperiment().getMatrix();
        this.kernelMatrix = null;
        this.data.distanceFunction = this.menu.getDistanceFunction();
        if (this.data.distanceFunction == 0) {
            this.data.distanceFunction = 4;
        }
        if ((sVMInitDialog = new SVMInitDialog(this.parentFrame, this.data)).showModal() != 0) {
            return false;
        }
        this.data = sVMInitDialog.getData();
        this.classes = this.classifyGenes ? new int[this.trainingMatrix.getRowDimension()] : new int[this.trainingMatrix.getColumnDimension()];
        this.showLogger("SVM Log Window");
        if (this.data.useEditor) {
            SVMClassificationEditor sVMClassificationEditor = new SVMClassificationEditor(this.framework, this.data.classifyGenes);
            this.logger.append("Using Classification Editor\n");
            sVMClassificationEditor.show();
            while (sVMClassificationEditor.isVisible()) {
            }
            if (sVMClassificationEditor.formCanceled()) {
                return false;
            }
            this.classes = sVMClassificationEditor.getClassification();
        } else {
            this.logger.append("Reading classification file\n");
            if (!this.readSVCFile()) {
                return false;
            }
        }
        return true;
    }

    private boolean readSVCFile() {
        String string = "";
        int n = 0;
        boolean bl = false;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(this.data.classificationFile.getPath())));
            String string3 = bufferedReader.readLine();
            if (string3 != null) {
                string = string3;
                n = string.indexOf(9);
                string2 = string = string.substring(n + 1, string.length());
            }
            int n2 = 0;
            string3 = bufferedReader.readLine();
            while (string3 != null) {
                string = string3;
                string = string.substring(string.indexOf(9) + 1);
                n = string.indexOf(9);
                string2 = string.substring(0, n);
                string = string.substring(n + 1, string.length());
                ++n2;
                if (string2.compareTo("1") * string2.compareTo("-1") != 0) {
                    JOptionPane.showMessageDialog(this.parentFrame, "Value not Element of [1,-1] in line " + n2, "Error", 0);
                    break;
                }
                this.classes[n2 - 1] = Integer.parseInt(string2);
                string3 = bufferedReader.readLine();
            }
            if (this.classifyGenes && n2 != this.experimentMap.getNumberOfGenes()) {
                JOptionPane.showMessageDialog(this.parentFrame, "Number of Genes to classify does not match current data set!", "Error", 0);
            } else if (!this.classifyGenes && n2 != this.experimentMap.getNumberOfSamples()) {
                JOptionPane.showMessageDialog(this.parentFrame, "Number of Experiments to classify does not match current data set!", "Error", 0);
            } else {
                bl = true;
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.parentFrame, "Can not read file " + this.data.classificationFile.getPath() + "!", "Error", 0);
        }
        return bl;
    }

    protected void bindTrainingParams(AlgorithmData algorithmData) {
        this.bindParams(algorithmData);
        algorithmData.addParam("is-classify", String.valueOf(false));
        algorithmData.addParam("distance-function", String.valueOf(this.data.distanceFunction));
        algorithmData.addIntArray("classes", this.classes);
        algorithmData.addParam("seed", String.valueOf(this.data.seed));
        algorithmData.addParam("normalize", String.valueOf(this.data.normalize));
        algorithmData.addParam("radial", String.valueOf(this.data.radial));
        algorithmData.addParam("width-factor", String.valueOf(this.data.widthFactor));
        algorithmData.addParam("positive-diagonal", String.valueOf(this.data.positiveDiagonal));
        algorithmData.addParam("negative-diagonal", String.valueOf(this.data.negativeDiagonal));
        algorithmData.addParam("diagonal-factor", String.valueOf(this.data.diagonalFactor));
        algorithmData.addParam("positive-constraint", String.valueOf(this.data.positiveConstraint));
        algorithmData.addParam("negative-constraint", String.valueOf(this.data.negativeConstraint));
        algorithmData.addParam("convergence-threshold", String.valueOf(this.data.convergenceThreshold));
        algorithmData.addParam("constrain-weights", String.valueOf(this.data.constrainWeights));
    }

    protected void getTrainingResults(AlgorithmData algorithmData) {
        FloatMatrix floatMatrix = algorithmData.getMatrix("weights");
        this.Weights = floatMatrix.getColumnPackedCopy();
    }

    protected DefaultMutableTreeNode createTrainingGUIResult() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new LeafInfo("SVM Training Result", new SVMTrainViewer(this.framework, this.experiment, this.data, this.Weights, this.info, this.data.classifyGenes)));
        return defaultMutableTreeNode;
    }

    protected boolean initClassificationParams() throws AlgorithmException {
        this.data.distanceFunction = this.menu.getDistanceFunction();
        if (this.data.distanceFunction == 0) {
            this.data.distanceFunction = 4;
        }
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.setCurrentDirectory(new File("Data/SVM"));
        jFileChooser.addChoosableFileFilter(new SVMFileFilter());
        jFileChooser.setFileView(new SVMFileView());
        int n = jFileChooser.showOpenDialog(this.parentFrame);
        if (n != 0) {
            return false;
        }
        this.SVMFile = jFileChooser.getSelectedFile();
        this.showLogger("SVM Classify Log Window");
        this.logger.append("Reading SVM file\n");
        try {
            if (!this.ReadSVMFile()) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean ReadSVMFile() throws Exception {
        String string = new String();
        String string2 = new String();
        String string3 = new String();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(this.SVMFile)));
            int n = this.experimentMap.getNumberOfGenes();
            int n2 = this.experimentMap.getNumberOfSamples();
            bufferedReader.readLine();
            string = bufferedReader.readLine();
            int n3 = string.indexOf(":");
            string3 = string.substring(n3 + 2, string.length());
            this.data.constant = Float.valueOf(string3).floatValue();
            string = bufferedReader.readLine();
            n3 = string.indexOf(":");
            string3 = string.substring(n3 + 2, string.length());
            this.data.coefficient = Float.valueOf(string3).floatValue();
            string = bufferedReader.readLine();
            n3 = string.indexOf(":");
            string3 = string.substring(n3 + 2, string.length());
            this.data.power = Float.valueOf(string3).floatValue();
            string = bufferedReader.readLine();
            n3 = string.indexOf(":");
            string3 = string.substring(n3 + 2, string.length());
            this.data.diagonalFactor = Float.valueOf(string3).floatValue();
            string = bufferedReader.readLine();
            n3 = string.indexOf(":");
            string3 = string.substring(n3 + 2, string.length());
            this.data.convergenceThreshold = Float.valueOf(string3).floatValue();
            string = bufferedReader.readLine();
            n3 = string.indexOf(":");
            string3 = string.substring(n3 + 2, string.length());
            this.data.radial = Boolean.valueOf(string3);
            string = bufferedReader.readLine();
            n3 = string.indexOf(":");
            string3 = string.substring(n3 + 2, string.length());
            this.data.widthFactor = Float.valueOf(string3).floatValue();
            string = bufferedReader.readLine();
            n3 = string.indexOf(":");
            string3 = string.substring(n3 + 2, string.length());
            this.data.constrainWeights = Boolean.valueOf(string3);
            string = bufferedReader.readLine();
            n3 = string.indexOf(":");
            string3 = string.substring(n3 + 2, string.length());
            this.data.positiveConstraint = Float.valueOf(string3).floatValue();
            string = bufferedReader.readLine();
            n3 = string.indexOf(":");
            string3 = string.substring(n3 + 2, string.length());
            this.data.negativeConstraint = Float.valueOf(string3).floatValue();
            bufferedReader.readLine();
            bufferedReader.readLine();
            string = bufferedReader.readLine();
            n3 = string.indexOf(":");
            string3 = string.substring(n3 + 2, string.length());
            this.data.objective1 = Float.valueOf(string3).floatValue();
            bufferedReader.readLine();
            bufferedReader.readLine();
            this.Weights = this.classifyGenes ? new float[n] : new float[n2];
            for (int i = 0; i < this.Weights.length; ++i) {
                string2 = string = bufferedReader.readLine();
                n3 = string2.indexOf(9);
                string3 = string2.substring(0, n3);
                this.Weights[i] = Float.valueOf(string3).floatValue();
            }
            if (bufferedReader.readLine() != null) {
                JOptionPane.showMessageDialog(this.parentFrame, this.SVMFile.getPath() + " has an incorrect number of weight values for current data set.", "Error", 0);
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.parentFrame, "Can not read file " + this.SVMFile.getPath() + "!", "Error", 0);
            throw exception;
        }
        return true;
    }

    protected void bindClassificationParams(AlgorithmData algorithmData) {
        this.bindParams(algorithmData);
        algorithmData.addParam("is-classify", String.valueOf(true));
        if (this.SVMMode == CLASSIFY_ONLY) {
            this.trainingMatrix = this.experiment.getExperiment().getMatrix();
        }
        if (this.data.classifyGenes) {
            algorithmData.addMatrix("training", this.trainingMatrix);
        } else {
            algorithmData.addMatrix("training", this.trainingMatrix.transpose());
        }
        algorithmData.addMatrix("weights", new FloatMatrix(this.Weights, 1));
        algorithmData.addParam("classify-genes", String.valueOf(this.classifyGenes));
        if (this.data.calculateHCL) {
            algorithmData.addParam("calculate-hcl", String.valueOf(this.data.calculateHCL));
            algorithmData.addParam("calculate-genes-hcl", String.valueOf(this.data.calcGeneHCL));
            algorithmData.addParam("calculate-samples-hcl", String.valueOf(this.data.calcSampleHCL));
            algorithmData.addParam("linkage-method", String.valueOf(this.data.hclMethod));
        }
    }

    protected void getClassificationResults(AlgorithmData algorithmData) {
        this.discriminantMatrix = algorithmData.getMatrix("discriminant");
    }

    protected DefaultMutableTreeNode createClassificationGUIResult() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new LeafInfo("SVM Classification Result", new SVMClassifyViewer(this.framework, this.experiment, this.data, this.discriminantMatrix, this.info, this.data.classifyGenes)));
        return defaultMutableTreeNode;
    }

    protected DefaultMutableTreeNode createViewers(AlgorithmData algorithmData) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Expression Images");
        int[][] nArray = this.getClassificationIndices(algorithmData.getIntArray("positives"), algorithmData.getIntArray("negatives"));
        JPanel jPanel = this.classifyGenes ? new SVMExperimentViewer(this.experimentMap, nArray) : new SVMExperimentClusterViewer(this.experimentMap, nArray);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Positives", (IViewer)((Object)jPanel), new Integer(0))));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Negatives", (IViewer)((Object)jPanel), new Integer(1))));
        return defaultMutableTreeNode;
    }

    protected DefaultMutableTreeNode createSVMExpressionViews(AlgorithmData algorithmData, int[] nArray) {
        int[] nArray2 = algorithmData.getIntArray("positives");
        int[] nArray3 = algorithmData.getIntArray("negatives");
        int[][] nArray4 = this.getTruePositives(nArray2, nArray);
        int[][] nArray5 = this.getFalseNegatives(nArray2, nArray);
        int[][] nArray6 = this.getFalsePositives(nArray3, nArray);
        int[][] nArray7 = this.getTrueNegatives(nArray3, nArray);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Expression Images");
        if (this.classifyGenes) {
            SVMDiscriminantExperimentViewer sVMDiscriminantExperimentViewer = new SVMDiscriminantExperimentViewer(this.experimentMap, this.getOrderedClassIndices(nArray4[0], nArray5[0], nArray6[0], nArray7[0]), nArray4 != null ? nArray4[0].length : 0, nArray6 != null ? nArray6[0].length : 0, this.getDiscriminants(nArray2, nArray3), null, this.classifyGenes);
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Positives", (IViewer)sVMDiscriminantExperimentViewer, new Integer(0))));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Negatives", (IViewer)sVMDiscriminantExperimentViewer, new Integer(1))));
        } else {
            int[] nArray8 = algorithmData.getIntArray("positve-samples-order");
            int[] nArray9 = algorithmData.getIntArray("negative-samples-order");
            SVMExperimentClusterViewer sVMExperimentClusterViewer = new SVMExperimentClusterViewer(this.experimentMap, this.getClassificationIndices(nArray2, nArray3));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Positive Experiments", (IViewer)sVMExperimentClusterViewer, new Integer(0))));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Negative Experiments", (IViewer)sVMExperimentClusterViewer, new Integer(1))));
        }
        return defaultMutableTreeNode;
    }

    protected void createInfoView(AlgorithmData algorithmData, DefaultMutableTreeNode defaultMutableTreeNode) {
        SVMInfoViewer sVMInfoViewer;
        int[] nArray = algorithmData.getIntArray("positives");
        int[] nArray2 = algorithmData.getIntArray("negatives");
        if (this.SVMMode == CLASSIFY_ONLY) {
            sVMInfoViewer = new SVMInfoViewer(nArray.length, nArray2.length, this.classifyGenes, this.SVMMode);
        } else {
            int n;
            int[][] nArray3 = this.getTruePositives(nArray, this.classes);
            int[][] nArray4 = this.getFalseNegatives(nArray, this.classes);
            int[][] nArray5 = this.getFalsePositives(nArray2, this.classes);
            int[][] nArray6 = this.getTrueNegatives(nArray2, this.classes);
            int n2 = 0;
            int n3 = 0;
            int n4 = this.getNumberOfPositiveExamples(this.classes);
            if (this.classes.length - n4 - (n = this.getNumberOfNegativeExamples(this.classes)) > 0) {
                n2 = this.getNumPosRecFromNeutrals(nArray, this.classes);
                n3 = this.getNumNegRecFromNeutrals(nArray2, this.classes);
            }
            sVMInfoViewer = new SVMInfoViewer(n4, n, this.classes.length - n4 - n, nArray.length, nArray3[0].length, nArray4[0].length, nArray2.length, nArray6[0].length, nArray5[0].length, n2, n3, this.classifyGenes, this.SVMMode);
        }
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Classification Information", sVMInfoViewer)));
    }

    private DefaultMutableTreeNode createSVMCentroidViews(AlgorithmData algorithmData, DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        int[][] nArray = this.getClassificationIndices(algorithmData.getIntArray("positives"), algorithmData.getIntArray("negatives"));
        if (this.classifyGenes) {
            SVMCentroidViewer sVMCentroidViewer = new SVMCentroidViewer(this.experimentMap, nArray);
            float[][] fArray = algorithmData.getMatrix((String)"means").A;
            float[][] fArray2 = algorithmData.getMatrix((String)"variances").A;
            sVMCentroidViewer.setMeans(fArray);
            sVMCentroidViewer.setVariances(fArray2);
            SVMCentroidsViewer sVMCentroidsViewer = new SVMCentroidsViewer(this.experimentMap, nArray);
            sVMCentroidsViewer.setMeans(fArray);
            sVMCentroidsViewer.setVariances(fArray2);
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Positives", (IViewer)sVMCentroidViewer, new CentroidUserObject(0, 1))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Negatives", (IViewer)sVMCentroidViewer, new CentroidUserObject(1, 1))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Both Groups", (IViewer)sVMCentroidsViewer, new Integer(1))));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Positives", (IViewer)sVMCentroidViewer, new CentroidUserObject(0, 0))));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Negatives", (IViewer)sVMCentroidViewer, new CentroidUserObject(1, 0))));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Both Groups", (IViewer)sVMCentroidsViewer, new Integer(0))));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
            return defaultMutableTreeNode;
        }
        SVMExperimentClusterCentroidViewer sVMExperimentClusterCentroidViewer = new SVMExperimentClusterCentroidViewer(this.experimentMap, nArray);
        float[][] fArray = algorithmData.getMatrix((String)"means").A;
        float[][] fArray3 = algorithmData.getMatrix((String)"variances").A;
        sVMExperimentClusterCentroidViewer.setMeans(fArray);
        sVMExperimentClusterCentroidViewer.setVariances(fArray3);
        SVMExperimentClusterCentroidsViewer sVMExperimentClusterCentroidsViewer = new SVMExperimentClusterCentroidsViewer(this.experimentMap, nArray);
        sVMExperimentClusterCentroidsViewer.setMeans(fArray);
        sVMExperimentClusterCentroidsViewer.setVariances(fArray3);
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Positives", (IViewer)sVMExperimentClusterCentroidViewer, new CentroidUserObject(0, 1))));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Negatives", (IViewer)sVMExperimentClusterCentroidViewer, new CentroidUserObject(1, 1))));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Both Groups", (IViewer)sVMExperimentClusterCentroidsViewer, new Integer(1))));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Positives", (IViewer)sVMExperimentClusterCentroidViewer, new CentroidUserObject(0, 0))));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Negatives", (IViewer)sVMExperimentClusterCentroidViewer, new CentroidUserObject(1, 0))));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Both Groups", (IViewer)sVMExperimentClusterCentroidsViewer, new Integer(0))));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode createHierarchicalTreeViews(Cluster cluster, AlgorithmData algorithmData) {
        if (!this.data.calculateHCL) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = cluster.getNodeList();
        String string = "Positives";
        int[][] nArray = null;
        if (!this.classifyGenes) {
            nArray = this.getClassificationIndices(algorithmData.getIntArray("positives"), algorithmData.getIntArray("negatives"));
            if (this.data.calcSampleHCL) {
                nArray = this.getOrderedIndices(nodeList, nArray, this.data.calcGeneHCL);
            }
        }
        for (int i = 0; i < nodeList.getSize(); ++i) {
            if (i > 0) {
                string = "Negatives";
            }
            if (this.classifyGenes) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo(string, this.createHCLViewer(nodeList.getNode(i), algorithmData, nArray))));
                continue;
            }
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo(string, this.createHCLViewer(nodeList.getNode(i), algorithmData, nArray), new Integer(i))));
        }
        return defaultMutableTreeNode;
    }

    private IViewer createHCLViewer(Node node, AlgorithmData algorithmData, int[][] nArray) {
        HCLTreeData hCLTreeData;
        HCLTreeData hCLTreeData2;
        HCLTreeData hCLTreeData3 = hCLTreeData2 = this.data.calcGeneHCL ? this.getResult(node, 0) : null;
        HCLTreeData hCLTreeData4 = this.data.calcSampleHCL ? this.getResult(node, this.data.calcGeneHCL ? 4 : 0) : (hCLTreeData = null);
        if (this.classifyGenes) {
            return new HCLViewer(this.experimentMap, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData);
        }
        return new HCLViewer(this.experimentMap, node.getFeaturesIndexes(), hCLTreeData2, hCLTreeData, nArray, true);
    }

    private HCLTreeData getResult(Node node, int n) {
        HCLTreeData hCLTreeData = new HCLTreeData();
        NodeValueList nodeValueList = node.getValues();
        hCLTreeData.child_1_array = (int[])nodeValueList.getNodeValue((int)n).value;
        hCLTreeData.child_2_array = (int[])nodeValueList.getNodeValue((int)(n + 1)).value;
        hCLTreeData.node_order = (int[])nodeValueList.getNodeValue((int)(n + 2)).value;
        hCLTreeData.height = (float[])nodeValueList.getNodeValue((int)(n + 3)).value;
        return hCLTreeData;
    }

    private void addSVMParameterNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2;
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("General Information");
        String string = this.SVMMode == TRAIN_ONLY ? "Train SVM Only" : (this.SVMMode == CLASSIFY_ONLY ? "Classify Only" : (this.SVMMode == TRAIN_AND_CLASSIFY ? "Train SVM and Classify" : "One-out Validation"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("SVM Mode: " + string);
        defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        defaultMutableTreeNode4 = new DefaultMutableTreeNode("Kernel Parameters");
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode("Metric: Dot Product on Normalized Vectors"));
        if (!this.data.radial) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode("Kernel Function: Polynomial");
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Constant: " + String.valueOf(this.data.constant)));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Coefficient: " + String.valueOf(this.data.coefficient)));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Power: " + String.valueOf(this.data.power)));
            defaultMutableTreeNode4.add(defaultMutableTreeNode2);
        } else {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode("Kernel Function: Radial Basis (Gausian)");
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Width Factor: " + String.valueOf(this.data.widthFactor)));
            defaultMutableTreeNode4.add(defaultMutableTreeNode2);
        }
        defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        defaultMutableTreeNode4 = new DefaultMutableTreeNode("Training Parameters");
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("Constrain Weights: " + String.valueOf(this.data.constrainWeights));
        if (this.data.constrainWeights) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Positive Constraint: " + String.valueOf(this.data.positiveConstraint)));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Negative Constraint: " + String.valueOf(this.data.negativeConstraint)));
        }
        defaultMutableTreeNode4.add(defaultMutableTreeNode2);
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode("Diagonal Factor: " + String.valueOf(this.data.diagonalFactor)));
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode("Threshold: " + String.valueOf(this.data.convergenceThreshold)));
        defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        if (this.data.calculateHCL) {
            defaultMutableTreeNode4 = new DefaultMutableTreeNode("HCL Parameters");
            string = AbstractAlgorithm.getDistanceName(this.data.distanceFunction);
            defaultMutableTreeNode4.add(new DefaultMutableTreeNode("HCL distance metric: " + string));
            String string2 = this.data.hclMethod == 0 ? "Average Linkage" : (this.data.hclMethod == 1 ? "Complete Linkage" : "Single Linkage");
            defaultMutableTreeNode4.add(new DefaultMutableTreeNode("Linkage Method: " + string2));
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private int[][] getDefaultGeneCluster() {
        int n = this.experimentMap.getNumberOfGenes();
        int[][] nArray = new int[1][n];
        for (int i = 0; i < n; ++i) {
            nArray[0][i] = i;
        }
        return nArray;
    }

    private float[][] getDiscriminants(int[] nArray, int[] nArray2) {
        int n;
        int n2 = this.discriminantMatrix.getRowDimension();
        float[][] fArray = this.discriminantMatrix.A;
        float[] fArray2 = new float[n2];
        for (int i = 0; i < n2; ++i) {
            fArray2[i] = fArray[i][1];
        }
        float[][] fArrayArray = new float[][]{new float[nArray.length], new float[nArray2.length]};
        for (n = 0; n < nArray.length; ++n) {
            fArrayArray[0][n] = fArray2[nArray[n]];
        }
        for (n = 0; n < nArray2.length; ++n) {
            fArrayArray[1][n] = fArray2[nArray2[n]];
        }
        return fArrayArray;
    }

    private int[][] getOrderedClassIndices(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[][] nArrayArray = new int[][]{new int[nArray.length + nArray2.length], new int[nArray3.length + nArray4.length]};
        System.arraycopy(nArray, 0, nArrayArray[0], 0, nArray.length);
        System.arraycopy(nArray2, 0, nArrayArray[0], nArray.length, nArray2.length);
        System.arraycopy(nArray3, 0, nArrayArray[1], 0, nArray3.length);
        System.arraycopy(nArray4, 0, nArrayArray[1], nArray3.length, nArray4.length);
        return nArrayArray;
    }

    private int[][] getTruePositives(int[] nArray, int[] nArray2) {
        int n;
        int[][] nArray3 = null;
        Vector<Integer> vector = new Vector<Integer>();
        for (n = 0; n < nArray.length; ++n) {
            if (nArray2[nArray[n]] != 1) continue;
            vector.add(new Integer(nArray[n]));
        }
        nArray3 = new int[1][vector.size()];
        for (n = 0; n < nArray3[0].length; ++n) {
            nArray3[0][n] = (Integer)vector.elementAt(n);
        }
        return nArray3;
    }

    private int[][] getFalseNegatives(int[] nArray, int[] nArray2) {
        int n;
        int[][] nArray3 = null;
        Vector<Integer> vector = new Vector<Integer>();
        for (n = 0; n < nArray.length; ++n) {
            if (nArray2[nArray[n]] > 0) continue;
            vector.add(new Integer(nArray[n]));
        }
        nArray3 = new int[1][vector.size()];
        for (n = 0; n < nArray3[0].length; ++n) {
            nArray3[0][n] = (Integer)vector.elementAt(n);
        }
        return nArray3;
    }

    private int[][] getFalsePositives(int[] nArray, int[] nArray2) {
        int n;
        int[][] nArray3 = null;
        Vector<Integer> vector = new Vector<Integer>();
        for (n = 0; n < nArray.length; ++n) {
            if (nArray2[nArray[n]] != 1) continue;
            vector.add(new Integer(nArray[n]));
        }
        nArray3 = new int[1][vector.size()];
        for (n = 0; n < nArray3[0].length; ++n) {
            nArray3[0][n] = (Integer)vector.elementAt(n);
        }
        return nArray3;
    }

    private int[][] getTrueNegatives(int[] nArray, int[] nArray2) {
        int n;
        int[][] nArray3 = null;
        Vector<Integer> vector = new Vector<Integer>();
        for (n = 0; n < nArray.length; ++n) {
            if (nArray2[nArray[n]] > 0) continue;
            vector.add(new Integer(nArray[n]));
        }
        nArray3 = new int[1][vector.size()];
        for (n = 0; n < nArray3[0].length; ++n) {
            nArray3[0][n] = (Integer)vector.elementAt(n);
        }
        return nArray3;
    }

    private int getNumberOfPositiveExamples(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != 1) continue;
            ++n;
        }
        return n;
    }

    private int getNumberOfNegativeExamples(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != -1) continue;
            ++n;
        }
        return n;
    }

    private int getNumPosRecFromNeutrals(int[] nArray, int[] nArray2) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray2[nArray[i]] != 0) continue;
            ++n;
        }
        return n;
    }

    private int getNumNegRecFromNeutrals(int[] nArray, int[] nArray2) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray2[nArray[i]] != 0) continue;
            ++n;
        }
        return n;
    }

    private int[][] getClassificationIndices(int[] nArray, int[] nArray2) {
        int[][] nArrayArray = new int[][]{nArray, nArray2};
        return nArrayArray;
    }

    private void accumulateResult(FloatMatrix floatMatrix, int n) {
        for (int i = 0; i < this.discriminantMatrix.getColumnDimension(); ++i) {
            floatMatrix.set(n, i, this.discriminantMatrix.get(n, i));
        }
    }

    private float[] toFloatArray(int[] nArray) {
        float[] fArray = new float[nArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = nArray[i];
        }
        return fArray;
    }

    private int getNumberOfNonNeutrals() {
        int n = 0;
        for (int i = 0; i < this.classes.length; ++i) {
            if (this.classes[i] == 0) continue;
            ++n;
        }
        return n;
    }

    protected void showLogger(String string) {
        if (this.logger == null) {
            this.logger = new Logger(this.parentFrame, string, this.listener);
            this.logger.show();
        }
    }

    private int[][] getOrderedIndices(NodeList nodeList, int[][] nArray, boolean bl) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i].length <= 0) continue;
            HCLTreeData hCLTreeData = this.getResult(nodeList.getNode(i), bl ? 4 : 0);
            nArray[i] = this.getSampleOrder(hCLTreeData, nArray[i]);
        }
        return nArray;
    }

    private int[] getSampleOrder(HCLTreeData hCLTreeData, int[] nArray) {
        return this.getLeafOrder(hCLTreeData.node_order, hCLTreeData.child_1_array, hCLTreeData.child_2_array, nArray);
    }

    private int[] getLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = new int[nArray.length];
        Arrays.fill(nArray5, -1);
        this.fillLeafOrder(nArray5, nArray2, nArray3, 0, nArray2.length - 2, nArray4);
        return nArray5;
    }

    private int fillLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int[] nArray4) {
        if (nArray2[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray2[n2], nArray4);
        }
        if (nArray3[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray3[n2], nArray4);
        } else {
            nArray[n] = nArray4 == null ? n2 : nArray4[n2];
            ++n;
        }
        return n;
    }

    private int[] getPositives(FloatMatrix floatMatrix) {
        int n = 0;
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            if ((double)floatMatrix.get(i, 0) != 1.0) continue;
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            if ((double)floatMatrix.get(i, 0) != 1.0) continue;
            nArray[n] = i;
            ++n;
        }
        return nArray;
    }

    private int[] getNegatives(FloatMatrix floatMatrix) {
        int n = 0;
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            if (!(floatMatrix.get(i, 0) <= 0.0f)) continue;
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            if (!(floatMatrix.get(i, 0) <= 0.0f)) continue;
            nArray[n] = i;
            ++n;
        }
        return nArray;
    }

    private FloatMatrix getMeans(FloatMatrix floatMatrix) {
        FloatMatrix floatMatrix2 = this.experiment.getExperiment().getMatrix();
        if (!this.classifyGenes) {
            floatMatrix2 = floatMatrix2.transpose();
        }
        int n = floatMatrix2.getColumnDimension();
        int n2 = floatMatrix2.getRowDimension();
        FloatMatrix floatMatrix3 = new FloatMatrix(2, n);
        float f = 0.0f;
        float f2 = 0.0f;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                float f3;
                float f4 = floatMatrix.get(j, 0);
                if (f4 == 1.0f) {
                    f3 = floatMatrix2.get(j, i);
                    if (Float.isNaN(f3)) continue;
                    ++n3;
                    f += f3;
                    continue;
                }
                f3 = floatMatrix2.get(j, i);
                if (Float.isNaN(f3)) continue;
                ++n4;
                f2 += f3;
            }
            floatMatrix3.set(0, i, n3 != 0 ? f / (float)n3 : 0.0f);
            floatMatrix3.set(1, i, n4 != 0 ? f2 / (float)n4 : 0.0f);
            n3 = 0;
            n4 = 0;
            f = 0.0f;
            f2 = 0.0f;
        }
        return floatMatrix3;
    }

    private FloatMatrix getVariance(FloatMatrix floatMatrix, FloatMatrix floatMatrix2) {
        FloatMatrix floatMatrix3 = this.experiment.getExperiment().getMatrix();
        if (!this.classifyGenes) {
            floatMatrix3 = floatMatrix3.transpose();
        }
        int n = floatMatrix3.getColumnDimension();
        int n2 = floatMatrix3.getRowDimension();
        FloatMatrix floatMatrix4 = new FloatMatrix(2, n);
        float f = 0.0f;
        int n3 = 0;
        float f2 = 0.0f;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                float f3;
                float f4 = floatMatrix.get(j, 0);
                if (f4 == 1.0f) {
                    f3 = floatMatrix3.get(j, i);
                    if (Float.isNaN(f3)) continue;
                    f = (float)((double)f + Math.pow(f3 - floatMatrix2.get(0, i), 2.0));
                    ++n3;
                    continue;
                }
                f3 = floatMatrix3.get(j, i);
                if (Float.isNaN(f3)) continue;
                f2 = (float)((double)f2 + Math.pow(f3 - floatMatrix2.get(1, i), 2.0));
                ++n4;
            }
            floatMatrix4.set(0, i, (float)(n3 > 1 ? Math.sqrt(f / (float)(n3 - 1)) : 0.0));
            floatMatrix4.set(1, i, (float)(n4 > 1 ? Math.sqrt(f2 / (float)(n4 - 1)) : 0.0));
            n3 = 0;
            n4 = 0;
            f = 0.0f;
            f2 = 0.0f;
        }
        return floatMatrix4;
    }

    private void calculateHCL(AlgorithmData algorithmData, FloatMatrix floatMatrix) throws AbortException, AlgorithmException {
        int[][] nArrayArray = new int[][]{this.getPositives(floatMatrix), this.getNegatives(floatMatrix)};
        if (this.data.calculateHCL) {
            Cluster cluster = new Cluster();
            NodeList nodeList = cluster.getNodeList();
            for (int i = 0; i < nArrayArray.length; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                int[] nArray = nArrayArray[i];
                Node node = new Node(nArray);
                nodeList.addNode(node);
                node.setValues(this.calculateHierarchicalTree(nArray, this.data.hclMethod, this.data.calcGeneHCL, this.data.calcSampleHCL));
            }
            algorithmData.addCluster("cluster", cluster);
        }
    }

    private NodeValueList calculateHierarchicalTree(int[] nArray, int n, boolean bl, boolean bl2) throws AlgorithmException {
        AlgorithmData algorithmData;
        FloatMatrix floatMatrix;
        NodeValueList nodeValueList = new NodeValueList();
        AlgorithmData algorithmData2 = new AlgorithmData();
        FloatMatrix floatMatrix2 = this.experimentMap.getMatrix();
        if (this.data.classifyGenes) {
            floatMatrix = this.getSubExperiment(floatMatrix2, nArray);
        } else {
            floatMatrix2 = floatMatrix2.transpose();
            floatMatrix = this.getSubExperimentReducedCols(floatMatrix2, nArray);
        }
        algorithmData2.addMatrix("experiment", floatMatrix);
        algorithmData2.addParam("distance-function", String.valueOf(this.data.distanceFunction));
        algorithmData2.addParam("distance-absolute", String.valueOf(this.framework.getDistanceMenu().isAbsoluteDistance()));
        algorithmData2.addParam("method-linkage", String.valueOf(this.data.hclMethod));
        Algorithm algorithm = this.framework.getAlgorithmFactory().getAlgorithm("HCL");
        if (bl) {
            algorithmData2.addParam("calculate-genes", String.valueOf(true));
            algorithmData = algorithm.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        if (bl2) {
            algorithmData2.addParam("calculate-genes", String.valueOf(false));
            algorithmData = algorithm.execute(algorithmData2);
            int[] nArray2 = algorithmData.getIntArray("node-order");
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        return nodeValueList;
    }

    private void addNodeValues(NodeValueList nodeValueList, AlgorithmData algorithmData) {
        nodeValueList.addNodeValue(new NodeValue("child-1-array", algorithmData.getIntArray("child-1-array")));
        nodeValueList.addNodeValue(new NodeValue("child-2-array", algorithmData.getIntArray("child-2-array")));
        nodeValueList.addNodeValue(new NodeValue("node-order", algorithmData.getIntArray("node-order")));
        nodeValueList.addNodeValue(new NodeValue("height", algorithmData.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(nArray.length, floatMatrix.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix2.A[i] = floatMatrix.A[nArray[i]];
        }
        return floatMatrix2;
    }

    private FloatMatrix getSubExperimentReducedCols(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = floatMatrix.copy();
        FloatMatrix floatMatrix3 = new FloatMatrix(nArray.length, floatMatrix2.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix3.A[i] = floatMatrix2.A[nArray[i]];
        }
        floatMatrix3 = floatMatrix3.transpose();
        return floatMatrix3;
    }

    private void validate(AlgorithmData algorithmData) throws AlgorithmException {
        if (algorithmData.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (algorithmData.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (algorithmData.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (algorithmData.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(ArrayList arrayList) {
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)((Float)arrayList.get(i)).floatValue();
        }
        return nArray;
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            int n = algorithmEvent.getId();
            switch (n) {
                case 1: {
                    break;
                }
                case 2: {
                    SVMGUI.this.logger.append(algorithmEvent.getDescription());
                    break;
                }
                case 3: {
                    if (SVMGUI.this.monitor == null) {
                        SVMGUI.this.monitor = new Monitor(SVMGUI.this.parentFrame, "Convergence", 75, 125, 0.1 / (double)SVMGUI.this.data.convergenceThreshold);
                        SVMGUI.this.monitor.show();
                        break;
                    }
                    SVMGUI.this.monitor.update(algorithmEvent.getFloatValue());
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                SVMGUI.this.algorithm.abort();
                if (SVMGUI.this.monitor != null) {
                    SVMGUI.this.monitor.dispose();
                }
                if (SVMGUI.this.logger != null) {
                    SVMGUI.this.logger.dispose();
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            SVMGUI.this.algorithm.abort();
            if (SVMGUI.this.monitor != null) {
                SVMGUI.this.monitor.dispose();
            }
            if (SVMGUI.this.logger != null) {
                SVMGUI.this.logger.dispose();
            }
        }
    }
}

