/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.TransformGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.KeyMotionBehavior;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.NavigationPanel;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.SliderBehavior;

public class ControlPanel
extends JPanel
implements ChangeListener {
    private SliderBehavior sliderBehavior;
    private JLabel label;
    private double scale = 0.01;
    private double curSliderValue = 0.0;

    public ControlPanel(TransformGroup transformGroup, KeyMotionBehavior keyMotionBehavior, BoundingLeaf boundingLeaf) {
        this.setBorder(new BevelBorder(0));
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(110, 130));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.label = new JLabel("Map position: 0.0");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.label, gridBagConstraints);
        this.sliderBehavior = this.createSliderBehavior(transformGroup, boundingLeaf, this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.sliderBehavior.getSlider(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)new NavigationPanel(keyMotionBehavior), gridBagConstraints);
    }

    public Behavior getSliderBehavior() {
        return this.sliderBehavior;
    }

    public double getSliderValue() {
        return this.curSliderValue;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.curSliderValue = this.scale * (double)((JSlider)changeEvent.getSource()).getValue();
        this.label.setText("Map position: " + String.valueOf(this.curSliderValue));
    }

    protected SliderBehavior createSliderBehavior(TransformGroup transformGroup, BoundingLeaf boundingLeaf, ChangeListener changeListener) {
        SliderBehavior sliderBehavior = new SliderBehavior(transformGroup);
        sliderBehavior.setSchedulingBoundingLeaf(boundingLeaf);
        sliderBehavior.getSlider().addChangeListener(changeListener);
        sliderBehavior.setOrientation(0);
        sliderBehavior.setMinimum(-30);
        sliderBehavior.setMaximum(30);
        sliderBehavior.setValue(0);
        sliderBehavior.setScale(this.scale);
        return sliderBehavior;
    }
}

