/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.TerrainInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.TerrainViewer;
import org.tigr.util.FloatMatrix;

public class TerrainGUI
implements IClusterGUI {
    private Algorithm algorithm;
    private Progress progress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        TerrainInitDialog terrainInitDialog = new TerrainInitDialog(iFramework.getFrame());
        if (terrainInitDialog.showModal() != 0) {
            return null;
        }
        boolean bl = terrainInitDialog.isGenes();
        int n = terrainInitDialog.getNeighbours();
        AlgorithmData algorithmData = new AlgorithmData();
        FloatMatrix floatMatrix = iFramework.getData().getExperiment().getMatrix();
        algorithmData.addMatrix("experiment", floatMatrix);
        algorithmData.addParam("distance-factor", String.valueOf(1.0f));
        algorithmData.addParam("distance-absolute", String.valueOf(iFramework.getDistanceMenu().isAbsoluteDistance()));
        int n2 = iFramework.getDistanceMenu().getDistanceFunction();
        n2 = n2 == 0 ? 7 : n2;
        algorithmData.addParam("distance-function", String.valueOf(n2));
        algorithmData.addParam("neighbours", String.valueOf(n));
        algorithmData.addParam("use-genes", String.valueOf(bl));
        GeneralInfo generalInfo = new GeneralInfo();
        generalInfo.function = iFramework.getDistanceMenu().getFunctionName(n2);
        generalInfo.absolute = iFramework.getDistanceMenu().isAbsoluteDistance();
        generalInfo.neighbours = n;
        generalInfo.isGenes = bl;
        Listener listener = new Listener();
        this.progress = new Progress(iFramework.getFrame(), "Calculating Terrain", listener);
        this.progress.show();
        try {
            this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("Terrain");
            this.algorithm.addAlgorithmListener(listener);
            long l = System.currentTimeMillis();
            AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
            generalInfo.time = System.currentTimeMillis() - l;
            this.progress.setDescription("Creating 3D View...");
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(algorithmData2, generalInfo, iFramework);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener(listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private DefaultMutableTreeNode createResultTree(AlgorithmData algorithmData, GeneralInfo generalInfo, IFramework iFramework) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Terrain");
        this.addTerrainView(defaultMutableTreeNode, algorithmData, iFramework, generalInfo);
        this.addGeneralInfo(defaultMutableTreeNode, generalInfo);
        return defaultMutableTreeNode;
    }

    private void addTerrainView(DefaultMutableTreeNode defaultMutableTreeNode, AlgorithmData algorithmData, IFramework iFramework, GeneralInfo generalInfo) throws AlgorithmException {
        FloatMatrix floatMatrix = algorithmData.getMatrix("locations");
        this.checkLocations(floatMatrix.A);
        Cluster cluster = algorithmData.getCluster("links");
        int[][] nArray = this.convert2int(cluster);
        float[][] fArray = this.convert2float(cluster);
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        float f = algorithmParameters.getFloat("sigma");
        TerrainViewer terrainViewer = new TerrainViewer(generalInfo.isGenes, iFramework, nArray, fArray, floatMatrix.A, f);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Map", terrainViewer)));
    }

    private void checkLocations(float[][] fArray) throws AlgorithmException {
        if (fArray == null) {
            throw new AlgorithmException("Locations is null.");
        }
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[i].length; ++j) {
                if (!Float.isNaN(fArray[i][j])) continue;
                throw new AlgorithmException("Location[" + i + "][" + j + "] is NaN.");
            }
        }
    }

    private void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, GeneralInfo generalInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Time: " + String.valueOf(generalInfo.time) + " ms"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Distance: " + generalInfo.function));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Absolute: " + generalInfo.absolute));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Neighbours: " + generalInfo.neighbours));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Data Type: " + (generalInfo.isGenes ? "Genes" : "Experiments")));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private int[][] convert2int(Cluster cluster) throws AlgorithmException {
        NodeList nodeList = cluster.getNodeList();
        int n = nodeList.getSize();
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n; ++i) {
            nArrayArray[i] = nodeList.getNode(i).getFeaturesIndexes();
            if (nArrayArray[i] != null) continue;
            throw new AlgorithmException("Cluster " + i + " does not contain indices.");
        }
        return nArrayArray;
    }

    private float[][] convert2float(Cluster cluster) throws AlgorithmException {
        NodeList nodeList = cluster.getNodeList();
        int n = nodeList.getSize();
        float[][] fArrayArray = new float[n][];
        int n2 = 0;
        try {
            for (n2 = 0; n2 < n; ++n2) {
                fArrayArray[n2] = (float[])nodeList.getNode((int)n2).getValues().getNodeValue((int)0).value;
                if (fArrayArray[n2] != null) continue;
                throw new Exception();
            }
        }
        catch (Exception exception) {
            throw new AlgorithmException("Cluster " + n2 + " does not contain weights.");
        }
        return fArrayArray;
    }

    private class GeneralInfo {
        public long time;
        public String function;
        public boolean absolute;
        public int neighbours;
        public boolean isGenes;

        private GeneralInfo() {
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            switch (algorithmEvent.getId()) {
                case 1: {
                    TerrainGUI.this.progress.setUnits(algorithmEvent.getIntValue());
                    TerrainGUI.this.progress.setDescription(algorithmEvent.getDescription());
                    break;
                }
                case 2: {
                    TerrainGUI.this.progress.setValue(algorithmEvent.getIntValue());
                    TerrainGUI.this.progress.setDescription(algorithmEvent.getDescription());
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                TerrainGUI.this.algorithm.abort();
                TerrainGUI.this.progress.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            TerrainGUI.this.algorithm.abort();
            TerrainGUI.this.progress.dispose();
        }
    }
}

