/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.tigr.util.StringSplitter;

public class GenepixFileParser
extends Thread {
    private final int FIRST_NUM = 1;
    private final String BLOCK = "\"Block\"";
    private final String BLOCK_N = "Block";
    private final String COLUMN = "\"Column\"";
    private final String COLUMN_N = "Column";
    private final String F_PIX = "\"F Pixels\"";
    private final String F_PIX_N = "F Pixels";
    private final String ID = "\"ID\"";
    private final String ID_N = "ID";
    private final String NAME = "\"Name\"";
    private final String NAME_N = "Name";
    private final String RW = "\"Row\"";
    private final String ROW_N = "Row";
    private final String WAVE_KEY_1 = "ImageName";
    private final String WAVE_KEY_2 = "Wavelengths";
    private boolean ready;
    private boolean hasError;
    private File gprFile;
    private int taskEnd;
    private int counter;
    private int fPixAddr;
    private String errorMsg;
    private String chA;
    private String chB;
    private String chAn;
    private String chBn;
    private String chAs;
    private String chAsn;
    private String chBs;
    private String chBsn;
    private String bgChA;
    private String bgChB;
    private String bgChAn;
    private String bgChBn;
    private Vector tavFile;

    public GenepixFileParser() {
        this(new String(""));
    }

    public GenepixFileParser(String string) {
        this(new File(string));
    }

    public GenepixFileParser(File file) {
        this(file, false);
    }

    public GenepixFileParser(String string, boolean bl) {
        this(new File(string), bl);
    }

    public GenepixFileParser(File file, boolean bl) {
        if (file != null) {
            this.gprFile = file;
            this.errorMsg = new String("");
            this.ready = false;
            this.hasError = false;
            this.taskEnd = 0;
            if (!bl) {
                this.startLoad();
            }
        }
    }

    public int getCurrentStep() {
        return this.counter;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public int getProgressEnd() {
        return this.taskEnd;
    }

    public Vector getTavFile() {
        return this.tavFile;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public boolean isCompleted() {
        return this.ready;
    }

    public void run() {
        this.startLoad();
    }

    public static void main(String[] stringArray) {
        if (stringArray != null) {
            GenepixFileParser genepixFileParser = new GenepixFileParser(stringArray[0]);
        } else {
            GenepixFileParser genepixFileParser = new GenepixFileParser();
        }
    }

    private String calculateDensity(String[] stringArray, int n, int n2, int n3) {
        String string = new String("");
        float f = Float.parseFloat(stringArray[n]);
        float f2 = Float.parseFloat(stringArray[n3]);
        float f3 = Float.parseFloat(stringArray[this.fPixAddr]);
        float f4 = Float.parseFloat(stringArray[n2]);
        int n4 = (int)(f3 * (f - f2) * (1.0f - (f4 /= 100.0f)));
        string = string + n4;
        return string;
    }

    private void defineKeys(String[] stringArray) {
        this.chA = new String("\"F" + stringArray[0] + " Median\"");
        this.chB = new String("\"F" + stringArray[1] + " Median\"");
        this.chAs = new String("\"F" + stringArray[0] + " % Sat.\"");
        this.chBs = new String("\"F" + stringArray[1] + " % Sat.\"");
        this.bgChA = new String("\"B" + stringArray[0] + " Median\"");
        this.bgChB = new String("\"B" + stringArray[1] + " Median\"");
        this.chAn = new String("F" + stringArray[0] + " Median");
        this.chBn = new String("F" + stringArray[1] + " Median");
        this.chAsn = new String("F" + stringArray[0] + " % Sat.");
        this.chBsn = new String("F" + stringArray[1] + " % Sat.");
        this.bgChAn = new String("B" + stringArray[0] + " Median");
        this.bgChBn = new String("B" + stringArray[1] + " Median");
    }

    private int findRightCol(String[] stringArray, String string, String string2) {
        int n = 0;
        int n2 = stringArray.length;
        String string3 = new String("");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string) && !stringArray[i].equalsIgnoreCase(string2)) continue;
            n = i;
            i = stringArray.length;
        }
        return n;
    }

    private String[] getWaveLengths(String string) {
        String[] stringArray = new String[2];
        String string2 = new String(string.substring(string.indexOf(61) + 1, string.lastIndexOf(34)));
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!this.isNumber(string3)) continue;
            stringArray[n] = new String(string3);
            ++n;
        }
        return stringArray;
    }

    private boolean isChar(char c) {
        boolean bl = true;
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    private boolean isNumber(String string) {
        boolean bl = true;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (!this.isChar(string.charAt(i))) continue;
            bl = false;
            i = n;
        }
        return bl;
    }

    private boolean isWaveLengthDefination(String string) {
        String string2 = string;
        if (string2.charAt(0) == '\"' && string2.indexOf(61) > 0) {
            return (string2 = string2.substring(1, string2.indexOf(61))).equalsIgnoreCase("ImageName") || string2.equalsIgnoreCase("Wavelengths");
        }
        return false;
    }

    private Vector readGenePixFile() {
        BufferedReader bufferedReader = null;
        Vector<String> vector = new Vector<String>(2000, 500);
        String string = new String("");
        try {
            FileInputStream fileInputStream = new FileInputStream(this.gprFile);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        }
        catch (IOException iOException) {
            this.hasError = true;
            this.errorMsg = "Failed to open " + this.gprFile.getName() + ": " + iOException.getMessage();
            return vector;
        }
        try {
            while ((string = bufferedReader.readLine()) != null) {
                vector.add(string);
            }
        }
        catch (IOException iOException) {
            this.hasError = true;
            this.errorMsg = "Failed to read " + this.gprFile.getName() + ": " + iOException.getMessage();
            vector.removeAllElements();
            return vector;
        }
        return vector;
    }

    private String removeAllEndSpaces(String string) {
        String string2;
        block1: {
            string2 = new String(string);
            if (string2.length() <= 0) break block1;
            while (string2.charAt(string2.length() - 1) == ' ' && (string2 = string2.substring(0, string2.length() - 1)).length() > 0) {
            }
        }
        return string2;
    }

    private String removeAllHeadSpaces(String string) {
        String string2;
        block1: {
            boolean bl = false;
            string2 = new String(string);
            int n = string2.length();
            if (n <= 0) break block1;
            while (string2.charAt(0) == ' ' && (string2 = string2.substring(1)).length() > 0) {
            }
        }
        return string2;
    }

    private String[] separateLine(String string) {
        String string2 = new String("");
        StringSplitter stringSplitter = new StringSplitter('\t');
        stringSplitter.init(string);
        int n = stringSplitter.countTokens() + 1;
        int n2 = 0;
        String[] stringArray = new String[n];
        if (n > 1) {
            while (stringSplitter.hasMoreTokens()) {
                string2 = stringSplitter.nextToken();
                string2 = this.removeAllEndSpaces(string2);
                string2 = this.removeAllHeadSpaces(string2);
                stringArray[n2++] = string2;
            }
        }
        return stringArray;
    }

    private void startLoad() {
        String string = new String("");
        String string2 = new String("");
        String string3 = new String("");
        String string4 = new String("");
        String string5 = new String("");
        String[] stringArray = new String[2];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Vector vector = this.readGenePixFile();
        this.taskEnd = vector.size();
        if (this.taskEnd <= 0) {
            return;
        }
        this.counter = 0;
        boolean bl = true;
        int n4 = vector.size();
        int n5 = 0;
        boolean bl2 = true;
        while (bl2) {
            string = (String)vector.elementAt(n5);
            if (string.charAt(0) == '\"' || this.isChar(string.charAt(0))) {
                if (this.isWaveLengthDefination(string)) {
                    stringArray = this.getWaveLengths(string);
                }
                bl2 = true;
                ++n5;
                continue;
            }
            if (n5 == 1) {
                bl2 = true;
                ++n5;
                continue;
            }
            bl2 = false;
        }
        this.defineKeys(stringArray);
        string = (String)vector.elementAt(n5 - 1);
        String[] stringArray2 = this.separateLine(string);
        int n6 = this.findRightCol(stringArray2, "\"Block\"", "Block");
        int n7 = this.findRightCol(stringArray2, "\"Column\"", "Column");
        int n8 = this.findRightCol(stringArray2, "\"Row\"", "Row");
        int n9 = this.findRightCol(stringArray2, "\"Name\"", "Name");
        int n10 = this.findRightCol(stringArray2, "\"ID\"", "ID");
        string = (String)vector.elementAt(n4 - 1);
        String[] stringArray3 = this.separateLine(string);
        if (stringArray3.length > 2) {
            n = Integer.parseInt(stringArray3[n6]);
            n3 = Integer.parseInt(stringArray3[n7]);
            n2 = Integer.parseInt(stringArray3[n8]);
        } else {
            JOptionPane.showMessageDialog(null, "You might add extra space at the end of file.\n(" + this.gprFile.getName() + "). \nPlease remove it and reload again.", "GenePix File Loader", 0);
            bl = false;
        }
        if (bl) {
            int n11 = n <= 12 ? 2 : 4;
            bl = true;
            if (n * n3 * n2 + n5 != vector.size()) {
                JOptionPane.showMessageDialog(null, "You might have dropped some of your spots in the file \n(" + this.gprFile.getName() + ".\nThe GenePix Loader requires an original gpr file.", "GenePix File Loader", 0);
                bl = false;
            }
            if (bl) {
                this.fPixAddr = this.findRightCol(stringArray2, "\"F Pixels\"", "F Pixels");
                int n12 = this.findRightCol(stringArray2, this.chA, this.chAn);
                int n13 = this.findRightCol(stringArray2, this.chAs, this.chAsn);
                int n14 = this.findRightCol(stringArray2, this.bgChA, this.bgChAn);
                int n15 = this.findRightCol(stringArray2, this.chB, this.chBn);
                int n16 = this.findRightCol(stringArray2, this.chBs, this.chBsn);
                int n17 = this.findRightCol(stringArray2, this.bgChB, this.bgChBn);
                this.tavFile = new Vector(n4 - n5, n4 - n5 >> 2);
                this.counter = n5;
                for (int i = n5; i < n4; ++i) {
                    string = (String)vector.elementAt(i);
                    stringArray3 = this.separateLine(string);
                    int n18 = Integer.parseInt(stringArray3[n6]);
                    int n19 = Integer.parseInt(stringArray3[n7]);
                    int n20 = Integer.parseInt(stringArray3[n8]);
                    string2 = this.calculateDensity(stringArray3, n15, n16, n17);
                    string3 = this.calculateDensity(stringArray3, n12, n13, n14);
                    int n21 = (n18 - 1) / n11 + 1;
                    int n22 = (n18 - 1) % n11 + 1;
                    int n23 = (n21 - 1) * n2 + n20;
                    int n24 = (n22 - 1) * n3 + n19;
                    string4 = stringArray3[n9];
                    string5 = stringArray3[n10];
                    Vector<Object> vector2 = new Vector<Object>(8);
                    vector2.add(new Integer(string2));
                    vector2.add(new Integer(string3));
                    vector2.add(new Integer(n23));
                    vector2.add(new Integer(n24));
                    vector2.add(new Integer(n21));
                    vector2.add(new Integer(n22));
                    vector2.add(string4);
                    vector2.add(string5);
                    this.tavFile.add(vector2);
                    ++this.counter;
                }
                this.ready = true;
                this.counter = this.taskEnd;
            }
        }
    }
}

