/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.StringSplitter;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;

public class StanfordFileLoader
extends ExpressionFileLoader {
    private GBA gba = new GBA();
    private boolean stop = false;
    private StanfordFileLoaderPanel sflp = new StanfordFileLoaderPanel();

    public StanfordFileLoader(SuperExpressionFileLoader superExpressionFileLoader) {
        super(superExpressionFileLoader);
    }

    public Vector loadExpressionFiles() throws IOException {
        return this.loadStanfordExpressionFile(new File(this.sflp.fileNameTextField.getText()));
    }

    public ISlideData loadExpressionFile(File file) {
        return null;
    }

    public Vector loadStanfordExpressionFile(File file) throws IOException {
        String string;
        int n = this.sflp.getXRow() + 1;
        int n2 = this.sflp.getXColumn();
        int n3 = this.getCountOfLines(file) - n;
        if (n3 <= 0) {
            JOptionPane.showMessageDialog(this.superLoader.getFrame(), "There is no spot data available.", "Stanford Load Error", 1);
        }
        int[] nArray = new int[]{0, 1, 0};
        int[] nArray2 = new int[]{0, 1, 0};
        String[] stringArray = new String[n2];
        int n4 = n3;
        ISlideData[] iSlideDataArray = null;
        int n5 = this.getCountOfLines(file);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        StringSplitter stringSplitter = new StringSplitter('\t');
        int n6 = 0;
        int n7 = 1;
        int n8 = 1;
        this.setFilesCount(1);
        this.setFilesProgress(0);
        this.setLinesCount(n5);
        this.setFileProgress(0);
        while ((string = bufferedReader.readLine()) != null) {
            Object object;
            int n9;
            if (this.stop) {
                return null;
            }
            stringSplitter.init(string);
            if (n6 == 0) {
                int n10;
                n9 = stringSplitter.countTokens() + 1 - n2;
                iSlideDataArray = new ISlideData[n9];
                iSlideDataArray[0] = new SlideData(n4, 1);
                for (int i = 1; i < iSlideDataArray.length; ++i) {
                    iSlideDataArray[i] = new FloatSlideData(iSlideDataArray[0].getSlideMetaData(), n3);
                }
                object = new String[n2];
                for (n10 = 0; n10 < n2; ++n10) {
                    object[n10] = stringSplitter.nextToken();
                }
                TMEV.setFieldNames(object);
                for (n10 = 0; n10 < n9; ++n10) {
                    iSlideDataArray[n10].setSlideDataName(stringSplitter.nextToken() + " " + file.getName());
                }
            } else if (n6 >= n) {
                nArray[0] = nArray[2] = n8++;
                nArray2[0] = nArray2[2] = n7;
                n7 = n7 == 1 ? 1 : ++n7;
                for (n9 = 0; n9 < n2; ++n9) {
                    stringArray[n9] = stringSplitter.nextToken();
                }
                SlideDataElement slideDataElement = new SlideDataElement(nArray, nArray2, new float[2], stringArray);
                iSlideDataArray[0].addSlideDataElement(slideDataElement);
                for (n9 = 0; n9 < iSlideDataArray.length; ++n9) {
                    float f;
                    float f2 = 100000.0f;
                    try {
                        object = stringSplitter.nextToken();
                        f = (float)(100000.0 * Math.pow(2.0, Float.parseFloat((String)object)));
                        if (Float.parseFloat((String)object) > 50.0f) {
                            System.out.println("value = " + (String)object + " cy5 = " + f);
                        }
                    }
                    catch (Exception exception) {
                        f = 0.0f;
                        f2 = 0.0f;
                    }
                    iSlideDataArray[n9].setIntensities(n6 - n, f2, f);
                }
            }
            this.setFileProgress(n6);
            ++n6;
        }
        bufferedReader.close();
        Vector<ISlideData> vector = new Vector<ISlideData>(iSlideDataArray.length);
        for (int i = 0; i < iSlideDataArray.length; ++i) {
            vector.add(iSlideDataArray[i]);
        }
        this.setFilesProgress(1);
        return vector;
    }

    public FileFilter getFileFilter() {
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith(".txt");
            }

            public String getDescription() {
                return "Stanford Files (*.txt)";
            }
        };
        return fileFilter;
    }

    public boolean checkLoadEnable() {
        int n = this.sflp.getXRow() + 1;
        int n2 = this.sflp.getXColumn();
        if (n2 < 0) {
            return false;
        }
        TableModel tableModel = this.sflp.getTable().getModel();
        String string = "";
        for (int i = 0; i < n2; ++i) {
            string = string + tableModel.getColumnName(i) + (i + 1 == n2 ? "" : ", ");
        }
        this.sflp.setFieldsText(string);
        if (n >= 1 && n2 >= 0) {
            this.setLoadEnabled(true);
            return true;
        }
        this.setLoadEnabled(false);
        return false;
    }

    public boolean validateFile(File file) {
        return true;
    }

    public JPanel getFileLoaderPanel() {
        return this.sflp;
    }

    public void processStanfordFile(File file) {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = new Vector();
        Vector<String> vector3 = null;
        BufferedReader bufferedReader = null;
        String string = null;
        if (!this.validateFile(file)) {
            return;
        }
        this.sflp.setFileName(file.getAbsolutePath());
        DefaultTableModel defaultTableModel = new DefaultTableModel(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        try {
            bufferedReader = new BufferedReader(new FileReader(file), 131072);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        try {
            int n;
            StringSplitter stringSplitter = new StringSplitter('\t');
            string = bufferedReader.readLine();
            stringSplitter.init(string);
            for (n = 0; n < stringSplitter.countTokens() + 1; ++n) {
                vector.add(stringSplitter.nextToken());
            }
            defaultTableModel.setColumnIdentifiers(vector);
            n = 0;
            while ((string = bufferedReader.readLine()) != null && n < 100) {
                ++n;
                stringSplitter.init(string);
                vector3 = new Vector<String>();
                for (int i = 0; i < stringSplitter.countTokens() + 1; ++i) {
                    try {
                        vector3.add(stringSplitter.nextToken());
                        continue;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        vector3.add(" ");
                    }
                }
                vector2.add(vector3);
                defaultTableModel.addRow(vector3);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.sflp.setTableModel(defaultTableModel);
    }

    public void setXColumns(int n) {
        this.sflp.setXColumns(n);
    }

    public void setXRows(int n) {
        this.sflp.setXRows(n);
    }

    private class StanfordFileLoaderPanel
    extends JPanel {
        JTextField fileNameTextField;
        JButton browseButton;
        JPanel fileSelectionPanel;
        JTable expressionTable;
        JLabel instructionsLabel;
        JScrollPane tableScrollPane;
        JPanel tablePanel;
        JPanel fileLoaderPanel;
        JTextField fieldsTextField;
        JPanel fieldsPanel;
        private int xRow = -1;
        private int xColumn = -1;

        public StanfordFileLoaderPanel() {
            this.setLayout(new GridBagLayout());
            this.fileNameTextField = new JTextField();
            this.fileNameTextField.setEditable(false);
            this.fileNameTextField.setForeground(Color.black);
            this.fileNameTextField.setFont(new Font("monospaced", 1, 12));
            this.browseButton = new JButton("File Browser");
            this.browseButton.addActionListener(new EventHandler());
            this.fileSelectionPanel = new JPanel();
            this.fileSelectionPanel.setLayout(new GridBagLayout());
            this.fileSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), "Selected Stanford File"));
            StanfordFileLoader.this.gba.add(this.fileSelectionPanel, this.fileNameTextField, 0, 0, 2, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            StanfordFileLoader.this.gba.add(this.fileSelectionPanel, this.browseButton, 2, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.expressionTable = new JTable();
            this.expressionTable.setCellSelectionEnabled(true);
            this.expressionTable.setColumnSelectionAllowed(false);
            this.expressionTable.setRowSelectionAllowed(false);
            this.expressionTable.setAutoResizeMode(0);
            this.expressionTable.getTableHeader().setReorderingAllowed(false);
            this.expressionTable.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    StanfordFileLoaderPanel.this.xRow = StanfordFileLoaderPanel.this.expressionTable.rowAtPoint(mouseEvent.getPoint());
                    StanfordFileLoaderPanel.this.xColumn = StanfordFileLoaderPanel.this.expressionTable.columnAtPoint(mouseEvent.getPoint());
                    StanfordFileLoader.this.checkLoadEnable();
                }
            });
            this.tableScrollPane = new JScrollPane(this.expressionTable, 22, 32);
            this.instructionsLabel = new JLabel();
            this.instructionsLabel.setForeground(Color.red);
            String string = "<html>Click the upper-leftmost expression value. Click the <b>Load</b> button to finish.</html>";
            this.instructionsLabel.setText(string);
            this.tablePanel = new JPanel();
            this.tablePanel.setLayout(new GridBagLayout());
            this.tablePanel.setBorder(new TitledBorder(new EtchedBorder(), "Expression Table"));
            StanfordFileLoader.this.gba.add(this.tablePanel, this.tableScrollPane, 0, 0, 1, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            StanfordFileLoader.this.gba.add(this.tablePanel, this.instructionsLabel, 0, 2, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.fieldsTextField = new JTextField();
            this.fieldsTextField.setEditable(false);
            this.fieldsTextField.setForeground(Color.black);
            this.fieldsTextField.setFont(new Font("serif", 1, 12));
            this.fieldsPanel = new JPanel();
            this.fieldsPanel.setLayout(new GridBagLayout());
            this.fieldsPanel.setBorder(new TitledBorder(new EtchedBorder(), "Annotation Fields"));
            StanfordFileLoader.this.gba.add(this.fieldsPanel, this.fieldsTextField, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.fileLoaderPanel = new JPanel();
            this.fileLoaderPanel.setLayout(new GridBagLayout());
            StanfordFileLoader.this.gba.add(this.fileLoaderPanel, this.fileSelectionPanel, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            StanfordFileLoader.this.gba.add(this.fileLoaderPanel, this.tablePanel, 0, 1, 1, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            StanfordFileLoader.this.gba.add(this.fileLoaderPanel, this.fieldsPanel, 0, 3, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            StanfordFileLoader.this.gba.add(this, this.fileLoaderPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        }

        public JTable getTable() {
            return this.expressionTable;
        }

        public int getXColumn() {
            return this.xColumn;
        }

        public int getXRow() {
            return this.xRow;
        }

        public void selectStanfordFile() {
            JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir") + "\\Data");
            jFileChooser.setFileFilter(StanfordFileLoader.this.getFileFilter());
            int n = jFileChooser.showDialog(this, "Select");
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                StanfordFileLoader.this.processStanfordFile(file);
            }
        }

        public void setFileName(String string) {
            this.fileNameTextField.setText(string);
        }

        public void setTableModel(TableModel tableModel) {
            this.expressionTable.setModel(tableModel);
            int n = this.expressionTable.getColumnCount();
            for (int i = 0; i < n; ++i) {
                this.expressionTable.getColumnModel().getColumn(i).setMinWidth(75);
            }
        }

        public void setFieldsText(String string) {
            this.fieldsTextField.setText(string);
        }

        public void setXColumns(int n) {
            this.xColumn = n;
        }

        public void setXRows(int n) {
            this.xRow = n;
        }

        private class EventHandler
        implements ActionListener {
            private EventHandler() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == StanfordFileLoaderPanel.this.browseButton) {
                    StanfordFileLoaderPanel.this.selectStanfordFile();
                }
            }
        }
    }
}

