/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.util;

import java.util.Arrays;
import org.tigr.util.FloatMatrix;

public class Adjustment {
    public static void log2Transform(FloatMatrix floatMatrix) {
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < floatMatrix.getColumnDimension(); ++j) {
                float f = floatMatrix.get(i, j);
                if (Float.isNaN(f)) continue;
                if (f > 0.0f) {
                    floatMatrix.set(i, j, (float)(Math.log(f) / 0.69314718));
                    continue;
                }
                floatMatrix.set(i, j, Float.NaN);
            }
        }
    }

    public static void normalizeSpots(FloatMatrix floatMatrix) {
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            Adjustment.normalizeGene(floatMatrix, i);
        }
    }

    public static void divideSpotsRMS(FloatMatrix floatMatrix) {
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            Adjustment.divideGeneByRMS(floatMatrix, i);
        }
    }

    public static void divideSpotsSD(FloatMatrix floatMatrix) {
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            Adjustment.divideGeneBySD(floatMatrix, i);
        }
    }

    public static void meanCenterSpots(FloatMatrix floatMatrix) {
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            Adjustment.meanCenterGene(floatMatrix, i);
        }
    }

    public static void medianCenterSpots(FloatMatrix floatMatrix) {
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            Adjustment.medianCenterGene(floatMatrix, i);
        }
    }

    public static void digitalSpots(FloatMatrix floatMatrix) {
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            Adjustment.makeDigitalGene(floatMatrix, i);
        }
    }

    public static void normalizeExperiments(FloatMatrix floatMatrix) {
        for (int i = 0; i < floatMatrix.getColumnDimension(); ++i) {
            Adjustment.normalizeExperiment(floatMatrix, i);
        }
    }

    public static void divideExperimentsRMS(FloatMatrix floatMatrix) {
        for (int i = 0; i < floatMatrix.getColumnDimension(); ++i) {
            Adjustment.divideExperimentByRMS(floatMatrix, i);
        }
    }

    public static void divideExperimentsSD(FloatMatrix floatMatrix) {
        for (int i = 0; i < floatMatrix.getColumnDimension(); ++i) {
            Adjustment.divideExperimentBySD(floatMatrix, i);
        }
    }

    public static void meanCenterExperiments(FloatMatrix floatMatrix) {
        for (int i = 0; i < floatMatrix.getColumnDimension(); ++i) {
            Adjustment.meanCenterExperiment(floatMatrix, i);
        }
    }

    public static void medianCenterExperiments(FloatMatrix floatMatrix) {
        for (int i = 0; i < floatMatrix.getColumnDimension(); ++i) {
            Adjustment.medianCenterExperiment(floatMatrix, i);
        }
    }

    public static void digitalExperiments(FloatMatrix floatMatrix) {
        for (int i = 0; i < floatMatrix.getColumnDimension(); ++i) {
            Adjustment.makeDigitalExperiment(floatMatrix, i);
        }
    }

    public static void log10toLog2(FloatMatrix floatMatrix) {
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < floatMatrix.getColumnDimension(); ++j) {
                float f = floatMatrix.get(i, j);
                if (Float.isNaN(f)) continue;
                floatMatrix.set(i, j, (float)((double)f / 0.301029995));
            }
        }
    }

    private static void normalizeGene(FloatMatrix floatMatrix, int n) {
        float f;
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        int n3 = floatMatrix.getColumnDimension();
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n, n2);
            if (Float.isNaN(f)) continue;
            d += (double)f;
        }
        d /= (double)n3;
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n, n2);
            if (Float.isNaN(f)) continue;
            d2 += Math.pow((double)f - d, 2.0);
        }
        d2 = Math.sqrt(d2 / (double)(n3 - 1));
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n, n2);
            if (Float.isNaN(f)) continue;
            if (d2 != 0.0) {
                floatMatrix.set(n, n2, (float)(((double)f - d) / d2));
                continue;
            }
            floatMatrix.set(n, n2, (float)(((double)f - d) / (double)1.4E-45f));
        }
    }

    private static void divideGeneByRMS(FloatMatrix floatMatrix, int n) {
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        float f = 0.0f;
        int n3 = floatMatrix.getColumnDimension();
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n, n2);
            if (Float.isNaN(f)) continue;
            d2 += Math.pow(f, 2.0);
        }
        d2 = Math.sqrt(d2 / (double)(n3 - 1));
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n, n2);
            if (Float.isNaN(f)) continue;
            if (d2 != 0.0) {
                floatMatrix.set(n, n2, (float)((double)f / d2));
                continue;
            }
            floatMatrix.set(n, n2, f / Float.MIN_VALUE);
        }
    }

    private static void divideGeneBySD(FloatMatrix floatMatrix, int n) {
        float f;
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        int n3 = floatMatrix.getColumnDimension();
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n, n2);
            if (Float.isNaN(f)) continue;
            d += (double)f;
        }
        d /= (double)n3;
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n, n2);
            if (Float.isNaN(f)) continue;
            d2 += Math.pow((double)f - d, 2.0);
        }
        d2 = Math.sqrt(d2 / (double)(n3 - 1));
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n, n2);
            if (Float.isNaN(f)) continue;
            if (d2 != 0.0) {
                floatMatrix.set(n, n2, (float)((double)f / d2));
                continue;
            }
            floatMatrix.set(n, n2, f / Float.MIN_VALUE);
        }
    }

    public static void meanCenterGene(FloatMatrix floatMatrix, int n) {
        float f;
        int n2;
        double d = 0.0;
        int n3 = floatMatrix.getColumnDimension();
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n, n2);
            if (Float.isNaN(f)) continue;
            d += (double)f;
        }
        d /= (double)n3;
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n, n2);
            if (Float.isNaN(f)) continue;
            floatMatrix.set(n, n2, (float)((double)f - d));
        }
    }

    private static void medianCenterGene(FloatMatrix floatMatrix, int n) {
        float f;
        int n2;
        int n3 = floatMatrix.getColumnDimension();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n, n2);
            if (Float.isNaN(f)) continue;
            ++n4;
        }
        float[] fArray = new float[n4];
        n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n, n2);
            if (Float.isNaN(f)) continue;
            fArray[n4] = f;
            ++n4;
        }
        Arrays.sort(fArray);
        float f2 = 0.0f;
        if (n4 % 2 == 0) {
            if (n4 > 0) {
                f2 = (float)(0.5 * (double)(fArray[n4 / 2 - 1] + fArray[n4 / 2]));
            }
        } else {
            f2 = fArray[(n4 + 1) / 2 - 1];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n, n2);
            if (Float.isNaN(f)) continue;
            floatMatrix.set(n, n2, f - f2);
        }
    }

    private static void makeDigitalGene(FloatMatrix floatMatrix, int n) {
        int n2;
        int n3 = floatMatrix.getColumnDimension();
        int n4 = (int)Math.floor(Math.log(n3) / Math.log(2.0));
        int n5 = 1000000 / n4;
        float f = Float.MAX_VALUE;
        float f2 = 0.0f;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!(floatMatrix.get(n, n2) < f)) continue;
            f = floatMatrix.get(n, n2);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            floatMatrix.set(n, n2, floatMatrix.get(n, n2) - f);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (!(floatMatrix.get(n, n2) > f2)) continue;
            f2 = floatMatrix.get(n, n2);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            floatMatrix.set(n, n2, floatMatrix.get(n, n2) / f2);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if ((double)floatMatrix.get(n, n2) == 1.0) {
                floatMatrix.set(n, n2, n4);
                continue;
            }
            floatMatrix.set(n, n2, (float)(Math.floor(floatMatrix.get(n, n2) * 1000000.0f / (float)n5) + 1.0));
        }
    }

    private static void normalizeExperiment(FloatMatrix floatMatrix, int n) {
        float f;
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        int n3 = floatMatrix.getRowDimension();
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n2, n);
            if (Float.isNaN(f)) continue;
            d += (double)f;
        }
        d /= (double)n3;
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n2, n);
            if (Float.isNaN(f)) continue;
            d2 += Math.pow((double)f - d, 2.0);
        }
        d2 = Math.sqrt(d2 / (double)(n3 - 1));
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n2, n);
            if (Float.isNaN(f)) continue;
            if (d2 != 0.0) {
                floatMatrix.set(n2, n, (float)(((double)f - d) / d2));
                continue;
            }
            floatMatrix.set(n2, n, (float)(((double)f - d) / (double)1.4E-45f));
        }
    }

    private static void divideExperimentBySD(FloatMatrix floatMatrix, int n) {
        float f;
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        int n3 = floatMatrix.getRowDimension();
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n2, n);
            if (Float.isNaN(f)) continue;
            d += (double)f;
        }
        d /= (double)n3;
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n2, n);
            if (Float.isNaN(f)) continue;
            d2 += Math.pow((double)f - d, 2.0);
        }
        d2 = Math.sqrt(d2 / (double)(n3 - 1));
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n2, n);
            if (Float.isNaN(f)) continue;
            if (d2 != 0.0) {
                floatMatrix.set(n2, n, (float)((double)f / d2));
                continue;
            }
            floatMatrix.set(n2, n, f / Float.MIN_VALUE);
        }
    }

    private static void divideExperimentByRMS(FloatMatrix floatMatrix, int n) {
        float f;
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        int n3 = floatMatrix.getRowDimension();
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n2, n);
            if (Float.isNaN(f)) continue;
            d2 += Math.pow(f, 2.0);
        }
        d2 = Math.sqrt(d2 / (double)n3);
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n2, n);
            if (Float.isNaN(f)) continue;
            if (d2 != 0.0) {
                floatMatrix.set(n2, n, (float)((double)f / d2));
                continue;
            }
            floatMatrix.set(n2, n, f / Float.MIN_VALUE);
        }
    }

    private static void meanCenterExperiment(FloatMatrix floatMatrix, int n) {
        float f;
        int n2;
        double d = 0.0;
        int n3 = floatMatrix.getRowDimension();
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n2, n);
            if (Float.isNaN(f)) continue;
            d += (double)f;
        }
        d /= (double)n3;
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n2, n);
            if (Float.isNaN(f)) continue;
            floatMatrix.set(n2, n, (float)((double)f - d));
        }
    }

    private static void medianCenterExperiment(FloatMatrix floatMatrix, int n) {
        float f;
        int n2;
        int n3 = floatMatrix.getRowDimension();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n2, n);
            if (Float.isNaN(f)) continue;
            ++n4;
        }
        float[] fArray = new float[n4];
        n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n2, n);
            if (Float.isNaN(f)) continue;
            fArray[n4] = f;
            ++n4;
        }
        Arrays.sort(fArray);
        float f2 = 0.0f;
        if (n4 % 2 == 0) {
            if (n4 > 0) {
                f2 = (float)(0.5 * (double)(fArray[n4 / 2 - 1] + fArray[n4 / 2]));
            }
        } else {
            f2 = fArray[(n4 + 1) / 2 - 1];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            f = floatMatrix.get(n2, n);
            if (Float.isNaN(f)) continue;
            floatMatrix.set(n2, n, f - f2);
        }
    }

    private static void makeDigitalExperiment(FloatMatrix floatMatrix, int n) {
        int n2;
        int n3 = floatMatrix.getRowDimension();
        int n4 = (int)Math.floor(Math.log(n3) / Math.log(2.0));
        int n5 = 1000000 / n4;
        float f = Float.MAX_VALUE;
        float f2 = 0.0f;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!(floatMatrix.get(n2, n) < f)) continue;
            f = floatMatrix.get(n2, n);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            floatMatrix.set(n2, n, floatMatrix.get(n2, n) - f);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (!(floatMatrix.get(n2, n) > f2)) continue;
            f2 = floatMatrix.get(n2, n);
        }
        if (f2 != 0.0f) {
            for (n2 = 0; n2 < n3; ++n2) {
                floatMatrix.set(n2, n, floatMatrix.get(n2, n) / f2);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if ((double)floatMatrix.get(n2, n) == 1.0) {
                floatMatrix.set(n2, n, n4);
                continue;
            }
            floatMatrix.set(n2, n, (float)(Math.floor(floatMatrix.get(n2, n) * 1000000.0f / (float)n5) + 1.0));
        }
    }
}

