/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.util;

import java.util.Random;
import java.util.Vector;
import org.tigr.util.FloatMatrix;

public class JacknifedMatrixByGenes {
    public Vector resampledIndices = new Vector();
    int jackknifedGene;

    float[][] get2DArrFromExpMatrix(FloatMatrix floatMatrix) {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        float[][] fArray = new float[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                fArray[i][j] = floatMatrix.get(i, j);
            }
        }
        return fArray;
    }

    float[][] resampleMatrix(FloatMatrix floatMatrix) {
        int n;
        float[][] fArray = this.get2DArrFromExpMatrix(floatMatrix);
        float[][] fArray2 = new float[fArray.length - 1][fArray[0].length];
        int n2 = fArray.length;
        int n3 = fArray[0].length;
        int n4 = 0;
        Random random = new Random();
        int n5 = random.nextInt(n2);
        for (n = 0; n < n3; ++n) {
            n4 = 0;
            for (int i = 0; i < n2; ++i) {
                if (i == n5) continue;
                fArray2[n4][n] = fArray[i][n];
                ++n4;
            }
        }
        this.jackknifedGene = n5;
        for (n = 0; n < n2; ++n) {
            if (n == this.jackknifedGene) continue;
            this.resampledIndices.add(new Integer(n));
        }
        return fArray2;
    }

    public FloatMatrix createResampExpMatrixObject(FloatMatrix floatMatrix) {
        float[][] fArray = this.resampleMatrix(floatMatrix);
        FloatMatrix floatMatrix2 = new FloatMatrix(fArray);
        return floatMatrix2;
    }

    void printMatrix(float[][] fArray) {
        int n = 0;
        for (int i = 0; i < fArray[0].length; ++i) {
            for (n = 0; n < fArray.length; ++n) {
                System.out.print((int)(fArray[n][i] * 100.0f) / 100 + " ");
            }
            System.out.println();
        }
    }
}

