/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.util.awt;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.tigr.util.awt.GBA;

public class SetElementSizeDialog
extends JDialog {
    private int result;
    private Dimension size;
    private JLabel widthLabel;
    private JLabel heightLabel;
    private JTextField widthTextField;
    private JTextField heightTextField;
    private GBA gba;

    public SetElementSizeDialog(JFrame jFrame, Dimension dimension) {
        super((Frame)jFrame, true);
        this.setTitle("Set Element Size");
        this.gba = new GBA();
        this.widthLabel = new JLabel("Element Width (" + dimension.width + "): ");
        this.widthTextField = new JTextField(10);
        this.widthTextField.setText("" + dimension.width);
        this.heightLabel = new JLabel("Element Height (" + dimension.height + "): ");
        this.heightTextField = new JTextField(10);
        this.heightTextField.setText("" + dimension.height);
        JButton jButton = new JButton("Okay");
        jButton.setActionCommand("ok-command");
        jButton.addActionListener(new Listener());
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("cancel-command");
        jButton2.addActionListener(new Listener());
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        this.gba.add(container, this.widthLabel, 0, 0, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(container, this.widthTextField, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(container, this.heightLabel, 0, 1, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(container, this.heightTextField, 1, 1, 2, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(container, jButton2, 0, 2, 1, 1, 0, 0, 0, 17, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(container, jButton, 1, 2, 1, 1, 0, 0, 0, 13, new Insets(5, 5, 5, 5), 0, 0);
        this.setResizable(false);
        this.widthTextField.grabFocus();
        this.getRootPane().setDefaultButton(jButton);
        this.pack();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public Dimension getElementSize() {
        return this.size;
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                String string2 = SetElementSizeDialog.this.widthTextField.getText();
                String string3 = SetElementSizeDialog.this.heightTextField.getText();
                try {
                    SetElementSizeDialog.this.size = new Dimension(Integer.parseInt(string2), Integer.parseInt(string3));
                    SetElementSizeDialog.this.result = 0;
                }
                catch (Exception exception) {
                    SetElementSizeDialog.this.result = 2;
                }
                SetElementSizeDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                SetElementSizeDialog.this.result = 2;
                SetElementSizeDialog.this.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            SetElementSizeDialog.this.result = -1;
            SetElementSizeDialog.this.dispose();
        }
    }
}

