/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.mevdialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class IterativeLogMCNormInitDialog
extends AlgorithmDialog {
    private JComboBox sdComboBox;
    private int result = 2;
    private final String[] SD_VALUES = new String[]{"+/-0.50 SD", "+/-1.00 SD", "+/-1.50 SD", "+/-1.96 SD", "+/-2.00 SD", "+/-2.50 SD", "+/-3.00 SD"};

    public IterativeLogMCNormInitDialog() {
        super(new JFrame(), "Iterative Log Mean Centering Normalization", true);
        this.sdComboBox = new JComboBox<String>(this.SD_VALUES);
        this.sdComboBox.setEditable(false);
        this.sdComboBox.setSelectedIndex(4);
        JPanel sdPanel = new JPanel(new GridBagLayout());
        sdPanel.setBackground(Color.white);
        sdPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Standard Deviation Range"));
        sdPanel.add((Component)this.sdComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(30, 0, 30, 0), 0, 0));
        this.addContent(sdPanel);
        this.setActionListeners(new Listener());
        ((Component)this).setSize(new Dimension(450, 220));
        this.setResizable(false);
        this.pack();
    }

    public double getSD() {
        double sd = 0.0;
        String sdString = (String)this.sdComboBox.getSelectedItem();
        sdString = sdString.substring(3, 7);
        try {
            sd = Double.parseDouble(sdString);
        }
        catch (Exception e) {
            // empty catch block
        }
        return sd;
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        this.dispose();
        return this.result;
    }

    public static void main(String[] args) {
        IterativeLogMCNormInitDialog dialog = new IterativeLogMCNormInitDialog();
        dialog.show();
        System.out.println("SD = " + dialog.getSD());
        System.exit(0);
    }

    public class Listener
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("ok-command")) {
                IterativeLogMCNormInitDialog.this.result = 0;
                IterativeLogMCNormInitDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                IterativeLogMCNormInitDialog.this.sdComboBox.setSelectedIndex(4);
            } else if (command.equals("cancel-command")) {
                IterativeLogMCNormInitDialog.this.result = 2;
                IterativeLogMCNormInitDialog.this.dispose();
            } else if (command.equals("info-command")) {
                HelpWindow hw = new HelpWindow(IterativeLogMCNormInitDialog.this, "Iterative Log Mean Centering Initialization Dialog");
                if (hw.getWindowContent()) {
                    ((Component)hw).setSize(480, 555);
                    hw.setLocation();
                    hw.show();
                } else {
                    ((Component)hw).setVisible(false);
                    hw.dispose();
                }
            }
        }
    }
}

