/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.midas.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Vector;
import org.tigr.midas.math.MathTools;
import org.tigr.midas.util.StringSplitter;
import org.tigr.midas.util.logger;

public class ColumnWorker {
    private String fileName;
    private int count;
    private int[] metaRow;
    private int[] metaCol;
    private String[] metaCombo;
    private long colOneTotal;
    private long colTwoTotal;
    private double col12Ratio;
    private double[] colOneArrayRaw;
    private double[] colTwoArrayRaw;
    private double[] colOneArray;
    private double[] colTwoArray;
    private double[] plainRatioArray;
    private double[] logProdArray;
    private double[] logRatioArray;
    private double[] colOneBkgdArray;
    private double[] colTwoBkgdArray;
    private double[] snRatioOne;
    private double[] snRatioTwo;
    private boolean[] rowFlag;
    private boolean[] channelFlag1;
    private boolean[] channelFlag2;
    private int[] colThreeArray;
    private String[] colThreeArrayStr;
    private String[] colFourArrayStr;
    private String[] featNameArray;
    private int[] ndxArray;

    public ColumnWorker(double[] column1, double[] column2, String[] MetaCombo) {
        this(column1.length);
        this.colOneArray = column1;
        this.colTwoArray = column2;
        this.metaCombo = MetaCombo;
        this.count = this.colOneArray.length;
        int rowCount = 0;
        while (rowCount < this.colOneArray.length) {
            if (this.colOneArray[rowCount] > 1.0 && this.colTwoArray[rowCount] > 1.0) {
                this.colOneTotal = (long)((double)this.colOneTotal + this.colOneArray[rowCount]);
                this.colTwoTotal = (long)((double)this.colTwoTotal + this.colTwoArray[rowCount]);
            }
            this.rowFlag[rowCount] = true;
            ++rowCount;
        }
        this.col12Ratio = (double)this.colOneTotal / (double)this.colTwoTotal;
    }

    public ColumnWorker(String fName) throws Exception {
        this.fileName = fName;
        int cnt = 0;
        String ln = "";
        try {
            BufferedReader inFile = new BufferedReader(new FileReader(this.fileName));
            do {
                ln = inFile.readLine();
                ++cnt;
            } while (ln.length() != 0);
        }
        catch (NullPointerException e) {
            logger.log("    Total gene count = " + (cnt - 1));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        this.initializeArrays(cnt - 1);
    }

    public ColumnWorker(int size) {
        this.metaRow = new int[size];
        this.metaCol = new int[size];
        this.metaCombo = new String[size];
        this.colOneArray = new double[size];
        this.colTwoArray = new double[size];
        this.colOneArrayRaw = new double[size];
        this.colTwoArrayRaw = new double[size];
        this.colOneBkgdArray = new double[size];
        this.colTwoBkgdArray = new double[size];
        this.snRatioOne = new double[size];
        this.snRatioTwo = new double[size];
        this.rowFlag = new boolean[size];
        this.channelFlag1 = new boolean[size];
        this.channelFlag2 = new boolean[size];
        this.colThreeArray = new int[size];
        this.colThreeArrayStr = new String[size];
        this.colFourArrayStr = new String[size];
        this.featNameArray = new String[size];
        this.ndxArray = new int[size];
        this.count = 0;
        this.colOneTotal = 0L;
        this.colTwoTotal = 0L;
        this.col12Ratio = 0.0;
    }

    public void initializeArrays(int size) {
        this.metaRow = new int[size];
        this.metaCol = new int[size];
        this.metaCombo = new String[size];
        this.colOneArray = new double[size];
        this.colTwoArray = new double[size];
        this.colOneArrayRaw = new double[size];
        this.colTwoArrayRaw = new double[size];
        this.colOneBkgdArray = new double[size];
        this.colTwoBkgdArray = new double[size];
        this.snRatioOne = new double[size];
        this.snRatioTwo = new double[size];
        this.rowFlag = new boolean[size];
        this.channelFlag1 = new boolean[size];
        this.channelFlag2 = new boolean[size];
        this.colThreeArray = new int[size];
        this.colThreeArrayStr = new String[size];
        this.colFourArrayStr = new String[size];
        this.featNameArray = new String[size];
        this.ndxArray = new int[size];
        this.count = 0;
        this.colOneTotal = 0L;
        this.colTwoTotal = 0L;
        this.col12Ratio = 0.0;
    }

    public void setColumnsForMeta(int col1, int col2) throws FileNotFoundException, NumberFormatException, Exception {
        Vector<String> inputRowVec = new Vector<String>();
        String line = "";
        int rowCount = 0;
        try {
            BufferedReader inFile = new BufferedReader(new FileReader(this.fileName));
            do {
                line = inFile.readLine();
                StringSplitter st = new StringSplitter(line, '\t');
                inputRowVec = new Vector();
                while (st.hasMoreTokens()) {
                    inputRowVec.add(st.nextToken());
                }
                this.metaCombo[rowCount] = inputRowVec.elementAt(col1).toString() + "_" + inputRowVec.elementAt(col2).toString();
                ++rowCount;
            } while (line.length() != 0);
        }
        catch (NullPointerException e) {
        }
        catch (FileNotFoundException nfex) {
            throw nfex;
        }
        catch (NumberFormatException nex) {
            throw nex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        String[] tt = new String[this.metaCombo.length];
        System.arraycopy(this.metaCombo, 0, tt, 0, this.metaCombo.length);
        this.metaCombo = new String[rowCount];
        System.arraycopy(tt, 0, this.metaCombo, 0, rowCount);
        int[] t = new int[this.metaRow.length];
        System.arraycopy(this.metaRow, 0, t, 0, this.metaRow.length);
        this.metaRow = new int[rowCount];
        System.arraycopy(t, 0, this.metaRow, 0, rowCount);
        t = new int[this.metaCol.length];
        System.arraycopy(this.metaCol, 0, t, 0, this.metaRow.length);
        this.metaCol = new int[rowCount];
        System.arraycopy(t, 0, this.metaCol, 0, rowCount);
        this.count = rowCount;
    }

    public void setColumnForFeatName(int col) throws FileNotFoundException, NumberFormatException, Exception {
        Vector<String> inputRowVec = new Vector<String>();
        String line = "";
        int rowCount = 0;
        try {
            BufferedReader inFile = new BufferedReader(new FileReader(this.fileName));
            do {
                line = inFile.readLine();
                StringSplitter st = new StringSplitter(line, '\t');
                inputRowVec = new Vector();
                while (st.hasMoreTokens()) {
                    inputRowVec.add(st.nextToken());
                }
                this.featNameArray[rowCount] = inputRowVec.elementAt(col).toString();
                ++rowCount;
            } while (line.length() != 0);
        }
        catch (NullPointerException e) {
        }
        catch (FileNotFoundException nfex) {
            throw nfex;
        }
        catch (NumberFormatException nex) {
            throw nex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        String[] tt = new String[this.featNameArray.length];
        System.arraycopy(this.featNameArray, 0, tt, 0, this.featNameArray.length);
        this.featNameArray = new String[rowCount];
        System.arraycopy(tt, 0, this.featNameArray, 0, rowCount);
        this.count = rowCount;
    }

    public void setOneColumn(int col) throws FileNotFoundException, NumberFormatException, Exception {
        Vector<String> inputRowVec = new Vector<String>();
        String line = "";
        int rowCount = 0;
        try {
            BufferedReader inFile = new BufferedReader(new FileReader(this.fileName));
            do {
                line = inFile.readLine();
                StringSplitter st = new StringSplitter(line, '\t');
                inputRowVec = new Vector();
                while (st.hasMoreTokens()) {
                    inputRowVec.add(st.nextToken());
                }
                this.colOneArray[rowCount] = Double.parseDouble(inputRowVec.elementAt(col).toString());
                ++rowCount;
            } while (line.length() != 0);
        }
        catch (NullPointerException e) {
        }
        catch (FileNotFoundException nfex) {
            throw nfex;
        }
        catch (NumberFormatException nex) {
            throw nex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        double[] t = new double[this.colOneArray.length];
        System.arraycopy(this.colOneArray, 0, t, 0, this.colOneArray.length);
        this.colOneArray = new double[rowCount];
        System.arraycopy(t, 0, this.colOneArray, 0, rowCount);
        this.count = rowCount;
    }

    public void setColumns(int col1, int col2) throws FileNotFoundException, NumberFormatException, Exception {
        Vector<String> inputRowVec = new Vector<String>();
        String line = "";
        int rowCount = 0;
        try {
            BufferedReader inFile = new BufferedReader(new FileReader(this.fileName));
            do {
                line = inFile.readLine();
                StringSplitter st = new StringSplitter(line, '\t');
                inputRowVec = new Vector();
                while (st.hasMoreTokens()) {
                    inputRowVec.add(st.nextToken());
                }
                this.colOneArray[rowCount] = Double.parseDouble(inputRowVec.elementAt(col1).toString());
                this.colTwoArray[rowCount] = Double.parseDouble(inputRowVec.elementAt(col2).toString());
                this.colOneArrayRaw[rowCount] = this.colOneArray[rowCount];
                this.colTwoArrayRaw[rowCount] = this.colTwoArray[rowCount];
                this.channelFlag1[rowCount] = true;
                this.channelFlag2[rowCount] = true;
                boolean bl = this.rowFlag[rowCount] = this.channelFlag1[rowCount] && this.channelFlag2[rowCount];
                if (this.colOneArray[rowCount] > 1.0 && this.colTwoArray[rowCount] > 1.0 && this.rowFlag[rowCount]) {
                    this.colOneTotal = (long)((double)this.colOneTotal + this.colOneArray[rowCount]);
                    this.colTwoTotal = (long)((double)this.colTwoTotal + this.colTwoArray[rowCount]);
                }
                ++rowCount;
            } while (line.length() != 0);
        }
        catch (NullPointerException e) {
        }
        catch (FileNotFoundException nfex) {
            throw nfex;
        }
        catch (NumberFormatException nex) {
            throw nex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        this.col12Ratio = (double)this.colOneTotal / (double)this.colTwoTotal;
        this.count = rowCount;
        double[] t = new double[this.colOneArray.length];
        System.arraycopy(this.colOneArray, 0, t, 0, this.colOneArray.length);
        this.colOneArray = new double[rowCount];
        System.arraycopy(t, 0, this.colOneArray, 0, rowCount);
        t = new double[this.colTwoArray.length];
        System.arraycopy(this.colTwoArray, 0, t, 0, this.colTwoArray.length);
        this.colTwoArray = new double[rowCount];
        System.arraycopy(t, 0, this.colTwoArray, 0, rowCount);
        t = new double[this.colOneArrayRaw.length];
        System.arraycopy(this.colOneArrayRaw, 0, t, 0, this.colOneArrayRaw.length);
        this.colOneArrayRaw = new double[rowCount];
        System.arraycopy(t, 0, this.colOneArrayRaw, 0, rowCount);
        t = new double[this.colTwoArrayRaw.length];
        System.arraycopy(this.colTwoArrayRaw, 0, t, 0, this.colTwoArrayRaw.length);
        this.colTwoArrayRaw = new double[rowCount];
        System.arraycopy(t, 0, this.colTwoArrayRaw, 0, rowCount);
        boolean[] b = new boolean[this.channelFlag1.length];
        System.arraycopy(this.channelFlag1, 0, b, 0, this.channelFlag1.length);
        this.channelFlag1 = new boolean[rowCount];
        System.arraycopy(b, 0, this.channelFlag1, 0, rowCount);
        b = new boolean[this.channelFlag2.length];
        System.arraycopy(this.channelFlag2, 0, b, 0, this.channelFlag2.length);
        this.channelFlag2 = new boolean[rowCount];
        System.arraycopy(b, 0, this.channelFlag2, 0, rowCount);
        b = new boolean[this.rowFlag.length];
        System.arraycopy(this.rowFlag, 0, b, 0, this.rowFlag.length);
        this.rowFlag = new boolean[rowCount];
        System.arraycopy(b, 0, this.rowFlag, 0, rowCount);
    }

    public void setColumns(int col1, int col2, int col3) throws FileNotFoundException, NumberFormatException, Exception {
        Vector<String> inputRowVec = new Vector<String>();
        String line = "";
        int rowCount = 0;
        try {
            BufferedReader inFile = new BufferedReader(new FileReader(this.fileName));
            do {
                line = inFile.readLine();
                StringSplitter st = new StringSplitter(line, '\t');
                inputRowVec = new Vector();
                while (st.hasMoreTokens()) {
                    inputRowVec.add(st.nextToken());
                }
                this.colOneArray[rowCount] = Double.parseDouble(inputRowVec.elementAt(col1).toString());
                this.colTwoArray[rowCount] = Double.parseDouble(inputRowVec.elementAt(col2).toString());
                this.colOneArrayRaw[rowCount] = this.colOneArray[rowCount];
                this.colTwoArrayRaw[rowCount] = this.colTwoArray[rowCount];
                this.colThreeArrayStr[rowCount] = inputRowVec.elementAt(col3).toString();
                if (this.colThreeArrayStr[rowCount].equalsIgnoreCase("B") || this.colThreeArrayStr[rowCount].equalsIgnoreCase("C")) {
                    this.channelFlag1[rowCount] = true;
                    this.channelFlag2[rowCount] = true;
                } else {
                    this.channelFlag1[rowCount] = false;
                    this.channelFlag2[rowCount] = false;
                }
                boolean bl = this.rowFlag[rowCount] = this.channelFlag1[rowCount] && this.channelFlag2[rowCount];
                if (!this.rowFlag[rowCount]) {
                    this.colOneArray[rowCount] = 0.0;
                    this.colTwoArray[rowCount] = 0.0;
                }
                if (this.colOneArray[rowCount] > 1.0 && this.colTwoArray[rowCount] > 1.0 && this.rowFlag[rowCount]) {
                    this.colOneTotal = (long)((double)this.colOneTotal + this.colOneArray[rowCount]);
                    this.colTwoTotal = (long)((double)this.colTwoTotal + this.colTwoArray[rowCount]);
                }
                ++rowCount;
            } while (line.length() != 0);
        }
        catch (NullPointerException e) {
        }
        catch (FileNotFoundException nfex) {
            throw nfex;
        }
        catch (NumberFormatException nex) {
            throw nex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        this.col12Ratio = (double)this.colOneTotal / (double)this.colTwoTotal;
        this.count = rowCount;
        double[] t = new double[this.colOneArray.length];
        System.arraycopy(this.colOneArray, 0, t, 0, this.colOneArray.length);
        this.colOneArray = new double[rowCount];
        System.arraycopy(t, 0, this.colOneArray, 0, rowCount);
        t = new double[this.colTwoArray.length];
        System.arraycopy(this.colTwoArray, 0, t, 0, this.colTwoArray.length);
        this.colTwoArray = new double[rowCount];
        System.arraycopy(t, 0, this.colTwoArray, 0, rowCount);
        t = new double[this.colOneArrayRaw.length];
        System.arraycopy(this.colOneArrayRaw, 0, t, 0, this.colOneArrayRaw.length);
        this.colOneArrayRaw = new double[rowCount];
        System.arraycopy(t, 0, this.colOneArrayRaw, 0, rowCount);
        t = new double[this.colTwoArrayRaw.length];
        System.arraycopy(this.colTwoArrayRaw, 0, t, 0, this.colTwoArrayRaw.length);
        this.colTwoArrayRaw = new double[rowCount];
        System.arraycopy(t, 0, this.colTwoArrayRaw, 0, rowCount);
        String[] tt = new String[this.colThreeArrayStr.length];
        System.arraycopy(this.colThreeArrayStr, 0, tt, 0, this.colThreeArrayStr.length);
        this.colThreeArrayStr = new String[rowCount];
        System.arraycopy(tt, 0, this.colThreeArrayStr, 0, rowCount);
        boolean[] b = new boolean[this.channelFlag1.length];
        System.arraycopy(this.channelFlag1, 0, b, 0, this.channelFlag1.length);
        this.channelFlag1 = new boolean[rowCount];
        System.arraycopy(b, 0, this.channelFlag1, 0, rowCount);
        b = new boolean[this.channelFlag2.length];
        System.arraycopy(this.channelFlag2, 0, b, 0, this.channelFlag2.length);
        this.channelFlag2 = new boolean[rowCount];
        System.arraycopy(b, 0, this.channelFlag2, 0, rowCount);
        b = new boolean[this.rowFlag.length];
        System.arraycopy(this.rowFlag, 0, b, 0, this.rowFlag.length);
        this.rowFlag = new boolean[rowCount];
        System.arraycopy(b, 0, this.rowFlag, 0, rowCount);
    }

    public void setColumns(int col1, int col2, int col3, int col4) throws FileNotFoundException, NumberFormatException, Exception {
        Vector<String> inputRowVec = new Vector<String>();
        String line = "";
        int rowCount = 0;
        try {
            BufferedReader inFile = new BufferedReader(new FileReader(this.fileName));
            do {
                line = inFile.readLine();
                StringSplitter st = new StringSplitter(line, '\t');
                inputRowVec = new Vector();
                while (st.hasMoreTokens()) {
                    inputRowVec.add(st.nextToken());
                }
                this.colOneArray[rowCount] = Double.parseDouble(inputRowVec.elementAt(col1).toString());
                this.colTwoArray[rowCount] = Double.parseDouble(inputRowVec.elementAt(col2).toString());
                this.colOneArrayRaw[rowCount] = this.colOneArray[rowCount];
                this.colTwoArrayRaw[rowCount] = this.colTwoArray[rowCount];
                this.colThreeArrayStr[rowCount] = inputRowVec.elementAt(col3).toString();
                this.colFourArrayStr[rowCount] = inputRowVec.elementAt(col4).toString();
                this.channelFlag1[rowCount] = this.colThreeArrayStr[rowCount].equalsIgnoreCase("B") || this.colThreeArrayStr[rowCount].equalsIgnoreCase("C");
                this.channelFlag2[rowCount] = this.colFourArrayStr[rowCount].equalsIgnoreCase("B") || this.colFourArrayStr[rowCount].equalsIgnoreCase("C");
                boolean bl = this.rowFlag[rowCount] = this.channelFlag1[rowCount] && this.channelFlag2[rowCount];
                if (!this.rowFlag[rowCount]) {
                    this.colOneArray[rowCount] = 0.0;
                    this.colTwoArray[rowCount] = 0.0;
                }
                if (this.colOneArray[rowCount] > 1.0 && this.colTwoArray[rowCount] > 1.0 && this.rowFlag[rowCount]) {
                    this.colOneTotal = (long)((double)this.colOneTotal + this.colOneArray[rowCount]);
                    this.colTwoTotal = (long)((double)this.colTwoTotal + this.colTwoArray[rowCount]);
                }
                ++rowCount;
            } while (line.length() != 0);
        }
        catch (NullPointerException e) {
        }
        catch (FileNotFoundException nfex) {
            throw nfex;
        }
        catch (NumberFormatException nex) {
            throw nex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        this.col12Ratio = (double)this.colOneTotal / (double)this.colTwoTotal;
        this.count = rowCount;
        double[] t = new double[this.colOneArray.length];
        System.arraycopy(this.colOneArray, 0, t, 0, this.colOneArray.length);
        this.colOneArray = new double[rowCount];
        System.arraycopy(t, 0, this.colOneArray, 0, rowCount);
        t = new double[this.colTwoArray.length];
        System.arraycopy(this.colTwoArray, 0, t, 0, this.colTwoArray.length);
        this.colTwoArray = new double[rowCount];
        System.arraycopy(t, 0, this.colTwoArray, 0, rowCount);
        t = new double[this.colOneArrayRaw.length];
        System.arraycopy(this.colOneArrayRaw, 0, t, 0, this.colOneArrayRaw.length);
        this.colOneArrayRaw = new double[rowCount];
        System.arraycopy(t, 0, this.colOneArrayRaw, 0, rowCount);
        t = new double[this.colTwoArrayRaw.length];
        System.arraycopy(this.colTwoArrayRaw, 0, t, 0, this.colTwoArrayRaw.length);
        this.colTwoArrayRaw = new double[rowCount];
        System.arraycopy(t, 0, this.colTwoArrayRaw, 0, rowCount);
        String[] tt = new String[this.colThreeArrayStr.length];
        System.arraycopy(this.colThreeArrayStr, 0, tt, 0, this.colThreeArrayStr.length);
        this.colThreeArrayStr = new String[rowCount];
        System.arraycopy(tt, 0, this.colThreeArrayStr, 0, rowCount);
        boolean[] b = new boolean[this.channelFlag1.length];
        System.arraycopy(this.channelFlag1, 0, b, 0, this.channelFlag1.length);
        this.channelFlag1 = new boolean[rowCount];
        System.arraycopy(b, 0, this.channelFlag1, 0, rowCount);
        b = new boolean[this.channelFlag2.length];
        System.arraycopy(this.channelFlag2, 0, b, 0, this.channelFlag2.length);
        this.channelFlag2 = new boolean[rowCount];
        System.arraycopy(b, 0, this.channelFlag2, 0, rowCount);
        b = new boolean[this.rowFlag.length];
        System.arraycopy(this.rowFlag, 0, b, 0, this.rowFlag.length);
        this.rowFlag = new boolean[rowCount];
        System.arraycopy(b, 0, this.rowFlag, 0, rowCount);
    }

    public void setColumnsForTwoBkgd(int col1, int col2, double snRatioCutoff) throws FileNotFoundException, NumberFormatException, Exception {
        Vector<String> inputRowVec = new Vector<String>();
        String line = "";
        int rowCount = 0;
        try {
            BufferedReader inFile = new BufferedReader(new FileReader(this.fileName));
            do {
                line = inFile.readLine();
                StringSplitter st = new StringSplitter(line, '\t');
                inputRowVec = new Vector();
                while (st.hasMoreTokens()) {
                    inputRowVec.add(st.nextToken());
                }
                this.colOneBkgdArray[rowCount] = Double.parseDouble(inputRowVec.elementAt(col1).toString());
                this.colTwoBkgdArray[rowCount] = Double.parseDouble(inputRowVec.elementAt(col2).toString());
                this.snRatioOne[rowCount] = (this.colOneArray[rowCount] + this.colOneBkgdArray[rowCount]) / this.colOneBkgdArray[rowCount];
                this.snRatioTwo[rowCount] = (this.colTwoArray[rowCount] + this.colTwoBkgdArray[rowCount]) / this.colTwoBkgdArray[rowCount];
                this.rowFlag[rowCount] = this.rowFlag[rowCount] && this.snRatioOne[rowCount] >= snRatioCutoff && this.snRatioTwo[rowCount] >= snRatioCutoff;
                if (!this.rowFlag[rowCount]) {
                    this.colOneArray[rowCount] = 0.0;
                    this.colTwoArray[rowCount] = 0.0;
                }
                ++rowCount;
            } while (line.length() != 0);
        }
        catch (NullPointerException e) {
        }
        catch (FileNotFoundException nfex) {
            throw nfex;
        }
        catch (NumberFormatException nex) {
            throw nex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        double[] t = new double[this.colOneBkgdArray.length];
        System.arraycopy(this.colOneBkgdArray, 0, t, 0, this.colOneBkgdArray.length);
        this.colOneBkgdArray = new double[rowCount];
        System.arraycopy(t, 0, this.colOneBkgdArray, 0, rowCount);
        t = new double[this.colTwoBkgdArray.length];
        System.arraycopy(this.colTwoBkgdArray, 0, t, 0, this.colTwoBkgdArray.length);
        this.colTwoBkgdArray = new double[rowCount];
        System.arraycopy(t, 0, this.colTwoBkgdArray, 0, rowCount);
        t = new double[this.snRatioOne.length];
        System.arraycopy(this.snRatioOne, 0, t, 0, this.snRatioOne.length);
        this.snRatioOne = new double[rowCount];
        System.arraycopy(t, 0, this.snRatioOne, 0, rowCount);
        t = new double[this.snRatioTwo.length];
        System.arraycopy(this.snRatioTwo, 0, t, 0, this.snRatioTwo.length);
        this.snRatioTwo = new double[rowCount];
        System.arraycopy(t, 0, this.snRatioTwo, 0, rowCount);
    }

    public void KeepTwoColumnsAddFlags(long cutOff1, long cutOff2) {
        int i = 0;
        while (i < this.count) {
            if (this.colTwoArray[i] <= 1.0 || this.colOneArray[i] <= 1.0) {
                this.colOneArray[i] = 0.0;
                this.colTwoArray[i] = 0.0;
                this.channelFlag1[i] = false;
                this.channelFlag2[i] = false;
                this.rowFlag[i] = false;
            }
            this.rowFlag[i] = this.colOneArray[i] > (double)cutOff1 && this.colTwoArray[i] > (double)cutOff2;
            ++i;
        }
    }

    public void resetTwoColumnsAddFlagsRefColOne(long cutOff1, long cutOff2) {
        int i = 0;
        while (i < this.count) {
            if (this.colTwoArray[i] <= 1.0 || this.colOneArray[i] <= 1.0) {
                this.colOneArray[i] = 0.0;
                this.colTwoArray[i] = 0.0;
                this.channelFlag1[i] = false;
                this.channelFlag2[i] = false;
                this.rowFlag[i] = false;
            } else {
                int n = i;
                this.colTwoArray[n] = this.colTwoArray[n] * this.col12Ratio;
            }
            this.rowFlag[i] = this.colOneArray[i] > (double)cutOff1 && this.colTwoArray[i] > (double)cutOff2;
            ++i;
        }
    }

    public void resetTwoColumnsAddFlagsRefColTwo(long cutOff1, long cutOff2) {
        int i = 0;
        while (i < this.count) {
            if (this.colOneArray[i] <= 1.0 || this.colTwoArray[i] <= 1.0) {
                this.colOneArray[i] = 0.0;
                this.colTwoArray[i] = 0.0;
                this.channelFlag1[i] = false;
                this.channelFlag2[i] = false;
                this.rowFlag[i] = false;
            } else {
                int n = i;
                this.colOneArray[n] = this.colOneArray[n] / this.col12Ratio;
            }
            this.rowFlag[i] = this.colOneArray[i] > (double)cutOff1 && this.colTwoArray[i] > (double)cutOff2;
            ++i;
        }
    }

    public void computeGoodRatiosAndLogRatios(long cutOff1, long cutOff2) {
        this.plainRatioArray = new double[this.colOneArray.length];
        this.logProdArray = new double[this.colOneArray.length];
        this.logRatioArray = new double[this.colOneArray.length];
        int i = 0;
        while (i < this.count) {
            if (this.colOneArray[i] > (double)cutOff1 && this.colTwoArray[i] > (double)cutOff2 && this.rowFlag[i]) {
                this.plainRatioArray[i] = this.colTwoArray[i] / this.colOneArray[i];
                this.logProdArray[i] = MathTools.log10((double)(this.colOneArray[i] * this.colTwoArray[i]));
                this.logRatioArray[i] = MathTools.log2((double)(this.colTwoArray[i] / this.colOneArray[i]));
            } else {
                this.plainRatioArray[i] = 0.0;
                this.logProdArray[i] = 0.0;
                this.logRatioArray[i] = 9999.0;
            }
            ++i;
        }
    }

    public String getFileName() {
        if (this.fileName.lastIndexOf("\\") > 0) {
            return this.fileName.substring(this.fileName.lastIndexOf("\\") + 1, this.fileName.lastIndexOf(46));
        }
        return this.fileName;
    }

    public String[] getMetaCombo() {
        return this.metaCombo;
    }

    public int[] getMetaRow() {
        return this.metaRow;
    }

    public int[] getMetaCol() {
        return this.metaCol;
    }

    public String[] getFeatNameArray() {
        return this.featNameArray;
    }

    public double[] getColumnOneArrayRaw() {
        return this.colOneArrayRaw;
    }

    public double[] getColumnTwoArrayRaw() {
        return this.colTwoArrayRaw;
    }

    public double[] getColumnOneArray() {
        return this.colOneArray;
    }

    public double[] getColumnTwoArray() {
        return this.colTwoArray;
    }

    public int[] getColumnThreeArray() {
        return this.colThreeArray;
    }

    public String[] getColumnThreeArrayStr() {
        return this.colThreeArrayStr;
    }

    public double getColumn12Ratio() {
        return this.col12Ratio;
    }

    public double[] getPlainRatioArray() {
        return this.plainRatioArray;
    }

    public double[] getLogProdArray() {
        return this.logProdArray;
    }

    public double[] getLogRatioArray() {
        return this.logRatioArray;
    }

    public boolean[] getRowFlagArray() {
        return this.rowFlag;
    }

    public int getRowCounts() {
        return this.count;
    }

    public boolean[] getChannelFlagOne() {
        return this.channelFlag1;
    }

    public boolean[] getChannelFlagTwo() {
        return this.channelFlag2;
    }

    public void setFileName(String f) {
        this.fileName = f;
    }

    public void setColOneArray(double[] a) {
        this.colOneArray = a;
    }

    public void setColTwoArray(double[] b) {
        this.colTwoArray = b;
    }

    public void setRowFlag(boolean[] c) {
        this.rowFlag = c;
    }

    public void setColumnOneArrayRaw(int size) {
        this.colOneArrayRaw = new double[size];
    }

    public void setColumnTwoArrayRaw(int size) {
        this.colTwoArrayRaw = new double[size];
    }

    public void setNdxArray(int[] d) {
        this.ndxArray = d;
    }
}

