/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.tigr.util.awt.GBA;

public class ProgressDialog
extends JDialog {
    protected JFrame parent;
    protected String title;
    protected Container contentPane;
    protected GBA gba;
    protected JPanel labelPanel;
    protected JPanel mainPanel;
    protected JLabel[] labels;
    protected Vector timers;

    public ProgressDialog(JFrame jFrame, String string, boolean bl, int n) {
        super(jFrame, string, bl);
        this.parent = jFrame;
        this.title = string;
        this.labels = new JLabel[n];
        this.mainPanel = new JPanel(new GridBagLayout());
        this.contentPane = this.getContentPane();
        this.gba = new GBA();
        this.timers = new Vector();
        this.initializeGUI();
    }

    public void initializeGUI() {
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.contentPane.setLayout(new GridBagLayout());
        this.contentPane.setBackground(Color.white);
        this.labelPanel = new JPanel();
        this.labelPanel.setLayout(new GridBagLayout());
        this.labelPanel.setBackground(Color.white);
        this.labelPanel.setBorder(BorderFactory.createBevelBorder(1));
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i] = new JLabel(this.title);
            this.labels[i].setBackground(Color.white);
            this.gba.add(this.labelPanel, this.labels[i], 0, i, 1, 1, 1, 0, 2, 10);
        }
        this.gba.add(this.mainPanel, this.labelPanel, 0, 0, 1, 1, 1, 1, 1, 10);
        this.gba.add(this.contentPane, new HeaderImagePanel(), 0, 0, 1, 1, 1, 0, 1, 17);
        this.gba.add(this.contentPane, this.mainPanel, 0, 1, 1, 1, 1, 1, 1, 10);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setResizable(false);
        this.pack();
        this.setSize(405, 350);
    }

    public JPanel getLabelPanel() {
        return this.labelPanel;
    }

    public void setMainPanel(JPanel jPanel) {
        this.gba.add(this.mainPanel, jPanel, 0, 0, 1, 1, 1, 1, 1, 10);
        this.repaint();
    }

    public void setMessage(int n, String string) {
        this.setMessage(n, string, Color.black);
    }

    public void setMessage(int n, String string, Color color) {
        if (n >= this.labels.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        JLabel jLabel = this.labels[n];
        if (jLabel != null) {
            jLabel.setForeground(color);
            jLabel.setText(string);
            jLabel.repaint();
        }
    }

    public void dismiss() {
        this.setVisible(false);
        for (int i = 0; i < this.timers.size(); ++i) {
            ((TimerThread)this.timers.elementAt(i)).setRunning(false);
        }
        this.dispose();
    }

    public void setTimerLabel(int n, String string, String string2, int n2) {
        TimerThread timerThread = new TimerThread(n, string, string2, n2);
        timerThread.setPriority(1);
        this.timers.addElement(timerThread);
        timerThread.start();
    }

    public static void main(String[] stringArray) {
        ProgressDialog progressDialog = new ProgressDialog(new JFrame(), "Test Progress Dialog", true, 5);
        progressDialog.show();
        System.exit(0);
    }

    public class FillPanel
    extends JPanel {
        GradientPaint gp;
        Color backgroundColor = new Color(25, 25, 169);
        Color fadeColor = new Color(140, 220, 240);

        public void paint(Graphics graphics) {
            super.paint(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = this.getSize();
            this.gp = new GradientPaint(0.0f, dimension.height / 2, this.backgroundColor, dimension.width, dimension.height / 2, this.fadeColor);
            graphics2D.setPaint(this.gp);
            graphics2D.fillRect(0, 0, dimension.width, dimension.height);
            graphics2D.setColor(Color.black);
        }
    }

    public class HeaderImagePanel
    extends JPanel {
        public HeaderImagePanel() {
            JLabel jLabel;
            this.setLayout(new GridBagLayout());
            URL uRL = HeaderImagePanel.class.getResource("/org/tigr/microarray/mev/cluster/gui/impl/images/dialog_banner2.gif");
            if (uRL != null) {
                ImageIcon imageIcon = new ImageIcon(uRL);
                jLabel = new JLabel(imageIcon);
            } else {
                jLabel = new JLabel();
            }
            jLabel.setOpaque(false);
            jLabel.setAlignmentX(0.0f);
            FillPanel fillPanel = new FillPanel();
            fillPanel.setBackground(Color.blue);
            this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)fillPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    private class TimerThread
    extends Thread {
        public boolean running = true;
        private int labelIndex;
        private String preString;
        private String postString;
        private int ms;

        public TimerThread(int n, String string, String string2, int n2) {
            this.labelIndex = n;
            this.preString = string;
            this.postString = string2;
            this.ms = n2;
        }

        public void run() {
            try {
                long l = System.currentTimeMillis();
                while (this.running) {
                    long l2 = System.currentTimeMillis();
                    long l3 = (long)((float)(l2 - l) / 1000.0f);
                    ProgressDialog.this.setMessage(this.labelIndex, this.preString + l3 + this.postString);
                    TimerThread.sleep(this.ms);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void setRunning(boolean bl) {
            this.running = bl;
        }
    }
}

