/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.data.sequence;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import org.biolegato.core.data.sequence.SequenceListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sequence
extends Hashtable<String, Object>
implements Cloneable {
    private final LinkedList<SequenceListener> listeners = new LinkedList();
    private static final Hashtable<String, Object> defaults = new Hashtable<String, Object>(){
        private static final long serialVersionUID = 7526472295622777006L;
        {
            this.put("modified", Boolean.FALSE);
            this.put("name", "New Sequence");
            this.put("direction", Direction.FROM5TO3);
            this.put("strandedness", Strandedness.SINGLE);
            this.put("topology", Topology.LINEAR);
            this.put("type", Type.DNA);
            this.put("protect_align", Boolean.FALSE);
            this.put("protect_ambig", Boolean.TRUE);
            this.put("protect_unambig", Boolean.TRUE);
        }
    };

    public Sequence() {
        this("");
    }

    public Sequence(String string) {
        this((Map<String, Object>)defaults);
        this.put("sequence", string);
    }

    public Sequence(Map<String, Object> data) {
        super(data);
    }

    public void addListener(SequenceListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(SequenceListener listener) {
        this.listeners.remove(listener);
    }

    public Object getField(String key) {
        return this.containsKey(key) ? this.get(key) : Sequence.getDefault(key);
    }

    public void setField(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("Cannot call Sequence.setField(" + key + "," + value + ")");
        }
        if (value == null) {
            value = Sequence.getDefault(key);
        }
        this.put("modified", Boolean.TRUE);
        this.put(key, value);
        for (SequenceListener listener : this.listeners) {
            listener.sequenceChanged(this, key);
        }
    }

    public static Object getDefault(String key) {
        return defaults.containsKey(key) ? defaults.get(key) : "";
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer("--- SEQUENCE DATA ---");
        for (String key : this.keySet()) {
            result.append("\t" + key + "=" + this.getField(key) + "\n");
        }
        return result.toString();
    }

    public Sequence subseq(int start) {
        Sequence split = (Sequence)this.clone();
        if (start <= split.getField("sequence").toString().length()) {
            split.setField("sequence", split.getField("sequence").toString().substring(start));
        } else {
            split.setField("sequence", "");
        }
        return split;
    }

    public Sequence subseq(int start, int end) {
        int length = end - start;
        Sequence split = this.subseq(start);
        if (end >= 0 && end <= split.getField("sequence").toString().length()) {
            split.setField("sequence", split.getField("sequence").toString().substring(0, end));
        }
        return split;
    }

    @Override
    public Object clone() {
        return new Sequence(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Strandedness {
        SINGLE{

            public String toString() {
                return "Single stranded";
            }
        }
        ,
        DOUBLE{

            public String toString() {
                return "Double stranded";
            }
        }
        ,
        MIXED{

            public String toString() {
                return "Mixed strandedness";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Topology {
        LINEAR{

            public String toString() {
                return "Linear";
            }
        }
        ,
        CIRCULAR{

            public String toString() {
                return "Circular";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        FROM3TO5{

            public String toString() {
                return "From 3' to 5'";
            }
        }
        ,
        FROM5TO3{

            public String toString() {
                return "From 5' to 3'";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        DNA{

            public String toString() {
                return "DNA";
            }
        }
        ,
        RNA{

            public String toString() {
                return "RNA";
            }
        }
        ,
        PROTEIN{

            public String toString() {
                return "Protein";
            }
        }
        ,
        MASK{

            public String toString() {
                return "Colour mask";
            }
        }
        ,
        TEXT{

            public String toString() {
                return "Text";
            }
        };

    }
}

