/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.core.properties;

import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.biolegato.core.properties.BLProperties;
import org.biolegato.core.properties.PropertiesListener;

public class PropertiesNumber
extends Box
implements ChangeListener,
PropertiesListener {
    JSpinner spinner;
    private String propertyKey;
    private BLProperties properties;
    private static final long serialVersionUID = 7526472295622777036L;

    public PropertiesNumber(BLProperties properties, String name, String propertyKey, int min, int max) {
        super(2);
        this.propertyKey = propertyKey;
        this.properties = properties;
        this.add(new JLabel(name));
        properties.addPropertiesListener(propertyKey, this);
        this.spinner = new JSpinner(new SpinnerNumberModel((min + max) / 2, min, max, 1));
        this.propertiesUpdate(propertyKey, properties.getProperty(propertyKey));
        this.spinner.addChangeListener(this);
        this.add(this.spinner);
    }

    public void stateChanged(ChangeEvent e) {
        this.properties.setProperty(this.propertyKey, this.spinner.getValue().toString());
    }

    public void propertiesUpdate(String key, String value) {
        if (key != null && key.equalsIgnoreCase(this.propertyKey)) {
            try {
                this.spinner.setValue(Integer.parseInt(this.properties.getProperty(this.propertyKey)));
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
    }
}

