.\"% Read this file by typing 'nroff -man weighbor.man | less'
.\"% or 'nroff -man weighbor.man | more'
.\"% or by installing on your man path
.\"% and typing 'man weighbor' 
.TH WEIGHBOR L "[16-Jun-01]" "Ver 1.2"
.SH NAME
weighbor \- weighted neighbor joining
.SH SYNOPSIS
.B weighbor
[\-L
.I sequenceLength] 
[\-b
.I alphabetSize]
[\-i
.I fileName] 
[\-o 
.I fileName] 
[\-v[v[v]]] [\-V]
.SH DESCRIPTION
.B Weighbor 
takes an input file of pairwise distances in
.I Phylip
format (see section
.B FILE FORMATS
below) 
and computes the phylogentic tree that best corresponds to
those distances. The output is the tree in the
lisp-like 'Newick' format. Currently the input is read from
.B stdin
and the output is written to 
.B stdout.
Note, several inputs can be sent to
.B weighbor
and it will process each in order and print the corresponding tree.
Additional information about how the tree was built can be
output to a log file (currently
.B weighbor.out
). The amount of information written to the log file can be controlled.
.PP
These options are available:
.TP
.BI "\-L " sequenceLength
Sets the length of the sequences. Default is 500. This is the effective sequence 
length equal to the number of varying sites. 
Note if the 
.B
\-L
option is not used then the program will print a warning message to
stderr indicating that it is using this default length.
.TP
.BI "\-b " alphabetSize
Sets the size of the alphabet of characters (number of bases) 
.B b.
.B 1/b 
is equal to the probablity that there will be a match for
infinite evolution time. The default value for 
.B b
is 4.
.TP
.BI "\-i " fileName
Read input from the filename given. Default is to read from stdin.
.TP
.BI "\-o " fileName
Write output to the given file. Default is to write to stdout.
.TP
.B \-v
Turns on logging and creates the logfile
.I weighbor.out
The amount of information can be adjusted by using
.B \-v,
.B \-vv
or 
.B \-vvv
to get progressively more detailed information in the logfile. At
level one
.B (\-v)
the the logfile will contain the pair of taxa that was joined at each
iteration of the algorithm along with the taxon that was the next best
choice. Also printed is the p-value of this triplet.  
.TP
.B \-V
Print out the version number.
.SH FILE FORMATS
.I Weighbor
tries to be as flexable as possible in the format of the input file it
will allow, while maintaining PHYLIP compatibility.  A file that conforms
.I EXACTLY
to the PHYLIP format (as defined in the PHYLIP package) will work with
.I PROVIDED
the first character after the 10-character name (i.e., the 11th
character on the line) is a space (' '), tab or newline.

Additionally we have added the following extensions. 
.TP
Long taxon names.
Taxon names can be up to 128 characters long. There is one caveat,
spaces embedded in the file name can only exist from position 2-9. A
space before pos 2 will be discared and after position 9  will
terminate the name. Any non-white space character can be used in the
name. 

.TP
Tab and newline delimiters
.I Weighbor
will allow both tabs and newlines to delimit taxon names so the
following will be read correct even though it is not a valid PHYLIP
format because the names are not padded to 10 characters.
.PP
.nf
3
Name1
0 1 2
Name2
1 0 2
Name3
1 2 0
.fi
.PP

.TP
Lower triangular form
.I Weighbor 
will also a distance matrices in lower triangular
form. For example the following matrix will result in the same
distance matrix as the previous sample
.PP
.nf
3
Name1
0
Name2
1 0
Name3
1 2 0
.fi
.PP

.TP 
Symmetry sanity checks
.I Weigbhor 
will force symmetry on non symmetric inputs. It does so by
averaging the given input with its transpose.

.SH DEVELOPMENT TEAM
W. Bruno
.IR <wjb@dnamining.com>
.PP
A. Halpern
.IR <halpern@ender.unm.edu>
.PP
N. D. Socci
.IR <soccin@rockefeller.edu>
