/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biolegato.core.data.seqdoc.undo;

/**
 * This interface is used for generalizing all objects which perform undo-related
 * actions.  Subclass examples are UndoInsert and UndoDelete which undo inserts and
 * deletions from a sequence document.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public interface Undoable {
    /**
     * Undoes an action represented by the undoable object.
     *
     * @return an object which can redo the undone operation.
     */
    public Undoable undo ();
}
