/*
 * BLMain.java
 *
 * Created on November 7, 2007, 1:04 PM
 *
 * This is the file which contains all of the main classes, and functions for
 * running BioLegato.
 *
 * Current serializable number:
 * private static final long serialVersionUID = 7526472295622777038L;
 * released:   private static final long serialVersionUID = 7526472295622777010L;
 */
package org.biolegato.core.main;

///////////////
//***********//
//* IMPORTS *//
//***********//
///////////////
import java.io.BufferedReader;
import java.io.IOException;

/**
 * The main program and generic function class.
 * <p>
 *  This class is used to generate the main window, do all startup processing,
 *  and run the program.  This class also contains all of the utility functions,
 *  and a wide assortment of utility classes.
 * </p>
 *
 * @version 0.5.6 2-July-2009
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public final class BLMain {

    /**
     * This constant stores the program's name
     */
    public static final String NAME = "BioLegato";

    /**
     * Starts up BioLegato.
     *
     * @param args the command line arguments.
     */
    public static void main (String[] args) {
        // create a new instance of the program window
        // and pass it all of the command arguments
        new ProgramWindow(args);
    }

    /**
     * Sends an error message to BioLegato's standard err.
     * Alias for error(message, null);
     *
     * @param message the error message to send.
     */
    public static void error (String message) {
        error(message, null);
    }

    /**
     * Sends an error message to BioLegato's standard err.
     *
     * @param message the error message to send.
     * @param location the location the error occurred.
     */
    public static void error (String message, String location) {
        // print the error to the error stream
        System.err.println(NAME + ((location != null &&  ! location.trim().equals(""))
                                   ? " (" + location + ")" : "") + ": ERROR --- " + message);
    }

    /**
     * Sends an warning message to BioLegato's standard err.
     * Alias for warning(message, null);
     *
     * @param message the warning message to send.
     */
    public static void warning (String message) {
        warning(message, null);
    }

    /**
     * Sends an warning message to BioLegato's standard err.
     *
     * @param message the warning message to send.
     * @param location the location the error occurred.
     */
    public static void warning (String message, String location) {
        // prints the warning to BioLegato's error stream
        System.err.println(NAME + ((location != null &&  ! location.trim().equals(""))
                                   ? " (" + location + ")" : "") + ": WARNING --- " + message);
    }

    /**
     * Sends a message to BioLegato's standard out.
     * Alias for message(message, null);
     *
     * @param message the message to send.
     */
    public static void message (String message) {
        message(message, null);
    }

    /**
     * Sends a message to BioLegato's standard out.
     *
     * @param message the message to send.
     * @param location the location the message was sent from.
     */
    public static void message (String message, String location) {
        // prints the warning to BioLegato's error stream
        System.out.println(NAME + ((location != null &&  ! location.trim().equals(""))
                                   ? " (" + location + ")" : "") + ": " + message);
    }

    /**
     * Reads the complete contents of a BufferedReader into a string.
     *
     * @param reader the BufferedReader to read.
     * @return the contents of the BufferedReader.
     * @throws IOException throws any exceptions from the read operation.
     */
    public static String readStream (BufferedReader reader) throws IOException {
        String line = reader.readLine();            // the current line to read
        StringBuffer result = new StringBuffer();   // the result of the operation

        // read in every line from the stream
        // NOTE: append is faster than + or concat operators
        while (line != null) {
            // don't forget to add the \n back to the line
            result.append(line).append("\n");
            
            // itterate to the next line
            line = reader.readLine();
        }

        // return the resulting string
        return result.toString();
    }

}