/*
 * Canvas.java
 *
 * Created on November 7, 2007, 1:12 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package org.biolegato.core.plugintypes;

import org.biolegato.core.data.sequence.Sequence;
import javax.swing.Box;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import org.biolegato.core.main.ProgramWindow;

/**
 * All subclasses are expected to implement a displayable canvas for BioLegato.
 * 
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public abstract class DataCanvas extends Box implements ChangeListener {
	/**
	 * The program window to use to obtain program data from.
	 */
	protected ProgramWindow program = null;

	/**
	 * Creates a new instance of BLCanvas
	 * 
	 * @param program the BioLegato instance to attach the canvas to.
	 * @param alignment the alignment for the box.
	 */
	protected DataCanvas (ProgramWindow program, int alignment) {
		super(alignment);
		this.program = program;
	}

	/**
	 * Returns the current/selected data in the canvas.
	 *
	 * @return the current data for usage by commands
	 * @throws BadLocationException
	 */
	public Sequence[] getData () throws BadLocationException {
		return getAllData();
	}

	/**
	 * Returns the complete contents of the data in the canvas.
	 *
	 * @return the complete contents of the data in the canvas
	 * @throws BadLocationException any location exceptions thrown by the underlying Document class
	 */
	public final Sequence[] getAllData () throws BadLocationException {
		Sequence[] result = new Sequence[program.getSeqDoc().getLineCount()];
		for (int line = 0; line < program.getSeqDoc().getLineCount(); line++) {
			result[line] = program.getSeqDoc().getSequence(line);
		}
		return result;
	}

	/**
	 * Returns the name of the canvas.
	 *
	 * @return the name to display for the canvas in all program text referring to it.
	 */
	public abstract String getTabName ();

	/**
	 * Refreshes the canvas on tab changes.
	 * Override this method, if you wish to do anything special on tab changes.
	 *
	 * @param event used to determine whether or not to refresh/
	 */
	public void stateChanged (javax.swing.event.ChangeEvent event) {
	}
}
