/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biolegato.core.properties;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;

/**
 *
 * @author alvare
 */
public class PropertiesCheckbox extends JCheckBox implements ActionListener, PropertiesListener {

    private String propertyKey;
    private BLProperties properties;

    public PropertiesCheckbox(BLProperties properties, String name, String propertyKey) {
        super(name);

        this.propertyKey = propertyKey;
        this.properties = properties;

        setSelected(properties.getProperty(propertyKey).equalsIgnoreCase("true"));
        properties.addPropertiesListener(propertyKey, this);
	this.addActionListener(this);
    }
    
    public void actionPerformed(ActionEvent e) {
        properties.setProperty(propertyKey, (isSelected() ? "true" : "false"));
    }

    public void propertiesUpdate(String key, String value) {
        if (key.equalsIgnoreCase(propertyKey)) {
            setSelected(properties.getProperty(propertyKey).equalsIgnoreCase("true"));
        }
    }

}
