/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biolegato.core.properties;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 *
 * @author alvare
 */
public class PropertiesNumber extends Box implements ChangeListener, PropertiesListener {

    JSpinner spinner;
    private String propertyKey;
    private BLProperties properties;
    /**
     * Used for serialization purposes
     */
    private static final long serialVersionUID = 7526472295622777036L;

    public PropertiesNumber(BLProperties properties, String name, String propertyKey, int min, int max) {
        super(BoxLayout.LINE_AXIS);

        this.propertyKey = propertyKey;
        this.properties = properties;

        add(new JLabel(name));
        properties.addPropertiesListener(propertyKey, this);
        spinner = new JSpinner(new SpinnerNumberModel(((min + max) / 2), min, max, 1));
        propertiesUpdate(propertyKey, properties.getProperty(propertyKey));
	spinner.addChangeListener(this);
        add(spinner);
    }
    
    public void propertiesUpdate(String key, String value) {
        if (key.equalsIgnoreCase(propertyKey)) {
            try {
                spinner.setValue(Integer.parseInt(properties.getProperty(propertyKey)));
            } catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        properties.setProperty(propertyKey, spinner.getValue().toString());
    }
}
